/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.io;

import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.lang.Assert;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public abstract class AbstractDeserializer<T>
implements Deserializer<T> {
    protected static final int EOF = -1;
    private static final byte[] EMPTY_BYTES = new byte[0];

    protected AbstractDeserializer() {
    }

    @Override
    public final T deserialize(byte[] object) throws DeserializationException {
        object = object == null ? EMPTY_BYTES : object;
        object = new ByteArrayInputStream((byte[])object);
        object = new InputStreamReader((InputStream)object, StandardCharsets.UTF_8);
        return this.deserialize((Reader)object);
    }

    @Override
    public final T deserialize(Reader object) throws DeserializationException {
        Assert.notNull(object, "Reader argument cannot be null.");
        try {
            return this.doDeserialize((Reader)object);
        }
        catch (Throwable throwable) {
            object = throwable;
            if (throwable instanceof DeserializationException) {
                throw (DeserializationException)object;
            }
            String string = "Unable to deserialize: " + ((Throwable)object).getMessage();
            throw new DeserializationException(string, (Throwable)object);
        }
    }

    protected abstract T doDeserialize(Reader var1) throws Exception;
}

