/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.io;

import io.jsonwebtoken.io.SerializationException;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.lang.Objects;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public abstract class AbstractSerializer<T>
implements Serializer<T> {
    protected AbstractSerializer() {
    }

    @Override
    public final byte[] serialize(T t2) throws SerializationException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.serialize(t2, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public final void serialize(T object, OutputStream object2) throws SerializationException {
        try {
            this.doSerialize(object, (OutputStream)object2);
            return;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            if (throwable instanceof SerializationException) {
                throw (SerializationException)object2;
            }
            object = "Unable to serialize object of type " + Objects.nullSafeClassName(object) + ": " + ((Throwable)object2).getMessage();
            throw new SerializationException((String)object, (Throwable)object2);
        }
    }

    protected abstract void doSerialize(T var1, OutputStream var2) throws Exception;
}

