/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.io;

import io.jsonwebtoken.io.Encoder;
import io.jsonwebtoken.io.EncodingException;
import io.jsonwebtoken.lang.Assert;

class ExceptionPropagatingEncoder<T, R>
implements Encoder<T, R> {
    private final Encoder<T, R> encoder;

    ExceptionPropagatingEncoder(Encoder<T, R> encoder) {
        Assert.notNull(encoder, "Encoder cannot be null.");
        this.encoder = encoder;
    }

    @Override
    public R encode(T object) throws EncodingException {
        Assert.notNull(object, "Encode argument cannot be null.");
        try {
            return this.encoder.encode(object);
        }
        catch (EncodingException encodingException) {
            object = encodingException;
            throw encodingException;
        }
        catch (Exception exception) {
            String string = "Unable to encode input: " + exception.getMessage();
            throw new EncodingException(string, exception);
        }
    }
}

