/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.lang;

import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import java.lang.reflect.Array;
import java.util.List;

public final class Arrays {
    private Arrays() {
    }

    public static <T> int length(T[] TArray) {
        if (TArray == null) {
            return 0;
        }
        return TArray.length;
    }

    public static <T> List<T> asList(T[] TArray) {
        if (Objects.isEmpty(TArray)) {
            return Collections.emptyList();
        }
        return java.util.Arrays.asList(TArray);
    }

    public static int length(byte[] byArray) {
        if (byArray != null) {
            return byArray.length;
        }
        return 0;
    }

    public static byte[] clean(byte[] byArray) {
        if (Arrays.length(byArray) > 0) {
            return byArray;
        }
        return null;
    }

    public static Object copy(Object object) {
        if (object == null) {
            return null;
        }
        Assert.isTrue(Objects.isArray(object), "Argument must be an array.");
        if (object instanceof Object[]) {
            return ((Object[])object).clone();
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).clone();
        }
        if (object instanceof byte[]) {
            return ((byte[])object).clone();
        }
        if (object instanceof char[]) {
            return ((char[])object).clone();
        }
        if (object instanceof double[]) {
            return ((double[])object).clone();
        }
        if (object instanceof float[]) {
            return ((float[])object).clone();
        }
        if (object instanceof int[]) {
            return ((int[])object).clone();
        }
        if (object instanceof long[]) {
            return ((long[])object).clone();
        }
        if (object instanceof short[]) {
            return ((short[])object).clone();
        }
        Object[] objectArray = object.getClass().getComponentType();
        int n2 = Array.getLength(object);
        objectArray = (Object[])Array.newInstance(objectArray, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = Array.get(object, i2);
        }
        return objectArray;
    }
}

