/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.lang;

import io.jsonwebtoken.lang.Classes$1;
import io.jsonwebtoken.lang.Classes$2;
import io.jsonwebtoken.lang.Classes$3;
import io.jsonwebtoken.lang.Classes$ClassLoaderAccessor;
import io.jsonwebtoken.lang.InstantiationException;
import io.jsonwebtoken.lang.UnknownClassException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public final class Classes {
    private static final Classes$ClassLoaderAccessor THREAD_CL_ACCESSOR = new Classes$1();
    private static final Classes$ClassLoaderAccessor CLASS_CL_ACCESSOR = new Classes$2();
    private static final Classes$ClassLoaderAccessor SYSTEM_CL_ACCESSOR = new Classes$3();

    private Classes() {
    }

    public static <T> Class<T> forName(String string) throws UnknownClassException {
        Class<?> clazz = THREAD_CL_ACCESSOR.loadClass(string);
        if (clazz == null) {
            clazz = CLASS_CL_ACCESSOR.loadClass(string);
        }
        if (clazz == null) {
            clazz = SYSTEM_CL_ACCESSOR.loadClass(string);
        }
        if (clazz == null) {
            clazz = "Unable to load class named [" + string + "] from the thread context, current, or system/application ClassLoaders.  All heuristics have been exhausted.  Class could not be found.";
            if (string != null && string.startsWith("io.jsonwebtoken.impl")) {
                clazz = (String)((Object)clazz) + "  Have you remembered to include the jjwt-impl.jar in your runtime classpath?";
            }
            throw new UnknownClassException((String)((Object)clazz));
        }
        return clazz;
    }

    public static InputStream getResourceAsStream(String string) {
        InputStream inputStream = THREAD_CL_ACCESSOR.getResourceStream(string);
        if (inputStream == null) {
            inputStream = CLASS_CL_ACCESSOR.getResourceStream(string);
        }
        if (inputStream == null) {
            inputStream = SYSTEM_CL_ACCESSOR.getResourceStream(string);
        }
        return inputStream;
    }

    private static URL getResource(String string) {
        URL uRL = THREAD_CL_ACCESSOR.getResource(string);
        if (uRL == null) {
            uRL = CLASS_CL_ACCESSOR.getResource(string);
        }
        if (uRL == null) {
            return SYSTEM_CL_ACCESSOR.getResource(string);
        }
        return uRL;
    }

    public static boolean isAvailable(String string) {
        try {
            Classes.forName(string);
            return true;
        }
        catch (UnknownClassException unknownClassException) {
            return false;
        }
    }

    public static <T> T newInstance(String string) {
        return Classes.newInstance(Classes.forName(string));
    }

    public static <T> T newInstance(String constructor, Class<?>[] classArray, Object ... objectArray) {
        constructor = Classes.forName((String)((Object)constructor));
        constructor = Classes.getConstructor(constructor, classArray);
        return Classes.instantiate(constructor, objectArray);
    }

    public static <T> T newInstance(String string, Object ... objectArray) {
        return Classes.newInstance(Classes.forName(string), objectArray);
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (clazz == null) {
            String string = "Class method parameter cannot be null.";
            throw new IllegalArgumentException(string);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new InstantiationException("Unable to instantiate class [" + clazz.getName() + "]", exception);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        Constructor<T> constructor = Classes.getConstructor(clazz, classArray);
        return Classes.instantiate(constructor, objectArray);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... classArray) throws IllegalStateException {
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
    }

    public static <T> T instantiate(Constructor<T> object, Object ... objectArray) {
        try {
            return ((Constructor)object).newInstance(objectArray);
        }
        catch (Exception exception) {
            object = "Unable to instantiate instance with constructor [" + object + "]";
            throw new InstantiationException((String)object, exception);
        }
    }

    public static <T> T invokeStatic(String string, String string2, Class<?>[] classArray, Object ... objectArray) {
        try {
            Class<T> clazz = Classes.forName(string);
            return Classes.invokeStatic(clazz, string2, classArray, objectArray);
        }
        catch (Exception exception) {
            string = "Unable to invoke class method " + string + "#" + string2 + ".  Ensure the necessary implementation is in the runtime classpath.";
            throw new IllegalStateException(string, exception);
        }
    }

    public static <T> T invokeStatic(Class<?> object, String string, Class<?>[] object2, Object ... objectArray) {
        try {
            object2 = ((Class)object).getDeclaredMethod(string, (Class<?>)object2);
            ((Method)object2).setAccessible(true);
            return (T)((Method)object2).invoke(null, objectArray);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            object2 = reflectiveOperationException;
            objectArray = reflectiveOperationException.getCause();
            if (objectArray instanceof RuntimeException) {
                throw (RuntimeException)objectArray;
            }
            object = "Unable to invoke class method " + ((Class)object).getName() + "#" + string + ". Ensure the necessary implementation is in the runtime classpath.";
            throw new IllegalStateException((String)object, (Throwable)object2);
        }
    }

    public static <T> T getFieldValue(Object object, String string, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        try {
            Field field = object.getClass().getDeclaredField(string);
            field.setAccessible(true);
            Object object2 = field.get(object);
            return clazz.cast(object2);
        }
        catch (Throwable throwable) {
            String string2 = "Unable to read field " + object.getClass().getName() + "#" + string + ": " + throwable.getMessage();
            throw new IllegalStateException(string2, throwable);
        }
    }
}

