/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.lang;

import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public final class Strings {
    public static final String EMPTY = "";
    private static final CharBuffer EMPTY_BUF = CharBuffer.wrap("");
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static final char EXTENSION_SEPARATOR = '.';
    public static final Charset UTF_8 = StandardCharsets.UTF_8;

    private Strings() {
    }

    public static boolean hasLength(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static boolean hasLength(String string) {
        return Strings.hasLength((CharSequence)string);
    }

    public static boolean hasText(CharSequence charSequence) {
        if (!Strings.hasLength(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(charSequence.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String string) {
        return Strings.hasText((CharSequence)string);
    }

    public static boolean containsWhitespace(CharSequence charSequence) {
        if (!Strings.hasLength(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Character.isWhitespace(charSequence.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String string) {
        return Strings.containsWhitespace((CharSequence)string);
    }

    public static String trimWhitespace(String string) {
        return (String)Strings.trimWhitespace((CharSequence)string);
    }

    private static CharSequence trimWhitespace(CharSequence charSequence) {
        int n2;
        if (!Strings.hasLength(charSequence)) {
            return charSequence;
        }
        int n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && Character.isWhitespace(charSequence.charAt(n2)); ++n2) {
        }
        int n4 = n3;
        while (n2 < n3 && Character.isWhitespace(charSequence.charAt(n4 - 1))) {
            --n4;
        }
        if (n2 > 0 || n4 < n3) {
            return charSequence.subSequence(n2, n4);
        }
        return charSequence;
    }

    public static String clean(String charSequence) {
        if ((charSequence = Strings.clean(charSequence)) != null) {
            return charSequence.toString();
        }
        return null;
    }

    public static CharSequence clean(CharSequence charSequence) {
        if (!Strings.hasLength(charSequence = Strings.trimWhitespace(charSequence))) {
            return null;
        }
        return charSequence;
    }

    public static byte[] utf8(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        charSequence = charSequence instanceof CharBuffer ? (CharBuffer)charSequence : CharBuffer.wrap(charSequence);
        ((CharBuffer)charSequence).mark();
        ByteBuffer byteBuffer = UTF_8.encode((CharBuffer)charSequence);
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        ((CharBuffer)charSequence).reset();
        return byArray;
    }

    public static String utf8(byte[] byArray) {
        return new String(byArray, UTF_8);
    }

    public static String ascii(byte[] byArray) {
        return new String(byArray, StandardCharsets.US_ASCII);
    }

    public static byte[] ascii(CharSequence object) {
        byte[] byArray = null;
        if (object != null) {
            object = object instanceof CharBuffer ? (CharBuffer)object : CharBuffer.wrap((CharSequence)object);
            object = StandardCharsets.US_ASCII.encode((CharBuffer)object);
            byArray = new byte[((Buffer)object).remaining()];
            ((ByteBuffer)object).get(byArray);
        }
        return byArray;
    }

    public static CharBuffer wrap(CharSequence charSequence) {
        if (!Strings.hasLength(charSequence)) {
            return EMPTY_BUF;
        }
        if (charSequence instanceof CharBuffer) {
            return (CharBuffer)charSequence;
        }
        return CharBuffer.wrap(charSequence);
    }

    public static String toBinary(byte by2) {
        String string = Integer.toBinaryString(by2 & 0xFF);
        return String.format("%8s", string).replace('\f', '0');
    }

    public static String toBinary(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(19);
        for (byte by2 : byArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\f');
            }
            String string = Strings.toBinary(by2);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by2 : byArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\f');
            }
            stringBuilder.append(String.format("%02x", by2));
        }
        return stringBuilder.toString();
    }

    public static String trimAllWhitespace(String charSequence) {
        if (!Strings.hasLength((String)charSequence)) {
            return charSequence;
        }
        charSequence = new StringBuilder((String)charSequence);
        int n2 = 0;
        while (((StringBuilder)charSequence).length() > n2) {
            if (Character.isWhitespace(((StringBuilder)charSequence).charAt(n2))) {
                ((StringBuilder)charSequence).deleteCharAt(n2);
                continue;
            }
            ++n2;
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String trimLeadingWhitespace(String charSequence) {
        if (!Strings.hasLength((String)charSequence)) {
            return charSequence;
        }
        charSequence = new StringBuilder((String)charSequence);
        while (((StringBuilder)charSequence).length() > 0 && Character.isWhitespace(((StringBuilder)charSequence).charAt(0))) {
            ((StringBuilder)charSequence).deleteCharAt(0);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String trimTrailingWhitespace(String charSequence) {
        if (!Strings.hasLength((String)charSequence)) {
            return charSequence;
        }
        charSequence = new StringBuilder((String)charSequence);
        while (((StringBuilder)charSequence).length() > 0) {
            CharSequence charSequence2 = charSequence;
            if (!Character.isWhitespace(((StringBuilder)charSequence2).charAt(((StringBuilder)charSequence2).length() - 1))) break;
            CharSequence charSequence3 = charSequence;
            ((StringBuilder)charSequence3).deleteCharAt(((StringBuilder)charSequence3).length() - 1);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String trimLeadingCharacter(String charSequence, char c2) {
        if (!Strings.hasLength((String)charSequence)) {
            return charSequence;
        }
        charSequence = new StringBuilder((String)charSequence);
        while (((StringBuilder)charSequence).length() > 0 && ((StringBuilder)charSequence).charAt(0) == c2) {
            ((StringBuilder)charSequence).deleteCharAt(0);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String trimTrailingCharacter(String charSequence, char c2) {
        if (!Strings.hasLength((String)charSequence)) {
            return charSequence;
        }
        charSequence = new StringBuilder((String)charSequence);
        while (((StringBuilder)charSequence).length() > 0) {
            CharSequence charSequence2 = charSequence;
            if (((StringBuilder)charSequence2).charAt(((StringBuilder)charSequence2).length() - 1) != c2) break;
            CharSequence charSequence3 = charSequence;
            ((StringBuilder)charSequence3).deleteCharAt(((StringBuilder)charSequence3).length() - 1);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.length() < string2.length()) {
            return false;
        }
        if (string.startsWith(string2)) {
            return true;
        }
        string = string.substring(0, string2.length()).toLowerCase();
        string2 = string2.toLowerCase();
        return string.equals(string2);
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.endsWith(string2)) {
            return true;
        }
        if (string.length() < string2.length()) {
            return false;
        }
        String string3 = string;
        string = string3.substring(string3.length() - string2.length()).toLowerCase();
        string2 = string2.toLowerCase();
        return string.equals(string2);
    }

    public static boolean substringMatch(CharSequence charSequence, int n2, CharSequence charSequence2) {
        for (int i2 = 0; i2 < charSequence2.length(); ++i2) {
            int n3 = n2 + i2;
            if (n3 < charSequence.length() && charSequence.charAt(n3) == charSequence2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static int countOccurrencesOf(String string, String string2) {
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n3)) != -1) {
            ++n2;
            n3 += string2.length();
        }
        return n2;
    }

    public static String replace(String string, String string2, String string3) {
        if (!Strings.hasLength(string) || !Strings.hasLength(string2) || string3 == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        int n4 = string2.length();
        while (n3 >= 0) {
            stringBuilder.append(string.substring(n2, n3));
            stringBuilder.append(string3);
            n2 = n3 + n4;
            n3 = string.indexOf(string2, n2);
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    public static String delete(String string, String string2) {
        return Strings.replace(string, string2, EMPTY);
    }

    public static String deleteAny(String string, String string2) {
        if (!Strings.hasLength(string) || !Strings.hasLength(string2)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (string2.indexOf(c2) != -1) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String quote(String string) {
        if (string != null) {
            return "'" + string + "'";
        }
        return null;
    }

    public static Object quoteIfString(Object object) {
        if (object instanceof String) {
            return Strings.quote((String)object);
        }
        return object;
    }

    public static String unqualify(String string) {
        return Strings.unqualify(string, '.');
    }

    public static String unqualify(String string, char c2) {
        String string2 = string;
        return string2.substring(string2.lastIndexOf(c2) + 1);
    }

    public static String capitalize(String string) {
        return Strings.changeFirstCharacterCase(string, true);
    }

    public static String uncapitalize(String string) {
        return Strings.changeFirstCharacterCase(string, false);
    }

    private static String changeFirstCharacterCase(String string, boolean bl2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        if (bl2) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0)));
        } else {
            stringBuilder.append(Character.toLowerCase(string.charAt(0)));
        }
        stringBuilder.append(string.substring(1));
        return stringBuilder.toString();
    }

    public static String getFilename(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(FOLDER_SEPARATOR);
        if (n2 != -1) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public static String getFilenameExtension(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return null;
        }
        int n3 = string.lastIndexOf(FOLDER_SEPARATOR);
        if (n3 > n2) {
            return null;
        }
        return string.substring(n2 + 1);
    }

    public static String stripFilenameExtension(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        int n3 = string.lastIndexOf(FOLDER_SEPARATOR);
        if (n3 > n2) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String applyRelativePath(String string, String string2) {
        int n2 = string.lastIndexOf(FOLDER_SEPARATOR);
        if (n2 != -1) {
            string = string.substring(0, n2);
            if (!string2.startsWith(FOLDER_SEPARATOR)) {
                string = string + FOLDER_SEPARATOR;
            }
            return string + string2;
        }
        return string2;
    }

    public static String cleanPath(String object) {
        int n2;
        if (object == null) {
            return null;
        }
        object = Strings.replace((String)object, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int n3 = ((String)object).indexOf(":");
        String string = EMPTY;
        if (n3 != -1) {
            string = ((String)object).substring(0, n3 + 1);
            object = ((String)object).substring(n3 + 1);
        }
        if (((String)object).startsWith(FOLDER_SEPARATOR)) {
            string = string + FOLDER_SEPARATOR;
            object = ((String)object).substring(1);
        }
        object = Strings.delimitedListToStringArray((String)object, FOLDER_SEPARATOR);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n4 = 0;
        for (n2 = ((Object)object).length - 1; n2 >= 0; --n2) {
            Object object2 = object[n2];
            if (CURRENT_PATH.equals(object2)) continue;
            if (TOP_PATH.equals(object2)) {
                ++n4;
                continue;
            }
            if (n4 > 0) {
                --n4;
                continue;
            }
            linkedList.add(0, object2);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            linkedList.add(0, TOP_PATH);
        }
        return string + Strings.collectionToDelimitedString(linkedList, FOLDER_SEPARATOR);
    }

    public static boolean pathEquals(String string, String string2) {
        return Strings.cleanPath(string).equals(Strings.cleanPath(string2));
    }

    public static Locale parseLocaleString(String string) {
        int n2;
        String[] stringArray = Strings.tokenizeToStringArray(string, "_ ", false, false);
        String string2 = stringArray.length > 0 ? stringArray[0] : EMPTY;
        String string3 = stringArray.length > 1 ? stringArray[1] : EMPTY;
        Strings.validateLocalePart(string2);
        Strings.validateLocalePart(string3);
        String string4 = EMPTY;
        if (stringArray.length >= 2 && (string4 = Strings.trimLeadingWhitespace(string.substring(n2 = string.indexOf(string3) + string3.length()))).startsWith("_")) {
            string4 = Strings.trimLeadingCharacter(string4, '_');
        }
        if (string2.length() > 0) {
            return new Locale(string2, string3, string4);
        }
        return null;
    }

    private static void validateLocalePart(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '_' || c2 == ' ' || Character.isLetterOrDigit(c2)) continue;
            throw new IllegalArgumentException("Locale part \"" + string + "\" contains invalid characters");
        }
    }

    public static String toLanguageTag(Locale locale) {
        return locale.getLanguage() + (Strings.hasText(locale.getCountry()) ? "-" + locale.getCountry() : EMPTY);
    }

    public static String[] addStringToArray(String[] stringArray, String string) {
        if (Objects.isEmpty(stringArray)) {
            return new String[]{string};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    public static String[] concatenateStringArrays(String[] stringArray, String[] stringArray2) {
        if (Objects.isEmpty(stringArray)) {
            return stringArray2;
        }
        if (Objects.isEmpty(stringArray2)) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static String[] mergeStringArrays(String[] stringArray, String[] stringArray2) {
        if (Objects.isEmpty(stringArray)) {
            return stringArray2;
        }
        if (Objects.isEmpty(stringArray2)) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return Strings.toStringArray(arrayList);
    }

    public static String[] sortStringArray(String[] stringArray) {
        if (Objects.isEmpty(stringArray)) {
            return new String[0];
        }
        Arrays.sort(stringArray);
        return stringArray;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        Collection<String> collection2 = collection;
        return collection2.toArray(new String[collection2.size()]);
    }

    public static String[] toStringArray(Enumeration<String> object) {
        if (object == null) {
            return null;
        }
        object = java.util.Collections.list(object);
        return object.toArray(new String[object.size()]);
    }

    public static String[] trimArrayElements(String[] stringArray) {
        if (Objects.isEmpty(stringArray)) {
            return new String[0];
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            stringArray2[i2] = string != null ? string.trim() : null;
        }
        return stringArray2;
    }

    public static String[] removeDuplicateStrings(String[] stringArray) {
        if (Objects.isEmpty(stringArray)) {
            return stringArray;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : stringArray) {
            treeSet.add(string);
        }
        return Strings.toStringArray(treeSet);
    }

    public static String[] split(String string, String string2) {
        if (!Strings.hasLength(string) || !Strings.hasLength(string2)) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return null;
        }
        String string3 = string.substring(0, n2);
        string = string.substring(n2 + string2.length());
        return new String[]{string3, string};
    }

    public static Properties splitArrayElementsIntoProperties(String[] stringArray, String string) {
        return Strings.splitArrayElementsIntoProperties(stringArray, string, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Properties splitArrayElementsIntoProperties(String[] stringArray, String string, String string2) {
        if (Objects.isEmpty(stringArray)) {
            return null;
        }
        Properties properties = new Properties();
        for (String string3 : stringArray) {
            void var6_9;
            String[] stringArray2;
            if (string2 != null) {
                String string4 = Strings.deleteAny(string3, string2);
            }
            if ((stringArray2 = Strings.split((String)var6_9, string)) == null) continue;
            properties.setProperty(stringArray2[0].trim(), stringArray2[1].trim());
        }
        return properties;
    }

    public static String[] tokenizeToStringArray(String string, String string2) {
        return Strings.tokenizeToStringArray(string, string2, true, true);
    }

    public static String[] tokenizeToStringArray(String object, String object2, boolean bl2, boolean bl3) {
        if (object == null) {
            return null;
        }
        object = new StringTokenizer((String)object, (String)object2);
        object2 = new ArrayList();
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            if (bl2) {
                string = string.trim();
            }
            if (bl3 && string.length() <= 0) continue;
            object2.add(string);
        }
        return Strings.toStringArray((Collection<String>)object2);
    }

    public static String[] delimitedListToStringArray(String string, String string2) {
        return Strings.delimitedListToStringArray(string, string2, null);
    }

    public static String[] delimitedListToStringArray(String string, String string2, String string3) {
        if (string == null) {
            return new String[0];
        }
        if (string2 == null) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (EMPTY.equals(string2)) {
            int n2 = 0;
            while (n2 < string.length()) {
                int n3 = n2++;
                arrayList.add(Strings.deleteAny(string.substring(n3, n3 + 1), string3));
            }
        } else {
            int n4;
            int n5 = 0;
            while ((n4 = string.indexOf(string2, n5)) != -1) {
                arrayList.add(Strings.deleteAny(string.substring(n5, n4), string3));
                n5 = n4 + string2.length();
            }
            if (string.length() > 0 && n5 <= string.length()) {
                arrayList.add(Strings.deleteAny(string.substring(n5), string3));
            }
        }
        return Strings.toStringArray(arrayList);
    }

    public static String[] commaDelimitedListToStringArray(String string) {
        return Strings.delimitedListToStringArray(string, ",");
    }

    public static Set<String> commaDelimitedListToSet(String stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray2 = Strings.commaDelimitedListToStringArray((String)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            treeSet.add(string);
        }
        return treeSet;
    }

    public static String collectionToDelimitedString(Collection<?> object, String string, String string2, String string3) {
        if (Collections.isEmpty(object)) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            stringBuilder.append(string2).append(object.next()).append(string3);
            if (!object.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String collectionToDelimitedString(Collection<?> collection, String string) {
        return Strings.collectionToDelimitedString(collection, string, EMPTY, EMPTY);
    }

    public static String collectionToCommaDelimitedString(Collection<?> collection) {
        return Strings.collectionToDelimitedString(collection, ",");
    }

    public static String arrayToDelimitedString(Object[] objectArray, String string) {
        if (Objects.isEmpty(objectArray)) {
            return EMPTY;
        }
        if (objectArray.length == 1) {
            return Objects.nullSafeToString(objectArray[0]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(objectArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String arrayToCommaDelimitedString(Object[] objectArray) {
        return Strings.arrayToDelimitedString(objectArray, ",");
    }

    public static StringBuilder nespace(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return null;
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append(' ');
        }
        return stringBuilder;
    }
}

