/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.activation.UnsupportedDataTypeException;
import java.io.IOException;
import java.io.OutputStream;

class DataSourceDataContentHandler
implements DataContentHandler {
    private DataSource ds = null;
    private ActivationDataFlavor[] transferFlavors = null;
    private DataContentHandler dch = null;

    public DataSourceDataContentHandler(DataContentHandler dataContentHandler, DataSource dataSource) {
        this.ds = dataSource;
        this.dch = dataContentHandler;
    }

    @Override
    public ActivationDataFlavor[] getTransferDataFlavors() {
        if (this.transferFlavors == null) {
            if (this.dch != null) {
                this.transferFlavors = this.dch.getTransferDataFlavors();
            } else {
                this.transferFlavors = new ActivationDataFlavor[1];
                this.transferFlavors[0] = new ActivationDataFlavor(this.ds.getContentType(), this.ds.getContentType());
            }
        }
        return this.transferFlavors;
    }

    @Override
    public Object getTransferData(ActivationDataFlavor activationDataFlavor, DataSource dataSource) throws IOException {
        if (this.dch != null) {
            return this.dch.getTransferData(activationDataFlavor, dataSource);
        }
        if (activationDataFlavor.equals(this.getTransferDataFlavors()[0])) {
            return dataSource.getInputStream();
        }
        throw new IOException("Unsupported DataFlavor: " + activationDataFlavor);
    }

    @Override
    public Object getContent(DataSource dataSource) throws IOException {
        if (this.dch != null) {
            return this.dch.getContent(dataSource);
        }
        return dataSource.getInputStream();
    }

    @Override
    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (this.dch != null) {
            this.dch.writeTo(object, string, outputStream);
            return;
        }
        throw new UnsupportedDataTypeException("no DCH for content type " + this.ds.getContentType());
    }
}

