/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import java.util.logging.Level;
import java.util.logging.Logger;

class LogSupport {
    private static boolean debug = false;
    private static Logger logger;
    private static final Level level;

    private LogSupport() {
    }

    public static void log(String string) {
        if (debug) {
            System.out.println(string);
        }
        logger.log(level, string);
    }

    public static void log(String string, Throwable throwable) {
        if (debug) {
            System.out.println(string + "; Exception: " + throwable);
        }
        logger.log(level, string, throwable);
    }

    public static boolean isLoggable() {
        return debug || logger.isLoggable(level);
    }

    static {
        level = Level.FINE;
        try {
            debug = Boolean.getBoolean("jakarta.activation.debug") || Boolean.getBoolean("javax.activation.debug");
        }
        catch (Throwable throwable) {}
        logger = Logger.getLogger("jakarta.activation");
    }
}

