/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapFile;
import jakarta.activation.CommandInfo;
import jakarta.activation.CommandMap;
import jakarta.activation.DataContentHandler;
import jakarta.activation.MailcapCommandMap$1;
import jakarta.activation.SecuritySupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MailcapCommandMap
extends CommandMap {
    private MailcapFile[] DB;
    private static final int PROG = 0;
    private static final String confDir;

    public MailcapCommandMap() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(5);
        arrayList.add(null);
        LogSupport.log("MailcapCommandMap: load HOME");
        try {
            object = System.getProperty("user.home");
            if (object != null) {
                object = (String)object + File.separator + ".mailcap";
                if ((object = this.loadFile((String)object)) != null) {
                    arrayList.add(object);
                }
            }
        }
        catch (SecurityException securityException) {}
        LogSupport.log("MailcapCommandMap: load SYS");
        try {
            if (confDir != null && (object = this.loadFile(confDir + "mailcap")) != null) {
                arrayList.add(object);
            }
        }
        catch (SecurityException securityException) {}
        LogSupport.log("MailcapCommandMap: load JAR");
        this.loadAllResources(arrayList, "META-INF/mailcap");
        LogSupport.log("MailcapCommandMap: load DEF");
        object = this.loadResource("/META-INF/mailcap.default");
        if (object != null) {
            arrayList.add(object);
        }
        this.DB = new MailcapFile[arrayList.size()];
        this.DB = arrayList.toArray(this.DB);
    }

    /*
     * Loose catch block
     */
    private MailcapFile loadResource(String string) {
        block25: {
            InputStream inputStream;
            block24: {
                block22: {
                    MailcapFile mailcapFile;
                    block23: {
                        inputStream = null;
                        inputStream = SecuritySupport.getResourceAsStream(this.getClass(), string);
                        if (inputStream == null) break block22;
                        mailcapFile = new MailcapFile(inputStream);
                        if (!LogSupport.isLoggable()) break block23;
                        LogSupport.log("MailcapCommandMap: successfully loaded mailcap file: " + string);
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    return mailcapFile;
                }
                if (!LogSupport.isLoggable()) break block24;
                LogSupport.log("MailcapCommandMap: not loading mailcap file: " + string);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block25;
            }
            catch (IOException iOException) {}
            break block25;
            catch (IOException iOException) {
                block26: {
                    if (!LogSupport.isLoggable()) break block26;
                    LogSupport.log("MailcapCommandMap: can't load " + string, iOException);
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block25;
                }
                catch (IOException iOException2) {}
                break block25;
            }
            catch (SecurityException securityException) {
                block27: {
                    if (!LogSupport.isLoggable()) break block27;
                    LogSupport.log("MailcapCommandMap: can't load " + string, securityException);
                    {
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private void loadAllResources(List list, String string) {
        Object object;
        boolean bl2;
        block26: {
            bl2 = false;
            try {
                object = SecuritySupport.getContextClassLoader();
                if (object == null) {
                    object = this.getClass().getClassLoader();
                }
                if ((object = object != null ? SecuritySupport.getResources((ClassLoader)object, string) : SecuritySupport.getSystemResources(string)) == null) break block26;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MailcapCommandMap: getResources");
                }
                for (int i2 = 0; i2 < ((URL[])object).length; ++i2) {
                    InputStream inputStream;
                    URL uRL;
                    block27: {
                        uRL = object[i2];
                        inputStream = null;
                        if (LogSupport.isLoggable()) {
                            LogSupport.log("MailcapCommandMap: URL " + uRL);
                        }
                        inputStream = SecuritySupport.openStream(uRL);
                        if (inputStream != null) {
                            list.add(new MailcapFile(inputStream));
                            bl2 = true;
                            if (LogSupport.isLoggable()) {
                                LogSupport.log("MailcapCommandMap: successfully loaded mailcap file from URL: " + uRL);
                            }
                            break block27;
                        }
                        if (!LogSupport.isLoggable()) break block27;
                        LogSupport.log("MailcapCommandMap: not loading mailcap file from URL: " + uRL);
                    }
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                    catch (IOException iOException) {
                        block28: {
                            if (!LogSupport.isLoggable()) break block28;
                            LogSupport.log("MailcapCommandMap: can't load " + uRL, iOException);
                        }
                        try {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                        continue;
                    }
                    catch (SecurityException securityException) {
                        block29: {
                            if (!LogSupport.isLoggable()) break block29;
                            LogSupport.log("MailcapCommandMap: can't load " + uRL, securityException);
                            {
                                catch (Throwable throwable) {
                                    try {
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                    }
                                    catch (IOException iOException) {}
                                    throw throwable;
                                }
                            }
                        }
                        try {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
            }
            catch (Exception exception) {
                if (!LogSupport.isLoggable()) break block26;
                LogSupport.log("MailcapCommandMap: can't load " + string, exception);
            }
        }
        if (!bl2) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: !anyLoaded");
            }
            if ((object = this.loadResource("/" + string)) != null) {
                list.add(object);
            }
        }
    }

    private MailcapFile loadFile(String string) {
        MailcapFile mailcapFile = null;
        try {
            mailcapFile = new MailcapFile(string);
        }
        catch (IOException iOException) {}
        return mailcapFile;
    }

    public MailcapCommandMap(String string) throws IOException {
        this();
        if (LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: load PROG from " + string);
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile(string);
        }
    }

    public MailcapCommandMap(InputStream inputStream) {
        this();
        LogSupport.log("MailcapCommandMap: load PROG");
        if (this.DB[0] == null) {
            try {
                this.DB[0] = new MailcapFile(inputStream);
                return;
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public synchronized CommandInfo[] getPreferredCommands(String string) {
        Map map;
        int n2;
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (map = this.DB[n2].getMailcapList(string)) == null) continue;
            this.appendPrefCmdsToList(map, arrayList);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (map = this.DB[n2].getMailcapFallbackList(string)) == null) continue;
            this.appendPrefCmdsToList(map, arrayList);
        }
        CommandInfo[] commandInfoArray = new CommandInfo[arrayList.size()];
        commandInfoArray = arrayList.toArray(commandInfoArray);
        return commandInfoArray;
    }

    private void appendPrefCmdsToList(Map map, List list) {
        for (String string : map.keySet()) {
            if (this.checkForVerb(list, string)) continue;
            Object object = (List)map.get(string);
            object = (String)object.get(0);
            list.add(new CommandInfo(string, (String)object));
        }
    }

    private boolean checkForVerb(List object, String string) {
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = ((CommandInfo)object.next()).getCommandName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized CommandInfo[] getAllCommands(String string) {
        Map map;
        int n2;
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (map = this.DB[n2].getMailcapList(string)) == null) continue;
            this.appendCmdsToList(map, arrayList);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (map = this.DB[n2].getMailcapFallbackList(string)) == null) continue;
            this.appendCmdsToList(map, arrayList);
        }
        CommandInfo[] commandInfoArray = new CommandInfo[arrayList.size()];
        commandInfoArray = arrayList.toArray(commandInfoArray);
        return commandInfoArray;
    }

    private void appendCmdsToList(Map map, List list) {
        for (String string : map.keySet()) {
            Object object = (List)map.get(string);
            object = object.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                list.add(new CommandInfo(string, string2));
            }
        }
    }

    @Override
    public synchronized CommandInfo getCommand(String string, String string2) {
        Object object;
        int n2;
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (object = this.DB[n2].getMailcapList(string)) == null || (object = (List)object.get(string2)) == null || (object = (String)object.get(0)) == null) continue;
            return new CommandInfo(string2, (String)object);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null || (object = this.DB[n2].getMailcapFallbackList(string)) == null || (object = (List)object.get(string2)) == null || (object = (String)object.get(0)) == null) continue;
            return new CommandInfo(string2, (String)object);
        }
        return null;
    }

    public synchronized void addMailcap(String string) {
        LogSupport.log("MailcapCommandMap: add to PROG");
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile();
        }
        this.DB[0].appendToMailcap(string);
    }

    @Override
    public synchronized DataContentHandler createDataContentHandler(String string) {
        Object object;
        int n2;
        if (LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: createDataContentHandler for " + string);
        }
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log("  search DB #" + n2);
            }
            if ((object = this.DB[n2].getMailcapList(string)) == null || (object = (List)object.get("content-handler")) == null) continue;
            object = (String)object.get(0);
            if ((object = this.getDataContentHandler((String)object)) == null) continue;
            return object;
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            if (this.DB[n2] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log("  search fallback DB #" + n2);
            }
            if ((object = this.DB[n2].getMailcapFallbackList(string)) == null || (object = (List)object.get("content-handler")) == null) continue;
            object = (String)object.get(0);
            if ((object = this.getDataContentHandler((String)object)) == null) continue;
            return object;
        }
        return null;
    }

    private DataContentHandler getDataContentHandler(String string) {
        block8: {
            if (LogSupport.isLoggable()) {
                LogSupport.log("    got content-handler");
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log("      class " + string);
            }
            try {
                Class<?> clazz = SecuritySupport.getContextClassLoader();
                if (clazz == null) {
                    clazz = this.getClass().getClassLoader();
                }
                try {
                    clazz = ((ClassLoader)((Object)clazz)).loadClass(string);
                }
                catch (Exception exception) {
                    clazz = Class.forName(string);
                }
                if (clazz != null) {
                    return (DataContentHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                if (!LogSupport.isLoggable()) break block8;
                LogSupport.log("Can't load DCH " + string, reflectiveOperationException);
            }
        }
        return null;
    }

    @Override
    public synchronized String[] getMimeTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.DB.length; ++i2) {
            String[] stringArray;
            if (this.DB[i2] == null || (stringArray = this.DB[i2].getMimeTypes()) == null) continue;
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (arrayList.contains(stringArray[i3])) continue;
                arrayList.add(stringArray[i3]);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public synchronized String[] getNativeCommands(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (int i2 = 0; i2 < this.DB.length; ++i2) {
            String[] stringArray;
            if (this.DB[i2] == null || (stringArray = this.DB[i2].getNativeCommands(string)) == null) continue;
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (arrayList.contains(stringArray[i3])) continue;
                arrayList.add(stringArray[i3]);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    static {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new MailcapCommandMap$1());
        }
        catch (Exception exception) {}
        confDir = string;
    }
}

