/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind;

import jakarta.xml.bind.ContextFinder$1;
import jakarta.xml.bind.ContextFinder$2;
import jakarta.xml.bind.ContextFinder$3;
import jakarta.xml.bind.ContextFinder$4;
import jakarta.xml.bind.ContextFinder$5;
import jakarta.xml.bind.GetPropertyAction;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBContextFactory;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Messages;
import jakarta.xml.bind.ModuleUtil;
import jakarta.xml.bind.ServiceLoaderUtil;
import jakarta.xml.bind.ServiceLoaderUtil$ExceptionHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class ContextFinder {
    private static final Logger logger = Logger.getLogger("jakarta.xml.bind");
    static final String DEFAULT_FACTORY_CLASS = "org.glassfish.jaxb.runtime.v2.ContextFactory";
    private static ServiceLoaderUtil$ExceptionHandler<JAXBException> EXCEPTION_HANDLER;

    ContextFinder() {
    }

    private static Throwable handleInvocationTargetException(InvocationTargetException invocationTargetException) throws JAXBException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable != null) {
            if (throwable instanceof JAXBException) {
                throw (JAXBException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            return throwable;
        }
        return invocationTargetException;
    }

    private static JAXBException handleClassCastException(Class<?> clazz, Class<?> serializable) {
        serializable = ContextFinder.which(serializable);
        return new JAXBException(Messages.format("JAXBContext.IllegalCast", ContextFinder.getClassClassLoader(clazz).getResource("jakarta/xml/bind/JAXBContext.class"), serializable));
    }

    static JAXBContext newInstance(String string, Class<?>[] classArray, String string2, ClassLoader classLoader, Map<String, ?> map) throws JAXBException {
        try {
            Class<?> clazz = ServiceLoaderUtil.safeLoadClass(string2, DEFAULT_FACTORY_CLASS, classLoader);
            return ContextFinder.newInstance(string, classArray, clazz, classLoader, map);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXBException(Messages.format("ContextFinder.DefaultProviderNotFound"), classNotFoundException);
        }
        catch (JAXBException | RuntimeException exception) {
            Exception exception2 = exception;
            throw exception;
        }
        catch (Exception exception) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", string2, exception), exception);
        }
    }

    static JAXBContext newInstance(String string, Class<?>[] object, Class<?> clazz, ClassLoader classLoader, Map<String, ?> map) throws JAXBException {
        try {
            Object object2;
            Method method;
            ModuleUtil.delegateAddOpensToImplModule(object, clazz);
            object = null;
            try {
                method = clazz.getMethod("createContext", String.class, ClassLoader.class, Map.class);
                object2 = ContextFinder.instantiateProviderIfNecessary(clazz);
                object = method.invoke(object2, string, classLoader, map);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (object == null) {
                method = clazz.getMethod("createContext", String.class, ClassLoader.class);
                object2 = ContextFinder.instantiateProviderIfNecessary(clazz);
                object = method.invoke(object2, string, classLoader);
            }
            if (!(object instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(object.getClass(), JAXBContext.class);
            }
            return (JAXBContext)object;
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException;
            Throwable throwable = ContextFinder.handleInvocationTargetException(invocationTargetException);
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, throwable), throwable);
        }
        catch (Exception exception) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, exception), exception);
        }
    }

    private static Object instantiateProviderIfNecessary(Class<?> clazz) throws JAXBException {
        try {
            if (JAXBContextFactory.class.isAssignableFrom(clazz)) {
                return AccessController.doPrivileged(new ContextFinder$2(clazz));
            }
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            privilegedActionException2 = privilegedActionException.getCause() == null ? privilegedActionException2 : privilegedActionException2.getCause();
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, privilegedActionException2), privilegedActionException2);
        }
    }

    private static JAXBContext newInstance(Class<?>[] classArray, Map<String, ?> map, String string) throws JAXBException {
        return ContextFinder.newInstance(classArray, map, string, ContextFinder.getContextClassLoader());
    }

    private static JAXBContext newInstance(Class<?>[] classArray, Map<String, ?> map, String string, ClassLoader object) throws JAXBException {
        try {
            object = ServiceLoaderUtil.safeLoadClass(string, DEFAULT_FACTORY_CLASS, (ClassLoader)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXBException(Messages.format("ContextFinder.DefaultProviderNotFound"), classNotFoundException);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{string, ContextFinder.which(object)});
        }
        return ContextFinder.newInstance(classArray, map, object);
    }

    static JAXBContext newInstance(Class<?>[] object, Map<String, ?> map, Class<?> object2) throws JAXBException {
        try {
            ModuleUtil.delegateAddOpensToImplModule(object, object2);
            Method method = ((Class)object2).getMethod("createContext", Class[].class, Map.class);
            object2 = ContextFinder.instantiateProviderIfNecessary(object2);
            object = method.invoke(object2, object, map);
            if (!(object instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(object.getClass(), JAXBContext.class);
            }
            return (JAXBContext)object;
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new JAXBException(reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            object2 = ContextFinder.handleInvocationTargetException(invocationTargetException);
            throw new JAXBException((Throwable)object2);
        }
    }

    static JAXBContext find(String iterable, String string, ClassLoader classLoader, Map<String, ?> map) throws JAXBException {
        if (string == null || string.isEmpty()) {
            throw new JAXBException(Messages.format("ContextFinder.NoPackageInContextPath"));
        }
        Class<?>[] classArray = ModuleUtil.getClassesFromContextPath(string, classLoader);
        Object object22 = ContextFinder.classNameFromSystemProperties();
        if (object22 != null) {
            return ContextFinder.newInstance(string, classArray, (String)object22, classLoader, map);
        }
        if (map != null) {
            if ((iterable = map.get(iterable)) != null) {
                if (iterable instanceof String) {
                    object22 = (String)((Object)iterable);
                } else {
                    throw new JAXBException(Messages.format("JAXBContext.IllegalCast", iterable.getClass().getName(), "String"));
                }
            }
            if (object22 != null) {
                return ContextFinder.newInstance(string, classArray, (String)object22, classLoader, ContextFinder.cleanProperties(map));
            }
        }
        if ((iterable = ServiceLoaderUtil.firstByServiceLoader(JAXBContextFactory.class, logger, EXCEPTION_HANDLER)) != null) {
            ModuleUtil.delegateAddOpensToImplModule(classArray, iterable.getClass());
            return iterable.createContext(string, classLoader, map);
        }
        iterable = ServiceLoaderUtil.lookupsUsingOSGiServiceLoader("jakarta.xml.bind.JAXBContextFactory", logger);
        if (iterable != null) {
            for (Object object22 : iterable) {
                try {
                    return ContextFinder.newInstance(string, classArray, object22, classLoader, map);
                }
                catch (Throwable throwable) {
                    logger.log(Level.FINE, throwable, () -> ContextFinder.lambda$find$0((Class)object22));
                }
            }
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(string, classArray, DEFAULT_FACTORY_CLASS, classLoader, map);
    }

    static JAXBContext find(Class<?>[] classArray, Map<String, ?> map) throws JAXBException {
        Object object;
        Object object2 = ContextFinder.classNameFromSystemProperties();
        if (object2 != null) {
            return ContextFinder.newInstance(classArray, map, (String)object2);
        }
        if (map != null) {
            object = map.get("jakarta.xml.bind.JAXBContextFactory");
            if (object != null) {
                if (object instanceof String) {
                    object2 = (String)object;
                } else {
                    throw new JAXBException(Messages.format("JAXBContext.IllegalCast", object.getClass().getName(), "String"));
                }
            }
            if (object2 != null) {
                return ContextFinder.newInstance(classArray, ContextFinder.cleanProperties(map), (String)object2);
            }
        }
        if ((object = ServiceLoaderUtil.firstByServiceLoader(JAXBContextFactory.class, logger, EXCEPTION_HANDLER)) != null) {
            ModuleUtil.delegateAddOpensToImplModule(classArray, object.getClass());
            return object.createContext(classArray, map);
        }
        logger.fine("Trying to create the platform default provider");
        object2 = (Class)ServiceLoaderUtil.lookupUsingOSGiServiceLoader("jakarta.xml.bind.JAXBContextFactory", logger);
        if (object2 != null) {
            return ContextFinder.newInstance(classArray, map, object2);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(classArray, map, DEFAULT_FACTORY_CLASS);
    }

    private static String classNameFromSystemProperties() throws JAXBException {
        String string = ContextFinder.getSystemProperty("jakarta.xml.bind.JAXBContextFactory");
        if (string != null) {
            return string;
        }
        return null;
    }

    private static Map<String, ?> cleanProperties(Map<String, ?> map) {
        return map.entrySet().stream().filter(Predicate.not(entry -> "jakarta.xml.bind.JAXBContextFactory".equals(entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static String getSystemProperty(String string) {
        logger.log(Level.FINE, "Checking system property {0}", string);
        string = AccessController.doPrivileged(new GetPropertyAction(string));
        if (string != null) {
            logger.log(Level.FINE, "  found {0}", string);
        } else {
            logger.log(Level.FINE, "  not found");
        }
        return string;
    }

    static URL which(Class<?> object, ClassLoader classLoader) {
        object = ((Class)object).getName().replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ContextFinder.getSystemClassLoader();
        }
        return classLoader.getResource((String)object);
    }

    static URL which(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        return ContextFinder.which(clazz2, ContextFinder.getClassClassLoader(clazz2));
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new ContextFinder$3());
    }

    private static ClassLoader getClassClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new ContextFinder$4(clazz));
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new ContextFinder$5());
    }

    private static /* synthetic */ String lambda$find$0(Class clazz) {
        return "Error instantiating provider " + String.valueOf(clazz);
    }

    static {
        try {
            if (AccessController.doPrivileged(new GetPropertyAction("jaxb.debug")) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(Level.ALL);
                logger.addHandler(consoleHandler);
            }
        }
        catch (Throwable throwable) {}
        EXCEPTION_HANDLER = new ContextFinder$1();
    }
}

