/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind;

import jakarta.xml.bind.DatatypeConverter;
import jakarta.xml.bind.DatatypeConverterImpl$CalendarFormatter;
import jakarta.xml.bind.DatatypeConverterInterface;
import jakarta.xml.bind.WhiteSpaceProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

final class DatatypeConverterImpl
implements DatatypeConverterInterface {
    public static final DatatypeConverterInterface theInstance = new DatatypeConverterImpl();
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();
    private static final byte[] decodeMap = DatatypeConverterImpl.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] encodeMap = DatatypeConverterImpl.initEncodeMap();
    private static final DatatypeFactory datatypeFactory;

    protected DatatypeConverterImpl() {
    }

    @Override
    public final String parseString(String string) {
        return string;
    }

    @Override
    public final BigInteger parseInteger(String string) {
        return DatatypeConverterImpl._parseInteger(string);
    }

    public static BigInteger _parseInteger(CharSequence charSequence) {
        return new BigInteger(DatatypeConverterImpl.removeOptionalPlus(WhiteSpaceProcessor.trim(charSequence)).toString());
    }

    @Override
    public final String printInteger(BigInteger bigInteger) {
        return DatatypeConverterImpl._printInteger(bigInteger);
    }

    public static String _printInteger(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("val is null");
        }
        return bigInteger.toString();
    }

    @Override
    public final int parseInt(String string) {
        return DatatypeConverterImpl._parseInt(string);
    }

    public static int _parseInt(CharSequence charSequence) {
        int n2 = charSequence.length();
        int n3 = 1;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (WhiteSpaceProcessor.isWhiteSpace(c2)) continue;
            if ('0' <= c2 && c2 <= '9') {
                n4 = n4 * 10 + (c2 - 48);
                continue;
            }
            if (c2 == '-') {
                n3 = -1;
                continue;
            }
            if (c2 == '+') continue;
            throw new NumberFormatException("Not a number: " + String.valueOf(charSequence));
        }
        return n4 * n3;
    }

    @Override
    public final long parseLong(String string) {
        return DatatypeConverterImpl._parseLong(string);
    }

    public static long _parseLong(CharSequence charSequence) {
        return Long.parseLong(DatatypeConverterImpl.removeOptionalPlus(WhiteSpaceProcessor.trim(charSequence)).toString());
    }

    @Override
    public final short parseShort(String string) {
        return DatatypeConverterImpl._parseShort(string);
    }

    public static short _parseShort(CharSequence charSequence) {
        return (short)DatatypeConverterImpl._parseInt(charSequence);
    }

    @Override
    public final String printShort(short s2) {
        return DatatypeConverterImpl._printShort(s2);
    }

    public static String _printShort(short s2) {
        return String.valueOf(s2);
    }

    @Override
    public final BigDecimal parseDecimal(String string) {
        return DatatypeConverterImpl._parseDecimal(string);
    }

    public static BigDecimal _parseDecimal(CharSequence charSequence) {
        if ((charSequence = WhiteSpaceProcessor.trim(charSequence)).length() <= 0) {
            return null;
        }
        return new BigDecimal(charSequence.toString());
    }

    @Override
    public final float parseFloat(String string) {
        return DatatypeConverterImpl._parseFloat(string);
    }

    public static float _parseFloat(CharSequence charSequence) {
        block7: {
            block6: {
                if (((String)(charSequence = WhiteSpaceProcessor.trim(charSequence).toString())).equals("NaN")) {
                    return Float.NaN;
                }
                if (((String)charSequence).equals("INF")) {
                    return Float.POSITIVE_INFINITY;
                }
                if (((String)charSequence).equals("-INF")) {
                    return Float.NEGATIVE_INFINITY;
                }
                if (((String)charSequence).isEmpty() || !DatatypeConverterImpl.isDigitOrPeriodOrSign(((String)charSequence).charAt(0))) break block6;
                CharSequence charSequence2 = charSequence;
                if (DatatypeConverterImpl.isDigitOrPeriodOrSign(((String)charSequence2).charAt(((String)charSequence2).length() - 1))) break block7;
            }
            throw new NumberFormatException();
        }
        return Float.parseFloat((String)charSequence);
    }

    @Override
    public final String printFloat(float f2) {
        return DatatypeConverterImpl._printFloat(f2);
    }

    public static String _printFloat(float f2) {
        if (Float.isNaN(f2)) {
            return "NaN";
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (f2 == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return String.valueOf(f2);
    }

    @Override
    public final double parseDouble(String string) {
        return DatatypeConverterImpl._parseDouble(string);
    }

    public static double _parseDouble(CharSequence charSequence) {
        block7: {
            block6: {
                if (((String)(charSequence = WhiteSpaceProcessor.trim(charSequence).toString())).equals("NaN")) {
                    return Double.NaN;
                }
                if (((String)charSequence).equals("INF")) {
                    return Double.POSITIVE_INFINITY;
                }
                if (((String)charSequence).equals("-INF")) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (((String)charSequence).isEmpty() || !DatatypeConverterImpl.isDigitOrPeriodOrSign(((String)charSequence).charAt(0))) break block6;
                CharSequence charSequence2 = charSequence;
                if (DatatypeConverterImpl.isDigitOrPeriodOrSign(((String)charSequence2).charAt(((String)charSequence2).length() - 1))) break block7;
            }
            throw new NumberFormatException((String)charSequence);
        }
        return Double.parseDouble((String)charSequence);
    }

    @Override
    public final boolean parseBoolean(String string) {
        return DatatypeConverterImpl._parseBoolean(string);
    }

    public static Boolean _parseBoolean(CharSequence charSequence) {
        char c2;
        if (charSequence == null) {
            throw new IllegalArgumentException("String \"null\" is not valid boolean value.");
        }
        int n2 = 0;
        int n3 = charSequence.length();
        boolean bl2 = false;
        if (charSequence.length() <= 0) {
            throw new IllegalArgumentException("String \"\" is not valid boolean value.");
        }
        while (WhiteSpaceProcessor.isWhiteSpace(c2 = charSequence.charAt(n2++)) && n2 < n3) {
        }
        int n4 = 0;
        switch (c2) {
            case '1': {
                bl2 = true;
                break;
            }
            case '0': {
                bl2 = false;
                break;
            }
            case 't': {
                String string = "rue";
                do {
                    c2 = charSequence.charAt(n2++);
                } while (string.charAt(n4++) == c2 && n2 < n3 && n4 < 3);
                if (n4 == 3 && string.charAt(n4 - 1) == c2) {
                    bl2 = true;
                    break;
                }
                throw new IllegalArgumentException("String \"" + String.valueOf(charSequence) + "\" is not valid boolean value.");
            }
            case 'f': {
                String string = "alse";
                do {
                    c2 = charSequence.charAt(n2++);
                } while (string.charAt(n4++) == c2 && n2 < n3 && n4 < 4);
                if (n4 == 4 && string.charAt(n4 - 1) == c2) {
                    bl2 = false;
                    break;
                }
                throw new IllegalArgumentException("String \"" + String.valueOf(charSequence) + "\" is not valid boolean value.");
            }
        }
        while (n2 < n3 && WhiteSpaceProcessor.isWhiteSpace(charSequence.charAt(n2))) {
            ++n2;
        }
        if (n2 == n3) {
            return bl2;
        }
        throw new IllegalArgumentException("String \"" + String.valueOf(charSequence) + "\" is not valid boolean value.");
    }

    @Override
    public final String printBoolean(boolean bl2) {
        if (bl2) {
            return "true";
        }
        return "false";
    }

    public static String _printBoolean(boolean bl2) {
        if (bl2) {
            return "true";
        }
        return "false";
    }

    @Override
    public final byte parseByte(String string) {
        return DatatypeConverterImpl._parseByte(string);
    }

    public static byte _parseByte(CharSequence charSequence) {
        return (byte)DatatypeConverterImpl._parseInt(charSequence);
    }

    @Override
    public final String printByte(byte by2) {
        return DatatypeConverterImpl._printByte(by2);
    }

    public static String _printByte(byte by2) {
        return String.valueOf(by2);
    }

    @Override
    public final QName parseQName(String string, NamespaceContext namespaceContext) {
        return DatatypeConverterImpl._parseQName(string, namespaceContext);
    }

    public static QName _parseQName(CharSequence charSequence, NamespaceContext object) {
        String string;
        int n2;
        int n3;
        int n4 = charSequence.length();
        for (n3 = 0; n3 < n4 && WhiteSpaceProcessor.isWhiteSpace(charSequence.charAt(n3)); ++n3) {
        }
        while (n4 > n3 && WhiteSpaceProcessor.isWhiteSpace(charSequence.charAt(n4 - 1))) {
            --n4;
        }
        if (n4 == n3) {
            throw new IllegalArgumentException("input is empty");
        }
        for (n2 = n3 + 1; n2 < n4 && charSequence.charAt(n2) != ':'; ++n2) {
        }
        if (n2 == n4) {
            object = object.getNamespaceURI("");
            charSequence = charSequence.subSequence(n3, n4).toString();
            string = "";
        } else {
            string = charSequence.subSequence(n3, n2).toString();
            charSequence = charSequence.subSequence(n2 + 1, n4).toString();
            if ((object = object.getNamespaceURI(string)) == null || ((String)object).isEmpty()) {
                throw new IllegalArgumentException("prefix " + string + " is not bound to a namespace");
            }
        }
        return new QName((String)object, (String)charSequence, string);
    }

    @Override
    public final Calendar parseDateTime(String string) {
        return DatatypeConverterImpl._parseDateTime(string);
    }

    public static GregorianCalendar _parseDateTime(CharSequence charSequence) {
        charSequence = WhiteSpaceProcessor.trim(charSequence).toString();
        return datatypeFactory.newXMLGregorianCalendar((String)charSequence).toGregorianCalendar();
    }

    @Override
    public final String printDateTime(Calendar calendar) {
        return DatatypeConverterImpl._printDateTime(calendar);
    }

    public static String _printDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("val is null");
        }
        return DatatypeConverterImpl$CalendarFormatter.doFormat("%Y-%M-%DT%h:%m:%s%z", calendar);
    }

    @Override
    public final byte[] parseBase64Binary(String string) {
        return DatatypeConverterImpl._parseBase64Binary(string);
    }

    @Override
    public final byte[] parseHexBinary(String string) {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + string);
        }
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = DatatypeConverterImpl.hexToBin(string.charAt(i2));
            int n4 = DatatypeConverterImpl.hexToBin(string.charAt(i2 + 1));
            if (n3 == -1 || n4 == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + string);
            }
            byArray[i2 / 2] = (byte)((n3 << 4) + n4);
        }
        return byArray;
    }

    private static int hexToBin(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('A' <= c2 && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        return -1;
    }

    @Override
    public final String printHexBinary(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("data is null");
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length << 1);
        for (byte by2 : byArray) {
            stringBuilder.append(hexCode[by2 >> 4 & 0xF]);
            stringBuilder.append(hexCode[by2 & 0xF]);
        }
        return stringBuilder.toString();
    }

    @Override
    public final long parseUnsignedInt(String string) {
        return DatatypeConverterImpl._parseLong(string);
    }

    @Override
    public final String printUnsignedInt(long l2) {
        return DatatypeConverterImpl._printLong(l2);
    }

    @Override
    public final int parseUnsignedShort(String string) {
        return DatatypeConverterImpl._parseInt(string);
    }

    @Override
    public final Calendar parseTime(String string) {
        return datatypeFactory.newXMLGregorianCalendar(string).toGregorianCalendar();
    }

    @Override
    public final String printTime(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("val is null");
        }
        return DatatypeConverterImpl$CalendarFormatter.doFormat("%h:%m:%s%z", calendar);
    }

    @Override
    public final Calendar parseDate(String string) {
        return datatypeFactory.newXMLGregorianCalendar(string).toGregorianCalendar();
    }

    @Override
    public final String printDate(Calendar calendar) {
        return DatatypeConverterImpl._printDate(calendar);
    }

    public static String _printDate(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("val is null");
        }
        return DatatypeConverterImpl$CalendarFormatter.doFormat("%Y-%M-%D%z", calendar);
    }

    @Override
    public final String parseAnySimpleType(String string) {
        return string;
    }

    @Override
    public final String printString(String string) {
        return string;
    }

    @Override
    public final String printInt(int n2) {
        return DatatypeConverterImpl._printInt(n2);
    }

    public static String _printInt(int n2) {
        return String.valueOf(n2);
    }

    @Override
    public final String printLong(long l2) {
        return DatatypeConverterImpl._printLong(l2);
    }

    public static String _printLong(long l2) {
        return String.valueOf(l2);
    }

    @Override
    public final String printDecimal(BigDecimal bigDecimal) {
        return DatatypeConverterImpl._printDecimal(bigDecimal);
    }

    public static String _printDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("val is null");
        }
        return bigDecimal.toPlainString();
    }

    @Override
    public final String printDouble(double d2) {
        return DatatypeConverterImpl._printDouble(d2);
    }

    public static String _printDouble(double d2) {
        if (Double.isNaN(d2)) {
            return "NaN";
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return String.valueOf(d2);
    }

    @Override
    public final String printQName(QName qName, NamespaceContext namespaceContext) {
        return DatatypeConverterImpl._printQName(qName, namespaceContext);
    }

    public static String _printQName(QName object, NamespaceContext object2) {
        object2 = object2.getPrefix(((QName)object).getNamespaceURI());
        object = ((QName)object).getLocalPart();
        if (object2 != null && !((String)object2).isEmpty()) {
            object = (String)object2 + ":" + (String)object;
        }
        return object;
    }

    @Override
    public final String printBase64Binary(byte[] byArray) {
        return DatatypeConverterImpl._printBase64Binary(byArray);
    }

    @Override
    public final String printUnsignedShort(int n2) {
        return String.valueOf(n2);
    }

    @Override
    public final String printAnySimpleType(String string) {
        return string;
    }

    public static String installHook(String string) {
        DatatypeConverter.setDatatypeConverter(theInstance);
        return string;
    }

    private static byte[] initDecodeMap() {
        int n2;
        byte[] byArray = new byte[128];
        for (n2 = 0; n2 < 128; ++n2) {
            byArray[n2] = -1;
        }
        n2 = 65;
        while (n2 <= 90) {
            int n3 = n2++;
            byArray[n3] = (byte)(n3 - 65);
        }
        n2 = 97;
        while (n2 <= 122) {
            int n4 = n2++;
            byArray[n4] = (byte)(n4 - 97 + 26);
        }
        n2 = 48;
        while (n2 <= 57) {
            int n5 = n2++;
            byArray[n5] = (byte)(n5 - 48 + 52);
        }
        byArray[43] = 62;
        byArray[47] = 63;
        byArray[61] = 127;
        return byArray;
    }

    private static int guessLength(String string) {
        int n2;
        int n3;
        int n4 = string.length();
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            n2 = decodeMap[string.charAt(n3)];
            if (n2 == 127) continue;
            if (n2 != -1) break;
            return string.length() / 4 * 3;
        }
        if ((n2 = n4 - ++n3) > 2) {
            return string.length() / 4 * 3;
        }
        return string.length() / 4 * 3 - n2;
    }

    public static byte[] _parseBase64Binary(String string) {
        if (string == null || string.length() % 4 != 0) {
            throw new IllegalArgumentException("base64 text invalid.");
        }
        int n2 = DatatypeConverterImpl.guessLength(string);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = string.length();
        byte[] byArray2 = new byte[4];
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = string.charAt(i2);
            if ((c2 = decodeMap[c2]) != '\uffffffff') {
                byArray2[n5++] = c2;
            }
            if (n5 != 4) continue;
            byArray[n3++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            if (byArray2[2] != 127) {
                byArray[n3++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            }
            if (byArray2[3] != 127) {
                byArray[n3++] = (byte)(byArray2[2] << 6 | byArray2[3]);
            }
            n5 = 0;
        }
        if (n2 == n3) {
            return byArray;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        return byArray3;
    }

    private static char[] initEncodeMap() {
        int n2;
        char[] cArray = new char[64];
        for (n2 = 0; n2 < 26; ++n2) {
            cArray[n2] = (char)(n2 + 65);
        }
        for (n2 = 26; n2 < 52; ++n2) {
            cArray[n2] = (char)(97 + (n2 - 26));
        }
        for (n2 = 52; n2 < 62; ++n2) {
            cArray[n2] = (char)(48 + (n2 - 52));
        }
        cArray[62] = 43;
        cArray[63] = 47;
        return cArray;
    }

    public static char encode(int n2) {
        return encodeMap[n2 & 0x3F];
    }

    public static byte encodeByte(int n2) {
        return (byte)encodeMap[n2 & 0x3F];
    }

    public static String _printBase64Binary(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("input is null");
        }
        return DatatypeConverterImpl._printBase64Binary(byArray, 0, byArray.length);
    }

    public static String _printBase64Binary(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[(n3 + 2) / 3 << 2];
        int n4 = DatatypeConverterImpl._printBase64Binary(byArray, n2, n3, cArray, 0);
        assert (n4 == cArray.length);
        return new String(cArray);
    }

    public static int _printBase64Binary(byte[] byArray, int n2, int n3, char[] cArray, int n4) {
        while (n3 >= 3) {
            cArray[n4++] = DatatypeConverterImpl.encode(byArray[n2] >> 2);
            cArray[n4++] = DatatypeConverterImpl.encode((byArray[n2] & 3) << 4 | byArray[n2 + 1] >> 4 & 0xF);
            cArray[n4++] = DatatypeConverterImpl.encode((byArray[n2 + 1] & 0xF) << 2 | byArray[n2 + 2] >> 6 & 3);
            cArray[n4++] = DatatypeConverterImpl.encode(byArray[n2 + 2] & 0x3F);
            n3 -= 3;
            n2 += 3;
        }
        if (n3 == 1) {
            cArray[n4++] = DatatypeConverterImpl.encode(byArray[n2] >> 2);
            cArray[n4++] = DatatypeConverterImpl.encode((byArray[n2] & 3) << 4);
            cArray[n4++] = 61;
            cArray[n4++] = 61;
        }
        if (n3 == 2) {
            cArray[n4++] = DatatypeConverterImpl.encode(byArray[n2] >> 2);
            cArray[n4++] = DatatypeConverterImpl.encode((byArray[n2] & 3) << 4 | byArray[n2 + 1] >> 4 & 0xF);
            cArray[n4++] = DatatypeConverterImpl.encode((byArray[n2 + 1] & 0xF) << 2);
            cArray[n4++] = 61;
        }
        return n4;
    }

    public static int _printBase64Binary(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        while (n3 >= 3) {
            byArray2[n4++] = DatatypeConverterImpl.encodeByte(byArray[n2] >> 2);
            byArray2[n4++] = DatatypeConverterImpl.encodeByte((byArray[n2] & 3) << 4 | byArray[n2 + 1] >> 4 & 0xF);
            byArray2[n4++] = DatatypeConverterImpl.encodeByte((byArray[n2 + 1] & 0xF) << 2 | byArray[n2 + 2] >> 6 & 3);
            byArray2[n4++] = DatatypeConverterImpl.encodeByte(byArray[n2 + 2] & 0x3F);
            n3 -= 3;
            n2 += 3;
        }
        if (n3 == 1) {
            byArray2[n4++] = DatatypeConverterImpl.encodeByte(byArray[n2] >> 2);
            byArray2[n4++] = DatatypeConverterImpl.encodeByte((byArray[n2] & 3) << 4);
            byArray2[n4++] = 61;
            byArray2[n4++] = 61;
        }
        if (n3 == 2) {
            byArray2[n4++] = DatatypeConverterImpl.encodeByte(byArray[n2] >> 2);
            byArray2[n4++] = DatatypeConverterImpl.encodeByte((byArray[n2] & 3) << 4 | byArray[n2 + 1] >> 4 & 0xF);
            byArray2[n4++] = DatatypeConverterImpl.encodeByte((byArray[n2 + 1] & 0xF) << 2);
            byArray2[n4++] = 61;
        }
        return n4;
    }

    private static CharSequence removeOptionalPlus(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 <= 1 || charSequence.charAt(0) != '+') {
            return charSequence;
        }
        if (48 <= (n2 = (int)(charSequence = charSequence.subSequence(1, n2)).charAt(0)) && n2 <= 57) {
            return charSequence;
        }
        if (46 == n2) {
            return charSequence;
        }
        throw new NumberFormatException();
    }

    private static boolean isDigitOrPeriodOrSign(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return true;
        }
        return c2 == '+' || c2 == '-' || c2 == '.';
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
            return;
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new Error(datatypeConfigurationException);
        }
    }
}

