/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind;

import jakarta.xml.bind.Binder;
import jakarta.xml.bind.ContextFinder;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.SchemaOutputResolver;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import org.w3c.dom.Node;

public abstract class JAXBContext {
    public static final String JAXB_CONTEXT_FACTORY = "jakarta.xml.bind.JAXBContextFactory";

    protected JAXBContext() {
    }

    public static JAXBContext newInstance(String string) throws JAXBException {
        return JAXBContext.newInstance(string, JAXBContext.getContextClassLoader());
    }

    public static JAXBContext newInstance(String string, ClassLoader classLoader) throws JAXBException {
        return JAXBContext.newInstance(string, classLoader, Collections.emptyMap());
    }

    public static JAXBContext newInstance(String string, ClassLoader classLoader, Map<String, ?> map) throws JAXBException {
        return ContextFinder.find(JAXB_CONTEXT_FACTORY, string, classLoader, map);
    }

    public static JAXBContext newInstance(Class<?> ... classArray) throws JAXBException {
        return JAXBContext.newInstance(classArray, Collections.emptyMap());
    }

    public static JAXBContext newInstance(Class<?>[] classArray, Map<String, ?> map) throws JAXBException {
        if (classArray == null) {
            throw new IllegalArgumentException();
        }
        for (int i2 = classArray.length - 1; i2 >= 0; --i2) {
            if (classArray[i2] != null) continue;
            throw new IllegalArgumentException();
        }
        return ContextFinder.find(classArray, map);
    }

    public abstract Unmarshaller createUnmarshaller() throws JAXBException;

    public abstract Marshaller createMarshaller() throws JAXBException;

    public <T> Binder<T> createBinder(Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    public Binder<Node> createBinder() {
        return this.createBinder(Node.class);
    }

    public JAXBIntrospector createJAXBIntrospector() {
        throw new UnsupportedOperationException();
    }

    public void generateSchema(SchemaOutputResolver schemaOutputResolver) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }
}

