/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class ModuleUtil {
    private static final Logger LOGGER;
    private static final boolean JPMS_SUPPORTED;

    ModuleUtil() {
    }

    static Class<?>[] getClassesFromContextPath(String stringArray, ClassLoader classLoader) throws JAXBException {
        ArrayList arrayList = new ArrayList();
        if (stringArray == null || stringArray.isEmpty()) {
            return arrayList.toArray(new Class[0]);
        }
        String[] stringArray2 = stringArray.split(":");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class<?> clazz;
            String string = stringArray[i2];
            try {
                clazz = classLoader.loadClass(string + ".ObjectFactory");
                arrayList.add(clazz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = ModuleUtil.findFirstByJaxbIndex(string, classLoader);
                    if (clazz == null) continue;
                    arrayList.add(clazz);
                    continue;
                }
                catch (IOException iOException) {
                    throw new JAXBException(iOException);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Resolved classes from context path: {0}", arrayList);
        }
        return arrayList.toArray(new Class[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Class<?> findFirstByJaxbIndex(String string, ClassLoader clazz) throws IOException, JAXBException {
        Object object = string.replace('.', '/') + "/jaxb.index";
        if ((object = ((ClassLoader)((Object)clazz)).getResourceAsStream((String)object)) == null) {
            return null;
        }
        object = new BufferedReader(new InputStreamReader((InputStream)object, StandardCharsets.UTF_8));
        try {
            String string2 = ((BufferedReader)object).readLine();
            while (string2 != null) {
                if ((string2 = string2.trim()).startsWith("#") || string2.isEmpty()) {
                    string2 = ((BufferedReader)object).readLine();
                    continue;
                }
                try {
                    clazz = ((ClassLoader)((Object)clazz)).loadClass(string + "." + string2);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        throw new JAXBException(Messages.format("ContextFinder.ErrorLoadClass", string2, string), classNotFoundException);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
        finally {
            ((BufferedReader)object).close();
        }
    }

    public static void delegateAddOpensToImplModule(Class<?>[] classArray, Class<?> annotatedElement) throws JAXBException {
        if (JPMS_SUPPORTED) {
            annotatedElement = ((Class)annotatedElement).getModule();
            Module module = JAXBContext.class.getModule();
            if (!module.isNamed()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Using jakarta.xml.bind-api on the class path.");
                }
                return;
            }
            for (Class<?> clazz : classArray) {
                clazz = clazz.isArray() ? clazz.getComponentType() : clazz;
                Module module2 = clazz.getModule();
                String string = clazz.getPackageName();
                if (!module2.isNamed() || module2.getName().equals("java.base")) continue;
                if (!module2.isOpen(string, module)) {
                    throw new JAXBException(Messages.format("JAXBClasses.notOpen", string, clazz.getName(), module2.getName()));
                }
                module2.addOpens(string, (Module)annotatedElement);
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Propagating openness of package {0} in {1} to {2}.", new String[]{string, module2.getName(), ((Module)annotatedElement).getName()});
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Using jakarta.xml.bind-api with no JPMS related APIs, such as Class::getModule.");
        }
    }

    static {
        boolean bl2;
        LOGGER = Logger.getLogger("jakarta.xml.bind");
        try {
            JAXBContext.class.getModule();
            bl2 = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            bl2 = false;
        }
        JPMS_SUPPORTED = bl2;
    }
}

