/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind.helpers;

import jakarta.xml.bind.ValidationEventLocator;
import jakarta.xml.bind.helpers.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.w3c.dom.Node;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class ValidationEventLocatorImpl
implements ValidationEventLocator {
    private URL url = null;
    private int offset = -1;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private Object object = null;
    private Node node = null;

    public ValidationEventLocatorImpl() {
    }

    public ValidationEventLocatorImpl(Locator locator) {
        if (locator == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "loc"));
        }
        this.url = ValidationEventLocatorImpl.toURL(locator.getSystemId());
        this.columnNumber = locator.getColumnNumber();
        this.lineNumber = locator.getLineNumber();
    }

    public ValidationEventLocatorImpl(SAXParseException sAXParseException) {
        if (sAXParseException == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "e"));
        }
        this.url = ValidationEventLocatorImpl.toURL(sAXParseException.getSystemId());
        this.columnNumber = sAXParseException.getColumnNumber();
        this.lineNumber = sAXParseException.getLineNumber();
    }

    public ValidationEventLocatorImpl(Node node) {
        if (node == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "_node"));
        }
        this.node = node;
    }

    public ValidationEventLocatorImpl(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "_object"));
        }
        this.object = object;
    }

    private static URL toURL(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n2) {
        this.offset = n2;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n2) {
        this.lineNumber = n2;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int n2) {
        this.columnNumber = n2;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String toString() {
        return MessageFormat.format("[node={0},object={1},url={2},line={3},col={4},offset={5}]", this.getNode(), this.getObject(), this.getURL(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber()), String.valueOf(this.getOffset()));
    }
}

