/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.scenario.animation.NumberTangentInterpolator;
import com.sun.scenario.animation.SplineInterpolator;
import javafx.animation.Interpolatable;
import javafx.animation.Interpolator$1;
import javafx.animation.Interpolator$2;
import javafx.animation.Interpolator$3;
import javafx.animation.Interpolator$4;
import javafx.animation.Interpolator$5;
import javafx.util.Duration;

public abstract class Interpolator {
    private static final double EPSILON = 1.0E-12;
    public static final Interpolator DISCRETE = new Interpolator$1();
    public static final Interpolator LINEAR = new Interpolator$2();
    public static final Interpolator EASE_BOTH = new Interpolator$3();
    public static final Interpolator EASE_IN = new Interpolator$4();
    public static final Interpolator EASE_OUT = new Interpolator$5();

    protected Interpolator() {
    }

    public static Interpolator SPLINE(double d2, double d3, double d4, double d5) {
        return new SplineInterpolator(d2, d3, d4, d5);
    }

    public static Interpolator TANGENT(Duration duration, double d2, Duration duration2, double d3) {
        return new NumberTangentInterpolator(duration, d2, duration2, d3);
    }

    public static Interpolator TANGENT(Duration duration, double d2) {
        return new NumberTangentInterpolator(duration, d2);
    }

    public Object interpolate(Object object, Object object2, double d2) {
        if (object instanceof Number && object2 instanceof Number) {
            double d3 = ((Number)object).doubleValue();
            double d4 = ((Number)object2).doubleValue();
            double d5 = d3 + (d4 - d3) * this.curve(d2);
            if (object instanceof Double || object2 instanceof Double) {
                return d5;
            }
            if (object instanceof Float || object2 instanceof Float) {
                return Float.valueOf((float)d5);
            }
            if (object instanceof Long || object2 instanceof Long) {
                return Math.round(d5);
            }
            return (int)Math.round(d5);
        }
        if (object instanceof Interpolatable && object2 instanceof Interpolatable) {
            return ((Interpolatable)object).interpolate(object2, this.curve(d2));
        }
        if (this.curve(d2) == 1.0) {
            return object2;
        }
        return object;
    }

    public boolean interpolate(boolean bl2, boolean bl3, double d2) {
        if (Math.abs(this.curve(d2) - 1.0) < 1.0E-12) {
            return bl3;
        }
        return bl2;
    }

    public double interpolate(double d2, double d3, double d4) {
        return d2 + (d3 - d2) * this.curve(d4);
    }

    public int interpolate(int n2, int n3, double d2) {
        return n2 + (int)Math.round((double)(n3 - n2) * this.curve(d2));
    }

    public long interpolate(long l2, long l3, double d2) {
        return l2 + Math.round((double)(l3 - l2) * this.curve(d2));
    }

    private static double clamp(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 1.0;
        }
        return d2;
    }

    protected abstract double curve(double var1);
}

