/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javafx.animation.KeyValue;
import javafx.beans.NamedArg;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;

public final class KeyFrame {
    private static final EventHandler<ActionEvent> DEFAULT_ON_FINISHED = null;
    private static final String DEFAULT_NAME = null;
    private final Duration time;
    private final Set<KeyValue> values;
    private final EventHandler<ActionEvent> onFinished;
    private final String name;

    public final Duration getTime() {
        return this.time;
    }

    public final Set<KeyValue> getValues() {
        return this.values;
    }

    public final EventHandler<ActionEvent> getOnFinished() {
        return this.onFinished;
    }

    public final String getName() {
        return this.name;
    }

    public KeyFrame(@NamedArg(value="time") Duration serializable, @NamedArg(value="name") String string, @NamedArg(value="onFinished") EventHandler<ActionEvent> eventHandler, @NamedArg(value="values") Collection<KeyValue> collection) {
        if (serializable == null) {
            throw new NullPointerException("The time has to be specified");
        }
        if (((Duration)serializable).lessThan(Duration.ZERO) || ((Duration)serializable).equals(Duration.UNKNOWN)) {
            throw new IllegalArgumentException("The time is invalid.");
        }
        this.time = serializable;
        this.name = string;
        if (collection != null) {
            serializable = new CopyOnWriteArraySet<KeyValue>(collection);
            serializable.remove(null);
            this.values = serializable.size() == 0 ? Collections.emptySet() : (serializable.size() == 1 ? Collections.singleton((KeyValue)serializable.iterator().next()) : Collections.unmodifiableSet(serializable));
        } else {
            this.values = Collections.emptySet();
        }
        this.onFinished = eventHandler;
    }

    public KeyFrame(@NamedArg(value="time") Duration serializable, @NamedArg(value="name") String keyValueArray, @NamedArg(value="onFinished") EventHandler<ActionEvent> eventHandler, KeyValue ... keyValueArray2) {
        if (serializable == null) {
            throw new NullPointerException("The time has to be specified");
        }
        if (((Duration)serializable).lessThan(Duration.ZERO) || ((Duration)serializable).equals(Duration.UNKNOWN)) {
            throw new IllegalArgumentException("The time is invalid.");
        }
        this.time = serializable;
        this.name = keyValueArray;
        if (keyValueArray2 != null) {
            serializable = new CopyOnWriteArraySet();
            keyValueArray = keyValueArray2;
            int n2 = keyValueArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                KeyValue keyValue = keyValueArray[i2];
                if (keyValue == null) continue;
                serializable.add(keyValue);
            }
            this.values = serializable.size() == 0 ? Collections.emptySet() : (serializable.size() == 1 ? Collections.singleton((KeyValue)serializable.iterator().next()) : Collections.unmodifiableSet(serializable));
        } else {
            this.values = Collections.emptySet();
        }
        this.onFinished = eventHandler;
    }

    public KeyFrame(@NamedArg(value="time") Duration duration, @NamedArg(value="onFinished") EventHandler<ActionEvent> eventHandler, KeyValue ... keyValueArray) {
        this(duration, DEFAULT_NAME, eventHandler, keyValueArray);
    }

    public KeyFrame(@NamedArg(value="time") Duration duration, @NamedArg(value="name") String string, KeyValue ... keyValueArray) {
        this(duration, string, DEFAULT_ON_FINISHED, keyValueArray);
    }

    public KeyFrame(@NamedArg(value="time") Duration duration, KeyValue ... keyValueArray) {
        this(duration, DEFAULT_NAME, DEFAULT_ON_FINISHED, keyValueArray);
    }

    public final String toString() {
        return "KeyFrame [time=" + String.valueOf(this.time) + ", values=" + String.valueOf(this.values) + ", onFinished=" + String.valueOf(this.onFinished) + ", name=" + this.name + "]";
    }

    public final int hashCode() {
        assert (this.time != null && this.values != null);
        int n2 = 31 + this.time.hashCode();
        n2 = n2 * 31 + (this.name == null ? 0 : this.name.hashCode());
        n2 = n2 * 31 + (this.onFinished == null ? 0 : this.onFinished.hashCode());
        n2 = n2 * 31 + this.values.hashCode();
        return n2;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof KeyFrame) {
            object = (KeyFrame)object;
            assert (this.time != null && this.values != null && ((KeyFrame)object).time != null && ((KeyFrame)object).values != null);
            return this.time.equals(((KeyFrame)object).time) && (this.name == null ? ((KeyFrame)object).name == null : this.name.equals(((KeyFrame)object).name)) && (this.onFinished == null ? ((KeyFrame)object).onFinished == null : this.onFinished.equals(((KeyFrame)object).onFinished)) && this.values.equals(((KeyFrame)object).values);
        }
        return false;
    }
}

