/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import java.util.HashSet;
import java.util.Set;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition$1;
import javafx.animation.ParallelTransition$2;
import javafx.animation.ParallelTransition$3;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.util.Duration;

public final class ParallelTransition
extends Transition {
    private static final Animation[] EMPTY_ANIMATION_ARRAY = new Animation[0];
    private static final double EPSILON = 1.0E-12;
    private Animation[] cachedChildren = EMPTY_ANIMATION_ARRAY;
    private long[] durations;
    private long[] delays;
    private double[] rates;
    private long[] offsetTicks;
    private boolean[] forceChildSync;
    private long oldTicks;
    private long cycleTime;
    private boolean childrenChanged = true;
    private boolean toggledRate;
    private final InvalidationListener childrenListener = observable -> {
        this.childrenChanged = true;
        if (this.getStatus() == Animation$Status.STOPPED) {
            ParallelTransition parallelTransition = this;
            parallelTransition.setCycleDuration(parallelTransition.computeCycleDuration());
        }
    };
    private final ChangeListener<Number> rateListener = new ParallelTransition$1(this);
    private ObjectProperty<Node> node;
    private static final Node DEFAULT_NODE = null;
    private final Set<Animation> childrenSet = new HashSet<Animation>();
    private final ObservableList<Animation> children = new ParallelTransition$3(this, new ParallelTransition$2(this));

    public final void setNode(Node node) {
        if (this.node != null || node != null) {
            this.nodeProperty().set(node);
        }
    }

    public final Node getNode() {
        if (this.node == null) {
            return DEFAULT_NODE;
        }
        return (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty<Node>(this, "node", DEFAULT_NODE);
        }
        return this.node;
    }

    private static boolean checkCycle(Animation animation, Animation animation2) {
        while (animation2 != animation) {
            if (animation2.parent != null) {
                animation2 = animation2.parent;
                continue;
            }
            return false;
        }
        return true;
    }

    public final ObservableList<Animation> getChildren() {
        return this.children;
    }

    public ParallelTransition(Node node, Animation ... animationArray) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
        this.getChildren().setAll((Animation[])animationArray);
    }

    public ParallelTransition(Animation ... animationArray) {
        this((Node)null, animationArray);
    }

    public ParallelTransition(Node node) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
    }

    public ParallelTransition() {
        this((Node)null);
    }

    ParallelTransition(AbstractPrimaryTimer abstractPrimaryTimer) {
        super(abstractPrimaryTimer);
        this.setInterpolator(Interpolator.LINEAR);
    }

    @Override
    protected final Node getParentTargetNode() {
        Node node = this.getNode();
        if (node != null) {
            return node;
        }
        if (this.parent != null && this.parent instanceof Transition) {
            return ((Transition)this.parent).getParentTargetNode();
        }
        return null;
    }

    private Duration computeCycleDuration() {
        Duration object = Duration.ZERO;
        for (Animation animation : this.getChildren()) {
            double d2;
            double d3 = Math.abs(animation.getRate());
            Duration d32 = d2 < 1.0E-12 ? animation.getTotalDuration() : animation.getTotalDuration().divide(d3);
            Duration object2 = d32.add(animation.getDelay());
            if (object2.isIndefinite()) {
                return Duration.INDEFINITE;
            }
            if (!object2.greaterThan(object)) continue;
            object = object2;
        }
        return object;
    }

    private double calculateFraction(long l2, long l3) {
        double d2;
        double d3 = (double)l2 / (double)l3;
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (d3 >= 1.0) {
            return 1.0;
        }
        return d3;
    }

    private boolean startChild(Animation animation, int n2) {
        boolean bl2 = this.forceChildSync[n2];
        if (animation.startable(bl2)) {
            animation.clipEnvelope.setRate(this.rates[n2] * Math.signum(this.getCurrentRate()));
            animation.doStart(bl2);
            this.forceChildSync[n2] = false;
            return true;
        }
        return false;
    }

    @Override
    final void sync(boolean n2) {
        super.sync(n2 != 0);
        if (n2 && this.childrenChanged || this.durations == null) {
            this.cachedChildren = this.getChildren().toArray(EMPTY_ANIMATION_ARRAY);
            n2 = this.cachedChildren.length;
            this.durations = new long[n2];
            this.delays = new long[n2];
            this.rates = new double[n2];
            this.offsetTicks = new long[n2];
            this.forceChildSync = new boolean[n2];
            this.cycleTime = 0L;
            int n3 = 0;
            Animation[] animationArray = this.cachedChildren;
            int n4 = this.cachedChildren.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                Animation animation = animationArray[i2];
                this.rates[n3] = Math.abs(animation.getRate());
                if (this.rates[n3] < 1.0E-12) {
                    this.rates[n3] = 1.0;
                }
                this.durations[n3] = TickCalculation.fromDuration(animation.getTotalDuration(), this.rates[n3]);
                this.delays[n3] = TickCalculation.fromDuration(animation.getDelay());
                this.cycleTime = Math.max(this.cycleTime, TickCalculation.add(this.durations[n3], this.delays[n3]));
                this.forceChildSync[n3] = true;
                ++n3;
            }
            this.childrenChanged = false;
            return;
        }
        if (n2) {
            n2 = this.forceChildSync.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                this.forceChildSync[i3] = true;
            }
        }
    }

    @Override
    final void doPause() {
        super.doPause();
        Animation[] animationArray = this.cachedChildren;
        int n2 = this.cachedChildren.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Animation animation = animationArray[i2];
            if (animation.getStatus() != Animation$Status.RUNNING) continue;
            animation.doPause();
        }
    }

    @Override
    final void doResume() {
        super.doResume();
        int n2 = 0;
        Animation[] animationArray = this.cachedChildren;
        int n3 = this.cachedChildren.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Animation animation = animationArray[i2];
            if (animation.getStatus() == Animation$Status.PAUSED) {
                animation.doResume();
                animation.clipEnvelope.setRate(this.rates[n2] * Math.signum(this.getCurrentRate()));
            }
            ++n2;
        }
    }

    @Override
    final void doStart(boolean bl2) {
        super.doStart(bl2);
        this.toggledRate = false;
        this.rateProperty().addListener(this.rateListener);
        double d2 = this.getCurrentRate();
        long l2 = TickCalculation.fromDuration(this.getCurrentTime());
        if (d2 < 0.0) {
            this.jumpToEnd();
            if (l2 < this.cycleTime) {
                this.doJumpTo(l2, this.cycleTime, false);
                return;
            }
        } else {
            this.jumpToStart();
            if (l2 > 0L) {
                this.doJumpTo(l2, this.cycleTime, false);
            }
        }
    }

    @Override
    final void doStop() {
        super.doStop();
        Animation[] animationArray = this.cachedChildren;
        int n2 = this.cachedChildren.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Animation animation = animationArray[i2];
            if (animation.getStatus() == Animation$Status.STOPPED) continue;
            animation.doStop();
        }
        if (this.childrenChanged) {
            ParallelTransition parallelTransition = this;
            parallelTransition.setCycleDuration(parallelTransition.computeCycleDuration());
        }
        this.rateProperty().removeListener(this.rateListener);
    }

    @Override
    final void doPlayTo(long l2, long l3) {
        this.setCurrentTicks(l2);
        double d2 = this.calculateFraction(l2, l3);
        long l4 = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, l3, d2), l3));
        if (this.toggledRate) {
            for (int i2 = 0; i2 < this.cachedChildren.length; ++i2) {
                if (this.cachedChildren[i2].getStatus() != Animation$Status.RUNNING) continue;
                int n2 = i2;
                this.offsetTicks[n2] = (long)((double)this.offsetTicks[n2] - Math.signum(this.getCurrentRate()) * (double)(this.durations[i2] - 2L * (this.oldTicks - this.delays[i2])));
            }
            this.toggledRate = false;
        }
        if (this.getCurrentRate() > 0.0) {
            int n3 = 0;
            Animation[] animationArray = this.cachedChildren;
            int n4 = this.cachedChildren.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                Object object = animationArray[i3];
                if (l4 >= this.delays[n3] && (this.oldTicks <= this.delays[n3] || l4 < TickCalculation.add(this.delays[n3], this.durations[n3]) && ((Animation)object).getStatus() == Animation$Status.STOPPED)) {
                    boolean bl2;
                    boolean bl3 = bl2 = this.oldTicks <= this.delays[n3];
                    if (this.startChild((Animation)object, n3)) {
                        ((Animation)object).clipEnvelope.jumpTo(0L);
                    } else {
                        if (!bl2 || (object = ((Animation)object).getOnFinished()) == null) continue;
                        object.handle(new ActionEvent(this, null));
                        continue;
                    }
                }
                if (l4 >= TickCalculation.add(this.durations[n3], this.delays[n3])) {
                    if (((Animation)object).getStatus() == Animation$Status.RUNNING) {
                        ((Animation)object).doTimePulse(TickCalculation.sub(this.durations[n3], this.offsetTicks[n3]));
                        this.offsetTicks[n3] = 0L;
                    }
                } else if (l4 > this.delays[n3]) {
                    ((Animation)object).doTimePulse(TickCalculation.sub(l4 - this.delays[n3], this.offsetTicks[n3]));
                }
                ++n3;
            }
        } else {
            int n5 = 0;
            Animation[] animationArray = this.cachedChildren;
            int n6 = this.cachedChildren.length;
            for (int i4 = 0; i4 < n6; ++i4) {
                Object object = animationArray[i4];
                if (l4 < TickCalculation.add(this.durations[n5], this.delays[n5])) {
                    if (this.oldTicks >= TickCalculation.add(this.durations[n5], this.delays[n5]) || l4 >= this.delays[n5] && ((Animation)object).getStatus() == Animation$Status.STOPPED) {
                        boolean bl4;
                        boolean bl5 = bl4 = this.oldTicks >= TickCalculation.add(this.durations[n5], this.delays[n5]);
                        if (this.startChild((Animation)object, n5)) {
                            ((Animation)object).clipEnvelope.jumpTo(Math.round((double)this.durations[n5] * this.rates[n5]));
                        } else {
                            if (!bl4 || (object = ((Animation)object).getOnFinished()) == null) continue;
                            object.handle(new ActionEvent(this, null));
                            continue;
                        }
                    }
                    if (l4 <= this.delays[n5]) {
                        if (((Animation)object).getStatus() == Animation$Status.RUNNING) {
                            ((Animation)object).doTimePulse(TickCalculation.sub(this.durations[n5], this.offsetTicks[n5]));
                            this.offsetTicks[n5] = 0L;
                        }
                    } else {
                        ((Animation)object).doTimePulse(TickCalculation.sub(TickCalculation.add(this.durations[n5], this.delays[n5]) - l4, this.offsetTicks[n5]));
                    }
                }
                ++n5;
            }
        }
        this.oldTicks = l4;
    }

    @Override
    final void doJumpTo(long l2, long l3, boolean bl2) {
        this.setCurrentTicks(l2);
        if (this.getStatus() == Animation$Status.STOPPED && !bl2) {
            return;
        }
        this.sync(false);
        double d2 = this.calculateFraction(l2, l3);
        long l4 = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, l3, d2), l3));
        int n2 = 0;
        Animation[] animationArray = this.cachedChildren;
        int n3 = this.cachedChildren.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Animation animation = animationArray[i2];
            Animation$Status animation$Status = animation.getStatus();
            if (l4 <= this.delays[n2]) {
                this.offsetTicks[n2] = 0L;
                if (animation$Status != Animation$Status.STOPPED) {
                    animation.clipEnvelope.jumpTo(0L);
                    animation.doStop();
                } else if (TickCalculation.fromDuration(animation.getCurrentTime()) != 0L) {
                    animation.doJumpTo(0L, this.durations[n2], true);
                }
            } else if (l4 >= TickCalculation.add(this.durations[n2], this.delays[n2])) {
                this.offsetTicks[n2] = 0L;
                if (animation$Status != Animation$Status.STOPPED) {
                    animation.clipEnvelope.jumpTo(Math.round((double)this.durations[n2] * this.rates[n2]));
                    animation.doStop();
                } else if (TickCalculation.fromDuration(animation.getCurrentTime()) != this.durations[n2]) {
                    animation.doJumpTo(this.durations[n2], this.durations[n2], true);
                }
            } else {
                if (animation$Status == Animation$Status.STOPPED) {
                    this.startChild(animation, n2);
                    if (this.getStatus() == Animation$Status.PAUSED) {
                        animation.doPause();
                    }
                    this.offsetTicks[n2] = this.getCurrentRate() > 0.0 ? l4 - this.delays[n2] : TickCalculation.add(this.durations[n2], this.delays[n2]) - l4;
                } else if (animation$Status == Animation$Status.PAUSED) {
                    int n4 = n2;
                    this.offsetTicks[n4] = (long)((double)this.offsetTicks[n4] + (double)(l4 - this.oldTicks) * Math.signum(this.clipEnvelope.getCurrentRate()));
                } else {
                    int n5 = n2;
                    this.offsetTicks[n5] = this.offsetTicks[n5] + (this.getCurrentRate() > 0.0 ? l4 - this.oldTicks : this.oldTicks - l4);
                }
                animation.clipEnvelope.jumpTo(Math.round((double)TickCalculation.sub(l4, this.delays[n2]) * this.rates[n2]));
            }
            ++n2;
        }
        this.oldTicks = l4;
    }

    @Override
    protected final void interpolate(double d2) {
    }

    private void jumpToEnd() {
        for (int i2 = 0; i2 < this.cachedChildren.length; ++i2) {
            if (this.forceChildSync[i2]) {
                this.cachedChildren[i2].sync(true);
            }
            this.cachedChildren[i2].doJumpTo(this.durations[i2], this.durations[i2], true);
        }
    }

    private void jumpToStart() {
        for (int i2 = this.cachedChildren.length - 1; i2 >= 0; --i2) {
            if (this.forceChildSync[i2]) {
                this.cachedChildren[i2].sync(true);
            }
            this.cachedChildren[i2].doJumpTo(0L, this.durations[i2], true);
        }
    }
}

