/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import java.util.ArrayList;
import javafx.animation.PathTransition$1;
import javafx.animation.PathTransition$OrientationType;
import javafx.animation.PathTransition$Segment;
import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public final class PathTransition
extends Transition {
    private ObjectProperty<Node> node;
    private double totalLength = 0.0;
    private final ArrayList<PathTransition$Segment> segments = new ArrayList();
    private static final Node DEFAULT_NODE = null;
    private static final int SMOOTH_ZONE = 10;
    private Node cachedNode;
    private ObjectProperty<Duration> duration;
    private static final Duration DEFAULT_DURATION = Duration.millis(400.0);
    private ObjectProperty<Shape> path;
    private static final Shape DEFAULT_PATH = null;
    private ObjectProperty<PathTransition$OrientationType> orientation;
    private static final PathTransition$OrientationType DEFAULT_ORIENTATION = PathTransition$OrientationType.NONE;
    private boolean cachedIsNormalRequired;

    public final void setNode(Node node) {
        if (this.node != null || node != null) {
            this.nodeProperty().set(node);
        }
    }

    public final Node getNode() {
        if (this.node == null) {
            return DEFAULT_NODE;
        }
        return (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty<Node>(this, "node", DEFAULT_NODE);
        }
        return this.node;
    }

    public final void setDuration(Duration duration) {
        if (this.duration != null || !DEFAULT_DURATION.equals(duration)) {
            this.durationProperty().set(duration);
        }
    }

    public final Duration getDuration() {
        if (this.duration == null) {
            return DEFAULT_DURATION;
        }
        return (Duration)this.duration.get();
    }

    public final ObjectProperty<Duration> durationProperty() {
        if (this.duration == null) {
            this.duration = new PathTransition$1(this, DEFAULT_DURATION);
        }
        return this.duration;
    }

    public final void setPath(Shape shape) {
        if (this.path != null || shape != null) {
            this.pathProperty().set(shape);
        }
    }

    public final Shape getPath() {
        if (this.path == null) {
            return DEFAULT_PATH;
        }
        return (Shape)this.path.get();
    }

    public final ObjectProperty<Shape> pathProperty() {
        if (this.path == null) {
            this.path = new SimpleObjectProperty<Shape>(this, "path", DEFAULT_PATH);
        }
        return this.path;
    }

    public final void setOrientation(PathTransition$OrientationType pathTransition$OrientationType) {
        if (this.orientation != null || !DEFAULT_ORIENTATION.equals((Object)pathTransition$OrientationType)) {
            this.orientationProperty().set(pathTransition$OrientationType);
        }
    }

    public final PathTransition$OrientationType getOrientation() {
        if (this.orientation == null) {
            return PathTransition$OrientationType.NONE;
        }
        return (PathTransition$OrientationType)((Object)this.orientation.get());
    }

    public final ObjectProperty<PathTransition$OrientationType> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new SimpleObjectProperty<PathTransition$OrientationType>(this, "orientation", DEFAULT_ORIENTATION);
        }
        return this.orientation;
    }

    public PathTransition(Duration duration, Shape shape, Node node) {
        this.setDuration(duration);
        this.setPath(shape);
        this.setNode(node);
        this.setCycleDuration(duration);
    }

    public PathTransition(Duration duration, Shape shape) {
        this(duration, shape, null);
    }

    public PathTransition() {
        this(DEFAULT_DURATION, null, null);
    }

    @Override
    public final void interpolate(double d2) {
        double d3 = this.totalLength * Math.min(1.0, Math.max(0.0, d2));
        int n2 = this.findSegment(0, this.segments.size() - 1, d3);
        PathTransition$Segment pathTransition$Segment = this.segments.get(n2);
        double d4 = pathTransition$Segment.accumLength - pathTransition$Segment.length;
        double d5 = d3 - d4;
        double d6 = d5 / pathTransition$Segment.length;
        PathTransition$Segment pathTransition$Segment2 = pathTransition$Segment.prevSeg;
        double d7 = pathTransition$Segment2.toX + (pathTransition$Segment.toX - pathTransition$Segment2.toX) * d6;
        double d8 = pathTransition$Segment2.toY + (pathTransition$Segment.toY - pathTransition$Segment2.toY) * d6;
        double d9 = pathTransition$Segment.rotateAngle;
        double d10 = Math.min(10.0, pathTransition$Segment.length / 2.0);
        if (d5 < d10 && !pathTransition$Segment2.isMoveTo) {
            d9 = PathTransition.interpolate(pathTransition$Segment2.rotateAngle, pathTransition$Segment.rotateAngle, d5 / d10 / 2.0 + 0.5);
        } else {
            double d11 = pathTransition$Segment.length - d5;
            pathTransition$Segment2 = pathTransition$Segment.nextSeg;
            if (d11 < d10 && pathTransition$Segment2 != null && !pathTransition$Segment2.isMoveTo) {
                d9 = PathTransition.interpolate(pathTransition$Segment.rotateAngle, pathTransition$Segment2.rotateAngle, (d10 - d11) / d10 / 2.0);
            }
        }
        this.cachedNode.setTranslateX(d7 - NodeHelper.getPivotX(this.cachedNode));
        this.cachedNode.setTranslateY(d8 - NodeHelper.getPivotY(this.cachedNode));
        if (this.cachedIsNormalRequired) {
            this.cachedNode.setRotate(d9);
        }
    }

    private Node getTargetNode() {
        Node node = this.getNode();
        if (node != null) {
            return node;
        }
        return this.getParentTargetNode();
    }

    @Override
    final boolean startable(boolean bl2) {
        return super.startable(bl2) && (this.getTargetNode() != null && this.getPath() != null && !this.getPath().getLayoutBounds().isEmpty() || !bl2 && this.cachedNode != null);
    }

    @Override
    final void sync(boolean bl2) {
        super.sync(bl2);
        if (bl2 || this.cachedNode == null) {
            this.cachedNode = this.getTargetNode();
            this.recomputeSegments();
            this.cachedIsNormalRequired = this.getOrientation() == PathTransition$OrientationType.ORTHOGONAL_TO_TANGENT;
        }
    }

    private void recomputeSegments() {
        this.segments.clear();
        Object object = this.getPath();
        PathTransition$Segment pathTransition$Segment = PathTransition$Segment.getZeroSegment();
        PathTransition$Segment pathTransition$Segment2 = PathTransition$Segment.getZeroSegment();
        float[] fArray = new float[6];
        object = ShapeHelper.configShape((Shape)object).getPathIterator(NodeHelper.getLeafTransform((Node)object), 1.0f);
        while (!object.isDone()) {
            PathTransition$Segment pathTransition$Segment3 = null;
            int n2 = object.currentSegment(fArray);
            double d2 = fArray[0];
            double d3 = fArray[1];
            switch (n2) {
                case 0: {
                    pathTransition$Segment3 = pathTransition$Segment = PathTransition$Segment.newMoveTo(d2, d3, pathTransition$Segment2.accumLength);
                    break;
                }
                case 4: {
                    pathTransition$Segment3 = PathTransition$Segment.newClosePath(pathTransition$Segment2, pathTransition$Segment);
                    if (pathTransition$Segment3 != null) break;
                    pathTransition$Segment2.convertToClosePath(pathTransition$Segment);
                    break;
                }
                case 1: {
                    pathTransition$Segment3 = PathTransition$Segment.newLineTo(pathTransition$Segment2, d2, d3);
                }
            }
            if (pathTransition$Segment3 != null) {
                this.segments.add(pathTransition$Segment3);
                pathTransition$Segment2 = pathTransition$Segment3;
            }
            object.next();
        }
        this.totalLength = pathTransition$Segment2.accumLength;
    }

    private int findSegment(int n2, int n3, double d2) {
        while (true) {
            if (n2 == n3) {
                if (this.segments.get((int)n2).isMoveTo && n2 > 0) {
                    return this.findSegment(n2 - 1, n2 - 1, d2);
                }
                return n2;
            }
            int n4 = n2 + (n3 - n2) / 2;
            if (this.segments.get((int)n4).accumLength > d2) {
                return this.findSegment(n2, n4, d2);
            }
            n2 = n4 + 1;
        }
    }

    private static double interpolate(double d2, double d3, double d4) {
        double d5;
        double d6 = d3 - d2;
        if (Math.abs(d5) > 180.0) {
            d3 += d6 > 0.0 ? -360.0 : 360.0;
        }
        return PathTransition.normalize(d2 + d4 * (d3 - d2));
    }

    private static double normalize(double d2) {
        while (d2 > 360.0) {
            d2 -= 360.0;
        }
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        return d2;
    }
}

