/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.animation.Interpolator;
import javafx.animation.SequentialTransition$1;
import javafx.animation.SequentialTransition$2;
import javafx.animation.SequentialTransition$3;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.util.Duration;

public final class SequentialTransition
extends Transition {
    private static final Animation[] EMPTY_ANIMATION_ARRAY = new Animation[0];
    private static final int BEFORE = -1;
    private static final double EPSILON = 1.0E-12;
    private Animation[] cachedChildren = EMPTY_ANIMATION_ARRAY;
    private long[] startTimes;
    private long[] durations;
    private long[] delays;
    private double[] rates;
    private boolean[] forceChildSync;
    private int end;
    private int curIndex = -1;
    private long oldTicks = 0L;
    private long offsetTicks;
    private boolean childrenChanged = true;
    private boolean toggledRate;
    private final InvalidationListener childrenListener = observable -> {
        this.childrenChanged = true;
        if (this.getStatus() == Animation$Status.STOPPED) {
            SequentialTransition sequentialTransition = this;
            sequentialTransition.setCycleDuration(sequentialTransition.computeCycleDuration());
        }
    };
    private final ChangeListener<Number> rateListener = new SequentialTransition$1(this);
    private ObjectProperty<Node> node;
    private static final Node DEFAULT_NODE = null;
    private final Set<Animation> childrenSet = new HashSet<Animation>();
    private final ObservableList<Animation> children = new SequentialTransition$3(this, new SequentialTransition$2(this));

    public final void setNode(Node node) {
        if (this.node != null || node != null) {
            this.nodeProperty().set(node);
        }
    }

    public final Node getNode() {
        if (this.node == null) {
            return DEFAULT_NODE;
        }
        return (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty<Node>(this, "node", DEFAULT_NODE);
        }
        return this.node;
    }

    private static boolean checkCycle(Animation animation, Animation animation2) {
        while (animation2 != animation) {
            if (animation2.parent != null) {
                animation2 = animation2.parent;
                continue;
            }
            return false;
        }
        return true;
    }

    public final ObservableList<Animation> getChildren() {
        return this.children;
    }

    public SequentialTransition(Node node, Animation ... animationArray) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
        this.getChildren().setAll((Animation[])animationArray);
    }

    public SequentialTransition(Animation ... animationArray) {
        this((Node)null, animationArray);
    }

    public SequentialTransition(Node node) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
    }

    public SequentialTransition() {
        this((Node)null);
    }

    SequentialTransition(AbstractPrimaryTimer abstractPrimaryTimer) {
        super(abstractPrimaryTimer);
        this.setInterpolator(Interpolator.LINEAR);
    }

    @Override
    protected final Node getParentTargetNode() {
        Node node = this.getNode();
        if (node != null) {
            return node;
        }
        if (this.parent != null && this.parent instanceof Transition) {
            return ((Transition)this.parent).getParentTargetNode();
        }
        return null;
    }

    private Duration computeCycleDuration() {
        Duration duration = Duration.ZERO;
        for (Animation animation : this.getChildren()) {
            duration = duration.add(animation.getDelay());
            double d2 = Math.abs(animation.getRate());
            if (!(duration = duration.add(d2 < 1.0E-12 ? animation.getTotalDuration() : animation.getTotalDuration().divide(d2))).isIndefinite()) continue;
        }
        return duration;
    }

    private double calculateFraction(long l2, long l3) {
        double d2;
        double d3 = (double)l2 / (double)l3;
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (d3 >= 1.0) {
            return 1.0;
        }
        return d3;
    }

    private int findNewIndex(long l2) {
        if (this.curIndex != -1 && this.curIndex != this.end && this.startTimes[this.curIndex] <= l2 && l2 <= this.startTimes[this.curIndex + 1]) {
            return this.curIndex;
        }
        int n2 = this.curIndex == -1 || this.curIndex == this.end ? 1 : 0;
        int n3 = n2 != 0 || l2 < this.oldTicks ? 0 : this.curIndex + 1;
        int n4 = Arrays.binarySearch(this.startTimes, n3, n2 = n2 != 0 || this.oldTicks < l2 ? this.end : this.curIndex, l2);
        if (n4 < 0) {
            return -n4 - 2;
        }
        if (n4 > 0) {
            return n4 - 1;
        }
        return 0;
    }

    @Override
    final void sync(boolean bl2) {
        super.sync(bl2);
        if (bl2 && this.childrenChanged || this.startTimes == null) {
            this.cachedChildren = this.getChildren().toArray(EMPTY_ANIMATION_ARRAY);
            this.end = this.cachedChildren.length;
            this.startTimes = new long[this.end + 1];
            this.durations = new long[this.end];
            this.delays = new long[this.end];
            this.rates = new double[this.end];
            this.forceChildSync = new boolean[this.end];
            long l2 = 0L;
            bl2 = false;
            Animation[] animationArray = this.cachedChildren;
            int n2 = this.cachedChildren.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Animation animation = animationArray[i2];
                this.startTimes[bl2] = l2;
                this.rates[bl2] = Math.abs(animation.getRate());
                if (this.rates[bl2] < 1.0E-12) {
                    this.rates[bl2] = 1.0;
                }
                this.durations[bl2] = TickCalculation.fromDuration(animation.getTotalDuration(), this.rates[bl2]);
                this.delays[bl2] = TickCalculation.fromDuration(animation.getDelay());
                l2 = this.durations[bl2] == Long.MAX_VALUE || this.delays[bl2] == Long.MAX_VALUE || l2 == Long.MAX_VALUE ? Long.MAX_VALUE : TickCalculation.add(l2, TickCalculation.add(this.durations[bl2], this.delays[bl2]));
                this.forceChildSync[bl2] = true;
                bl2 += 1;
            }
            this.startTimes[this.end] = l2;
            this.childrenChanged = false;
            return;
        }
        if (bl2) {
            int n3 = this.forceChildSync.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                this.forceChildSync[i3] = true;
            }
        }
    }

    @Override
    final void doStart(boolean bl2) {
        super.doStart(bl2);
        this.toggledRate = false;
        this.rateProperty().addListener(this.rateListener);
        this.offsetTicks = 0L;
        double d2 = this.getCurrentRate();
        long l2 = TickCalculation.fromDuration(this.getCurrentTime());
        if (d2 < 0.0) {
            this.jumpToEnd();
            this.curIndex = this.end;
            if (l2 < this.startTimes[this.end]) {
                this.doJumpTo(l2, this.startTimes[this.end], false);
                return;
            }
        } else {
            this.jumpToBefore();
            this.curIndex = -1;
            if (l2 > 0L) {
                this.doJumpTo(l2, this.startTimes[this.end], false);
            }
        }
    }

    @Override
    final void doPause() {
        Animation animation;
        super.doPause();
        if (this.curIndex != -1 && this.curIndex != this.end && (animation = this.cachedChildren[this.curIndex]).getStatus() == Animation$Status.RUNNING) {
            animation.doPause();
        }
    }

    @Override
    final void doResume() {
        Animation animation;
        super.doResume();
        if (this.curIndex != -1 && this.curIndex != this.end && (animation = this.cachedChildren[this.curIndex]).getStatus() == Animation$Status.PAUSED) {
            animation.doResume();
            animation.clipEnvelope.setRate(this.rates[this.curIndex] * Math.signum(this.getCurrentRate()));
        }
    }

    @Override
    final void doStop() {
        Animation animation;
        super.doStop();
        if (this.curIndex != -1 && this.curIndex != this.end && (animation = this.cachedChildren[this.curIndex]).getStatus() != Animation$Status.STOPPED) {
            animation.doStop();
        }
        if (this.childrenChanged) {
            SequentialTransition sequentialTransition = this;
            sequentialTransition.setCycleDuration(sequentialTransition.computeCycleDuration());
        }
        this.rateProperty().removeListener(this.rateListener);
    }

    private boolean startChild(Animation animation, int n2) {
        boolean bl2 = this.forceChildSync[n2];
        if (animation.startable(bl2)) {
            animation.clipEnvelope.setRate(this.rates[n2] * Math.signum(this.getCurrentRate()));
            animation.doStart(bl2);
            this.forceChildSync[n2] = false;
            return true;
        }
        return false;
    }

    @Override
    final void doPlayTo(long l2, long l3) {
        Animation animation;
        this.setCurrentTicks(l2);
        double d2 = this.calculateFraction(l2, l3);
        long l4 = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, l3, d2), l3));
        int n2 = this.findNewIndex(l4);
        Animation animation2 = animation = this.curIndex == -1 || this.curIndex == this.end ? null : this.cachedChildren[this.curIndex];
        if (this.toggledRate) {
            if (animation != null && animation.getStatus() == Animation$Status.RUNNING) {
                this.offsetTicks = (long)((double)this.offsetTicks - Math.signum(this.getCurrentRate()) * (double)(this.durations[this.curIndex] - 2L * (this.oldTicks - this.delays[this.curIndex] - this.startTimes[this.curIndex])));
            }
            this.toggledRate = false;
        }
        if (this.curIndex == n2) {
            if (this.getCurrentRate() > 0.0) {
                long l5 = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (l4 >= l5) {
                    if (this.oldTicks <= l5 || animation.getStatus() == Animation$Status.STOPPED) {
                        boolean bl2 = this.oldTicks <= l5;
                        if (bl2) {
                            animation.clipEnvelope.jumpTo(0L);
                        }
                        if (!this.startChild(animation, this.curIndex)) {
                            EventHandler<ActionEvent> eventHandler;
                            if (bl2 && (eventHandler = animation.getOnFinished()) != null) {
                                eventHandler.handle(new ActionEvent(this, null));
                            }
                            this.oldTicks = l4;
                            return;
                        }
                    }
                    if (l4 >= this.startTimes[this.curIndex + 1]) {
                        animation.doTimePulse(TickCalculation.sub(this.durations[this.curIndex], this.offsetTicks));
                        if (l4 == l3) {
                            this.curIndex = this.end;
                        }
                    } else {
                        long l6 = TickCalculation.sub(l4 - l5, this.offsetTicks);
                        animation.doTimePulse(l6);
                    }
                }
            } else {
                long l7 = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (this.oldTicks >= this.startTimes[this.curIndex + 1] || this.oldTicks >= l7 && animation.getStatus() == Animation$Status.STOPPED) {
                    boolean bl3 = this.oldTicks >= this.startTimes[this.curIndex + 1];
                    if (bl3) {
                        animation.clipEnvelope.jumpTo(Math.round((double)this.durations[this.curIndex] * this.rates[this.curIndex]));
                    }
                    if (!this.startChild(animation, this.curIndex)) {
                        EventHandler<ActionEvent> eventHandler;
                        if (bl3 && (eventHandler = animation.getOnFinished()) != null) {
                            eventHandler.handle(new ActionEvent(this, null));
                        }
                        this.oldTicks = l4;
                        return;
                    }
                }
                if (l4 <= l7) {
                    animation.doTimePulse(TickCalculation.sub(this.durations[this.curIndex], this.offsetTicks));
                    if (l4 == 0L) {
                        this.curIndex = -1;
                    }
                } else {
                    long l8 = TickCalculation.sub(this.startTimes[this.curIndex + 1] - l4, this.offsetTicks);
                    animation.doTimePulse(l8);
                }
            }
        } else if (this.curIndex < n2) {
            EventHandler<ActionEvent> eventHandler;
            if (animation != null) {
                long l9 = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (this.oldTicks <= l9 || animation.getStatus() == Animation$Status.STOPPED && this.oldTicks != this.startTimes[this.curIndex + 1]) {
                    EventHandler<ActionEvent> eventHandler2;
                    boolean bl4 = this.oldTicks <= l9;
                    if (bl4) {
                        animation.clipEnvelope.jumpTo(0L);
                    }
                    if (!this.startChild(animation, this.curIndex) && bl4 && (eventHandler2 = animation.getOnFinished()) != null) {
                        eventHandler2.handle(new ActionEvent(this, null));
                    }
                }
                if (animation.getStatus() == Animation$Status.RUNNING) {
                    animation.doTimePulse(TickCalculation.sub(this.durations[this.curIndex], this.offsetTicks));
                }
                this.oldTicks = this.startTimes[this.curIndex + 1];
            }
            this.offsetTicks = 0L;
            ++this.curIndex;
            while (this.curIndex < n2) {
                Animation animation3 = this.cachedChildren[this.curIndex];
                animation3.clipEnvelope.jumpTo(0L);
                if (this.startChild(animation3, this.curIndex)) {
                    animation3.doTimePulse(this.durations[this.curIndex]);
                } else {
                    eventHandler = animation3.getOnFinished();
                    if (eventHandler != null) {
                        eventHandler.handle(new ActionEvent(this, null));
                    }
                }
                this.oldTicks = this.startTimes[this.curIndex + 1];
                ++this.curIndex;
            }
            Animation animation4 = this.cachedChildren[this.curIndex];
            animation4.clipEnvelope.jumpTo(0L);
            if (this.startChild(animation4, this.curIndex)) {
                if (l4 >= this.startTimes[this.curIndex + 1]) {
                    animation4.doTimePulse(this.durations[this.curIndex]);
                    if (l4 == l3) {
                        this.curIndex = this.end;
                    }
                } else {
                    long l10 = TickCalculation.sub(l4, TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]));
                    animation4.doTimePulse(l10);
                }
            } else {
                eventHandler = animation4.getOnFinished();
                if (eventHandler != null) {
                    eventHandler.handle(new ActionEvent(this, null));
                }
            }
        } else {
            EventHandler<ActionEvent> eventHandler;
            if (animation != null) {
                long l11 = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (this.oldTicks >= this.startTimes[this.curIndex + 1] || this.oldTicks > l11 && animation.getStatus() == Animation$Status.STOPPED) {
                    EventHandler<ActionEvent> eventHandler3;
                    boolean bl5 = this.oldTicks >= this.startTimes[this.curIndex + 1];
                    if (bl5) {
                        animation.clipEnvelope.jumpTo(Math.round((double)this.durations[this.curIndex] * this.rates[this.curIndex]));
                    }
                    if (!this.startChild(animation, this.curIndex) && bl5 && (eventHandler3 = animation.getOnFinished()) != null) {
                        eventHandler3.handle(new ActionEvent(this, null));
                    }
                }
                if (animation.getStatus() == Animation$Status.RUNNING) {
                    animation.doTimePulse(TickCalculation.sub(this.durations[this.curIndex], this.offsetTicks));
                }
                this.oldTicks = this.startTimes[this.curIndex];
            }
            this.offsetTicks = 0L;
            --this.curIndex;
            while (this.curIndex > n2) {
                Animation animation5 = this.cachedChildren[this.curIndex];
                animation5.clipEnvelope.jumpTo(Math.round((double)this.durations[this.curIndex] * this.rates[this.curIndex]));
                if (this.startChild(animation5, this.curIndex)) {
                    animation5.doTimePulse(this.durations[this.curIndex]);
                } else {
                    eventHandler = animation5.getOnFinished();
                    if (eventHandler != null) {
                        eventHandler.handle(new ActionEvent(this, null));
                    }
                }
                this.oldTicks = this.startTimes[this.curIndex];
                --this.curIndex;
            }
            Animation animation6 = this.cachedChildren[this.curIndex];
            animation6.clipEnvelope.jumpTo(Math.round((double)this.durations[this.curIndex] * this.rates[this.curIndex]));
            if (this.startChild(animation6, this.curIndex)) {
                if (l4 <= TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex])) {
                    animation6.doTimePulse(this.durations[this.curIndex]);
                    if (l4 == 0L) {
                        this.curIndex = -1;
                    }
                } else {
                    long l12 = TickCalculation.sub(this.startTimes[this.curIndex + 1], l4);
                    animation6.doTimePulse(l12);
                }
            } else {
                eventHandler = animation6.getOnFinished();
                if (eventHandler != null) {
                    eventHandler.handle(new ActionEvent(this, null));
                }
            }
        }
        this.oldTicks = l4;
    }

    @Override
    final void doJumpTo(long l2, long l3, boolean bl2) {
        long l4;
        this.setCurrentTicks(l2);
        Animation$Status animation$Status = this.getStatus();
        if (animation$Status == Animation$Status.STOPPED && !bl2) {
            return;
        }
        this.sync(false);
        double d2 = this.calculateFraction(l2, l3);
        long l5 = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, l3, d2), l3));
        int n2 = this.curIndex;
        this.curIndex = this.findNewIndex(l5);
        Animation animation = this.cachedChildren[this.curIndex];
        double d3 = this.getCurrentRate();
        long l6 = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
        if (this.curIndex != n2 && animation$Status != Animation$Status.STOPPED) {
            Animation animation2;
            if (n2 != -1 && n2 != this.end && (animation2 = this.cachedChildren[n2]).getStatus() != Animation$Status.STOPPED) {
                this.cachedChildren[n2].doStop();
            }
            if (this.curIndex < n2) {
                int n3;
                int n4 = n3 = n2 == this.end ? this.end - 1 : n2;
                while (n3 > this.curIndex) {
                    this.cachedChildren[n3].doJumpTo(0L, this.durations[n3], true);
                    --n3;
                }
            } else {
                int n5;
                int n6 = n5 = n2 == -1 ? 0 : n2;
                while (n5 < this.curIndex) {
                    this.cachedChildren[n5].doJumpTo(this.durations[n5], this.durations[n5], true);
                    ++n5;
                }
            }
            if (l5 >= l6) {
                this.startChild(animation, this.curIndex);
                if (animation$Status == Animation$Status.PAUSED) {
                    animation.doPause();
                }
            }
        }
        if (n2 == this.curIndex) {
            if (d3 == 0.0) {
                SequentialTransition sequentialTransition = this;
                v3 = sequentialTransition;
                l4 = (long)((double)sequentialTransition.offsetTicks + (double)(l5 - this.oldTicks) * Math.signum(this.clipEnvelope.getCurrentRate()));
            } else {
                SequentialTransition sequentialTransition = this;
                v3 = sequentialTransition;
                l4 = sequentialTransition.offsetTicks + (d3 > 0.0 ? l5 - this.oldTicks : this.oldTicks - l5);
            }
        } else if (d3 == 0.0) {
            if (this.clipEnvelope.getCurrentRate() > 0.0) {
                v3 = this;
                l4 = Math.max(0L, l5 - l6);
            } else {
                SequentialTransition sequentialTransition = this;
                v3 = sequentialTransition;
                l4 = sequentialTransition.startTimes[this.curIndex] + this.durations[this.curIndex] - l5;
            }
        } else {
            v3 = this;
            l4 = d3 > 0.0 ? Math.max(0L, l5 - l6) : this.startTimes[this.curIndex + 1] - l5;
        }
        v3.offsetTicks = l4;
        animation.clipEnvelope.jumpTo(Math.round((double)TickCalculation.sub(l5, l6) * this.rates[this.curIndex]));
        this.oldTicks = l5;
    }

    private void jumpToEnd() {
        for (int i2 = 0; i2 < this.end; ++i2) {
            if (this.forceChildSync[i2]) {
                this.cachedChildren[i2].sync(true);
            }
            this.cachedChildren[i2].doJumpTo(this.durations[i2], this.durations[i2], true);
        }
    }

    private void jumpToBefore() {
        for (int i2 = this.end - 1; i2 >= 0; --i2) {
            if (this.forceChildSync[i2]) {
                this.cachedChildren[i2].sync(true);
            }
            this.cachedChildren[i2].doJumpTo(0L, this.durations[i2], true);
        }
    }

    @Override
    protected final void interpolate(double d2) {
    }
}

