/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.scenario.animation.AbstractPrimaryTimer;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.animation.Interpolator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;

public abstract class Transition
extends Animation {
    private ObjectProperty<Interpolator> interpolator;
    private static final Interpolator DEFAULT_INTERPOLATOR = Interpolator.EASE_BOTH;
    private Interpolator cachedInterpolator;

    public final void setInterpolator(Interpolator interpolator) {
        if (this.interpolator != null || !DEFAULT_INTERPOLATOR.equals(interpolator)) {
            this.interpolatorProperty().set(interpolator);
        }
    }

    public final Interpolator getInterpolator() {
        if (this.interpolator == null) {
            return DEFAULT_INTERPOLATOR;
        }
        return (Interpolator)this.interpolator.get();
    }

    public final ObjectProperty<Interpolator> interpolatorProperty() {
        if (this.interpolator == null) {
            this.interpolator = new SimpleObjectProperty<Interpolator>(this, "interpolator", DEFAULT_INTERPOLATOR);
        }
        return this.interpolator;
    }

    protected Interpolator getCachedInterpolator() {
        return this.cachedInterpolator;
    }

    public Transition(double d2) {
        super(d2);
    }

    public Transition() {
    }

    Transition(AbstractPrimaryTimer abstractPrimaryTimer) {
        super(abstractPrimaryTimer);
    }

    protected Node getParentTargetNode() {
        if (this.parent != null && this.parent instanceof Transition) {
            return ((Transition)this.parent).getParentTargetNode();
        }
        return null;
    }

    protected abstract void interpolate(double var1);

    private double calculateFraction(long l2, long l3) {
        double d2 = l3 <= 0L ? 1.0 : (double)l2 / (double)l3;
        return this.cachedInterpolator.interpolate(0.0, 1.0, d2);
    }

    @Override
    boolean startable(boolean bl2) {
        return super.startable(bl2) && (this.getInterpolator() != null || !bl2 && this.cachedInterpolator != null);
    }

    @Override
    void sync(boolean bl2) {
        super.sync(bl2);
        if (bl2 || this.cachedInterpolator == null) {
            this.cachedInterpolator = this.getInterpolator();
        }
    }

    @Override
    void doPlayTo(long l2, long l3) {
        this.setCurrentTicks(l2);
        Transition transition = this;
        transition.interpolate(transition.calculateFraction(l2, l3));
    }

    @Override
    void doJumpTo(long l2, long l3, boolean bl2) {
        this.setCurrentTicks(l2);
        if (this.getStatus() != Animation$Status.STOPPED || bl2) {
            this.sync(false);
            Transition transition = this;
            transition.interpolate(transition.calculateFraction(l2, l3));
        }
    }
}

