/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.Logging;
import com.sun.javafx.logging.PlatformLogger;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty$1;
import javafx.beans.property.DoubleProperty$2;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.WritableDoubleValue;

public abstract class DoubleProperty
extends ReadOnlyDoubleProperty
implements Property<Number>,
WritableDoubleValue {
    @Override
    public void setValue(Number number) {
        if (number == null) {
            ((PlatformLogger)Logging.getLogger()).fine("Attempt to set double property to null, using default value instead.", new NullPointerException());
            this.set(0.0);
            return;
        }
        this.set(number.doubleValue());
    }

    @Override
    public void bindBidirectional(Property<Number> property) {
        Bindings.bindBidirectional(this, property);
    }

    @Override
    public void unbindBidirectional(Property<Number> property) {
        Bindings.unbindBidirectional(this, property);
    }

    @Override
    public String toString() {
        Object object = this.getBean();
        String string = this.getName();
        StringBuilder stringBuilder = new StringBuilder("DoubleProperty [");
        if (object != null) {
            stringBuilder.append("bean: ").append(object).append(", ");
        }
        if (string != null && !string.equals("")) {
            stringBuilder.append("name: ").append(string).append(", ");
        }
        stringBuilder.append("value: ").append(this.get()).append("]");
        return stringBuilder.toString();
    }

    public static DoubleProperty doubleProperty(Property<Double> property) {
        Objects.requireNonNull(property, "Property cannot be null");
        return new DoubleProperty$1(property);
    }

    @Override
    public ObjectProperty<Double> asObject() {
        return new DoubleProperty$2(this);
    }
}

