/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.ExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.FloatBinding;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.FloatPropertyBase$1;
import javafx.beans.property.FloatPropertyBase$2;
import javafx.beans.property.FloatPropertyBase$Listener;
import javafx.beans.property.FloatPropertyBase$ValueWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableFloatValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;

public abstract class FloatPropertyBase
extends FloatProperty {
    private float value;
    private ObservableFloatValue observable = null;
    private InvalidationListener listener = null;
    private boolean valid = true;
    private ExpressionHelper<Number> helper = null;

    public FloatPropertyBase() {
    }

    public FloatPropertyBase(float f2) {
        this.value = f2;
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
    }

    @Override
    public void addListener(ChangeListener<? super Number> changeListener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
    }

    @Override
    public void removeListener(ChangeListener<? super Number> changeListener) {
        this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
    }

    protected void fireValueChangedEvent() {
        ExpressionHelper.fireValueChangedEvent(this.helper);
    }

    private void markInvalid() {
        if (this.valid) {
            this.valid = false;
            this.invalidated();
            this.fireValueChangedEvent();
        }
    }

    protected void invalidated() {
    }

    @Override
    public float get() {
        this.valid = true;
        if (this.observable == null) {
            return this.value;
        }
        return this.observable.get();
    }

    @Override
    public void set(float f2) {
        if (this.isBound()) {
            throw new RuntimeException((String)(this.getBean() != null && this.getName() != null ? this.getBean().getClass().getSimpleName() + "." + this.getName() + " : " : "") + "A bound value cannot be set.");
        }
        if (this.value != f2) {
            this.value = f2;
            this.markInvalid();
        }
    }

    @Override
    public boolean isBound() {
        return this.observable != null;
    }

    @Override
    public void bind(ObservableValue<? extends Number> observableFloatValue) {
        if (observableFloatValue == null) {
            throw new NullPointerException("Cannot bind to null");
        }
        if (observableFloatValue instanceof ObservableFloatValue) {
            observableFloatValue = observableFloatValue;
        } else if (observableFloatValue instanceof ObservableNumberValue) {
            ObservableNumberValue observableNumberValue = observableFloatValue;
            observableFloatValue = new FloatPropertyBase$1(this, observableFloatValue, observableNumberValue);
        } else {
            ObservableFloatValue observableFloatValue2 = observableFloatValue;
            observableFloatValue = new FloatPropertyBase$2(this, observableFloatValue2, observableFloatValue2);
        }
        if (!observableFloatValue.equals(this.observable)) {
            this.unbind();
            this.observable = observableFloatValue;
            if (this.listener == null) {
                this.listener = new FloatPropertyBase$Listener(this);
            }
            this.observable.addListener(this.listener);
            this.markInvalid();
        }
    }

    @Override
    public void unbind() {
        if (this.observable != null) {
            this.value = this.observable.get();
            this.observable.removeListener(this.listener);
            if (this.observable instanceof FloatPropertyBase$ValueWrapper) {
                ((FloatBinding)((FloatPropertyBase$ValueWrapper)this.observable)).dispose();
            }
            this.observable = null;
        }
    }

    @Override
    public String toString() {
        Object object = this.getBean();
        String string = this.getName();
        StringBuilder stringBuilder = new StringBuilder("FloatProperty [");
        if (object != null) {
            stringBuilder.append("bean: ").append(object).append(", ");
        }
        if (string != null && !string.equals("")) {
            stringBuilder.append("name: ").append(string).append(", ");
        }
        if (this.isBound()) {
            stringBuilder.append("bound, ");
            if (this.valid) {
                stringBuilder.append("value: ").append(this.get());
            } else {
                stringBuilder.append("invalid");
            }
        } else {
            stringBuilder.append("value: ").append(this.get());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

