/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.Logging;
import com.sun.javafx.logging.PlatformLogger;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty$1;
import javafx.beans.property.IntegerProperty$2;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.WritableIntegerValue;

public abstract class IntegerProperty
extends ReadOnlyIntegerProperty
implements Property<Number>,
WritableIntegerValue {
    @Override
    public void setValue(Number number) {
        if (number == null) {
            ((PlatformLogger)Logging.getLogger()).fine("Attempt to set integer property to null, using default value instead.", new NullPointerException());
            this.set(0);
            return;
        }
        this.set(number.intValue());
    }

    @Override
    public void bindBidirectional(Property<Number> property) {
        Bindings.bindBidirectional(this, property);
    }

    @Override
    public void unbindBidirectional(Property<Number> property) {
        Bindings.unbindBidirectional(this, property);
    }

    @Override
    public String toString() {
        Object object = this.getBean();
        String string = this.getName();
        StringBuilder stringBuilder = new StringBuilder("IntegerProperty [");
        if (object != null) {
            stringBuilder.append("bean: ").append(object).append(", ");
        }
        if (string != null && !string.equals("")) {
            stringBuilder.append("name: ").append(string).append(", ");
        }
        stringBuilder.append("value: ").append(this.get()).append("]");
        return stringBuilder.toString();
    }

    public static IntegerProperty integerProperty(Property<Integer> property) {
        Objects.requireNonNull(property, "Property cannot be null");
        return new IntegerProperty$1(property);
    }

    @Override
    public ObjectProperty<Integer> asObject() {
        return new IntegerProperty$2(this);
    }
}

