/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.ExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.LongBinding;
import javafx.beans.property.LongProperty;
import javafx.beans.property.LongPropertyBase$1;
import javafx.beans.property.LongPropertyBase$2;
import javafx.beans.property.LongPropertyBase$Listener;
import javafx.beans.property.LongPropertyBase$ValueWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;

public abstract class LongPropertyBase
extends LongProperty {
    private long value;
    private ObservableLongValue observable = null;
    private InvalidationListener listener = null;
    private boolean valid = true;
    private ExpressionHelper<Number> helper = null;

    public LongPropertyBase() {
    }

    public LongPropertyBase(long l2) {
        this.value = l2;
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
    }

    @Override
    public void addListener(ChangeListener<? super Number> changeListener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
    }

    @Override
    public void removeListener(ChangeListener<? super Number> changeListener) {
        this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
    }

    protected void fireValueChangedEvent() {
        ExpressionHelper.fireValueChangedEvent(this.helper);
    }

    private void markInvalid() {
        if (this.valid) {
            this.valid = false;
            this.invalidated();
            this.fireValueChangedEvent();
        }
    }

    protected void invalidated() {
    }

    @Override
    public long get() {
        this.valid = true;
        if (this.observable == null) {
            return this.value;
        }
        return this.observable.get();
    }

    @Override
    public void set(long l2) {
        if (this.isBound()) {
            throw new RuntimeException((String)(this.getBean() != null && this.getName() != null ? this.getBean().getClass().getSimpleName() + "." + this.getName() + " : " : "") + "A bound value cannot be set.");
        }
        if (this.value != l2) {
            this.value = l2;
            this.markInvalid();
        }
    }

    @Override
    public boolean isBound() {
        return this.observable != null;
    }

    @Override
    public void bind(ObservableValue<? extends Number> observableLongValue) {
        if (observableLongValue == null) {
            throw new NullPointerException("Cannot bind to null");
        }
        if (observableLongValue instanceof ObservableLongValue) {
            observableLongValue = observableLongValue;
        } else if (observableLongValue instanceof ObservableNumberValue) {
            ObservableNumberValue observableNumberValue = observableLongValue;
            observableLongValue = new LongPropertyBase$1(this, observableLongValue, observableNumberValue);
        } else {
            ObservableLongValue observableLongValue2 = observableLongValue;
            observableLongValue = new LongPropertyBase$2(this, observableLongValue2, observableLongValue2);
        }
        if (!observableLongValue.equals(this.observable)) {
            this.unbind();
            this.observable = observableLongValue;
            if (this.listener == null) {
                this.listener = new LongPropertyBase$Listener(this);
            }
            this.observable.addListener(this.listener);
            this.markInvalid();
        }
    }

    @Override
    public void unbind() {
        if (this.observable != null) {
            this.value = this.observable.get();
            this.observable.removeListener(this.listener);
            if (this.observable instanceof LongPropertyBase$ValueWrapper) {
                ((LongBinding)((LongPropertyBase$ValueWrapper)this.observable)).dispose();
            }
            this.observable = null;
        }
    }

    @Override
    public String toString() {
        Object object = this.getBean();
        String string = this.getName();
        StringBuilder stringBuilder = new StringBuilder("LongProperty [");
        if (object != null) {
            stringBuilder.append("bean: ").append(object).append(", ");
        }
        if (string != null && !string.equals("")) {
            stringBuilder.append("name: ").append(string).append(", ");
        }
        if (this.isBound()) {
            stringBuilder.append("bound, ");
            if (this.valid) {
                stringBuilder.append("value: ").append(this.get());
            } else {
                stringBuilder.append("invalid");
            }
        } else {
            stringBuilder.append("value: ").append(this.get());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

