/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property.adapter;

import com.sun.javafx.property.adapter.JavaBeanPropertyBuilderHelper;
import com.sun.javafx.property.adapter.PropertyDescriptor;
import java.lang.reflect.Method;
import javafx.beans.property.adapter.JavaBeanDoubleProperty;

public final class JavaBeanDoublePropertyBuilder {
    private final JavaBeanPropertyBuilderHelper<Number> helper = new JavaBeanPropertyBuilderHelper();

    private JavaBeanDoublePropertyBuilder() {
    }

    public static JavaBeanDoublePropertyBuilder create() {
        return new JavaBeanDoublePropertyBuilder();
    }

    public final JavaBeanDoubleProperty build() throws NoSuchMethodException {
        PropertyDescriptor<Number> propertyDescriptor = this.helper.getDescriptor();
        if (!Double.TYPE.equals(propertyDescriptor.getType()) && !Number.class.isAssignableFrom(propertyDescriptor.getType())) {
            throw new IllegalArgumentException("Not a double property");
        }
        return new JavaBeanDoubleProperty(propertyDescriptor, this.helper.getBean());
    }

    public final JavaBeanDoublePropertyBuilder name(String string) {
        this.helper.name(string);
        return this;
    }

    public final JavaBeanDoublePropertyBuilder bean(Object object) {
        this.helper.bean(object);
        return this;
    }

    public final JavaBeanDoublePropertyBuilder beanClass(Class<?> clazz) {
        this.helper.beanClass(clazz);
        return this;
    }

    public final JavaBeanDoublePropertyBuilder getter(String string) {
        this.helper.getterName(string);
        return this;
    }

    public final JavaBeanDoublePropertyBuilder setter(String string) {
        this.helper.setterName(string);
        return this;
    }

    public final JavaBeanDoublePropertyBuilder getter(Method method) {
        this.helper.getter(method);
        return this;
    }

    public final JavaBeanDoublePropertyBuilder setter(Method method) {
        this.helper.setter(method);
        return this;
    }
}

