/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.MapAdapterChange;
import com.sun.javafx.collections.MapListenerHelper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections$CheckedObservableMap$CheckedEntrySet;
import javafx.collections.MapChangeListener;
import javafx.collections.MapChangeListener$Change;
import javafx.collections.ObservableMap;
import javafx.collections.WeakMapChangeListener;

class FXCollections$CheckedObservableMap<K, V>
extends AbstractMap<K, V>
implements ObservableMap<K, V> {
    private final ObservableMap<K, V> backingMap;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private MapListenerHelper<K, V> listenerHelper;
    private final MapChangeListener<K, V> listener;
    private transient Set<Map.Entry<K, V>> entrySet = null;

    FXCollections$CheckedObservableMap(ObservableMap<K, V> observableMap, Class<K> clazz, Class<V> clazz2) {
        this.backingMap = observableMap;
        this.keyType = clazz;
        this.valueType = clazz2;
        this.listener = mapChangeListener$Change -> this.callObservers(new MapAdapterChange(this, mapChangeListener$Change));
        this.backingMap.addListener(new WeakMapChangeListener<K, V>(this.listener));
    }

    private void callObservers(MapChangeListener$Change<? extends K, ? extends V> mapChangeListener$Change) {
        MapListenerHelper.fireValueChangedEvent(this.listenerHelper, mapChangeListener$Change);
    }

    void typeCheck(Object object, Object object2) {
        if (object != null && !this.keyType.isInstance(object)) {
            throw new ClassCastException("Attempt to insert " + String.valueOf(object.getClass()) + " key into map with key type " + String.valueOf(this.keyType));
        }
        if (object2 != null && !this.valueType.isInstance(object2)) {
            throw new ClassCastException("Attempt to insert " + String.valueOf(object2.getClass()) + " value into map with value type " + String.valueOf(this.valueType));
        }
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void addListener(MapChangeListener<? super K, ? super V> mapChangeListener) {
        this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, mapChangeListener);
    }

    @Override
    public void removeListener(MapChangeListener<? super K, ? super V> mapChangeListener) {
        this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, mapChangeListener);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.backingMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.backingMap.get(object);
    }

    @Override
    public V put(K k2, V v2) {
        this.typeCheck(k2, v2);
        return this.backingMap.put(k2, v2);
    }

    @Override
    public V remove(Object object) {
        return this.backingMap.remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> object) {
        object = object.entrySet().toArray();
        ArrayList arrayList = new ArrayList(((Object)object).length);
        for (Object object2 : object) {
            object2 = (Map.Entry)object2;
            Object k2 = object2.getKey();
            object2 = object2.getValue();
            this.typeCheck(k2, object2);
            arrayList.add(new AbstractMap.SimpleImmutableEntry(k2, object2));
        }
        for (Map.Entry entry : arrayList) {
            this.backingMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new FXCollections$CheckedObservableMap$CheckedEntrySet(this.backingMap.entrySet(), this.valueType);
        }
        return this.entrySet;
    }

    @Override
    public boolean equals(Object object) {
        return object == this || this.backingMap.equals(object);
    }

    @Override
    public int hashCode() {
        return this.backingMap.hashCode();
    }
}

