/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.ChangeHelper;
import java.util.List;
import javafx.collections.ListChangeBuilder$SubChange;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;

class ListChangeBuilder$IterableChange<E>
extends ListChangeListener$Change<E> {
    private ListChangeBuilder$SubChange<E>[] changes;
    private int cursor = -1;

    private ListChangeBuilder$IterableChange(ListChangeBuilder$SubChange<E>[] subChangeArray, ObservableList<E> observableList) {
        super(observableList);
        this.changes = subChangeArray;
    }

    @Override
    public boolean next() {
        if (this.cursor + 1 < this.changes.length) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.cursor = -1;
    }

    @Override
    public int getFrom() {
        this.checkState();
        return this.changes[this.cursor].from;
    }

    @Override
    public int getTo() {
        this.checkState();
        return this.changes[this.cursor].to;
    }

    @Override
    public List<E> getRemoved() {
        this.checkState();
        return this.changes[this.cursor].removed;
    }

    @Override
    protected int[] getPermutation() {
        this.checkState();
        return this.changes[this.cursor].perm;
    }

    @Override
    public boolean wasUpdated() {
        this.checkState();
        return this.changes[this.cursor].updated;
    }

    private void checkState() {
        if (this.cursor == -1) {
            throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        for (int i2 = 0; i2 < this.changes.length; ++i2) {
            if (this.changes[i2].perm.length != 0) {
                stringBuilder.append(ChangeHelper.permChangeToString(this.changes[i2].perm));
            } else if (this.changes[i2].updated) {
                stringBuilder.append(ChangeHelper.updateChangeToString(this.changes[i2].from, this.changes[i2].to));
            } else {
                stringBuilder.append(ChangeHelper.addRemoveChangeToString(this.changes[i2].from, this.changes[i2].to, this.getList(), this.changes[i2].removed));
            }
            if (i2 == this.changes.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

