/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import java.util.Collection;
import java.util.List;
import javafx.collections.ModifiableObservableListBase$SubObservableList;
import javafx.collections.ObservableListBase;

public abstract class ModifiableObservableListBase<E>
extends ObservableListBase<E> {
    @Override
    public boolean setAll(Collection<? extends E> collection) {
        if (collection.isEmpty() && this.isEmpty()) {
            return false;
        }
        this.beginChange();
        try {
            this.clear();
            this.addAll(collection);
            return true;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        this.beginChange();
        try {
            boolean bl2 = super.addAll(collection);
            return bl2;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        if (collection.isEmpty()) {
            return false;
        }
        this.beginChange();
        try {
            n2 = super.addAll(n2, collection) ? 1 : 0;
            return n2 != 0;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    protected void removeRange(int n2, int n3) {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        if (n2 == n3) {
            return;
        }
        this.beginChange();
        try {
            super.removeRange(n2, n3);
            return;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection.isEmpty() || this.isEmpty()) {
            return false;
        }
        this.beginChange();
        try {
            boolean bl2 = super.removeAll(collection);
            return bl2;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection.isEmpty() && !this.isEmpty()) {
            this.clear();
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        this.beginChange();
        try {
            boolean bl2 = super.retainAll(collection);
            return bl2;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public void add(int n2, E e2) {
        this.doAdd(n2, e2);
        this.beginChange();
        int n3 = n2;
        this.nextAdd(n3, n3 + 1);
        ++this.modCount;
        this.endChange();
    }

    @Override
    public E set(int n2, E e2) {
        e2 = this.doSet(n2, e2);
        this.beginChange();
        this.nextSet(n2, e2);
        this.endChange();
        return e2;
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.indexOf(object);
        if (n2 != -1) {
            this.remove(n2);
            return true;
        }
        return false;
    }

    @Override
    public E remove(int n2) {
        E e2 = this.doRemove(n2);
        this.beginChange();
        this.nextRemove(n2, e2);
        ++this.modCount;
        this.endChange();
        return e2;
    }

    @Override
    public List<E> subList(int n2, int n3) {
        ModifiableObservableListBase modifiableObservableListBase = this;
        return new ModifiableObservableListBase$SubObservableList(modifiableObservableListBase, super.subList(n2, n3));
    }

    @Override
    public abstract E get(int var1);

    @Override
    public abstract int size();

    protected abstract void doAdd(int var1, E var2);

    protected abstract E doSet(int var1, E var2);

    protected abstract E doRemove(int var1);
}

