/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import java.lang.ref.WeakReference;
import javafx.beans.NamedArg;
import javafx.beans.WeakListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ListChangeListener$Change;

public final class WeakListChangeListener<E>
implements WeakListener,
ListChangeListener<E> {
    private final WeakReference<ListChangeListener<E>> ref;

    public WeakListChangeListener(@NamedArg(value="listener") ListChangeListener<E> listChangeListener) {
        if (listChangeListener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        this.ref = new WeakReference<ListChangeListener<E>>(listChangeListener);
    }

    @Override
    public final boolean wasGarbageCollected() {
        return this.ref.get() == null;
    }

    @Override
    public final void onChanged(ListChangeListener$Change<? extends E> listChangeListener$Change) {
        ListChangeListener listChangeListener = (ListChangeListener)this.ref.get();
        if (listChangeListener != null) {
            listChangeListener.onChanged(listChangeListener$Change);
            return;
        }
        listChangeListener$Change.getList().removeListener(this);
    }
}

