/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections.transformation;

import com.sun.javafx.collections.NonIterableChange$SimplePermutationChange;
import com.sun.javafx.collections.SortHelper;
import com.sun.javafx.collections.SourceAdapterChange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList$1;
import javafx.collections.transformation.SortedList$Element;
import javafx.collections.transformation.TransformationList;

public final class SortedList<E>
extends TransformationList<E, E> {
    private Comparator<SortedList$Element<E>> elementComparator;
    private SortedList$Element<E>[] sorted;
    private int[] perm;
    private int size;
    private final SortHelper helper = new SortHelper();
    private final SortedList$Element<E> tempElement = new SortedList$Element<Object>(null, -1);
    private ObjectProperty<Comparator<? super E>> comparator;

    public SortedList(@NamedArg(value="source") ObservableList<? extends E> observableList, @NamedArg(value="comparator") Comparator<? super E> comparator) {
        super(observableList);
        this.sorted = new SortedList$Element[observableList.size() * 3 / 2 + 1];
        this.perm = new int[this.sorted.length];
        this.size = observableList.size();
        int n2 = 0;
        while (n2 < this.size) {
            this.sorted[n2] = new SortedList$Element(observableList.get(n2), n2);
            int n3 = n2++;
            this.perm[n3] = n3;
        }
        if (comparator != null) {
            this.setComparator(comparator);
        }
    }

    public SortedList(@NamedArg(value="source") ObservableList<? extends E> observableList) {
        this(observableList, null);
    }

    @Override
    protected final void sourceChanged(ListChangeListener$Change<? extends E> listChangeListener$Change) {
        if (this.elementComparator != null) {
            this.beginChange();
            while (listChangeListener$Change.next()) {
                if (listChangeListener$Change.wasPermutated()) {
                    this.updatePermutationIndexes(listChangeListener$Change);
                    continue;
                }
                if (listChangeListener$Change.wasUpdated()) {
                    this.update(listChangeListener$Change);
                    continue;
                }
                this.addRemove(listChangeListener$Change);
            }
            this.endChange();
            return;
        }
        this.updateUnsorted(listChangeListener$Change);
        this.fireChange(new SourceAdapterChange<E>(this, listChangeListener$Change));
    }

    public final ObjectProperty<Comparator<? super E>> comparatorProperty() {
        if (this.comparator == null) {
            this.comparator = new SortedList$1(this);
        }
        return this.comparator;
    }

    public final Comparator<? super E> getComparator() {
        if (this.comparator == null) {
            return null;
        }
        return (Comparator)this.comparator.get();
    }

    public final void setComparator(Comparator<? super E> comparator) {
        this.comparatorProperty().set(comparator);
    }

    @Override
    public final E get(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.sorted[n2].e;
    }

    @Override
    public final int size() {
        return this.size;
    }

    private void doSortWithPermutationChange() {
        int n2;
        if (this.elementComparator != null) {
            int[] nArray = this.helper.sort(this.sorted, 0, this.size, this.elementComparator);
            for (int i2 = 0; i2 < this.size; ++i2) {
                this.perm[this.sorted[i2].index] = i2;
            }
            this.fireChange(new NonIterableChange$SimplePermutationChange(0, this.size, nArray, this));
            return;
        }
        int[] nArray = new int[this.size];
        int[] nArray2 = new int[this.size];
        for (n2 = 0; n2 < this.size; ++n2) {
            int n3 = n2;
            nArray2[n3] = n3;
            nArray[n2] = n3;
        }
        n2 = 0;
        int n4 = 0;
        while (n4 < this.size) {
            int n5 = this.sorted[n4].index;
            if (n5 == n4) {
                ++n4;
                continue;
            }
            SortedList$Element<E> sortedList$Element = this.sorted[n5];
            this.sorted[n5] = this.sorted[n4];
            this.sorted[n4] = sortedList$Element;
            int n6 = n4;
            this.perm[n6] = n6;
            int n7 = n5;
            this.perm[n7] = n7;
            nArray[nArray2[n4]] = n5;
            nArray[nArray2[n5]] = n4;
            n2 = nArray2[n4];
            nArray2[n4] = nArray2[n5];
            nArray2[n5] = n2;
            n2 = 1;
        }
        if (n2 != 0) {
            this.fireChange(new NonIterableChange$SimplePermutationChange(0, this.size, nArray, this));
        }
    }

    @Override
    public final int getSourceIndex(int n2) {
        return this.sorted[n2].index;
    }

    @Override
    public final int getViewIndex(int n2) {
        return this.perm[n2];
    }

    private void updatePermutationIndexes(ListChangeListener$Change<? extends E> listChangeListener$Change) {
        int n2 = 0;
        while (n2 < this.size) {
            int n3;
            this.sorted[n2].index = n3 = listChangeListener$Change.getPermutation(this.sorted[n2].index);
            this.perm[n3] = n2++;
        }
    }

    private void updateUnsorted(ListChangeListener$Change<? extends E> listChangeListener$Change) {
        while (listChangeListener$Change.next()) {
            if (listChangeListener$Change.wasPermutated()) {
                SortedList$Element[] sortedList$ElementArray = new SortedList$Element[this.sorted.length];
                for (int i2 = 0; i2 < this.size; ++i2) {
                    if (i2 >= listChangeListener$Change.getFrom() && i2 < listChangeListener$Change.getTo()) {
                        int n2 = listChangeListener$Change.getPermutation(i2);
                        sortedList$ElementArray[n2] = this.sorted[i2];
                        sortedList$ElementArray[n2].index = n2;
                        int n3 = i2;
                        this.perm[n3] = n3;
                        continue;
                    }
                    sortedList$ElementArray[i2] = this.sorted[i2];
                }
                this.sorted = sortedList$ElementArray;
            }
            if (listChangeListener$Change.wasRemoved()) {
                int n4 = listChangeListener$Change.getFrom() + listChangeListener$Change.getRemovedSize();
                System.arraycopy(this.sorted, n4, this.sorted, listChangeListener$Change.getFrom(), this.size - n4);
                System.arraycopy(this.perm, n4, this.perm, listChangeListener$Change.getFrom(), this.size - n4);
                this.size -= listChangeListener$Change.getRemovedSize();
                int n5 = n4;
                this.updateIndices(n5, n5, -listChangeListener$Change.getRemovedSize());
            }
            if (!listChangeListener$Change.wasAdded()) continue;
            SortedList sortedList = this;
            sortedList.ensureSize(sortedList.size + listChangeListener$Change.getAddedSize());
            this.updateIndices(listChangeListener$Change.getFrom(), listChangeListener$Change.getFrom(), listChangeListener$Change.getAddedSize());
            System.arraycopy(this.sorted, listChangeListener$Change.getFrom(), this.sorted, listChangeListener$Change.getTo(), this.size - listChangeListener$Change.getFrom());
            System.arraycopy(this.perm, listChangeListener$Change.getFrom(), this.perm, listChangeListener$Change.getTo(), this.size - listChangeListener$Change.getFrom());
            this.size += listChangeListener$Change.getAddedSize();
            int n6 = listChangeListener$Change.getFrom();
            while (n6 < listChangeListener$Change.getTo()) {
                this.sorted[n6] = new SortedList$Element(listChangeListener$Change.getList().get(n6), n6);
                int n7 = n6++;
                this.perm[n7] = n7;
            }
        }
    }

    private void ensureSize(int n2) {
        if (this.sorted.length < n2) {
            SortedList$Element[] sortedList$ElementArray = new SortedList$Element[n2 * 3 / 2 + 1];
            System.arraycopy(this.sorted, 0, sortedList$ElementArray, 0, this.size);
            this.sorted = sortedList$ElementArray;
            int[] nArray = new int[n2 * 3 / 2 + 1];
            System.arraycopy(this.perm, 0, nArray, 0, this.size);
            this.perm = nArray;
        }
    }

    private void updateIndices(int n2, int n3, int n4) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.sorted[i2].index >= n2) {
                this.sorted[i2].index += n4;
            }
            if (this.perm[i2] < n3) continue;
            int n5 = i2;
            this.perm[n5] = this.perm[n5] + n4;
        }
    }

    private int findPosition(E e2) {
        if (this.sorted.length == 0) {
            return 0;
        }
        this.tempElement.e = e2;
        int n2 = Arrays.binarySearch(this.sorted, 0, this.size, this.tempElement, this.elementComparator);
        return n2;
    }

    private void insertToMapping(E e2, int n2) {
        int n3 = this.findPosition(e2);
        if (n3 < 0) {
            n3 ^= 0xFFFFFFFF;
        }
        SortedList sortedList = this;
        sortedList.ensureSize(sortedList.size + 1);
        this.updateIndices(n2, n3, 1);
        System.arraycopy(this.sorted, n3, this.sorted, n3 + 1, this.size - n3);
        this.sorted[n3] = new SortedList$Element<E>(e2, n2);
        System.arraycopy(this.perm, n2, this.perm, n2 + 1, this.size - n2);
        this.perm[n2] = n3;
        ++this.size;
        int n4 = n3;
        this.nextAdd(n4, n4 + 1);
    }

    private void setAllToMapping(List<? extends E> list, int n2) {
        this.ensureSize(n2);
        this.size = n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sorted[i2] = new SortedList$Element<E>(list.get(i2), i2);
        }
        int[] nArray = this.helper.sort(this.sorted, 0, this.size, this.elementComparator);
        System.arraycopy(nArray, 0, this.perm, 0, this.size);
        this.nextAdd(0, this.size);
    }

    private void removeFromMapping(int n2, E e2) {
        int n3 = this.perm[n2];
        System.arraycopy(this.sorted, n3 + 1, this.sorted, n3, this.size - n3 - 1);
        System.arraycopy(this.perm, n2 + 1, this.perm, n2, this.size - n2 - 1);
        --this.size;
        this.sorted[this.size] = null;
        this.updateIndices(n2 + 1, n3, -1);
        this.nextRemove(n3, e2);
    }

    private void removeAllFromMapping() {
        ArrayList arrayList = new ArrayList(this);
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.sorted[i2] = null;
        }
        this.size = 0;
        this.nextRemove(0, arrayList);
    }

    private void update(ListChangeListener$Change<? extends E> listChangeListener$Change) {
        int n2;
        int[] nArray = this.helper.sort(this.sorted, 0, this.size, this.elementComparator);
        for (n2 = 0; n2 < this.size; ++n2) {
            this.perm[this.sorted[n2].index] = n2;
        }
        this.nextPermutation(0, this.size, nArray);
        int n3 = listChangeListener$Change.getTo();
        for (n2 = listChangeListener$Change.getFrom(); n2 < n3; ++n2) {
            SortedList sortedList = this;
            sortedList.nextUpdate(sortedList.perm[n2]);
        }
    }

    private void addRemove(ListChangeListener$Change<? extends E> listChangeListener$Change) {
        int n2;
        int n3;
        if (listChangeListener$Change.getFrom() == 0 && listChangeListener$Change.getRemovedSize() == this.size) {
            this.removeAllFromMapping();
        } else {
            n3 = listChangeListener$Change.getRemovedSize();
            for (n2 = 0; n2 < n3; ++n2) {
                this.removeFromMapping(listChangeListener$Change.getFrom(), listChangeListener$Change.getRemoved().get(n2));
            }
        }
        if (this.size == 0) {
            this.setAllToMapping(listChangeListener$Change.getList(), listChangeListener$Change.getTo());
            return;
        }
        n3 = listChangeListener$Change.getTo();
        for (n2 = listChangeListener$Change.getFrom(); n2 < n3; ++n2) {
            this.insertToMapping(listChangeListener$Change.getList().get(n2), n2);
        }
    }
}

