/*
 * Decompiled with CFR 0.152.
 */
package javafx.concurrent;

import java.util.Timer;
import java.util.TimerTask;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.ScheduledService$1;
import javafx.concurrent.ScheduledService$2;
import javafx.concurrent.ScheduledService$3;
import javafx.concurrent.ScheduledService$4;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.util.Callback;
import javafx.util.Duration;

public abstract class ScheduledService<V>
extends Service<V> {
    public static final Callback<ScheduledService<?>, Duration> EXPONENTIAL_BACKOFF_STRATEGY = new ScheduledService$1();
    public static final Callback<ScheduledService<?>, Duration> LOGARITHMIC_BACKOFF_STRATEGY = new ScheduledService$2();
    public static final Callback<ScheduledService<?>, Duration> LINEAR_BACKOFF_STRATEGY = new ScheduledService$3();
    private static final Timer DELAY_TIMER = new Timer("ScheduledService Delay Timer", true);
    private ObjectProperty<Duration> delay = new SimpleObjectProperty<Duration>(this, "delay", Duration.ZERO);
    private ObjectProperty<Duration> period = new SimpleObjectProperty<Duration>(this, "period", Duration.ZERO);
    private ObjectProperty<Callback<ScheduledService<?>, Duration>> backoffStrategy = new SimpleObjectProperty(this, "backoffStrategy", LOGARITHMIC_BACKOFF_STRATEGY);
    private BooleanProperty restartOnFailure = new SimpleBooleanProperty(this, "restartOnFailure", true);
    private IntegerProperty maximumFailureCount = new SimpleIntegerProperty(this, "maximumFailureCount", Integer.MAX_VALUE);
    private ReadOnlyIntegerWrapper currentFailureCount = new ReadOnlyIntegerWrapper(this, "currentFailureCount", 0);
    private ReadOnlyObjectWrapper<Duration> cumulativePeriod = new ReadOnlyObjectWrapper<Duration>(this, "cumulativePeriod", Duration.ZERO);
    private ObjectProperty<Duration> maximumCumulativePeriod = new SimpleObjectProperty<Duration>(this, "maximumCumulativePeriod", Duration.INDEFINITE);
    private ReadOnlyObjectWrapper<V> lastValue = new ReadOnlyObjectWrapper<Object>(this, "lastValue", null);
    private long lastRunTime = 0L;
    private boolean freshStart = true;
    private TimerTask delayTask = null;
    private boolean stop = false;

    public final Duration getDelay() {
        return (Duration)this.delay.get();
    }

    public final void setDelay(Duration duration) {
        this.delay.set(duration);
    }

    public final ObjectProperty<Duration> delayProperty() {
        return this.delay;
    }

    public final Duration getPeriod() {
        return (Duration)this.period.get();
    }

    public final void setPeriod(Duration duration) {
        this.period.set(duration);
    }

    public final ObjectProperty<Duration> periodProperty() {
        return this.period;
    }

    public final Callback<ScheduledService<?>, Duration> getBackoffStrategy() {
        return (Callback)this.backoffStrategy.get();
    }

    public final void setBackoffStrategy(Callback<ScheduledService<?>, Duration> callback) {
        this.backoffStrategy.set(callback);
    }

    public final ObjectProperty<Callback<ScheduledService<?>, Duration>> backoffStrategyProperty() {
        return this.backoffStrategy;
    }

    public final boolean getRestartOnFailure() {
        return this.restartOnFailure.get();
    }

    public final void setRestartOnFailure(boolean bl2) {
        this.restartOnFailure.set(bl2);
    }

    public final BooleanProperty restartOnFailureProperty() {
        return this.restartOnFailure;
    }

    public final int getMaximumFailureCount() {
        return this.maximumFailureCount.get();
    }

    public final void setMaximumFailureCount(int n2) {
        this.maximumFailureCount.set(n2);
    }

    public final IntegerProperty maximumFailureCountProperty() {
        return this.maximumFailureCount;
    }

    public final int getCurrentFailureCount() {
        return this.currentFailureCount.get();
    }

    public final ReadOnlyIntegerProperty currentFailureCountProperty() {
        return this.currentFailureCount.getReadOnlyProperty();
    }

    private void setCurrentFailureCount(int n2) {
        this.currentFailureCount.set(n2);
    }

    public final Duration getCumulativePeriod() {
        return (Duration)this.cumulativePeriod.get();
    }

    public final ReadOnlyObjectProperty<Duration> cumulativePeriodProperty() {
        return this.cumulativePeriod.getReadOnlyProperty();
    }

    void setCumulativePeriod(Duration duration) {
        duration = duration == null || duration.toMillis() < 0.0 ? Duration.ZERO : duration;
        Duration duration2 = (Duration)this.maximumCumulativePeriod.get();
        if (duration2 != null && !duration2.isUnknown() && !duration.isUnknown()) {
            if (duration2.toMillis() < 0.0) {
                duration = Duration.ZERO;
            } else if (!duration2.isIndefinite() && duration.greaterThan(duration2)) {
                duration = duration2;
            }
        }
        this.cumulativePeriod.set(duration);
    }

    public final Duration getMaximumCumulativePeriod() {
        return (Duration)this.maximumCumulativePeriod.get();
    }

    public final void setMaximumCumulativePeriod(Duration duration) {
        this.maximumCumulativePeriod.set(duration);
    }

    public final ObjectProperty<Duration> maximumCumulativePeriodProperty() {
        return this.maximumCumulativePeriod;
    }

    public final V getLastValue() {
        return (V)this.lastValue.get();
    }

    public final ReadOnlyObjectProperty<V> lastValueProperty() {
        return this.lastValue.getReadOnlyProperty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void executeTask(Task<V> task) {
        double d2;
        assert (task != null);
        this.checkThread();
        if (this.freshStart) {
            assert (this.delayTask == null);
            ScheduledService scheduledService = this;
            scheduledService.setCumulativePeriod(scheduledService.getPeriod());
            long l2 = (long)ScheduledService.normalize(this.getDelay());
            if (l2 == 0L) {
                this.executeTaskNow(task);
                return;
            }
            this.delayTask = this.createTimerTask(task);
            this.schedule(this.delayTask, l2);
            return;
        }
        double d3 = ScheduledService.normalize(this.getCumulativePeriod());
        double d4 = this.clock() - this.lastRunTime;
        if (!(d2 < d3)) {
            this.executeTaskNow(task);
            return;
        }
        assert (this.delayTask == null);
        this.delayTask = this.createTimerTask(task);
        this.schedule(this.delayTask, (long)(d3 - d4));
    }

    @Override
    protected void succeeded() {
        super.succeeded();
        this.lastValue.set(this.getValue());
        Duration duration = this.getPeriod();
        this.setCumulativePeriod(duration);
        boolean bl2 = this.stop;
        this.superReset();
        assert (!this.freshStart);
        if (bl2) {
            this.cancelFromReadyState();
            return;
        }
        this.start();
    }

    @Override
    protected void failed() {
        super.failed();
        assert (this.delayTask == null);
        ScheduledService scheduledService = this;
        scheduledService.setCurrentFailureCount(scheduledService.getCurrentFailureCount() + 1);
        if (this.getRestartOnFailure() && this.getMaximumFailureCount() > this.getCurrentFailureCount()) {
            Callback<ScheduledService<?>, Duration> callback = this.getBackoffStrategy();
            if (callback != null) {
                callback = callback.call(this);
                this.setCumulativePeriod((Duration)((Object)callback));
            }
            this.superReset();
            assert (!this.freshStart);
            this.start();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.stop = false;
        ScheduledService scheduledService = this;
        scheduledService.setCumulativePeriod(scheduledService.getPeriod());
        this.lastValue.set(null);
        this.setCurrentFailureCount(0);
        this.lastRunTime = 0L;
        this.freshStart = true;
    }

    @Override
    public boolean cancel() {
        boolean bl2 = super.cancel();
        this.stop = true;
        if (this.delayTask != null) {
            this.delayTask.cancel();
            this.delayTask = null;
        }
        return bl2;
    }

    void schedule(TimerTask timerTask, long l2) {
        DELAY_TIMER.schedule(timerTask, l2);
    }

    boolean isFreshStart() {
        return this.freshStart;
    }

    long clock() {
        return System.currentTimeMillis();
    }

    private void superReset() {
        super.reset();
    }

    private TimerTask createTimerTask(Task<V> task) {
        assert (task != null);
        return new ScheduledService$4(this, task);
    }

    private void executeTaskNow(Task<V> task) {
        assert (task != null);
        this.lastRunTime = this.clock();
        this.freshStart = false;
        super.executeTask(task);
    }

    private static double normalize(Duration duration) {
        if (duration == null || duration.isUnknown()) {
            return 0.0;
        }
        if (duration.isIndefinite()) {
            return Double.MAX_VALUE;
        }
        return duration.toMillis();
    }
}

