/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.Combinator;
import com.sun.javafx.css.PseudoClassState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javafx.css.Match;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.SimpleSelector;
import javafx.css.StyleConverter$StringStore;
import javafx.css.Styleable;

public final class CompoundSelector
extends Selector {
    private final List<SimpleSelector> selectors;
    private final List<Combinator> relationships;
    private int hash = -1;

    public final List<SimpleSelector> getSelectors() {
        return this.selectors;
    }

    CompoundSelector(List<SimpleSelector> list, List<Combinator> list2) {
        this.selectors = list != null ? Collections.unmodifiableList(list) : Collections.EMPTY_LIST;
        this.relationships = list2 != null ? Collections.unmodifiableList(list2) : Collections.EMPTY_LIST;
    }

    @Override
    public final Match createMatch() {
        PseudoClassState pseudoClassState = new PseudoClassState();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.selectors.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            Object object = this.selectors.get(i2);
            object = ((Selector)object).createMatch();
            pseudoClassState.addAll(((Match)object).getPseudoClasses());
            n2 += ((Match)object).idCount;
            n3 += ((Match)object).styleClassCount;
        }
        return new Match(this, pseudoClassState, n2, n3);
    }

    @Override
    public final boolean applies(Styleable styleable) {
        return this.applies(styleable, this.selectors.size() - 1, null, 0);
    }

    @Override
    public final boolean applies(Styleable styleable, Set<PseudoClass>[] setArray, int n2) {
        assert (setArray == null || n2 < setArray.length);
        if (setArray != null && setArray.length <= n2) {
            return false;
        }
        PseudoClassState[] pseudoClassStateArray = setArray != null ? new PseudoClassState[setArray.length] : null;
        boolean bl2 = this.applies(styleable, this.selectors.size() - 1, pseudoClassStateArray, n2);
        if (bl2 && pseudoClassStateArray != null) {
            for (n2 = 0; n2 < setArray.length; ++n2) {
                Set<PseudoClass> set = setArray[n2];
                PseudoClassState pseudoClassState = pseudoClassStateArray[n2];
                if (set != null) {
                    if (pseudoClassState == null) continue;
                    set.addAll(pseudoClassState);
                    continue;
                }
                setArray[n2] = pseudoClassState;
            }
        }
        return bl2;
    }

    private boolean applies(Styleable styleable, int n2, Set<PseudoClass>[] setArray, int n3) {
        while (true) {
            if (n2 < 0) {
                return false;
            }
            if (!((Selector)this.selectors.get(n2)).applies(styleable, setArray, n3)) {
                return false;
            }
            if (n2 == 0) {
                return true;
            }
            Combinator combinator = this.relationships.get(n2 - 1);
            if (combinator != Combinator.CHILD) break;
            if ((styleable = styleable.getStyleableParent()) == null) {
                return false;
            }
            ++n3;
            --n2;
        }
        for (styleable = styleable.getStyleableParent(); styleable != null; styleable = styleable.getStyleableParent()) {
            boolean bl2;
            if (!(bl2 = this.applies(styleable, n2 - 1, setArray, ++n3))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean stateMatches(Styleable styleable, Set<PseudoClass> set) {
        return this.stateMatches(styleable, set, this.selectors.size() - 1);
    }

    private boolean stateMatches(Styleable styleable, Set<PseudoClass> object, int n2) {
        block0: while (true) {
            if (n2 < 0) {
                return false;
            }
            if (!((Selector)this.selectors.get(n2)).stateMatches(styleable, (Set<PseudoClass>)object)) {
                return false;
            }
            if (n2 == 0) {
                return true;
            }
            object = this.relationships.get(n2 - 1);
            if (object == Combinator.CHILD) {
                if ((styleable = styleable.getStyleableParent()) == null) {
                    return false;
                }
                if (!((Selector)this.selectors.get(n2 - 1)).applies(styleable)) break;
                object = styleable.getPseudoClassStates();
                --n2;
                continue;
            }
            for (styleable = styleable.getStyleableParent(); styleable != null; styleable = styleable.getStyleableParent()) {
                if (!((Selector)this.selectors.get(n2 - 1)).applies(styleable)) continue;
                object = styleable.getPseudoClassStates();
                --n2;
                continue block0;
            }
            break;
        }
        return false;
    }

    public final int hashCode() {
        if (this.hash == -1) {
            int n2;
            int n3 = this.selectors.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.hash = 31 * (this.hash + this.selectors.get(n2).hashCode());
            }
            n3 = this.relationships.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.hash = 31 * (this.hash + this.relationships.get(n2).hashCode());
            }
        }
        return this.hash;
    }

    public final boolean equals(Object object) {
        int n2;
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (CompoundSelector)object;
        if (((CompoundSelector)object).selectors.size() != this.selectors.size()) {
            return false;
        }
        int n3 = this.selectors.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (((CompoundSelector)object).selectors.get(n2).equals(this.selectors.get(n2))) continue;
            return false;
        }
        if (((CompoundSelector)object).relationships.size() != this.relationships.size()) {
            return false;
        }
        n3 = this.relationships.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (((CompoundSelector)object).relationships.get(n2).equals((Object)this.relationships.get(n2))) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.selectors.get(0));
        for (int i2 = 1; i2 < this.selectors.size(); ++i2) {
            stringBuilder.append((Object)this.relationships.get(i2 - 1));
            stringBuilder.append(this.selectors.get(i2));
        }
        return stringBuilder.toString();
    }

    @Override
    protected final void writeBinary(DataOutputStream dataOutputStream, StyleConverter$StringStore styleConverter$StringStore) throws IOException {
        int n2;
        super.writeBinary(dataOutputStream, styleConverter$StringStore);
        dataOutputStream.writeShort(this.selectors.size());
        for (n2 = 0; n2 < this.selectors.size(); ++n2) {
            this.selectors.get(n2).writeBinary(dataOutputStream, styleConverter$StringStore);
        }
        dataOutputStream.writeShort(this.relationships.size());
        for (n2 = 0; n2 < this.relationships.size(); ++n2) {
            dataOutputStream.writeByte(this.relationships.get(n2).ordinal());
        }
    }

    static CompoundSelector readBinary(int n2, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        int n3;
        int n4 = dataInputStream.readShort();
        ArrayList<SimpleSelector> arrayList = new ArrayList<SimpleSelector>();
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList.add((SimpleSelector)Selector.readBinary(n2, dataInputStream, stringArray));
        }
        n3 = dataInputStream.readShort();
        ArrayList<Combinator> arrayList2 = new ArrayList<Combinator>();
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by2 = dataInputStream.readByte();
            n4 = by2;
            if (by2 == Combinator.CHILD.ordinal()) {
                arrayList2.add(Combinator.CHILD);
                continue;
            }
            if (n4 == Combinator.DESCENDANT.ordinal()) {
                arrayList2.add(Combinator.DESCENDANT);
                continue;
            }
            assert (false) : "error deserializing CompoundSelector: Combinator = " + n4;
            arrayList2.add(Combinator.DESCENDANT);
        }
        return new CompoundSelector(arrayList, arrayList2);
    }
}

