/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.Combinator;
import com.sun.javafx.css.FontFaceImpl;
import com.sun.javafx.css.FontFaceImpl$FontFaceSrc;
import com.sun.javafx.css.FontFaceImpl$FontFaceSrcType;
import com.sun.javafx.css.ParsedValueImpl;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.parser.Token;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.scene.layout.region.BackgroundPositionConverter;
import com.sun.javafx.scene.layout.region.BackgroundSizeConverter;
import com.sun.javafx.scene.layout.region.BorderImageSliceConverter;
import com.sun.javafx.scene.layout.region.BorderImageSlices;
import com.sun.javafx.scene.layout.region.BorderImageWidthConverter;
import com.sun.javafx.scene.layout.region.BorderImageWidthsSequenceConverter;
import com.sun.javafx.scene.layout.region.BorderStrokeStyleSequenceConverter;
import com.sun.javafx.scene.layout.region.BorderStyleConverter;
import com.sun.javafx.scene.layout.region.CornerRadiiConverter;
import com.sun.javafx.scene.layout.region.LayeredBackgroundPositionConverter;
import com.sun.javafx.scene.layout.region.LayeredBackgroundSizeConverter;
import com.sun.javafx.scene.layout.region.LayeredBorderPaintConverter;
import com.sun.javafx.scene.layout.region.LayeredBorderStyleConverter;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.Margins$Converter;
import com.sun.javafx.scene.layout.region.Margins$SequenceConverter;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import com.sun.javafx.scene.layout.region.RepeatStructConverter;
import com.sun.javafx.scene.layout.region.SliceSequenceConverter;
import com.sun.javafx.scene.layout.region.StrokeBorderPaintConverter;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.Utils;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javafx.collections.ObservableList;
import javafx.css.CompoundSelector;
import javafx.css.CssLexer;
import javafx.css.CssParser$ParseError;
import javafx.css.CssParser$ParseError$InlineStyleParsingError;
import javafx.css.CssParser$ParseError$StringParsingError;
import javafx.css.CssParser$ParseError$StylesheetParsingError;
import javafx.css.CssParser$ParseException;
import javafx.css.CssParser$Term;
import javafx.css.Declaration;
import javafx.css.FontFace;
import javafx.css.ParsedValue;
import javafx.css.Rule;
import javafx.css.Selector;
import javafx.css.SimpleSelector;
import javafx.css.Size;
import javafx.css.SizeUnits;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.Stylesheet;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.DeriveColorConverter;
import javafx.css.converter.DurationConverter;
import javafx.css.converter.EffectConverter$DropShadowConverter;
import javafx.css.converter.EffectConverter$InnerShadowConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.FontConverter;
import javafx.css.converter.FontConverter$FontSizeConverter;
import javafx.css.converter.FontConverter$FontStyleConverter;
import javafx.css.converter.FontConverter$FontWeightConverter;
import javafx.css.converter.InsetsConverter;
import javafx.css.converter.InsetsConverter$SequenceConverter;
import javafx.css.converter.LadderConverter;
import javafx.css.converter.PaintConverter$ImagePatternConverter;
import javafx.css.converter.PaintConverter$LinearGradientConverter;
import javafx.css.converter.PaintConverter$RadialGradientConverter;
import javafx.css.converter.PaintConverter$RepeatingImagePatternConverter;
import javafx.css.converter.PaintConverter$SequenceConverter;
import javafx.css.converter.SizeConverter;
import javafx.css.converter.SizeConverter$SequenceConverter;
import javafx.css.converter.StopConverter;
import javafx.css.converter.StringConverter;
import javafx.css.converter.URLConverter;
import javafx.css.converter.URLConverter$SequenceConverter;
import javafx.geometry.Insets;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public final class CssParser {
    private String stylesheetAsText;
    private String sourceOfStylesheet;
    private Styleable sourceOfInlineStyle;
    private static final PlatformLogger LOGGER = Logging.getCSSLogger();
    private final Map<String, String> properties = new HashMap<String, String>();
    private static final ParsedValueImpl<Size, Size> ZERO_PERCENT = new ParsedValueImpl(new Size(0.0, SizeUnits.PERCENT), null);
    private static final ParsedValueImpl<Size, Size> FIFTY_PERCENT = new ParsedValueImpl(new Size(50.0, SizeUnits.PERCENT), null);
    private static final ParsedValueImpl<Size, Size> ONE_HUNDRED_PERCENT = new ParsedValueImpl(new Size(100.0, SizeUnits.PERCENT), null);
    private static final String SPECIAL_REGION_URL_PREFIX = "SPECIAL-REGION-URL:";
    Token currentToken = null;
    private static Stack<String> imports;

    private void setInputSource(String string, String string2) {
        this.stylesheetAsText = string2;
        this.sourceOfStylesheet = string;
        this.sourceOfInlineStyle = null;
    }

    private void setInputSource(String string) {
        this.stylesheetAsText = string;
        this.sourceOfStylesheet = null;
        this.sourceOfInlineStyle = null;
    }

    private void setInputSource(Styleable styleable) {
        this.stylesheetAsText = styleable != null ? styleable.getStyle() : null;
        this.sourceOfStylesheet = null;
        this.sourceOfInlineStyle = styleable;
    }

    public final Stylesheet parse(String object) {
        Stylesheet stylesheet = new Stylesheet();
        if (object != null && !((String)object).trim().isEmpty()) {
            this.setInputSource((String)object);
            try {
                object = new CharArrayReader(((String)object).toCharArray());
                try {
                    this.parse(stylesheet, (Reader)object);
                }
                finally {
                    ((Reader)object).close();
                }
            }
            catch (IOException iOException) {}
        }
        return stylesheet;
    }

    public final Stylesheet parse(String object, String string) throws IOException {
        Stylesheet stylesheet = new Stylesheet((String)object);
        if (string != null && !string.trim().isEmpty()) {
            this.setInputSource((String)object, string);
            object = new CharArrayReader(string.toCharArray());
            try {
                this.parse(stylesheet, (Reader)object);
            }
            finally {
                ((Reader)object).close();
            }
        }
        return stylesheet;
    }

    public final Stylesheet parse(URL object) throws IOException {
        String string = object != null ? ((URL)object).toExternalForm() : null;
        Stylesheet stylesheet = new Stylesheet(string);
        if (object != null) {
            this.setInputSource(string, null);
            object = new BufferedReader(new InputStreamReader(((URL)object).openStream(), StandardCharsets.UTF_8));
            try {
                this.parse(stylesheet, (Reader)object);
            }
            finally {
                ((Reader)object).close();
            }
        }
        return stylesheet;
    }

    private void parse(Stylesheet stylesheet, Reader reader) {
        CssLexer cssLexer = new CssLexer();
        cssLexer.setReader(reader);
        try {
            this.parse(stylesheet, cssLexer);
            return;
        }
        catch (Exception exception) {
            this.reportException(exception);
            return;
        }
    }

    public final Stylesheet parseInlineStyle(Styleable object) {
        Stylesheet stylesheet = new Stylesheet();
        Object object2 = object != null ? object.getStyle() : null;
        if (object2 != null && !((String)object2).trim().isEmpty()) {
            this.setInputSource((Styleable)object);
            object = new ArrayList();
            try {
                object2 = new CharArrayReader(((String)object2).toCharArray());
                try {
                    Object object3 = new CssLexer();
                    ((CssLexer)object3).setReader((Reader)object2);
                    this.currentToken = this.nextToken((CssLexer)object3);
                    List<Declaration> list = this.declarations((CssLexer)object3);
                    if (list != null && !list.isEmpty()) {
                        object3 = Selector.getUniversalSelector();
                        object3 = new Rule(Collections.singletonList(object3), list);
                        object.add(object3);
                    }
                }
                finally {
                    ((Reader)object2).close();
                }
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                this.reportException(exception);
            }
            stylesheet.getRules().addAll((Collection<Rule>)object);
        }
        this.setInputSource((Styleable)null);
        return stylesheet;
    }

    final ParsedValue parseExpr(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        ParsedValueImpl parsedValueImpl = null;
        this.setInputSource(null, string + ": " + string2);
        Object object = new char[string2.length() + 1];
        System.arraycopy(string2.toCharArray(), 0, object, 0, string2.length());
        object[((char[])object).length - 1] = 59;
        try {
            object = new CharArrayReader((char[])object);
            try {
                CssLexer cssLexer = new CssLexer();
                cssLexer.setReader((Reader)object);
                this.currentToken = this.nextToken(cssLexer);
                CssParser$Term cssParser$Term = this.expr(cssLexer);
                parsedValueImpl = this.valueFor(string, cssParser$Term, cssLexer);
            }
            finally {
                ((Reader)object).close();
            }
        }
        catch (IOException iOException) {
        }
        catch (CssParser$ParseException cssParser$ParseException) {
            if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                LOGGER.warning("\"" + string + ": " + string2 + "\" " + cssParser$ParseException.toString());
            }
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
        return parsedValueImpl;
    }

    private CssParser$ParseError createError(String object) {
        object = this.sourceOfStylesheet != null ? new CssParser$ParseError$StylesheetParsingError(this.sourceOfStylesheet, (String)object) : (this.sourceOfInlineStyle != null ? new CssParser$ParseError$InlineStyleParsingError(this.sourceOfInlineStyle, (String)object) : new CssParser$ParseError$StringParsingError(this.stylesheetAsText, (String)object));
        return object;
    }

    private void reportError(CssParser$ParseError cssParser$ParseError) {
        ObservableList<CssParser$ParseError> observableList = StyleManager.getErrors();
        if (observableList != null) {
            observableList.add(cssParser$ParseError);
        }
    }

    private void error(CssParser$Term object, String string) throws CssParser$ParseException {
        object = object != null ? ((CssParser$Term)object).token : null;
        object = new CssParser$ParseException(string, (Token)object, this);
        CssParser cssParser = this;
        cssParser.reportError(cssParser.createError(((CssParser$ParseException)object).toString()));
        throw object;
    }

    private void reportException(Exception exception) {
        StackTraceElement[] stackTraceElementArray;
        if (LOGGER.isLoggable(PlatformLogger$Level.WARNING) && (stackTraceElementArray = exception.getStackTrace()).length > 0) {
            StringBuilder stringBuilder = new StringBuilder("Please report ");
            stringBuilder.append(exception.getClass().getName()).append(" at:");
            int n2 = 0;
            while (n2 < stackTraceElementArray.length && this.getClass().getName().equals(stackTraceElementArray[n2].getClassName())) {
                stringBuilder.append("\n\t").append(stackTraceElementArray[n2++].toString());
            }
            LOGGER.warning(stringBuilder.toString());
        }
    }

    private String formatDeprecatedMessage(CssParser$Term cssParser$Term, String string) {
        StringBuilder stringBuilder = new StringBuilder("Using deprecated syntax for ");
        stringBuilder.append(string);
        if (this.sourceOfStylesheet != null) {
            stringBuilder.append(" at ").append(this.sourceOfStylesheet).append("[").append(cssParser$Term.token.getLine()).append(',').append(cssParser$Term.token.getOffset()).append("]");
        }
        stringBuilder.append(". Refer to the CSS Reference Guide.");
        return stringBuilder.toString();
    }

    private ParsedValueImpl<Color, Color> colorValueOfString(String string) {
        if (string.startsWith("#") || string.startsWith("0x")) {
            double d2 = 1.0;
            String string2 = string;
            int n2 = string.startsWith("#") ? 1 : 2;
            int n3 = string2.length();
            if (n3 - n2 == 4) {
                d2 = (float)Integer.parseInt(string2.substring(n3 - 1), 16) / 15.0f;
                string2 = string2.substring(0, n3 - 1);
            } else if (n3 - n2 == 8) {
                d2 = (float)Integer.parseInt(string2.substring(n3 - 2), 16) / 255.0f;
                string2 = string2.substring(0, n3 - 2);
            }
            return new ParsedValueImpl<Color, Color>(Color.web(string2, d2), null);
        }
        try {
            return new ParsedValueImpl<Color, Color>(Color.web(string), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    private String stripQuotes(String string) {
        return Utils.stripQuotes(string);
    }

    private double clamp(double d2, double d3, double d4) {
        if (d3 < d2) {
            return d2;
        }
        if (d4 < d3) {
            return d4;
        }
        return d3;
    }

    private boolean isSize(Token token) {
        int n2 = token.getType();
        switch (n2) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return token.getType() == 11;
    }

    private Size size(Token object) throws CssParser$ParseException {
        int n2 = 2;
        String string = ((Token)object).getText().trim();
        int n3 = string.length();
        int n4 = ((Token)object).getType();
        switch (n4) {
            case 13: {
                object = SizeUnits.PX;
                n2 = 0;
                break;
            }
            case 22: {
                object = SizeUnits.PERCENT;
                n2 = 1;
                break;
            }
            case 15: {
                object = SizeUnits.EM;
                break;
            }
            case 16: {
                object = SizeUnits.EX;
                break;
            }
            case 21: {
                object = SizeUnits.PX;
                break;
            }
            case 14: {
                object = SizeUnits.CM;
                break;
            }
            case 18: {
                object = SizeUnits.MM;
                break;
            }
            case 17: {
                object = SizeUnits.IN;
                break;
            }
            case 20: {
                object = SizeUnits.PT;
                break;
            }
            case 19: {
                object = SizeUnits.PC;
                break;
            }
            case 23: {
                object = SizeUnits.DEG;
                n2 = 3;
                break;
            }
            case 24: {
                object = SizeUnits.GRAD;
                n2 = 4;
                break;
            }
            case 25: {
                object = SizeUnits.RAD;
                n2 = 3;
                break;
            }
            case 26: {
                object = SizeUnits.TURN;
                n2 = 4;
                break;
            }
            case 45: {
                object = SizeUnits.S;
                n2 = 1;
                break;
            }
            case 46: {
                object = SizeUnits.MS;
                break;
            }
            default: {
                if (LOGGER.isLoggable(PlatformLogger$Level.FINEST)) {
                    LOGGER.finest("Expected '<number>'");
                }
                object = new CssParser$ParseException("Expected '<number>'", (Token)object, this);
                CssParser cssParser = this;
                cssParser.reportError(cssParser.createError(((CssParser$ParseException)object).toString()));
                throw object;
            }
        }
        return new Size(Double.parseDouble(string.substring(0, n3 - n2)), (SizeUnits)((Object)object));
    }

    private int numberOfTerms(CssParser$Term cssParser$Term) {
        if (cssParser$Term == null) {
            return 0;
        }
        int n2 = 0;
        do {
            ++n2;
        } while ((cssParser$Term = cssParser$Term.nextInSeries) != null);
        return n2;
    }

    private int numberOfLayers(CssParser$Term cssParser$Term) {
        if (cssParser$Term == null) {
            return 0;
        }
        int n2 = 0;
        do {
            ++n2;
            while (cssParser$Term.nextInSeries != null) {
                cssParser$Term = cssParser$Term.nextInSeries;
            }
        } while ((cssParser$Term = cssParser$Term.nextLayer) != null);
        return n2;
    }

    private int numberOfArgs(CssParser$Term cssParser$Term) {
        if (cssParser$Term == null) {
            return 0;
        }
        int n2 = 0;
        cssParser$Term = cssParser$Term.firstArg;
        while (cssParser$Term != null) {
            ++n2;
            cssParser$Term = cssParser$Term.nextArg;
        }
        return n2;
    }

    private CssParser$Term nextLayer(CssParser$Term cssParser$Term) {
        if (cssParser$Term == null) {
            return null;
        }
        while (cssParser$Term.nextInSeries != null) {
            cssParser$Term = cssParser$Term.nextInSeries;
        }
        return cssParser$Term.nextLayer;
    }

    final ParsedValueImpl valueFor(String string, CssParser$Term cssParser$Term, CssLexer object) throws CssParser$ParseException {
        String string2 = string = string.toLowerCase(Locale.ROOT);
        this.properties.put(string2, string2);
        if (cssParser$Term == null || cssParser$Term.token == null) {
            this.error(cssParser$Term, "Expected value for property '" + string + "'");
        }
        if (cssParser$Term.token.getType() == 11) {
            object = cssParser$Term.token.getText();
            if ("inherit".equalsIgnoreCase((String)object)) {
                return new ParsedValueImpl("inherit", null);
            }
            if ("null".equalsIgnoreCase((String)object) || "none".equalsIgnoreCase((String)object)) {
                return new ParsedValueImpl("null", null);
            }
        }
        if ("-fx-fill".equals(string)) {
            object = this.parse(cssParser$Term);
            if (((ParsedValue)object).getConverter() == StyleConverter.getUrlConverter()) {
                object = new ParsedValueImpl(new ParsedValue[]{object}, PaintConverter$ImagePatternConverter.getInstance());
            }
            return object;
        }
        if ("-fx-background-color".equals(string)) {
            return this.parsePaintLayers(cssParser$Term);
        }
        if ("-fx-background-image".equals(string)) {
            return this.parseURILayers(cssParser$Term);
        }
        if ("-fx-background-insets".equals(string)) {
            return this.parseInsetsLayers(cssParser$Term);
        }
        if ("-fx-opaque-insets".equals(string)) {
            return this.parseInsetsLayer(cssParser$Term);
        }
        if ("-fx-background-position".equals(string)) {
            return this.parseBackgroundPositionLayers(cssParser$Term);
        }
        if ("-fx-background-radius".equals(string)) {
            return this.parseCornerRadius(cssParser$Term);
        }
        if ("-fx-background-repeat".equals(string)) {
            return this.parseBackgroundRepeatStyleLayers(cssParser$Term);
        }
        if ("-fx-background-size".equals(string)) {
            return this.parseBackgroundSizeLayers(cssParser$Term);
        }
        if ("-fx-border-color".equals(string)) {
            return this.parseBorderPaintLayers(cssParser$Term);
        }
        if ("-fx-border-insets".equals(string)) {
            return this.parseInsetsLayers(cssParser$Term);
        }
        if ("-fx-border-radius".equals(string)) {
            return this.parseCornerRadius(cssParser$Term);
        }
        if ("-fx-border-style".equals(string)) {
            return this.parseBorderStyleLayers(cssParser$Term);
        }
        if ("-fx-border-width".equals(string)) {
            return this.parseMarginsLayers(cssParser$Term);
        }
        if ("-fx-border-image-insets".equals(string)) {
            return this.parseInsetsLayers(cssParser$Term);
        }
        if ("-fx-border-image-repeat".equals(string)) {
            return this.parseBorderImageRepeatStyleLayers(cssParser$Term);
        }
        if ("-fx-border-image-slice".equals(string)) {
            return this.parseBorderImageSliceLayers(cssParser$Term);
        }
        if ("-fx-border-image-source".equals(string)) {
            return this.parseURILayers(cssParser$Term);
        }
        if ("-fx-border-image-width".equals(string)) {
            return this.parseBorderImageWidthLayers(cssParser$Term);
        }
        if ("-fx-padding".equals(string)) {
            object = this.parseSize1to4(cssParser$Term);
            return new ParsedValueImpl<ParsedValue[], Insets>((ParsedValue[])object, InsetsConverter.getInstance());
        }
        if ("-fx-label-padding".equals(string)) {
            object = this.parseSize1to4(cssParser$Term);
            return new ParsedValueImpl<ParsedValue[], Insets>((ParsedValue[])object, InsetsConverter.getInstance());
        }
        if (string.endsWith("font-family")) {
            return this.parseFontFamily(cssParser$Term);
        }
        if (string.endsWith("font-size")) {
            object = this.parseFontSize(cssParser$Term);
            if (object == null) {
                this.error(cssParser$Term, "Expected '<font-size>'");
            }
            return object;
        }
        if (string.endsWith("font-style")) {
            object = this.parseFontStyle(cssParser$Term);
            if (object == null) {
                this.error(cssParser$Term, "Expected '<font-style>'");
            }
            return object;
        }
        if (string.endsWith("font-weight")) {
            object = this.parseFontWeight(cssParser$Term);
            if (object == null) {
                this.error(cssParser$Term, "Expected '<font-style>'");
            }
            return object;
        }
        if (string.endsWith("font")) {
            return this.parseFont(cssParser$Term);
        }
        if ("-fx-stroke-dash-array".equals(string)) {
            object = cssParser$Term;
            int n2 = this.numberOfTerms((CssParser$Term)object);
            ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
            int n3 = 0;
            while (object != null) {
                parsedValueImplArray[n3++] = this.parseSize((CssParser$Term)object);
                object = ((CssParser$Term)object).nextInSeries;
            }
            return new ParsedValueImpl<ParsedValue[], Number[]>(parsedValueImplArray, SizeConverter$SequenceConverter.getInstance());
        }
        if ("-fx-stroke-line-join".equals(string)) {
            object = this.parseStrokeLineJoin(cssParser$Term);
            if (object == null) {
                this.error(cssParser$Term, "Expected 'miter', 'bevel' or 'round'");
            }
            return object[0];
        }
        if ("-fx-stroke-line-cap".equals(string)) {
            object = this.parseStrokeLineCap(cssParser$Term);
            if (object == null) {
                this.error(cssParser$Term, "Expected 'square', 'butt' or 'round'");
            }
            return object;
        }
        if ("-fx-stroke-type".equals(string)) {
            object = this.parseStrokeType(cssParser$Term);
            if (object == null) {
                this.error(cssParser$Term, "Expected 'centered', 'inside' or 'outside'");
            }
            return object;
        }
        if ("-fx-font-smoothing-type".equals(string) || "-fx-blend-mode".equals(string)) {
            int n4;
            object = null;
            Token cfr_ignored_0 = cssParser$Term.token;
            if (cssParser$Term.token == null || (n4 = cssParser$Term.token.getType()) != 10 && n4 != 11 || (object = cssParser$Term.token.getText()) == null || ((String)object).isEmpty()) {
                this.error(cssParser$Term, "Expected STRING or IDENT");
            }
            return new ParsedValueImpl(this.stripQuotes((String)object), null, false);
        }
        return this.parse(cssParser$Term);
    }

    private ParsedValueImpl parse(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        if (cssParser$Term.token == null) {
            this.error(cssParser$Term, "Parse error");
        }
        ParsedValueImpl parsedValueImpl = cssParser$Term.token;
        ParsedValueImpl<Object, Object> parsedValueImpl2 = null;
        int n2 = ((Token)((Object)parsedValueImpl)).getType();
        switch (n2) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                if (cssParser$Term.nextInSeries == null) {
                    ParsedValueImpl parsedValueImpl3 = new ParsedValueImpl(this.size((Token)((Object)parsedValueImpl)), null);
                    parsedValueImpl2 = new ParsedValueImpl(parsedValueImpl3, SizeConverter.getInstance());
                    break;
                }
                ParsedValueImpl<Size, Size>[] parsedValueImplArray = this.parseSizeSeries(cssParser$Term);
                parsedValueImpl2 = new ParsedValueImpl<ParsedValue[], Number[]>(parsedValueImplArray, SizeConverter$SequenceConverter.getInstance());
                break;
            }
            case 45: 
            case 46: {
                ParsedValueImpl parsedValueImpl4 = new ParsedValueImpl(this.size((Token)((Object)parsedValueImpl)), null);
                parsedValueImpl2 = new ParsedValueImpl(parsedValueImpl4, DurationConverter.getInstance());
                break;
            }
            case 10: 
            case 11: {
                n2 = n2 == 11 ? 1 : 0;
                parsedValueImpl = this.stripQuotes(((Token)((Object)parsedValueImpl)).getText());
                String string = ((String)((Object)parsedValueImpl)).toLowerCase(Locale.ROOT);
                if ("ladder".equals(string)) {
                    parsedValueImpl2 = this.ladder(cssParser$Term);
                    break;
                }
                if ("linear".equals(string) && cssParser$Term.nextInSeries != null) {
                    parsedValueImpl2 = this.linearGradient(cssParser$Term);
                    break;
                }
                if ("radial".equals(string) && cssParser$Term.nextInSeries != null) {
                    parsedValueImpl2 = this.radialGradient(cssParser$Term);
                    break;
                }
                if ("infinity".equals(string)) {
                    Size size = new Size(Double.MAX_VALUE, SizeUnits.PX);
                    parsedValueImpl = new ParsedValueImpl(size, null);
                    parsedValueImpl2 = new ParsedValueImpl(parsedValueImpl, SizeConverter.getInstance());
                    break;
                }
                if ("indefinite".equals(string)) {
                    Size size = new Size(Double.POSITIVE_INFINITY, SizeUnits.PX);
                    parsedValueImpl = new ParsedValueImpl(size, null);
                    parsedValueImpl2 = new ParsedValueImpl(parsedValueImpl, DurationConverter.getInstance());
                    break;
                }
                if ("true".equals(string)) {
                    parsedValueImpl2 = new ParsedValueImpl<String, Boolean>("true", BooleanConverter.getInstance());
                    break;
                }
                if ("false".equals(string)) {
                    parsedValueImpl2 = new ParsedValueImpl<String, Boolean>("false", BooleanConverter.getInstance());
                    break;
                }
                boolean bl2 = n2 != 0 && this.properties.containsKey(string);
                if (!bl2 && (parsedValueImpl2 = this.colorValueOfString((String)((Object)parsedValueImpl))) != null) break;
                parsedValueImpl2 = new ParsedValueImpl(bl2 ? string : parsedValueImpl, null, n2 != 0);
                break;
            }
            case 37: {
                String string = ((Token)((Object)parsedValueImpl)).getText();
                try {
                    parsedValueImpl2 = new ParsedValueImpl(Color.web(string), null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.error(cssParser$Term, illegalArgumentException.getMessage());
                }
                break;
            }
            case 12: {
                return this.parseFunction(cssParser$Term);
            }
            case 43: {
                return this.parseURI(cssParser$Term);
            }
            default: {
                parsedValueImpl = "Unknown token type: '" + n2 + "'";
                this.error(cssParser$Term, (String)((Object)parsedValueImpl));
            }
        }
        return parsedValueImpl2;
    }

    private ParsedValueImpl<?, Size> parseSize(CssParser$Term parsedValueImpl) throws CssParser$ParseException {
        if (((CssParser$Term)((Object)parsedValueImpl)).token == null || !this.isSize(((CssParser$Term)((Object)parsedValueImpl)).token)) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<size>'");
        }
        if (((CssParser$Term)((Object)parsedValueImpl)).token.getType() != 11) {
            parsedValueImpl = this.size(((CssParser$Term)((Object)parsedValueImpl)).token);
            parsedValueImpl = new ParsedValueImpl(parsedValueImpl, null);
        } else {
            parsedValueImpl = ((CssParser$Term)((Object)parsedValueImpl)).token.getText();
            parsedValueImpl = new ParsedValueImpl(parsedValueImpl, null, true);
        }
        return parsedValueImpl;
    }

    private ParsedValueImpl<?, Color> parseColor(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        ParsedValueImpl parsedValueImpl = null;
        if (cssParser$Term.token != null && (cssParser$Term.token.getType() == 11 || cssParser$Term.token.getType() == 37 || cssParser$Term.token.getType() == 12)) {
            parsedValueImpl = this.parse(cssParser$Term);
        } else {
            this.error(cssParser$Term, "Expected '<color>'");
        }
        return parsedValueImpl;
    }

    private ParsedValueImpl rgb(CssParser$Term object) throws CssParser$ParseException {
        double d2;
        double d3;
        double d4;
        int n2;
        Token token;
        Token token2;
        Object object2;
        Object object3;
        Object object4 = ((CssParser$Term)object).token != null ? ((CssParser$Term)object).token.getText() : null;
        if (object4 == null || !"rgb".regionMatches(true, 0, (String)object4, 0, 3)) {
            this.error((CssParser$Term)object, "Expected 'rgb' or 'rgba'");
        }
        object4 = object;
        object4 = ((CssParser$Term)object4).firstArg;
        if (object4 == null) {
            this.error((CssParser$Term)object, "Expected '<number>' or '<percentage>'");
        }
        if ((object3 = ((CssParser$Term)object4).token) == null || ((Token)object3).getType() != 13 && ((Token)object3).getType() != 22) {
            this.error((CssParser$Term)object4, "Expected '<number>' or '<percentage>'");
        }
        object = object4;
        object4 = ((CssParser$Term)object4).nextArg;
        if (object4 == null) {
            this.error((CssParser$Term)object, "Expected '<number>' or '<percentage>'");
        }
        if ((object2 = ((CssParser$Term)object4).token) == null || ((Token)object2).getType() != 13 && ((Token)object2).getType() != 22) {
            this.error((CssParser$Term)object4, "Expected '<number>' or '<percentage>'");
        }
        object = object4;
        object4 = ((CssParser$Term)object4).nextArg;
        if (object4 == null) {
            this.error((CssParser$Term)object, "Expected '<number>' or '<percentage>'");
        }
        if ((token2 = ((CssParser$Term)object4).token) == null || token2.getType() != 13 && token2.getType() != 22) {
            this.error((CssParser$Term)object4, "Expected '<number>' or '<percentage>'");
        }
        object = object4;
        object4 = ((CssParser$Term)object4).nextArg;
        if (object4 != null) {
            token = ((CssParser$Term)object4).token;
            if (token == null || token.getType() != 13) {
                this.error((CssParser$Term)object4, "Expected '<number>'");
            }
        } else {
            token = null;
        }
        if ((n2 = ((Token)object3).getType()) != ((Token)object2).getType() || n2 != token2.getType() || n2 != 13 && n2 != 22) {
            this.error((CssParser$Term)object, "Argument type mistmatch");
        }
        object = ((Token)object3).getText();
        object3 = ((Token)object2).getText();
        object2 = token2.getText();
        if (n2 == 13) {
            d4 = this.clamp(0.0, Double.parseDouble((String)object) / 255.0, 1.0);
            d3 = this.clamp(0.0, Double.parseDouble((String)object3) / 255.0, 1.0);
            d2 = this.clamp(0.0, Double.parseDouble((String)object2) / 255.0, 1.0);
        } else {
            d4 = this.clamp(0.0, Double.parseDouble(((String)object).substring(0, ((String)object).length() - 1)) / 100.0, 1.0);
            d3 = this.clamp(0.0, Double.parseDouble(((String)object3).substring(0, ((String)object3).length() - 1)) / 100.0, 1.0);
            d2 = this.clamp(0.0, Double.parseDouble(((String)object2).substring(0, ((String)object2).length() - 1)) / 100.0, 1.0);
        }
        object = token != null ? token.getText() : null;
        double d5 = object != null ? this.clamp(0.0, Double.parseDouble((String)object), 1.0) : 1.0;
        return new ParsedValueImpl(Color.color(d4, d3, d2, d5), null);
    }

    private ParsedValueImpl hsb(CssParser$Term object) throws CssParser$ParseException {
        Token token;
        Token token2;
        Object object2;
        Object object3 = ((CssParser$Term)object).token != null ? ((CssParser$Term)object).token.getText() : null;
        if (object3 == null || !"hsb".regionMatches(true, 0, (String)object3, 0, 3)) {
            this.error((CssParser$Term)object, "Expected 'hsb' or 'hsba'");
        }
        object3 = object;
        object3 = ((CssParser$Term)object3).firstArg;
        if (object3 == null) {
            this.error((CssParser$Term)object, "Expected '<number>'");
        }
        if ((object2 = ((CssParser$Term)object3).token) == null || ((Token)object2).getType() != 13) {
            this.error((CssParser$Term)object3, "Expected '<number>'");
        }
        object = object3;
        object3 = ((CssParser$Term)object3).nextArg;
        if (object3 == null) {
            this.error((CssParser$Term)object, "Expected '<percent>'");
        }
        if ((token2 = ((CssParser$Term)object3).token) == null || token2.getType() != 22) {
            this.error((CssParser$Term)object3, "Expected '<percent>'");
        }
        object = object3;
        object3 = ((CssParser$Term)object3).nextArg;
        if (object3 == null) {
            this.error((CssParser$Term)object, "Expected '<percent>'");
        }
        if ((object = ((CssParser$Term)object3).token) == null || ((Token)object).getType() != 22) {
            this.error((CssParser$Term)object3, "Expected '<percent>'");
        }
        if ((object3 = ((CssParser$Term)object3).nextArg) != null) {
            token = ((CssParser$Term)object3).token;
            if (token == null || token.getType() != 13) {
                this.error((CssParser$Term)object3, "Expected '<number>'");
            }
        } else {
            token = null;
        }
        object3 = this.size((Token)object2);
        object2 = this.size(token2);
        object = this.size((Token)object);
        double d2 = ((Size)object3).pixels();
        double d3 = this.clamp(0.0, ((Size)object2).pixels(), 1.0);
        double d4 = this.clamp(0.0, ((Size)object).pixels(), 1.0);
        object = token != null ? this.size(token) : null;
        double d5 = object != null ? this.clamp(0.0, ((Size)object).pixels(), 1.0) : 1.0;
        return new ParsedValueImpl(Color.hsb(d2, d3, d4, d5), null);
    }

    private ParsedValueImpl<ParsedValue[], Color> derive(CssParser$Term parsedValueImplArray) throws CssParser$ParseException {
        Object object = parsedValueImplArray.token != null ? parsedValueImplArray.token.getText() : null;
        if (object == null || !"derive".regionMatches(true, 0, (String)object, 0, 6)) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'derive'");
        }
        object = parsedValueImplArray;
        object = ((CssParser$Term)object).firstArg;
        if (object == null) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '<color>'");
        }
        parsedValueImplArray = this.parseColor((CssParser$Term)object);
        ParsedValueImpl<?, Size> parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<percent'");
        }
        object = this.parseSize((CssParser$Term)object);
        parsedValueImplArray = new ParsedValueImpl[]{parsedValueImplArray, object};
        return new ParsedValueImpl<ParsedValue[], Color>(parsedValueImplArray, DeriveColorConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Color> ladder(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        ParsedValueImpl[] parsedValueImplArray;
        Object object = cssParser$Term.token != null ? cssParser$Term.token.getText() : null;
        if (object == null || !"ladder".regionMatches(true, 0, (String)object, 0, 6)) {
            this.error(cssParser$Term, "Expected 'ladder'");
        }
        if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
            LOGGER.warning(this.formatDeprecatedMessage(cssParser$Term, "ladder"));
        }
        object = cssParser$Term;
        object = object.nextInSeries;
        if (object == null) {
            this.error(cssParser$Term, "Expected '<color>'");
        }
        ParsedValueImpl parsedValueImpl = this.parse((CssParser$Term)object);
        ParsedValueImpl[] parsedValueImplArray2 = object;
        object = object.nextInSeries;
        if (object == null) {
            this.error((CssParser$Term)parsedValueImplArray2, "Expected 'stops'");
        }
        if (object.token == null || object.token.getType() != 11 || !"stops".equalsIgnoreCase(object.token.getText())) {
            this.error((CssParser$Term)object, "Expected 'stops'");
        }
        parsedValueImplArray2 = object;
        object = object.nextInSeries;
        if (object == null) {
            this.error((CssParser$Term)parsedValueImplArray2, "Expected '(<number>, <color>)'");
        }
        int n2 = 0;
        ParsedValueImpl[] parsedValueImplArray3 = object;
        do {
            ++n2;
        } while ((parsedValueImplArray3 = parsedValueImplArray3.nextInSeries) != null && parsedValueImplArray3.token != null && parsedValueImplArray3.token.getType() == 34);
        ParsedValueImpl[] parsedValueImplArray4 = new ParsedValueImpl[n2 + 1];
        parsedValueImplArray3 = parsedValueImplArray4;
        parsedValueImplArray4[0] = parsedValueImpl;
        int n3 = 1;
        do {
            if ((parsedValueImplArray = this.stop((CssParser$Term)object)) != null) {
                parsedValueImplArray3[n3++] = parsedValueImplArray;
            }
            parsedValueImplArray = object;
        } while ((object = object.nextInSeries) != null && object.token.getType() == 34);
        if (object != null) {
            cssParser$Term.nextInSeries = object;
        } else {
            cssParser$Term.nextInSeries = null;
            cssParser$Term.nextLayer = parsedValueImplArray.nextLayer;
        }
        return new ParsedValueImpl<ParsedValue[], Color>(parsedValueImplArray3, LadderConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Color> parseLadder(CssParser$Term object) throws CssParser$ParseException {
        Object object2 = ((CssParser$Term)object).token != null ? ((CssParser$Term)object).token.getText() : null;
        if (object2 == null || !"ladder".regionMatches(true, 0, (String)object2, 0, 6)) {
            this.error((CssParser$Term)object, "Expected 'ladder'");
        }
        object2 = object;
        object2 = object2.firstArg;
        if (object2 == null) {
            this.error((CssParser$Term)object, "Expected '<color>'");
        }
        object = this.parse((CssParser$Term)object2);
        ParsedValueImpl<ParsedValue[], Stop>[] parsedValueImplArray = object2;
        object2 = object2.nextArg;
        if (object2 == null) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '<color-stop>[, <color-stop>]+'");
        }
        object2 = this.parseColorStops((CssParser$Term)object2);
        ParsedValueImpl[] parsedValueImplArray2 = new ParsedValueImpl[((ParsedValueImpl<ParsedValue[], Stop>[])object2).length + 1];
        parsedValueImplArray = parsedValueImplArray2;
        parsedValueImplArray2[0] = object;
        System.arraycopy(object2, 0, parsedValueImplArray, 1, ((ParsedValueImpl<ParsedValue[], Stop>[])object2).length);
        return new ParsedValueImpl<ParsedValue[], Color>(parsedValueImplArray, LadderConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Stop> stop(CssParser$Term parsedValueImplArray) throws CssParser$ParseException {
        Object object = parsedValueImplArray.token != null ? parsedValueImplArray.token.getText() : null;
        if (object == null || !"(".equals(object)) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '('");
        }
        if ((object = parsedValueImplArray.firstArg) == null) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '<number>'");
        }
        parsedValueImplArray = this.parseSize((CssParser$Term)object);
        ParsedValueImpl<?, Color> parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<color>'");
        }
        object = this.parseColor((CssParser$Term)object);
        parsedValueImplArray = new ParsedValueImpl[]{parsedValueImplArray, object};
        return new ParsedValueImpl<ParsedValue[], Stop>(parsedValueImplArray, StopConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Stop>[] parseColorStops(CssParser$Term object) throws CssParser$ParseException {
        Object object2;
        int n2 = 1;
        Object object3 = object;
        while (object3 != null) {
            if (object3.nextArg != null) {
                ++n2;
                object3 = object3.nextArg;
                continue;
            }
            if (object3.nextInSeries == null) break;
            object3 = object3.nextInSeries;
        }
        if (n2 < 2) {
            this.error((CssParser$Term)object, "Expected '<color-stop>'");
        }
        object3 = new ParsedValueImpl[n2];
        Object[] objectArray = new Size[n2];
        Arrays.fill(objectArray, null);
        for (int i2 = 0; i2 < n2; ++i2) {
            object3[i2] = this.parseColor((CssParser$Term)object);
            object2 = object;
            CssParser$Term cssParser$Term = ((CssParser$Term)object).nextInSeries;
            if (cssParser$Term != null) {
                if (this.isSize(cssParser$Term.token)) {
                    objectArray[i2] = this.size(cssParser$Term.token);
                } else {
                    this.error((CssParser$Term)object2, "Expected '<percent>' or '<length>'");
                }
                object = cssParser$Term.nextArg;
                continue;
            }
            object = ((CssParser$Term)object).nextArg;
        }
        if (objectArray[0] == null) {
            objectArray[0] = new Size(0.0, SizeUnits.PERCENT);
        }
        if (objectArray[n2 - 1] == null) {
            objectArray[n2 - 1] = new Size(100.0, SizeUnits.PERCENT);
        }
        Object object4 = null;
        for (int i3 = 1; i3 < n2; ++i3) {
            object = objectArray[i3 - 1];
            if (object == null) continue;
            if (object4 == null || ((Size)object4).getValue() < ((Size)object).getValue()) {
                object4 = object;
            }
            if ((object2 = objectArray[i3]) == null || !(((Size)object2).getValue() < ((Size)object4).getValue())) continue;
            objectArray[i3] = object4;
        }
        Object object5 = null;
        int n3 = -1;
        for (int i4 = 0; i4 < n2; ++i4) {
            object4 = objectArray[i4];
            if (object4 == null) {
                if (n3 != -1) continue;
                n3 = i4;
                continue;
            }
            if (n3 >= 0) {
                int n4 = i4 - n3;
                double d2 = ((Size)object5).getValue();
                double d3 = (((Size)object4).getValue() - d2) / (double)(n4 + 1);
                while (n3 < i4) {
                    objectArray[n3++] = new Size(d2 += d3, ((Size)object4).getUnits());
                }
                n3 = -1;
            }
            object5 = object4;
        }
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        for (int i5 = 0; i5 < n2; ++i5) {
            parsedValueImplArray[i5] = new ParsedValueImpl<ParsedValue[], Stop>(new ParsedValueImpl[]{new ParsedValueImpl(objectArray[i5], null), object3[i5]}, StopConverter.getInstance());
        }
        return parsedValueImplArray;
    }

    private ParsedValueImpl[] point(CssParser$Term object) throws CssParser$ParseException {
        Object object2;
        if (((CssParser$Term)object).token == null || ((CssParser$Term)object).token.getType() != 34) {
            this.error((CssParser$Term)object, "Expected '(<number>, <number>)'");
        }
        if ((object2 = ((CssParser$Term)object).token.getText()) == null || !"(".equalsIgnoreCase((String)object2)) {
            this.error((CssParser$Term)object, "Expected '('");
        }
        if ((object2 = ((CssParser$Term)object).firstArg) == null) {
            this.error((CssParser$Term)object, "Expected '<number>'");
        }
        object = this.parseSize((CssParser$Term)object2);
        ParsedValueImpl<?, Size> parsedValueImpl = object2;
        object2 = ((CssParser$Term)object2).nextArg;
        if (object2 == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<number>'");
        }
        object2 = this.parseSize((CssParser$Term)object2);
        return new ParsedValueImpl[]{object, object2};
    }

    private ParsedValueImpl parseFunction(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        String string = cssParser$Term.token != null ? cssParser$Term.token.getText() : null;
        if (string == null) {
            this.error(cssParser$Term, "Expected function name");
        } else {
            if ("rgb".regionMatches(true, 0, string, 0, 3)) {
                return this.rgb(cssParser$Term);
            }
            if ("hsb".regionMatches(true, 0, string, 0, 3)) {
                return this.hsb(cssParser$Term);
            }
            if ("derive".regionMatches(true, 0, string, 0, 6)) {
                return this.derive(cssParser$Term);
            }
            if ("innershadow".regionMatches(true, 0, string, 0, 11)) {
                return this.innershadow(cssParser$Term);
            }
            if ("dropshadow".regionMatches(true, 0, string, 0, 10)) {
                return this.dropshadow(cssParser$Term);
            }
            if ("linear-gradient".regionMatches(true, 0, string, 0, 15)) {
                return this.parseLinearGradient(cssParser$Term);
            }
            if ("radial-gradient".regionMatches(true, 0, string, 0, 15)) {
                return this.parseRadialGradient(cssParser$Term);
            }
            if ("image-pattern".regionMatches(true, 0, string, 0, 13)) {
                return this.parseImagePattern(cssParser$Term);
            }
            if ("repeating-image-pattern".regionMatches(true, 0, string, 0, 23)) {
                return this.parseRepeatingImagePattern(cssParser$Term);
            }
            if ("ladder".regionMatches(true, 0, string, 0, 6)) {
                return this.parseLadder(cssParser$Term);
            }
            if ("region".regionMatches(true, 0, string, 0, 6)) {
                return this.parseRegion(cssParser$Term);
            }
            this.error(cssParser$Term, "Unexpected function '" + string + "'");
        }
        return null;
    }

    private ParsedValueImpl<String, BlurType> blurType(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        if (cssParser$Term == null) {
            return null;
        }
        if (cssParser$Term.token == null || cssParser$Term.token.getType() != 11 || cssParser$Term.token.getText() == null || cssParser$Term.token.getText().isEmpty()) {
            this.error(cssParser$Term, "Expected 'gaussian', 'one-pass-box', 'two-pass-box', or 'three-pass-box'");
        }
        String string = cssParser$Term.token.getText().toLowerCase(Locale.ROOT);
        BlurType blurType = BlurType.THREE_PASS_BOX;
        if ("gaussian".equals(string)) {
            blurType = BlurType.GAUSSIAN;
        } else if ("one-pass-box".equals(string)) {
            blurType = BlurType.ONE_PASS_BOX;
        } else if ("two-pass-box".equals(string)) {
            blurType = BlurType.TWO_PASS_BOX;
        } else if ("three-pass-box".equals(string)) {
            blurType = BlurType.THREE_PASS_BOX;
        } else {
            this.error(cssParser$Term, "Expected 'gaussian', 'one-pass-box', 'two-pass-box', or 'three-pass-box'");
        }
        return new ParsedValueImpl<String, BlurType>(blurType.name(), new EnumConverter<BlurType>(BlurType.class));
    }

    private ParsedValueImpl innershadow(CssParser$Term parsedValueImplArray) throws CssParser$ParseException {
        Object object;
        Object object2 = object = parsedValueImplArray.token != null ? parsedValueImplArray.token.getText() : null;
        if (!"innershadow".regionMatches(true, 0, (String)object, 0, 11)) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'innershadow'");
        }
        if ((object = parsedValueImplArray.firstArg) == null) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '<blur-type>'");
        }
        parsedValueImplArray = this.blurType((CssParser$Term)object);
        ParsedValueImpl<?, Size> parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<color>'");
        }
        ParsedValueImpl<?, Color> parsedValueImpl2 = this.parseColor((CssParser$Term)object);
        parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl3 = this.parseSize((CssParser$Term)object);
        parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl4 = this.parseSize((CssParser$Term)object);
        parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl5 = this.parseSize((CssParser$Term)object);
        parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<number>'");
        }
        object = this.parseSize((CssParser$Term)object);
        parsedValueImplArray = new ParsedValueImpl[]{parsedValueImplArray, parsedValueImpl2, parsedValueImpl3, parsedValueImpl4, parsedValueImpl5, object};
        return new ParsedValueImpl<ParsedValue[], Effect>(parsedValueImplArray, EffectConverter$InnerShadowConverter.getInstance());
    }

    private ParsedValueImpl dropshadow(CssParser$Term parsedValueImplArray) throws CssParser$ParseException {
        Object object;
        Object object2 = object = parsedValueImplArray.token != null ? parsedValueImplArray.token.getText() : null;
        if (!"dropshadow".regionMatches(true, 0, (String)object, 0, 10)) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'dropshadow'");
        }
        if ((object = parsedValueImplArray.firstArg) == null) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '<blur-type>'");
        }
        parsedValueImplArray = this.blurType((CssParser$Term)object);
        ParsedValueImpl<?, Size> parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<color>'");
        }
        ParsedValueImpl<?, Color> parsedValueImpl2 = this.parseColor((CssParser$Term)object);
        parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl3 = this.parseSize((CssParser$Term)object);
        parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl4 = this.parseSize((CssParser$Term)object);
        parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl5 = this.parseSize((CssParser$Term)object);
        parsedValueImpl = object;
        object = ((CssParser$Term)object).nextArg;
        if (object == null) {
            this.error((CssParser$Term)((Object)parsedValueImpl), "Expected '<number>'");
        }
        object = this.parseSize((CssParser$Term)object);
        parsedValueImplArray = new ParsedValueImpl[]{parsedValueImplArray, parsedValueImpl2, parsedValueImpl3, parsedValueImpl4, parsedValueImpl5, object};
        return new ParsedValueImpl<ParsedValue[], Effect>(parsedValueImplArray, EffectConverter$DropShadowConverter.getInstance());
    }

    private ParsedValueImpl<String, CycleMethod> cycleMethod(CssParser$Term object) {
        Enum enum_ = null;
        if (object != null && ((CssParser$Term)object).token.getType() == 11) {
            object = ((CssParser$Term)object).token.getText().toLowerCase(Locale.ROOT);
            if ("repeat".equals(object)) {
                enum_ = CycleMethod.REPEAT;
            } else if ("reflect".equals(object)) {
                enum_ = CycleMethod.REFLECT;
            } else if ("no-cycle".equals(object)) {
                enum_ = CycleMethod.NO_CYCLE;
            }
        }
        if (enum_ != null) {
            return new ParsedValueImpl<String, CycleMethod>(enum_.name(), new EnumConverter<CycleMethod>(CycleMethod.class));
        }
        return null;
    }

    private ParsedValueImpl<ParsedValue[], Paint> linearGradient(CssParser$Term parsedValueImplArray) throws CssParser$ParseException {
        ParsedValueImpl[] parsedValueImplArray2;
        ParsedValueImpl<Object, Object> parsedValueImpl;
        Object object = parsedValueImplArray.token != null ? parsedValueImplArray.token.getText() : null;
        if (object == null || !"linear".equalsIgnoreCase((String)object)) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'linear'");
        }
        if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
            LOGGER.warning(this.formatDeprecatedMessage((CssParser$Term)parsedValueImplArray, "linear gradient"));
        }
        object = parsedValueImplArray;
        object = parsedValueImplArray.nextInSeries;
        if (object == null) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '(<number>, <number>)'");
        }
        ParsedValueImpl[] parsedValueImplArray3 = this.point((CssParser$Term)object);
        ParsedValueImpl[] parsedValueImplArray4 = object;
        object = object.nextInSeries;
        if (object == null) {
            this.error((CssParser$Term)parsedValueImplArray4, "Expected 'to'");
        }
        if (object.token == null || object.token.getType() != 11 || !"to".equalsIgnoreCase(object.token.getText())) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'to'");
        }
        parsedValueImplArray4 = object;
        object = object.nextInSeries;
        if (object == null) {
            this.error((CssParser$Term)parsedValueImplArray4, "Expected '(<number>, <number>)'");
        }
        ParsedValueImpl[] parsedValueImplArray5 = this.point((CssParser$Term)object);
        parsedValueImplArray4 = object;
        object = object.nextInSeries;
        if (object == null) {
            this.error((CssParser$Term)parsedValueImplArray4, "Expected 'stops'");
        }
        if (object.token == null || object.token.getType() != 11 || !"stops".equalsIgnoreCase(object.token.getText())) {
            this.error((CssParser$Term)object, "Expected 'stops'");
        }
        parsedValueImplArray4 = object;
        object = object.nextInSeries;
        if (object == null) {
            this.error((CssParser$Term)parsedValueImplArray4, "Expected '(<number>, <number>)'");
        }
        int n2 = 0;
        ParsedValueImpl[] parsedValueImplArray6 = object;
        do {
            ++n2;
        } while ((parsedValueImplArray6 = parsedValueImplArray6.nextInSeries) != null && parsedValueImplArray6.token != null && parsedValueImplArray6.token.getType() == 34);
        parsedValueImplArray6 = new ParsedValueImpl[n2];
        int n3 = 0;
        do {
            if ((parsedValueImpl = this.stop((CssParser$Term)object)) != null) {
                parsedValueImplArray6[n3++] = parsedValueImpl;
            }
            parsedValueImplArray2 = object;
        } while ((object = object.nextInSeries) != null && object.token.getType() == 34);
        parsedValueImpl = this.cycleMethod((CssParser$Term)object);
        if (parsedValueImpl == null) {
            parsedValueImpl = new ParsedValueImpl(CycleMethod.NO_CYCLE.name(), new EnumConverter<CycleMethod>(CycleMethod.class));
            if (object != null) {
                parsedValueImplArray.nextInSeries = object;
            } else {
                parsedValueImplArray.nextInSeries = null;
                parsedValueImplArray.nextLayer = parsedValueImplArray2.nextLayer;
            }
        } else {
            parsedValueImplArray.nextInSeries = object.nextInSeries;
            parsedValueImplArray.nextLayer = object.nextLayer;
        }
        parsedValueImplArray = new ParsedValueImpl[5 + parsedValueImplArray6.length];
        int n4 = 0;
        ++n4;
        parsedValueImplArray[0] = parsedValueImplArray3 != null ? parsedValueImplArray3[0] : null;
        ++n4;
        parsedValueImplArray[1] = parsedValueImplArray3 != null ? parsedValueImplArray3[1] : null;
        ++n4;
        parsedValueImplArray[2] = parsedValueImplArray5 != null ? parsedValueImplArray5[0] : null;
        ++n4;
        parsedValueImplArray[3] = parsedValueImplArray5 != null ? parsedValueImplArray5[1] : null;
        ++n4;
        parsedValueImplArray[4] = parsedValueImpl;
        for (int i2 = 0; i2 < parsedValueImplArray6.length; ++i2) {
            parsedValueImplArray[n4++] = parsedValueImplArray6[i2];
        }
        return new ParsedValueImpl<ParsedValue[], Paint>(parsedValueImplArray, PaintConverter$LinearGradientConverter.getInstance());
    }

    private ParsedValueImpl parseLinearGradient(CssParser$Term object) throws CssParser$ParseException {
        int n2;
        Object object2;
        Object object3 = object2 = ((CssParser$Term)object).token != null ? ((CssParser$Term)object).token.getText() : null;
        if (!"linear-gradient".regionMatches(true, 0, (String)object2, 0, 15)) {
            this.error((CssParser$Term)object, "Expected 'linear-gradient'");
        }
        if ((object2 = ((CssParser$Term)object).firstArg) == null || ((CssParser$Term)object2).token == null || ((CssParser$Term)object2).token.getText().isEmpty()) {
            this.error((CssParser$Term)object, "Expected 'from <point> to <point>' or 'to <side-or-corner>' or '<cycle-method>' or '<color-stop>'");
        }
        object = object2;
        ParsedValueImpl[] parsedValueImplArray = null;
        ParsedValueImpl[] parsedValueImplArray2 = null;
        if ("from".equalsIgnoreCase(((CssParser$Term)object2).token.getText())) {
            object = object2;
            object2 = ((CssParser$Term)object2).nextInSeries;
            if (object2 == null) {
                this.error((CssParser$Term)object, "Expected '<point>'");
            }
            ParsedValueImpl<?, Size> parsedValueImpl = this.parseSize((CssParser$Term)object2);
            object = object2;
            object2 = ((CssParser$Term)object2).nextInSeries;
            if (object2 == null) {
                this.error((CssParser$Term)object, "Expected '<point>'");
            }
            ParsedValueImpl<?, Size> parsedValueImpl2 = this.parseSize((CssParser$Term)object2);
            parsedValueImplArray = new ParsedValueImpl[]{parsedValueImpl, parsedValueImpl2};
            object = object2;
            object2 = ((CssParser$Term)object2).nextInSeries;
            if (object2 == null) {
                this.error((CssParser$Term)object, "Expected 'to'");
            }
            if (((CssParser$Term)object2).token == null || ((CssParser$Term)object2).token.getType() != 11 || !"to".equalsIgnoreCase(((CssParser$Term)object2).token.getText())) {
                this.error((CssParser$Term)object, "Expected 'to'");
            }
            object = object2;
            object2 = ((CssParser$Term)object2).nextInSeries;
            if (object2 == null) {
                this.error((CssParser$Term)object, "Expected '<point>'");
            }
            parsedValueImpl = this.parseSize((CssParser$Term)object2);
            object = object2;
            object2 = ((CssParser$Term)object2).nextInSeries;
            if (object2 == null) {
                this.error((CssParser$Term)object, "Expected '<point>'");
            }
            parsedValueImpl2 = this.parseSize((CssParser$Term)object2);
            parsedValueImplArray2 = new ParsedValueImpl[]{parsedValueImpl, parsedValueImpl2};
            object = object2;
            object2 = ((CssParser$Term)object2).nextArg;
        } else if ("to".equalsIgnoreCase(((CssParser$Term)object2).token.getText())) {
            object = object2;
            object2 = ((CssParser$Term)object2).nextInSeries;
            if (object2 == null || ((CssParser$Term)object2).token == null || ((CssParser$Term)object2).token.getType() != 11 || ((CssParser$Term)object2).token.getText().isEmpty()) {
                this.error((CssParser$Term)object, "Expected '<side-or-corner>'");
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            n2 = 0;
            object = ((CssParser$Term)object2).token.getText().toLowerCase(Locale.ROOT);
            if ("top".equals(object)) {
                n4 = 100;
                n2 = 0;
            } else if ("bottom".equals(object)) {
                n4 = 0;
                n2 = 100;
            } else if ("right".equals(object)) {
                n3 = 0;
                n5 = 100;
            } else if ("left".equals(object)) {
                n3 = 100;
                n5 = 0;
            } else {
                this.error((CssParser$Term)object2, "Invalid '<side-or-corner>'");
            }
            object = object2;
            if (((CssParser$Term)object2).nextInSeries != null) {
                object2 = ((CssParser$Term)object2).nextInSeries;
                if (((CssParser$Term)object2).token != null && ((CssParser$Term)object2).token.getType() == 11 && !((CssParser$Term)object2).token.getText().isEmpty()) {
                    object = ((CssParser$Term)object2).token.getText().toLowerCase(Locale.ROOT);
                    if ("right".equals(object) && n3 == 0 && n5 == 0) {
                        n3 = 0;
                        n5 = 100;
                    } else if ("left".equals(object) && n3 == 0 && n5 == 0) {
                        n3 = 100;
                        n5 = 0;
                    } else if ("top".equals(object) && n4 == 0 && n2 == 0) {
                        n4 = 100;
                        n2 = 0;
                    } else if ("bottom".equals(object) && n4 == 0 && n2 == 0) {
                        n4 = 0;
                        n2 = 100;
                    } else {
                        this.error((CssParser$Term)object2, "Invalid '<side-or-corner>'");
                    }
                } else {
                    this.error((CssParser$Term)object, "Expected '<side-or-corner>'");
                }
            }
            parsedValueImplArray = new ParsedValueImpl[]{new ParsedValueImpl(new Size(n3, SizeUnits.PERCENT), null), new ParsedValueImpl(new Size(n4, SizeUnits.PERCENT), null)};
            parsedValueImplArray2 = new ParsedValueImpl[]{new ParsedValueImpl(new Size(n5, SizeUnits.PERCENT), null), new ParsedValueImpl(new Size(n2, SizeUnits.PERCENT), null)};
            object = object2;
            object2 = ((CssParser$Term)object2).nextArg;
        }
        if (parsedValueImplArray == null && parsedValueImplArray2 == null) {
            parsedValueImplArray = new ParsedValueImpl[]{new ParsedValueImpl(new Size(0.0, SizeUnits.PERCENT), null), new ParsedValueImpl(new Size(0.0, SizeUnits.PERCENT), null)};
            parsedValueImplArray2 = new ParsedValueImpl[]{new ParsedValueImpl(new Size(0.0, SizeUnits.PERCENT), null), new ParsedValueImpl(new Size(100.0, SizeUnits.PERCENT), null)};
        }
        if (object2 == null || ((CssParser$Term)object2).token == null || ((CssParser$Term)object2).token.getText().isEmpty()) {
            this.error((CssParser$Term)object, "Expected '<cycle-method>' or '<color-stop>'");
        }
        CycleMethod cycleMethod = CycleMethod.NO_CYCLE;
        if ("reflect".equalsIgnoreCase(((CssParser$Term)object2).token.getText())) {
            cycleMethod = CycleMethod.REFLECT;
            object = object2;
            object2 = ((CssParser$Term)object2).nextArg;
        } else if ("repeat".equalsIgnoreCase(((CssParser$Term)object2).token.getText())) {
            cycleMethod = CycleMethod.REPEAT;
            object = object2;
            object2 = ((CssParser$Term)object2).nextArg;
        }
        if (object2 == null || ((CssParser$Term)object2).token == null || ((CssParser$Term)object2).token.getText().isEmpty()) {
            this.error((CssParser$Term)object, "Expected '<color-stop>'");
        }
        ParsedValueImpl<ParsedValue[], Stop>[] parsedValueImplArray3 = this.parseColorStops((CssParser$Term)object2);
        ParsedValueImpl[] parsedValueImplArray4 = new ParsedValueImpl[5 + parsedValueImplArray3.length];
        n2 = 0;
        ++n2;
        parsedValueImplArray4[0] = parsedValueImplArray != null ? parsedValueImplArray[0] : null;
        ++n2;
        parsedValueImplArray4[1] = parsedValueImplArray != null ? parsedValueImplArray[1] : null;
        ++n2;
        parsedValueImplArray4[2] = parsedValueImplArray2 != null ? parsedValueImplArray2[0] : null;
        ++n2;
        parsedValueImplArray4[3] = parsedValueImplArray2 != null ? parsedValueImplArray2[1] : null;
        ++n2;
        parsedValueImplArray4[4] = new ParsedValueImpl(cycleMethod.name(), new EnumConverter<CycleMethod>(CycleMethod.class));
        for (int i2 = 0; i2 < parsedValueImplArray3.length; ++i2) {
            parsedValueImplArray4[n2++] = parsedValueImplArray3[i2];
        }
        return new ParsedValueImpl<ParsedValue[], Paint>(parsedValueImplArray4, PaintConverter$LinearGradientConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Paint> radialGradient(CssParser$Term parsedValueImplArray) throws CssParser$ParseException {
        ParsedValueImpl[] parsedValueImplArray2;
        ParsedValueImpl<Object, Object> parsedValueImpl;
        Object object;
        ParsedValueImpl[] parsedValueImplArray3;
        ParsedValueImpl[] parsedValueImplArray4;
        Object object2;
        Object object3 = parsedValueImplArray.token != null ? parsedValueImplArray.token.getText() : null;
        if (object3 == null || !"radial".equalsIgnoreCase((String)object3)) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'radial'");
        }
        if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
            LOGGER.warning(this.formatDeprecatedMessage((CssParser$Term)parsedValueImplArray, "radial gradient"));
        }
        object3 = parsedValueImplArray;
        object3 = parsedValueImplArray.nextInSeries;
        if (object3 == null) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'focus-angle <number>', 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
        }
        if (object3.token == null) {
            this.error((CssParser$Term)object3, "Expected 'focus-angle <number>', 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl2 = null;
        if (object3.token.getType() == 11 && "focus-angle".equals(object2 = object3.token.getText().toLowerCase(Locale.ROOT))) {
            parsedValueImplArray4 = object3;
            object3 = object3.nextInSeries;
            if (object3 == null) {
                this.error((CssParser$Term)parsedValueImplArray4, "Expected '<number>'");
            }
            if (object3.token == null) {
                this.error((CssParser$Term)parsedValueImplArray4, "Expected '<number>'");
            }
            parsedValueImpl2 = this.parseSize((CssParser$Term)object3);
            parsedValueImplArray4 = object3;
            object3 = object3.nextInSeries;
            if (object3 == null) {
                this.error((CssParser$Term)parsedValueImplArray4, "Expected 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
            }
            if (object3.token == null) {
                this.error((CssParser$Term)object3, "Expected 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
            }
        }
        object2 = null;
        if (object3.token.getType() == 11 && "focus-distance".equals(parsedValueImplArray3 = object3.token.getText().toLowerCase(Locale.ROOT))) {
            parsedValueImplArray4 = object3;
            object3 = object3.nextInSeries;
            if (object3 == null) {
                this.error((CssParser$Term)parsedValueImplArray4, "Expected '<number>'");
            }
            if (object3.token == null) {
                this.error((CssParser$Term)parsedValueImplArray4, "Expected '<number>'");
            }
            object2 = this.parseSize((CssParser$Term)object3);
            parsedValueImplArray4 = object3;
            object3 = object3.nextInSeries;
            if (object3 == null) {
                this.error((CssParser$Term)parsedValueImplArray4, "Expected  'center (<number>,<number>)' or '<size>'");
            }
            if (object3.token == null) {
                this.error((CssParser$Term)object3, "Expected  'center (<number>,<number>)' or '<size>'");
            }
        }
        parsedValueImplArray3 = null;
        if (object3.token.getType() == 11 && "center".equals(object = object3.token.getText().toLowerCase(Locale.ROOT))) {
            parsedValueImplArray4 = object3;
            object3 = object3.nextInSeries;
            if (object3 == null) {
                this.error((CssParser$Term)parsedValueImplArray4, "Expected '(<number>,<number>)'");
            }
            if (object3.token == null || object3.token.getType() != 34) {
                this.error((CssParser$Term)object3, "Expected '(<number>,<number>)'");
            }
            parsedValueImplArray3 = this.point((CssParser$Term)object3);
            parsedValueImplArray4 = object3;
            object3 = object3.nextInSeries;
            if (object3 == null) {
                this.error((CssParser$Term)parsedValueImplArray4, "Expected '<size>'");
            }
            if (object3.token == null) {
                this.error((CssParser$Term)object3, "Expected '<size>'");
            }
        }
        object = this.parseSize((CssParser$Term)object3);
        parsedValueImplArray4 = object3;
        object3 = object3.nextInSeries;
        if (object3 == null) {
            this.error((CssParser$Term)parsedValueImplArray4, "Expected 'stops' keyword");
        }
        if (object3.token == null || object3.token.getType() != 11) {
            this.error((CssParser$Term)object3, "Expected 'stops' keyword");
        }
        if (!"stops".equalsIgnoreCase(object3.token.getText())) {
            this.error((CssParser$Term)object3, "Expected 'stops'");
        }
        parsedValueImplArray4 = object3;
        object3 = object3.nextInSeries;
        if (object3 == null) {
            this.error((CssParser$Term)parsedValueImplArray4, "Expected '(<number>, <number>)'");
        }
        int n2 = 0;
        ParsedValueImpl[] parsedValueImplArray5 = object3;
        do {
            ++n2;
        } while ((parsedValueImplArray5 = parsedValueImplArray5.nextInSeries) != null && parsedValueImplArray5.token != null && parsedValueImplArray5.token.getType() == 34);
        parsedValueImplArray5 = new ParsedValueImpl[n2];
        int n3 = 0;
        do {
            if ((parsedValueImpl = this.stop((CssParser$Term)object3)) != null) {
                parsedValueImplArray5[n3++] = parsedValueImpl;
            }
            parsedValueImplArray2 = object3;
        } while ((object3 = object3.nextInSeries) != null && object3.token.getType() == 34);
        parsedValueImpl = this.cycleMethod((CssParser$Term)object3);
        if (parsedValueImpl == null) {
            parsedValueImpl = new ParsedValueImpl(CycleMethod.NO_CYCLE.name(), new EnumConverter<CycleMethod>(CycleMethod.class));
            if (object3 != null) {
                parsedValueImplArray.nextInSeries = object3;
            } else {
                parsedValueImplArray.nextInSeries = null;
                parsedValueImplArray.nextLayer = parsedValueImplArray2.nextLayer;
            }
        } else {
            parsedValueImplArray.nextInSeries = object3.nextInSeries;
            parsedValueImplArray.nextLayer = object3.nextLayer;
        }
        parsedValueImplArray = new ParsedValueImpl[6 + parsedValueImplArray5.length];
        int n4 = 0;
        ++n4;
        parsedValueImplArray[0] = parsedValueImpl2;
        ++n4;
        parsedValueImplArray[1] = object2;
        ++n4;
        parsedValueImplArray[2] = parsedValueImplArray3 != null ? parsedValueImplArray3[0] : null;
        ++n4;
        parsedValueImplArray[3] = parsedValueImplArray3 != null ? parsedValueImplArray3[1] : null;
        ++n4;
        parsedValueImplArray[4] = object;
        ++n4;
        parsedValueImplArray[5] = parsedValueImpl;
        for (int i2 = 0; i2 < parsedValueImplArray5.length; ++i2) {
            parsedValueImplArray[n4++] = parsedValueImplArray5[i2];
        }
        return new ParsedValueImpl<ParsedValue[], Paint>(parsedValueImplArray, PaintConverter$RadialGradientConverter.getInstance());
    }

    private ParsedValueImpl parseRadialGradient(CssParser$Term parsedValueImplArray) throws CssParser$ParseException {
        Object object;
        Object object2;
        Object object3 = object2 = parsedValueImplArray.token != null ? parsedValueImplArray.token.getText() : null;
        if (!"radial-gradient".regionMatches(true, 0, (String)object2, 0, 15)) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'radial-gradient'");
        }
        if ((object2 = parsedValueImplArray.firstArg) == null || object2.token == null || object2.token.getText().isEmpty()) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'focus-angle <angle>' or 'focus-distance <percentage>' or 'center <point>' or 'radius [<length> | <percentage>]'");
        }
        parsedValueImplArray = object2;
        ParsedValueImpl parsedValueImpl = null;
        ParsedValueImpl parsedValueImpl2 = null;
        ParsedValueImpl[] parsedValueImplArray2 = null;
        ParsedValueImpl<?, Size> parsedValueImpl3 = null;
        if ("focus-angle".equalsIgnoreCase(object2.token.getText())) {
            parsedValueImplArray = object2;
            object2 = object2.nextInSeries;
            if (object2 == null || !this.isSize(object2.token)) {
                this.error((CssParser$Term)parsedValueImplArray, "Expected '<angle>'");
            }
            object = this.size(object2.token);
            switch (((Size)object).getUnits()) {
                case DEG: 
                case RAD: 
                case GRAD: 
                case TURN: 
                case PX: {
                    break;
                }
                default: {
                    this.error((CssParser$Term)object2, "Expected [deg | rad | grad | turn ]");
                }
            }
            parsedValueImpl = new ParsedValueImpl(object, null);
            parsedValueImplArray = object2;
            object2 = object2.nextArg;
            if (object2 == null) {
                this.error((CssParser$Term)parsedValueImplArray, "Expected 'focus-distance <percentage>' or 'center <point>' or 'radius [<length> | <percentage>]'");
            }
        }
        if ("focus-distance".equalsIgnoreCase(object2.token.getText())) {
            parsedValueImplArray = object2;
            object2 = object2.nextInSeries;
            if (object2 == null || !this.isSize(object2.token)) {
                this.error((CssParser$Term)parsedValueImplArray, "Expected '<percentage>'");
            }
            object = this.size(object2.token);
            switch (((Size)object).getUnits()) {
                case PERCENT: {
                    break;
                }
                default: {
                    this.error((CssParser$Term)object2, "Expected '%'");
                }
            }
            parsedValueImpl2 = new ParsedValueImpl((Size)object, null);
            parsedValueImplArray = object2;
            object2 = object2.nextArg;
            if (object2 == null) {
                this.error((CssParser$Term)parsedValueImplArray, "Expected 'center <center>' or 'radius <length>'");
            }
        }
        if ("center".equalsIgnoreCase(object2.token.getText())) {
            parsedValueImplArray = object2;
            object2 = object2.nextInSeries;
            if (object2 == null) {
                this.error((CssParser$Term)parsedValueImplArray, "Expected '<point>'");
            }
            object = this.parseSize((CssParser$Term)object2);
            parsedValueImplArray = object2;
            object2 = object2.nextInSeries;
            if (object2 == null) {
                this.error((CssParser$Term)parsedValueImplArray, "Expected '<point>'");
            }
            parsedValueImplArray = this.parseSize((CssParser$Term)object2);
            parsedValueImplArray2 = new ParsedValueImpl[]{object, parsedValueImplArray};
            parsedValueImplArray = object2;
            object2 = object2.nextArg;
            if (object2 == null) {
                this.error((CssParser$Term)parsedValueImplArray, "Expected 'radius [<length> | <percentage>]'");
            }
        }
        if ("radius".equalsIgnoreCase(object2.token.getText())) {
            parsedValueImplArray = object2;
            object2 = object2.nextInSeries;
            if (object2 == null || !this.isSize(object2.token)) {
                this.error((CssParser$Term)parsedValueImplArray, "Expected '[<length> | <percentage>]'");
            }
            parsedValueImpl3 = this.parseSize((CssParser$Term)object2);
            parsedValueImplArray = object2;
            object2 = object2.nextArg;
            if (object2 == null) {
                this.error((CssParser$Term)parsedValueImplArray, "Expected 'radius [<length> | <percentage>]'");
            }
        }
        object = CycleMethod.NO_CYCLE;
        if ("reflect".equalsIgnoreCase(object2.token.getText())) {
            object = CycleMethod.REFLECT;
            parsedValueImplArray = object2;
            object2 = object2.nextArg;
        } else if ("repeat".equalsIgnoreCase(object2.token.getText())) {
            object = CycleMethod.REPEAT;
            parsedValueImplArray = object2;
            object2 = object2.nextArg;
        }
        if (object2 == null || object2.token == null || object2.token.getText().isEmpty()) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '<color-stop>'");
        }
        parsedValueImplArray = this.parseColorStops((CssParser$Term)object2);
        object2 = new ParsedValueImpl[6 + parsedValueImplArray.length];
        int n2 = 0;
        ++n2;
        object2[0] = parsedValueImpl;
        ++n2;
        object2[1] = parsedValueImpl2;
        ++n2;
        object2[2] = parsedValueImplArray2 != null ? parsedValueImplArray2[0] : null;
        ++n2;
        object2[3] = parsedValueImplArray2 != null ? parsedValueImplArray2[1] : null;
        ++n2;
        object2[4] = parsedValueImpl3;
        ++n2;
        object2[5] = new ParsedValueImpl(((Enum)object).name(), new EnumConverter<CycleMethod>(CycleMethod.class));
        for (int i2 = 0; i2 < parsedValueImplArray.length; ++i2) {
            object2[n2++] = parsedValueImplArray[i2];
        }
        return new ParsedValueImpl<ParsedValue[], Paint>((ParsedValue[])object2, PaintConverter$RadialGradientConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Paint> parseImagePattern(CssParser$Term object) throws CssParser$ParseException {
        Object object2;
        Object object3 = object2 = ((CssParser$Term)object).token != null ? ((CssParser$Term)object).token.getText() : null;
        if (!"image-pattern".regionMatches(true, 0, (String)object2, 0, 13)) {
            this.error((CssParser$Term)object, "Expected 'image-pattern'");
        }
        if ((object2 = ((CssParser$Term)object).firstArg) == null || object2.token == null || object2.token.getText().isEmpty()) {
            this.error((CssParser$Term)object, "Expected '<uri-string>'");
        }
        object = object2;
        Object object4 = object2.token.getText();
        object4 = new ParsedValueImpl[]{new ParsedValueImpl<String, String>((String)object4, StringConverter.getInstance()), null};
        object4 = new ParsedValueImpl<ParsedValue[], String>((ParsedValue[])object4, URLConverter.getInstance());
        if (object2.nextArg == null) {
            ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[1];
            object = parsedValueImplArray;
            parsedValueImplArray[0] = object4;
            return new ParsedValueImpl<ParsedValue[], Paint>((ParsedValue[])object, PaintConverter$ImagePatternConverter.getInstance());
        }
        object2 = object2.nextArg;
        if (object2 == null) {
            this.error((CssParser$Term)object, "Expected '<size>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl = this.parseSize((CssParser$Term)object2);
        object = object2;
        object2 = object2.nextArg;
        if (object2 == null) {
            this.error((CssParser$Term)object, "Expected '<size>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl2 = this.parseSize((CssParser$Term)object2);
        object = object2;
        object2 = object2.nextArg;
        if (object2 == null) {
            this.error((CssParser$Term)object, "Expected '<size>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl3 = this.parseSize((CssParser$Term)object2);
        object = object2;
        object2 = object2.nextArg;
        if (object2 == null) {
            this.error((CssParser$Term)object, "Expected '<size>'");
        }
        ParsedValueImpl<?, Size> parsedValueImpl4 = this.parseSize((CssParser$Term)object2);
        if (object2.nextArg == null) {
            ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[5];
            object2 = parsedValueImplArray;
            parsedValueImplArray[0] = object4;
            object2[1] = parsedValueImpl;
            object2[2] = parsedValueImpl2;
            object2[3] = parsedValueImpl3;
            object2[4] = parsedValueImpl4;
            return new ParsedValueImpl<ParsedValue[], Paint>((ParsedValue[])object2, PaintConverter$ImagePatternConverter.getInstance());
        }
        object = object2;
        object2 = object2.nextArg;
        if (object2 == null) {
            this.error((CssParser$Term)object, "Expected '<boolean>'");
        }
        if ((object = object2.token) == null || ((Token)object).getText() == null) {
            this.error((CssParser$Term)object2, "Expected '<boolean>'");
        }
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[6];
        object2 = parsedValueImplArray;
        parsedValueImplArray[0] = object4;
        object2[1] = parsedValueImpl;
        object2[2] = parsedValueImpl2;
        object2[3] = parsedValueImpl3;
        object2[4] = parsedValueImpl4;
        object2[5] = new ParsedValueImpl(Boolean.parseBoolean(((Token)object).getText()), null);
        return new ParsedValueImpl<ParsedValue[], Paint>((ParsedValue[])object2, PaintConverter$ImagePatternConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Paint> parseRepeatingImagePattern(CssParser$Term object) throws CssParser$ParseException {
        ParsedValueImpl[] parsedValueImplArray;
        ParsedValueImpl[] parsedValueImplArray2 = parsedValueImplArray = object.token != null ? object.token.getText() : null;
        if (!"repeating-image-pattern".regionMatches(true, 0, (String)parsedValueImplArray, 0, 23)) {
            this.error((CssParser$Term)object, "Expected 'repeating-image-pattern'");
        }
        if ((parsedValueImplArray = object.firstArg) == null || parsedValueImplArray.token == null || parsedValueImplArray.token.getText().isEmpty()) {
            this.error((CssParser$Term)object, "Expected '<uri-string>'");
        }
        object = parsedValueImplArray.token.getText();
        object = new ParsedValueImpl[]{new ParsedValueImpl<String, String>((String)object, StringConverter.getInstance()), null};
        object = new ParsedValueImpl<ParsedValue[], String>((ParsedValue[])object, URLConverter.getInstance());
        ParsedValueImpl[] parsedValueImplArray3 = new ParsedValueImpl[1];
        parsedValueImplArray = parsedValueImplArray3;
        parsedValueImplArray3[0] = object;
        return new ParsedValueImpl<ParsedValue[], Paint>(parsedValueImplArray, PaintConverter$RepeatingImagePatternConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<?, Paint>[], Paint[]> parsePaintLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        int n3 = 0;
        do {
            if (cssParser$Term.token == null || cssParser$Term.token.getText() == null || cssParser$Term.token.getText().isEmpty()) {
                this.error(cssParser$Term, "Expected '<paint>'");
            }
            parsedValueImplArray[n3++] = this.parse(cssParser$Term);
        } while ((cssParser$Term = this.nextLayer(cssParser$Term)) != null);
        return new ParsedValueImpl<ParsedValue<?, Paint>[], Paint[]>(parsedValueImplArray, PaintConverter$SequenceConverter.getInstance());
    }

    private ParsedValueImpl<?, Size>[] parseSize1to4(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[4];
        int n2 = 0;
        while (n2 < 4 && cssParser$Term != null) {
            parsedValueImplArray[n2++] = this.parseSize(cssParser$Term);
            cssParser$Term = cssParser$Term.nextInSeries;
        }
        if (n2 < 2) {
            parsedValueImplArray[1] = parsedValueImplArray[0];
        }
        if (n2 < 3) {
            parsedValueImplArray[2] = parsedValueImplArray[0];
        }
        if (n2 < 4) {
            parsedValueImplArray[3] = parsedValueImplArray[1];
        }
        return parsedValueImplArray;
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], Insets>[], Insets[]> parseInsetsLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        int n3 = 0;
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        while (cssParser$Term != null) {
            ParsedValueImpl<?, Size>[] parsedValueImplArray2 = this.parseSize1to4(cssParser$Term);
            parsedValueImplArray[n3++] = new ParsedValueImpl<ParsedValue[], Insets>(parsedValueImplArray2, InsetsConverter.getInstance());
            while (cssParser$Term.nextInSeries != null) {
                cssParser$Term = cssParser$Term.nextInSeries;
            }
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], Insets>[], Insets[]>(parsedValueImplArray, InsetsConverter$SequenceConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Insets> parseInsetsLayer(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        Object object = null;
        while (cssParser$Term != null) {
            object = this.parseSize1to4(cssParser$Term);
            object = new ParsedValueImpl<ParsedValue[], Insets>((ParsedValue[])object, InsetsConverter.getInstance());
            while (cssParser$Term.nextInSeries != null) {
                cssParser$Term = cssParser$Term.nextInSeries;
            }
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return object;
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], Margins>[], Margins[]> parseMarginsLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        int n3 = 0;
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        while (cssParser$Term != null) {
            ParsedValueImpl<?, Size>[] parsedValueImplArray2 = this.parseSize1to4(cssParser$Term);
            parsedValueImplArray[n3++] = new ParsedValueImpl<ParsedValue[], Margins>(parsedValueImplArray2, Margins$Converter.getInstance());
            while (cssParser$Term.nextInSeries != null) {
                cssParser$Term = cssParser$Term.nextInSeries;
            }
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], Margins>[], Margins[]>(parsedValueImplArray, Margins$SequenceConverter.getInstance());
    }

    private ParsedValueImpl<Size, Size>[] parseSizeSeries(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        if (cssParser$Term.token == null) {
            this.error(cssParser$Term, "Parse error");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CssParser$Term cssParser$Term2 = cssParser$Term;
        while (cssParser$Term2 != null) {
            Object object = cssParser$Term2.token;
            int n2 = ((Token)object).getType();
            switch (n2) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    object = new ParsedValueImpl(this.size((Token)object), null);
                    arrayList.add(object);
                    break;
                }
                default: {
                    this.error(cssParser$Term, "expected series of <size>");
                }
            }
            cssParser$Term2 = cssParser$Term2.nextInSeries;
        }
        ArrayList<Object> arrayList2 = arrayList;
        return arrayList2.toArray(new ParsedValueImpl[arrayList2.size()]);
    }

    private ParsedValueImpl<ParsedValue<ParsedValue<?, Size>[][], CornerRadii>[], CornerRadii[]> parseCornerRadius(CssParser$Term parsedValueImplArray) throws CssParser$ParseException {
        int n2 = this.numberOfLayers((CssParser$Term)parsedValueImplArray);
        Object object = parsedValueImplArray;
        int n3 = 0;
        ParsedValueImpl[] parsedValueImplArray2 = new ParsedValueImpl[n2];
        while (object != null) {
            int n4;
            int n5 = 0;
            ParsedValueImpl[][] parsedValueImplArray3 = object;
            while (parsedValueImplArray3 != null) {
                if (parsedValueImplArray3.token.getType() == 32) {
                    parsedValueImplArray3 = parsedValueImplArray3.nextInSeries;
                    break;
                }
                ++n5;
                parsedValueImplArray3 = parsedValueImplArray3.nextInSeries;
            }
            int n6 = 0;
            while (parsedValueImplArray3 != null) {
                if (parsedValueImplArray3.token.getType() == 32) {
                    this.error((CssParser$Term)parsedValueImplArray3, "unexpected SOLIDUS");
                    break;
                }
                ++n6;
                parsedValueImplArray3 = parsedValueImplArray3.nextInSeries;
            }
            if (n5 == 0 || n5 > 4 || n6 > 4) {
                this.error((CssParser$Term)parsedValueImplArray, "expected [<length>|<percentage>]{1,4} [/ [<length>|<percentage>]{1,4}]?");
            }
            n5 = 0;
            parsedValueImplArray3 = new ParsedValueImpl[2][4];
            ParsedValueImpl parsedValueImpl = new ParsedValueImpl(new Size(0.0, SizeUnits.PX), null);
            for (n4 = 0; n4 < 4; ++n4) {
                parsedValueImplArray3[0][n4] = parsedValueImpl;
                parsedValueImplArray3[1][n4] = parsedValueImpl;
            }
            n4 = 0;
            int n7 = 0;
            Object object2 = object;
            while (n4 <= 4 && n7 <= 4 && object != null) {
                if (object.token.getType() == 32) {
                    ++n5;
                } else {
                    object2 = this.parseSize((CssParser$Term)object);
                    if (n5 == 0) {
                        parsedValueImplArray3[n5][n4++] = object2;
                    } else {
                        parsedValueImplArray3[n5][n7++] = object2;
                    }
                }
                object2 = object;
                object = object.nextInSeries;
            }
            if (n4 != 0) {
                if (n4 < 2) {
                    parsedValueImplArray3[0][1] = parsedValueImplArray3[0][0];
                }
                if (n4 < 3) {
                    parsedValueImplArray3[0][2] = parsedValueImplArray3[0][0];
                }
                if (n4 < 4) {
                    parsedValueImplArray3[0][3] = parsedValueImplArray3[0][1];
                }
            } else assert (false);
            if (n7 != 0) {
                if (n7 < 2) {
                    parsedValueImplArray3[1][1] = parsedValueImplArray3[1][0];
                }
                if (n7 < 3) {
                    parsedValueImplArray3[1][2] = parsedValueImplArray3[1][0];
                }
                if (n7 < 4) {
                    parsedValueImplArray3[1][3] = parsedValueImplArray3[1][1];
                }
            } else {
                parsedValueImplArray3[1][0] = parsedValueImplArray3[0][0];
                parsedValueImplArray3[1][1] = parsedValueImplArray3[0][1];
                parsedValueImplArray3[1][2] = parsedValueImplArray3[0][2];
                parsedValueImplArray3[1][3] = parsedValueImplArray3[0][3];
            }
            if (parsedValueImpl.equals(parsedValueImplArray3[0][0]) || parsedValueImpl.equals(parsedValueImplArray3[1][0])) {
                ParsedValueImpl parsedValueImpl2 = parsedValueImpl;
                parsedValueImplArray3[0][0] = parsedValueImpl2;
                parsedValueImplArray3[1][0] = parsedValueImpl2;
            }
            if (parsedValueImpl.equals(parsedValueImplArray3[0][1]) || parsedValueImpl.equals(parsedValueImplArray3[1][1])) {
                ParsedValueImpl parsedValueImpl3 = parsedValueImpl;
                parsedValueImplArray3[0][1] = parsedValueImpl3;
                parsedValueImplArray3[1][1] = parsedValueImpl3;
            }
            if (parsedValueImpl.equals(parsedValueImplArray3[0][2]) || parsedValueImpl.equals(parsedValueImplArray3[1][2])) {
                ParsedValueImpl parsedValueImpl4 = parsedValueImpl;
                parsedValueImplArray3[0][2] = parsedValueImpl4;
                parsedValueImplArray3[1][2] = parsedValueImpl4;
            }
            if (parsedValueImpl.equals(parsedValueImplArray3[0][3]) || parsedValueImpl.equals(parsedValueImplArray3[1][3])) {
                ParsedValueImpl parsedValueImpl5 = parsedValueImpl;
                parsedValueImplArray3[0][3] = parsedValueImpl5;
                parsedValueImplArray3[1][3] = parsedValueImpl5;
            }
            parsedValueImplArray2[n3++] = new ParsedValueImpl(parsedValueImplArray3, null);
            object = this.nextLayer((CssParser$Term)object2);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue<?, Size>[][], CornerRadii>[], CornerRadii[]>(parsedValueImplArray2, CornerRadiiConverter.getInstance());
    }

    private static boolean isPositionKeyWord(String string) {
        return "center".equalsIgnoreCase(string) || "top".equalsIgnoreCase(string) || "bottom".equalsIgnoreCase(string) || "left".equalsIgnoreCase(string) || "right".equalsIgnoreCase(string);
    }

    private ParsedValueImpl<ParsedValue[], BackgroundPosition> parseBackgroundPosition(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        ParsedValueImpl<Size, Size> parsedValueImpl;
        ParsedValueImpl<Size, Size> parsedValueImpl2;
        Object object;
        Object object2;
        Object object3;
        if (cssParser$Term.token == null || cssParser$Term.token.getText() == null || cssParser$Term.token.getText().isEmpty()) {
            this.error(cssParser$Term, "Expected '<bg-position>'");
        }
        Object object4 = cssParser$Term;
        Object object5 = cssParser$Term.token;
        Object object6 = ((CssParser$Term)object4).nextInSeries;
        ParsedValueImpl<Size, Size> parsedValueImpl3 = object6 != null ? ((CssParser$Term)object6).token : null;
        Object object7 = object6 != null ? ((CssParser$Term)object6).nextInSeries : null;
        ParsedValueImpl<Size, Size> parsedValueImpl4 = object7 != null ? ((CssParser$Term)object7).token : null;
        Object object8 = object7 != null ? ((CssParser$Term)object7).nextInSeries : null;
        Object object9 = object3 = object8 != null ? ((CssParser$Term)object8).token : null;
        if (object5 != null && parsedValueImpl3 != null && parsedValueImpl4 == null && object3 == null) {
            object2 = ((Token)object5).getText();
            object = ((Token)((Object)parsedValueImpl3)).getText();
            if (("top".equals(object2) || "bottom".equals(object2)) && ("left".equals(object) || "right".equals(object) || "center".equals(object))) {
                parsedValueImpl2 = parsedValueImpl3;
                parsedValueImpl3 = object5;
                object5 = parsedValueImpl2;
                parsedValueImpl2 = object6;
                object6 = object4;
                object4 = parsedValueImpl2;
            }
        } else if (object5 != null && parsedValueImpl3 != null && parsedValueImpl4 != null) {
            object2 = null;
            object = null;
            if (object3 != null) {
                if (("top".equals(((Token)object5).getText()) || "bottom".equals(((Token)object5).getText())) && ("left".equals(((Token)((Object)parsedValueImpl4)).getText()) || "right".equals(((Token)((Object)parsedValueImpl4)).getText()))) {
                    object2 = new CssParser$Term[]{object7, object8, object4, object6};
                    object = new Token[]{parsedValueImpl4, object3, object5, parsedValueImpl3};
                }
            } else if ("top".equals(((Token)object5).getText()) || "bottom".equals(((Token)object5).getText())) {
                if ("left".equals(((Token)((Object)parsedValueImpl3)).getText()) || "right".equals(((Token)((Object)parsedValueImpl3)).getText())) {
                    object2 = new CssParser$Term[]{object6, object7, object4, null};
                    object = new Token[]{parsedValueImpl3, parsedValueImpl4, object5, null};
                } else {
                    object2 = new CssParser$Term[]{object7, object4, object6, null};
                    object = new Token[]{parsedValueImpl4, object5, parsedValueImpl3, null};
                }
            }
            if (object2 != null) {
                object4 = object2[0];
                object6 = object2[1];
                object7 = object2[2];
                object8 = object2[3];
                object5 = object[0];
                parsedValueImpl3 = object[1];
                parsedValueImpl4 = object[2];
                object3 = object[3];
            }
        }
        parsedValueImpl2 = parsedValueImpl = ZERO_PERCENT;
        object = parsedValueImpl;
        object2 = parsedValueImpl;
        if (object5 == null && parsedValueImpl3 == null && parsedValueImpl4 == null && object3 == null) {
            this.error(cssParser$Term, "No value found for background-position");
        } else if (object5 != null && parsedValueImpl3 == null && parsedValueImpl4 == null && object3 == null) {
            if ("center".equals(object5 = ((Token)object5).getText())) {
                parsedValueImpl = FIFTY_PERCENT;
                object = ZERO_PERCENT;
                object2 = FIFTY_PERCENT;
                parsedValueImpl2 = ZERO_PERCENT;
            } else if ("left".equals(object5)) {
                parsedValueImpl = ZERO_PERCENT;
                object = ZERO_PERCENT;
                object2 = FIFTY_PERCENT;
                parsedValueImpl2 = ZERO_PERCENT;
            } else if ("right".equals(object5)) {
                parsedValueImpl = ONE_HUNDRED_PERCENT;
                object = ZERO_PERCENT;
                object2 = FIFTY_PERCENT;
                parsedValueImpl2 = ZERO_PERCENT;
            } else if ("top".equals(object5)) {
                parsedValueImpl = FIFTY_PERCENT;
                object = ZERO_PERCENT;
                object2 = ZERO_PERCENT;
                parsedValueImpl2 = ZERO_PERCENT;
            } else if ("bottom".equals(object5)) {
                parsedValueImpl = FIFTY_PERCENT;
                object = ZERO_PERCENT;
                object2 = ONE_HUNDRED_PERCENT;
                parsedValueImpl2 = ZERO_PERCENT;
            } else {
                parsedValueImpl = this.parseSize((CssParser$Term)object4);
                object = ZERO_PERCENT;
                object2 = FIFTY_PERCENT;
                parsedValueImpl2 = ZERO_PERCENT;
            }
        } else if (object5 != null && parsedValueImpl3 != null && parsedValueImpl4 == null && object3 == null) {
            object5 = ((Token)object5).getText().toLowerCase(Locale.ROOT);
            parsedValueImpl3 = ((Token)((Object)parsedValueImpl3)).getText().toLowerCase(Locale.ROOT);
            if (!CssParser.isPositionKeyWord((String)object5)) {
                parsedValueImpl = this.parseSize((CssParser$Term)object4);
                object = ZERO_PERCENT;
                if ("top".equals(parsedValueImpl3)) {
                    object2 = ZERO_PERCENT;
                    parsedValueImpl2 = ZERO_PERCENT;
                } else if ("bottom".equals(parsedValueImpl3)) {
                    object2 = ONE_HUNDRED_PERCENT;
                    parsedValueImpl2 = ZERO_PERCENT;
                } else if ("center".equals(parsedValueImpl3)) {
                    object2 = FIFTY_PERCENT;
                    parsedValueImpl2 = ZERO_PERCENT;
                } else if (!CssParser.isPositionKeyWord(parsedValueImpl3)) {
                    object2 = this.parseSize((CssParser$Term)object6);
                    parsedValueImpl2 = ZERO_PERCENT;
                } else {
                    this.error((CssParser$Term)object6, "Expected 'top', 'bottom', 'center' or <size>");
                }
            } else if (((String)object5).equals("left") || ((String)object5).equals("right")) {
                parsedValueImpl = ((String)object5).equals("right") ? ONE_HUNDRED_PERCENT : ZERO_PERCENT;
                object = ZERO_PERCENT;
                if (!CssParser.isPositionKeyWord(parsedValueImpl3)) {
                    object2 = this.parseSize((CssParser$Term)object6);
                    parsedValueImpl2 = ZERO_PERCENT;
                } else if (((String)((Object)parsedValueImpl3)).equals("top") || ((String)((Object)parsedValueImpl3)).equals("bottom") || ((String)((Object)parsedValueImpl3)).equals("center")) {
                    if (((String)((Object)parsedValueImpl3)).equals("top")) {
                        object2 = ZERO_PERCENT;
                        parsedValueImpl2 = ZERO_PERCENT;
                    } else if (((String)((Object)parsedValueImpl3)).equals("center")) {
                        object2 = FIFTY_PERCENT;
                        parsedValueImpl2 = ZERO_PERCENT;
                    } else {
                        object2 = ONE_HUNDRED_PERCENT;
                        parsedValueImpl2 = ZERO_PERCENT;
                    }
                } else {
                    this.error((CssParser$Term)object6, "Expected 'top', 'bottom', 'center' or <size>");
                }
            } else if (((String)object5).equals("center")) {
                parsedValueImpl = FIFTY_PERCENT;
                object = ZERO_PERCENT;
                if (((String)((Object)parsedValueImpl3)).equals("top")) {
                    object2 = ZERO_PERCENT;
                    parsedValueImpl2 = ZERO_PERCENT;
                } else if (((String)((Object)parsedValueImpl3)).equals("bottom")) {
                    object2 = ONE_HUNDRED_PERCENT;
                    parsedValueImpl2 = ZERO_PERCENT;
                } else if (((String)((Object)parsedValueImpl3)).equals("center")) {
                    object2 = FIFTY_PERCENT;
                    parsedValueImpl2 = ZERO_PERCENT;
                } else if (!CssParser.isPositionKeyWord(parsedValueImpl3)) {
                    object2 = this.parseSize((CssParser$Term)object6);
                    parsedValueImpl2 = ZERO_PERCENT;
                } else {
                    this.error((CssParser$Term)object6, "Expected 'top', 'bottom', 'center' or <size>");
                }
            }
        } else if (object5 != null && parsedValueImpl3 != null && parsedValueImpl4 != null && object3 == null) {
            object5 = ((Token)object5).getText().toLowerCase(Locale.ROOT);
            parsedValueImpl3 = ((Token)((Object)parsedValueImpl3)).getText().toLowerCase(Locale.ROOT);
            parsedValueImpl4 = ((Token)((Object)parsedValueImpl4)).getText().toLowerCase(Locale.ROOT);
            if (!CssParser.isPositionKeyWord((String)object5) || "center".equals(object5)) {
                parsedValueImpl = "center".equals(object5) ? FIFTY_PERCENT : this.parseSize((CssParser$Term)object4);
                object = ZERO_PERCENT;
                if (!CssParser.isPositionKeyWord(parsedValueImpl4)) {
                    if ("top".equals(parsedValueImpl3)) {
                        object2 = this.parseSize((CssParser$Term)object7);
                        parsedValueImpl2 = ZERO_PERCENT;
                    } else if ("bottom".equals(parsedValueImpl3)) {
                        object2 = ZERO_PERCENT;
                        parsedValueImpl2 = this.parseSize((CssParser$Term)object7);
                    } else {
                        this.error((CssParser$Term)object6, "Expected 'top' or 'bottom'");
                    }
                } else {
                    this.error((CssParser$Term)object7, "Expected <size>");
                }
            } else if ("left".equals(object5) || "right".equals(object5)) {
                if (!CssParser.isPositionKeyWord(parsedValueImpl3)) {
                    if ("left".equals(object5)) {
                        parsedValueImpl = this.parseSize((CssParser$Term)object6);
                        object = ZERO_PERCENT;
                    } else {
                        parsedValueImpl = ZERO_PERCENT;
                        object = this.parseSize((CssParser$Term)object6);
                    }
                    if ("top".equals(parsedValueImpl4)) {
                        object2 = ZERO_PERCENT;
                        parsedValueImpl2 = ZERO_PERCENT;
                    } else if ("bottom".equals(parsedValueImpl4)) {
                        object2 = ONE_HUNDRED_PERCENT;
                        parsedValueImpl2 = ZERO_PERCENT;
                    } else if ("center".equals(parsedValueImpl4)) {
                        object2 = FIFTY_PERCENT;
                        parsedValueImpl2 = ZERO_PERCENT;
                    } else {
                        this.error((CssParser$Term)object7, "Expected 'top', 'bottom' or 'center'");
                    }
                } else {
                    if ("left".equals(object5)) {
                        parsedValueImpl = ZERO_PERCENT;
                        object = ZERO_PERCENT;
                    } else {
                        parsedValueImpl = ONE_HUNDRED_PERCENT;
                        object = ZERO_PERCENT;
                    }
                    if (!CssParser.isPositionKeyWord(parsedValueImpl4)) {
                        if ("top".equals(parsedValueImpl3)) {
                            object2 = this.parseSize((CssParser$Term)object7);
                            parsedValueImpl2 = ZERO_PERCENT;
                        } else if ("bottom".equals(parsedValueImpl3)) {
                            object2 = ZERO_PERCENT;
                            parsedValueImpl2 = this.parseSize((CssParser$Term)object7);
                        } else {
                            this.error((CssParser$Term)object6, "Expected 'top' or 'bottom'");
                        }
                    } else {
                        this.error((CssParser$Term)object7, "Expected <size>");
                    }
                }
            }
        } else {
            object5 = ((Token)object5).getText().toLowerCase(Locale.ROOT);
            parsedValueImpl3 = ((Token)((Object)parsedValueImpl3)).getText().toLowerCase(Locale.ROOT);
            parsedValueImpl4 = ((Token)((Object)parsedValueImpl4)).getText().toLowerCase(Locale.ROOT);
            object4 = ((Token)object3).getText().toLowerCase(Locale.ROOT);
            if ((((String)object5).equals("left") || ((String)object5).equals("right")) && (((String)((Object)parsedValueImpl4)).equals("top") || ((String)((Object)parsedValueImpl4)).equals("bottom")) && !CssParser.isPositionKeyWord(parsedValueImpl3) && !CssParser.isPositionKeyWord((String)object4)) {
                if (((String)object5).equals("left")) {
                    parsedValueImpl = this.parseSize((CssParser$Term)object6);
                    object = ZERO_PERCENT;
                } else {
                    parsedValueImpl = ZERO_PERCENT;
                    object = this.parseSize((CssParser$Term)object6);
                }
                if (((String)((Object)parsedValueImpl4)).equals("top")) {
                    object2 = this.parseSize((CssParser$Term)object8);
                    parsedValueImpl2 = ZERO_PERCENT;
                } else {
                    object2 = ZERO_PERCENT;
                    parsedValueImpl2 = this.parseSize((CssParser$Term)object8);
                }
            } else {
                this.error(cssParser$Term, "Expected 'left' or 'right' followed by <size> followed by 'top' or 'bottom' followed by <size>");
            }
        }
        object5 = new ParsedValueImpl[]{object2, object, parsedValueImpl2, parsedValueImpl};
        return new ParsedValueImpl<ParsedValue[], BackgroundPosition>((ParsedValue[])object5, BackgroundPositionConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], BackgroundPosition>[], BackgroundPosition[]> parseBackgroundPositionLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        int n3 = 0;
        while (cssParser$Term != null) {
            parsedValueImplArray[n3++] = this.parseBackgroundPosition(cssParser$Term);
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], BackgroundPosition>[], BackgroundPosition[]>(parsedValueImplArray, LayeredBackgroundPositionConverter.getInstance());
    }

    private ParsedValueImpl<String, BackgroundRepeat>[] parseRepeatStyle(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        String string;
        BackgroundRepeat backgroundRepeat;
        BackgroundRepeat backgroundRepeat2 = backgroundRepeat = BackgroundRepeat.NO_REPEAT;
        if (cssParser$Term.token == null || cssParser$Term.token.getType() != 11 || cssParser$Term.token.getText() == null || cssParser$Term.token.getText().isEmpty()) {
            this.error(cssParser$Term, "Expected '<repeat-style>'");
        }
        if ("repeat-x".equals(string = cssParser$Term.token.getText().toLowerCase(Locale.ROOT))) {
            backgroundRepeat2 = BackgroundRepeat.REPEAT;
            backgroundRepeat = BackgroundRepeat.NO_REPEAT;
        } else if ("repeat-y".equals(string)) {
            backgroundRepeat2 = BackgroundRepeat.NO_REPEAT;
            backgroundRepeat = BackgroundRepeat.REPEAT;
        } else if ("repeat".equals(string)) {
            backgroundRepeat2 = BackgroundRepeat.REPEAT;
            backgroundRepeat = BackgroundRepeat.REPEAT;
        } else if ("space".equals(string)) {
            backgroundRepeat2 = BackgroundRepeat.SPACE;
            backgroundRepeat = BackgroundRepeat.SPACE;
        } else if ("round".equals(string)) {
            backgroundRepeat2 = BackgroundRepeat.ROUND;
            backgroundRepeat = BackgroundRepeat.ROUND;
        } else if ("no-repeat".equals(string)) {
            backgroundRepeat2 = BackgroundRepeat.NO_REPEAT;
            backgroundRepeat = BackgroundRepeat.NO_REPEAT;
        } else if ("stretch".equals(string)) {
            backgroundRepeat2 = BackgroundRepeat.NO_REPEAT;
            backgroundRepeat = BackgroundRepeat.NO_REPEAT;
        } else {
            this.error(cssParser$Term, "Expected  '<repeat-style>' " + string);
        }
        cssParser$Term = cssParser$Term.nextInSeries;
        if (cssParser$Term != null && cssParser$Term.token != null && cssParser$Term.token.getType() == 11 && cssParser$Term.token.getText() != null && !cssParser$Term.token.getText().isEmpty()) {
            string = cssParser$Term.token.getText().toLowerCase(Locale.ROOT);
            if ("repeat-x".equals(string)) {
                this.error(cssParser$Term, "Unexpected 'repeat-x'");
            } else if ("repeat-y".equals(string)) {
                this.error(cssParser$Term, "Unexpected 'repeat-y'");
            } else if ("repeat".equals(string)) {
                backgroundRepeat = BackgroundRepeat.REPEAT;
            } else if ("space".equals(string)) {
                backgroundRepeat = BackgroundRepeat.SPACE;
            } else if ("round".equals(string)) {
                backgroundRepeat = BackgroundRepeat.ROUND;
            } else if ("no-repeat".equals(string)) {
                backgroundRepeat = BackgroundRepeat.NO_REPEAT;
            } else if ("stretch".equals(string)) {
                backgroundRepeat = BackgroundRepeat.NO_REPEAT;
            } else {
                this.error(cssParser$Term, "Expected  '<repeat-style>'");
            }
        }
        return new ParsedValueImpl[]{new ParsedValueImpl(backgroundRepeat2.name(), new EnumConverter<BackgroundRepeat>(BackgroundRepeat.class)), new ParsedValueImpl(backgroundRepeat.name(), new EnumConverter<BackgroundRepeat>(BackgroundRepeat.class))};
    }

    private ParsedValueImpl<ParsedValue<String, BackgroundRepeat>[][], RepeatStruct[]> parseBorderImageRepeatStyleLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        ParsedValueImpl[][] parsedValueImplArrayArray = new ParsedValueImpl[n2][];
        int n3 = 0;
        while (cssParser$Term != null) {
            parsedValueImplArrayArray[n3++] = this.parseRepeatStyle(cssParser$Term);
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<String, BackgroundRepeat>[][], RepeatStruct[]>(parsedValueImplArrayArray, RepeatStructConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<String, BackgroundRepeat>[][], RepeatStruct[]> parseBackgroundRepeatStyleLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        ParsedValueImpl[][] parsedValueImplArrayArray = new ParsedValueImpl[n2][];
        int n3 = 0;
        while (cssParser$Term != null) {
            parsedValueImplArrayArray[n3++] = this.parseRepeatStyle(cssParser$Term);
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<String, BackgroundRepeat>[][], RepeatStruct[]>(parsedValueImplArrayArray, RepeatStructConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], BackgroundSize> parseBackgroundSize(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        ParsedValueImpl[] parsedValueImplArray;
        ParsedValueImpl<Size, Size> parsedValueImpl = null;
        ParsedValueImpl<Object, Size> parsedValueImpl2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (cssParser$Term.token == null) {
            this.error(cssParser$Term, "Expected '<bg-size>'");
        }
        if (cssParser$Term.token.getType() == 11) {
            ParsedValueImpl[] parsedValueImplArray2 = parsedValueImplArray = cssParser$Term.token.getText() != null ? cssParser$Term.token.getText().toLowerCase(Locale.ROOT) : null;
            if (!"auto".equals(parsedValueImplArray)) {
                if ("cover".equals(parsedValueImplArray)) {
                    bl2 = true;
                } else if ("contain".equals(parsedValueImplArray)) {
                    bl3 = true;
                } else if ("stretch".equals(parsedValueImplArray)) {
                    parsedValueImpl2 = ONE_HUNDRED_PERCENT;
                    parsedValueImpl = ONE_HUNDRED_PERCENT;
                } else {
                    this.error(cssParser$Term, "Expected 'auto', 'cover', 'contain', or  'stretch'");
                }
            }
        } else if (this.isSize(cssParser$Term.token)) {
            parsedValueImpl2 = this.parseSize(cssParser$Term);
            parsedValueImpl = null;
        } else {
            this.error(cssParser$Term, "Expected '<bg-size>'");
        }
        cssParser$Term = cssParser$Term.nextInSeries;
        if (cssParser$Term != null) {
            if (bl2 || bl3) {
                this.error(cssParser$Term, "Unexpected '<bg-size>'");
            }
            if (cssParser$Term.token.getType() == 11) {
                ParsedValueImpl[] parsedValueImplArray3 = parsedValueImplArray = cssParser$Term.token.getText() != null ? cssParser$Term.token.getText().toLowerCase(Locale.ROOT) : null;
                if ("auto".equals(parsedValueImplArray)) {
                    parsedValueImpl = null;
                } else if ("cover".equals(parsedValueImplArray)) {
                    this.error(cssParser$Term, "Unexpected 'cover'");
                } else if ("contain".equals(parsedValueImplArray)) {
                    this.error(cssParser$Term, "Unexpected 'contain'");
                } else if ("stretch".equals(parsedValueImplArray)) {
                    parsedValueImpl = ONE_HUNDRED_PERCENT;
                } else {
                    this.error(cssParser$Term, "Expected 'auto' or 'stretch'");
                }
            } else if (this.isSize(cssParser$Term.token)) {
                parsedValueImpl = this.parseSize(cssParser$Term);
            } else {
                this.error(cssParser$Term, "Expected '<bg-size>'");
            }
        }
        parsedValueImplArray = new ParsedValueImpl[]{parsedValueImpl2, parsedValueImpl, new ParsedValueImpl<String, Boolean>(bl2 ? "true" : "false", BooleanConverter.getInstance()), new ParsedValueImpl<String, Boolean>(bl3 ? "true" : "false", BooleanConverter.getInstance())};
        return new ParsedValueImpl<ParsedValue[], BackgroundSize>(parsedValueImplArray, BackgroundSizeConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], BackgroundSize>[], BackgroundSize[]> parseBackgroundSizeLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        int n3 = 0;
        while (cssParser$Term != null) {
            parsedValueImplArray[n3++] = this.parseBackgroundSize(cssParser$Term);
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], BackgroundSize>[], BackgroundSize[]>(parsedValueImplArray, LayeredBackgroundSizeConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<?, Paint>[], Paint[]> parseBorderPaint(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[4];
        int n2 = 0;
        while (cssParser$Term != null) {
            if (cssParser$Term.token == null || parsedValueImplArray.length <= n2) {
                this.error(cssParser$Term, "Expected '<paint>'");
            }
            parsedValueImplArray[n2++] = this.parse(cssParser$Term);
            cssParser$Term = cssParser$Term.nextInSeries;
        }
        if (n2 < 2) {
            parsedValueImplArray[1] = parsedValueImplArray[0];
        }
        if (n2 < 3) {
            parsedValueImplArray[2] = parsedValueImplArray[0];
        }
        if (n2 < 4) {
            parsedValueImplArray[3] = parsedValueImplArray[1];
        }
        return new ParsedValueImpl<ParsedValue<?, Paint>[], Paint[]>(parsedValueImplArray, StrokeBorderPaintConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue<?, Paint>[], Paint[]>[], Paint[][]> parseBorderPaintLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        int n3 = 0;
        while (cssParser$Term != null) {
            parsedValueImplArray[n3++] = this.parseBorderPaint(cssParser$Term);
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue<?, Paint>[], Paint[]>[], Paint[][]>(parsedValueImplArray, LayeredBorderPaintConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], BorderStrokeStyle>[], BorderStrokeStyle[]> parseBorderStyleSeries(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[4];
        int n2 = 0;
        while (cssParser$Term != null) {
            parsedValueImplArray[n2++] = this.parseBorderStyle(cssParser$Term);
            cssParser$Term = cssParser$Term.nextInSeries;
        }
        if (n2 < 2) {
            parsedValueImplArray[1] = parsedValueImplArray[0];
        }
        if (n2 < 3) {
            parsedValueImplArray[2] = parsedValueImplArray[0];
        }
        if (n2 < 4) {
            parsedValueImplArray[3] = parsedValueImplArray[1];
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], BorderStrokeStyle>[], BorderStrokeStyle[]>(parsedValueImplArray, BorderStrokeStyleSequenceConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue<ParsedValue[], BorderStrokeStyle>[], BorderStrokeStyle[]>[], BorderStrokeStyle[][]> parseBorderStyleLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        int n3 = 0;
        while (cssParser$Term != null) {
            parsedValueImplArray[n3++] = this.parseBorderStyleSeries(cssParser$Term);
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue<ParsedValue[], BorderStrokeStyle>[], BorderStrokeStyle[]>[], BorderStrokeStyle[][]>(parsedValueImplArray, LayeredBorderStyleConverter.getInstance());
    }

    private String getKeyword(CssParser$Term cssParser$Term) {
        if (cssParser$Term != null && cssParser$Term.token != null && cssParser$Term.token.getType() == 11 && cssParser$Term.token.getText() != null && !cssParser$Term.token.getText().isEmpty()) {
            return cssParser$Term.token.getText().toLowerCase(Locale.ROOT);
        }
        return null;
    }

    private ParsedValueImpl<ParsedValue[], BorderStrokeStyle> parseBorderStyle(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        ParsedValueImpl<String, StrokeType> parsedValueImpl;
        ParsedValueImpl parsedValueImpl2 = null;
        ParsedValueImpl parsedValueImpl3 = null;
        ParsedValueImpl parsedValueImpl4 = null;
        ParsedValueImpl<String, StrokeLineCap> parsedValueImpl5 = null;
        CssParser$Term cssParser$Term2 = cssParser$Term;
        ParsedValue<ParsedValue[], Number[]> parsedValue = this.dashStyle(cssParser$Term2);
        Object object = cssParser$Term2;
        cssParser$Term2 = cssParser$Term2.nextInSeries;
        String string = this.getKeyword(cssParser$Term2);
        if ("phase".equals(string)) {
            cssParser$Term2 = cssParser$Term2.nextInSeries;
            if (cssParser$Term2 == null || cssParser$Term2.token == null || !this.isSize(cssParser$Term2.token)) {
                this.error(cssParser$Term2, "Expected '<size>'");
            }
            object = this.parseSize(cssParser$Term2);
            parsedValueImpl2 = new ParsedValueImpl((ParsedValue<?, Size>)object, SizeConverter.getInstance());
            object = cssParser$Term2;
            cssParser$Term2 = cssParser$Term2.nextInSeries;
        }
        if ((parsedValueImpl = this.parseStrokeType(cssParser$Term2)) != null) {
            object = cssParser$Term2;
            cssParser$Term2 = cssParser$Term2.nextInSeries;
        }
        if ("line-join".equals(string = this.getKeyword(cssParser$Term2))) {
            cssParser$Term2 = cssParser$Term2.nextInSeries;
            object = this.parseStrokeLineJoin(cssParser$Term2);
            if (object != null) {
                parsedValueImpl3 = object[0];
                parsedValueImpl4 = object[1];
            } else {
                this.error(cssParser$Term2, "Expected 'miter <size>?', 'bevel' or 'round'");
            }
            object = cssParser$Term2;
            cssParser$Term2 = cssParser$Term2.nextInSeries;
            string = this.getKeyword(cssParser$Term2);
        }
        if ("line-cap".equals(string)) {
            cssParser$Term2 = cssParser$Term2.nextInSeries;
            parsedValueImpl5 = this.parseStrokeLineCap(cssParser$Term2);
            if (parsedValueImpl5 == null) {
                this.error(cssParser$Term2, "Expected 'square', 'butt' or 'round'");
            }
            object = cssParser$Term2;
            cssParser$Term2 = cssParser$Term2.nextInSeries;
        }
        if (cssParser$Term2 != null) {
            cssParser$Term.nextInSeries = cssParser$Term2;
        } else {
            cssParser$Term.nextInSeries = null;
            cssParser$Term.nextLayer = object.nextLayer;
        }
        object = new ParsedValue[]{parsedValue, parsedValueImpl2, parsedValueImpl, parsedValueImpl3, parsedValueImpl4, parsedValueImpl5};
        return new ParsedValueImpl<ParsedValue[], BorderStrokeStyle>((ParsedValue[])object, BorderStyleConverter.getInstance());
    }

    private ParsedValue<ParsedValue[], Number[]> dashStyle(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        if (cssParser$Term.token == null) {
            this.error(cssParser$Term, "Expected '<dash-style>'");
        }
        int n2 = cssParser$Term.token.getType();
        ParsedValue<ParsedValue[], Number[]> parsedValue = null;
        if (n2 == 11) {
            parsedValue = this.borderStyle(cssParser$Term);
        } else if (n2 == 12) {
            parsedValue = this.segments(cssParser$Term);
        } else {
            this.error(cssParser$Term, "Expected '<dash-style>'");
        }
        return parsedValue;
    }

    private ParsedValue<ParsedValue[], Number[]> borderStyle(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        String string;
        if (cssParser$Term.token == null || cssParser$Term.token.getType() != 11 || cssParser$Term.token.getText() == null || cssParser$Term.token.getText().isEmpty()) {
            this.error(cssParser$Term, "Expected '<border-style>'");
        }
        if ("none".equals(string = cssParser$Term.token.getText().toLowerCase(Locale.ROOT))) {
            return BorderStyleConverter.NONE;
        }
        if ("hidden".equals(string)) {
            return BorderStyleConverter.NONE;
        }
        if ("dotted".equals(string)) {
            return BorderStyleConverter.DOTTED;
        }
        if ("dashed".equals(string)) {
            return BorderStyleConverter.DASHED;
        }
        if ("solid".equals(string)) {
            return BorderStyleConverter.SOLID;
        }
        if ("double".equals(string)) {
            this.error(cssParser$Term, "Unsupported <border-style> 'double'");
        } else if ("groove".equals(string)) {
            this.error(cssParser$Term, "Unsupported <border-style> 'groove'");
        } else if ("ridge".equals(string)) {
            this.error(cssParser$Term, "Unsupported <border-style> 'ridge'");
        } else if ("inset".equals(string)) {
            this.error(cssParser$Term, "Unsupported <border-style> 'inset'");
        } else if ("outset".equals(string)) {
            this.error(cssParser$Term, "Unsupported <border-style> 'outset'");
        } else {
            this.error(cssParser$Term, "Unsupported <border-style> '" + string + "'");
        }
        return BorderStyleConverter.SOLID;
    }

    private ParsedValueImpl<ParsedValue[], Number[]> segments(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        Object object;
        Object object2 = object = cssParser$Term.token != null ? cssParser$Term.token.getText() : null;
        if (!"segments".regionMatches(true, 0, (String)object, 0, 8)) {
            this.error(cssParser$Term, "Expected 'segments'");
        }
        if ((object = cssParser$Term.firstArg) == null) {
            this.error(null, "Expected '<size>'");
        }
        int n2 = this.numberOfArgs(cssParser$Term);
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        int n3 = 0;
        while (object != null) {
            parsedValueImplArray[n3++] = this.parseSize((CssParser$Term)object);
            object = ((CssParser$Term)object).nextArg;
        }
        return new ParsedValueImpl<ParsedValue[], Number[]>(parsedValueImplArray, SizeConverter$SequenceConverter.getInstance());
    }

    private ParsedValueImpl<String, StrokeType> parseStrokeType(CssParser$Term object) {
        if ("centered".equals(object = this.getKeyword((CssParser$Term)object)) || "inside".equals(object) || "outside".equals(object)) {
            return new ParsedValueImpl(object, new EnumConverter<StrokeType>(StrokeType.class));
        }
        return null;
    }

    private ParsedValueImpl[] parseStrokeLineJoin(CssParser$Term object) throws CssParser$ParseException {
        Object object2 = this.getKeyword((CssParser$Term)object);
        if ("miter".equals(object2) || "bevel".equals(object2) || "round".equals(object2)) {
            ParsedValueImpl parsedValueImpl = new ParsedValueImpl((String)object2, new EnumConverter<StrokeLineJoin>(StrokeLineJoin.class));
            ParsedValueImpl parsedValueImpl2 = null;
            if ("miter".equals(object2) && (object2 = ((CssParser$Term)object).nextInSeries) != null && ((CssParser$Term)object2).token != null && this.isSize(((CssParser$Term)object2).token)) {
                ((CssParser$Term)object).nextInSeries = ((CssParser$Term)object2).nextInSeries;
                object = this.parseSize((CssParser$Term)object2);
                parsedValueImpl2 = new ParsedValueImpl((ParsedValue<?, Size>)object, SizeConverter.getInstance());
            }
            return new ParsedValueImpl[]{parsedValueImpl, parsedValueImpl2};
        }
        return null;
    }

    private ParsedValueImpl<String, StrokeLineCap> parseStrokeLineCap(CssParser$Term object) {
        if ("square".equals(object = this.getKeyword((CssParser$Term)object)) || "butt".equals(object) || "round".equals(object)) {
            return new ParsedValueImpl(object, new EnumConverter<StrokeLineCap>(StrokeLineCap.class));
        }
        return null;
    }

    private ParsedValueImpl<ParsedValue[], BorderImageSlices> parseBorderImageSlice(CssParser$Term object) throws CssParser$ParseException {
        if (object.token == null || !this.isSize(object.token)) {
            this.error((CssParser$Term)object, "Expected '<size>'");
        }
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[4];
        Boolean bl2 = Boolean.FALSE;
        int n2 = 0;
        while (n2 < 4 && object != null) {
            parsedValueImplArray[n2++] = this.parseSize((CssParser$Term)object);
            object = object.nextInSeries;
            if (object == null || object.token == null || object.token.getType() != 11 || !"fill".equalsIgnoreCase(object.token.getText())) continue;
            bl2 = Boolean.TRUE;
            break;
        }
        if (n2 < 2) {
            parsedValueImplArray[1] = parsedValueImplArray[0];
        }
        if (n2 < 3) {
            parsedValueImplArray[2] = parsedValueImplArray[0];
        }
        if (n2 < 4) {
            parsedValueImplArray[3] = parsedValueImplArray[1];
        }
        object = new ParsedValueImpl[]{new ParsedValueImpl<ParsedValue[], Insets>(parsedValueImplArray, InsetsConverter.getInstance()), new ParsedValueImpl(bl2, null)};
        return new ParsedValueImpl<ParsedValue[], BorderImageSlices>((ParsedValue[])object, BorderImageSliceConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], BorderImageSlices>[], BorderImageSlices[]> parseBorderImageSliceLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        int n3 = 0;
        while (cssParser$Term != null) {
            parsedValueImplArray[n3++] = this.parseBorderImageSlice(cssParser$Term);
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], BorderImageSlices>[], BorderImageSlices[]>(parsedValueImplArray, SliceSequenceConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], BorderWidths> parseBorderImageWidth(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        if (cssParser$Term.token == null || !this.isSize(cssParser$Term.token)) {
            this.error(cssParser$Term, "Expected '<size>'");
        }
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[4];
        int n2 = 0;
        while (n2 < 4 && cssParser$Term != null) {
            parsedValueImplArray[n2++] = this.parseSize(cssParser$Term);
            cssParser$Term = cssParser$Term.nextInSeries;
            if (cssParser$Term == null || cssParser$Term.token == null || cssParser$Term.token.getType() != 11) continue;
        }
        if (n2 < 2) {
            parsedValueImplArray[1] = parsedValueImplArray[0];
        }
        if (n2 < 3) {
            parsedValueImplArray[2] = parsedValueImplArray[0];
        }
        if (n2 < 4) {
            parsedValueImplArray[3] = parsedValueImplArray[1];
        }
        return new ParsedValueImpl<ParsedValue[], BorderWidths>(parsedValueImplArray, BorderImageWidthConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], BorderWidths>[], BorderWidths[]> parseBorderImageWidthLayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        int n3 = 0;
        while (cssParser$Term != null) {
            parsedValueImplArray[n3++] = this.parseBorderImageWidth(cssParser$Term);
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], BorderWidths>[], BorderWidths[]>(parsedValueImplArray, BorderImageWidthsSequenceConverter.getInstance());
    }

    private ParsedValueImpl<String, String> parseRegion(CssParser$Term object) throws CssParser$ParseException {
        Object object2;
        Object object3 = object2 = ((CssParser$Term)object).token != null ? ((CssParser$Term)object).token.getText() : null;
        if (!"region".regionMatches(true, 0, (String)object2, 0, 6)) {
            this.error((CssParser$Term)object, "Expected 'region'");
        }
        if ((object2 = ((CssParser$Term)object).firstArg) == null) {
            this.error((CssParser$Term)object, "Expected 'region(\"<styleclass-or-id-string>\")'");
        }
        if (((CssParser$Term)object2).token == null || ((CssParser$Term)object2).token.getType() != 10 || ((CssParser$Term)object2).token.getText() == null || ((CssParser$Term)object2).token.getText().isEmpty()) {
            this.error((CssParser$Term)object, "Expected 'region(\"<styleclass-or-id-string>\")'");
        }
        object = SPECIAL_REGION_URL_PREFIX + Utils.stripQuotes(((CssParser$Term)object2).token.getText());
        return new ParsedValueImpl<String, String>((String)object, StringConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], String> parseURI(CssParser$Term parsedValueImplArray) throws CssParser$ParseException {
        if (parsedValueImplArray == null) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'url(\"<uri-string>\")'");
        }
        if (parsedValueImplArray.token == null || parsedValueImplArray.token.getType() != 43 || parsedValueImplArray.token.getText() == null || parsedValueImplArray.token.getText().isEmpty()) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected 'url(\"<uri-string>\")'");
        }
        parsedValueImplArray = parsedValueImplArray.token.getText();
        parsedValueImplArray = new ParsedValueImpl[]{new ParsedValueImpl<String, String>((String)parsedValueImplArray, StringConverter.getInstance()), null};
        return new ParsedValueImpl<ParsedValue[], String>(parsedValueImplArray, URLConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], String>[], String[]> parseURILayers(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        int n2 = this.numberOfLayers(cssParser$Term);
        int n3 = 0;
        ParsedValueImpl[] parsedValueImplArray = new ParsedValueImpl[n2];
        while (cssParser$Term != null) {
            parsedValueImplArray[n3++] = this.parseURI(cssParser$Term);
            cssParser$Term = this.nextLayer(cssParser$Term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], String>[], String[]>(parsedValueImplArray, URLConverter$SequenceConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<?, Size>, Number> parseFontSize(CssParser$Term object) throws CssParser$ParseException {
        Object object2;
        if (object == null) {
            return null;
        }
        Token token = ((CssParser$Term)object).token;
        if (token == null || !this.isSize(token)) {
            this.error((CssParser$Term)object, "Expected '<font-size>'");
        }
        object = null;
        if (token.getType() == 11) {
            object2 = token.getText().toLowerCase(Locale.ROOT);
            double d2 = -1.0;
            if ("inherit".equals(object2)) {
                d2 = 100.0;
            } else if ("xx-small".equals(object2)) {
                d2 = 60.0;
            } else if ("x-small".equals(object2)) {
                d2 = 75.0;
            } else if ("small".equals(object2)) {
                d2 = 80.0;
            } else if ("medium".equals(object2)) {
                d2 = 100.0;
            } else if ("large".equals(object2)) {
                d2 = 120.0;
            } else if ("x-large".equals(object2)) {
                d2 = 150.0;
            } else if ("xx-large".equals(object2)) {
                d2 = 200.0;
            } else if ("smaller".equals(object2)) {
                d2 = 80.0;
            } else if ("larger".equals(object2)) {
                d2 = 120.0;
            }
            if (d2 > -1.0) {
                object = new Size(d2, SizeUnits.PERCENT);
            }
        }
        if (object == null) {
            object = this.size(token);
        }
        object2 = new ParsedValueImpl((CssParser$Term)object, null);
        return new ParsedValueImpl(object2, FontConverter$FontSizeConverter.getInstance());
    }

    private ParsedValueImpl<String, FontPosture> parseFontStyle(CssParser$Term object) throws CssParser$ParseException {
        if (object == null) {
            return null;
        }
        Token token = ((CssParser$Term)object).token;
        if (token == null || token.getType() != 11 || token.getText() == null || token.getText().isEmpty()) {
            this.error((CssParser$Term)object, "Expected '<font-style>'");
        }
        object = token.getText().toLowerCase(Locale.ROOT);
        FontPosture.REGULAR.name();
        if ("normal".equals(object)) {
            object = FontPosture.REGULAR.name();
        } else if ("italic".equals(object)) {
            object = FontPosture.ITALIC.name();
        } else if ("oblique".equals(object)) {
            object = FontPosture.ITALIC.name();
        } else if ("inherit".equals(object)) {
            object = "inherit";
        } else {
            return null;
        }
        return new ParsedValueImpl<String, FontPosture>((String)object, FontConverter$FontStyleConverter.getInstance());
    }

    private ParsedValueImpl<String, FontWeight> parseFontWeight(CssParser$Term cssParser$Term) throws CssParser$ParseException {
        if (cssParser$Term == null) {
            return null;
        }
        Object object = cssParser$Term.token;
        if (object == null || ((Token)object).getText() == null || ((Token)object).getText().isEmpty()) {
            this.error(cssParser$Term, "Expected '<font-weight>'");
        }
        object = ((Token)object).getText().toLowerCase(Locale.ROOT);
        String string = FontWeight.NORMAL.name();
        if ("inherit".equals(object)) {
            string = FontWeight.NORMAL.name();
        } else if ("normal".equals(object)) {
            string = FontWeight.NORMAL.name();
        } else if ("bold".equals(object)) {
            string = FontWeight.BOLD.name();
        } else if ("bolder".equals(object)) {
            string = FontWeight.BOLD.name();
        } else if ("lighter".equals(object)) {
            string = FontWeight.LIGHT.name();
        } else if ("100".equals(object)) {
            string = FontWeight.findByWeight(100).name();
        } else if ("200".equals(object)) {
            string = FontWeight.findByWeight(200).name();
        } else if ("300".equals(object)) {
            string = FontWeight.findByWeight(300).name();
        } else if ("400".equals(object)) {
            string = FontWeight.findByWeight(400).name();
        } else if ("500".equals(object)) {
            string = FontWeight.findByWeight(500).name();
        } else if ("600".equals(object)) {
            string = FontWeight.findByWeight(600).name();
        } else if ("700".equals(object)) {
            string = FontWeight.findByWeight(700).name();
        } else if ("800".equals(object)) {
            string = FontWeight.findByWeight(800).name();
        } else if ("900".equals(object)) {
            string = FontWeight.findByWeight(900).name();
        } else {
            this.error(cssParser$Term, "Expected '<font-weight>'");
        }
        return new ParsedValueImpl<String, FontWeight>(string, FontConverter$FontWeightConverter.getInstance());
    }

    private ParsedValueImpl<String, String> parseFontFamily(CssParser$Term object) throws CssParser$ParseException {
        if (object == null) {
            return null;
        }
        Token token = ((CssParser$Term)object).token;
        String string = null;
        if (token == null || token.getType() != 11 && token.getType() != 10 || (string = token.getText()) == null || string.isEmpty()) {
            this.error((CssParser$Term)object, "Expected '<font-family>'");
        }
        if ("inherit".equals(object = this.stripQuotes(string.toLowerCase(Locale.ROOT)))) {
            return new ParsedValueImpl<String, String>("inherit", StringConverter.getInstance());
        }
        if ("serif".equals(object) || "sans-serif".equals(object) || "cursive".equals(object) || "fantasy".equals(object) || "monospace".equals(object)) {
            return new ParsedValueImpl<String, String>((String)object, StringConverter.getInstance());
        }
        return new ParsedValueImpl<String, String>(token.getText(), StringConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Font> parseFont(CssParser$Term parsedValueImplArray) throws CssParser$ParseException {
        Object object;
        Object object2;
        Object object3 = parsedValueImplArray.nextInSeries;
        parsedValueImplArray.nextInSeries = null;
        while (object3 != null) {
            object2 = ((CssParser$Term)object3).nextInSeries;
            ((CssParser$Term)object3).nextInSeries = parsedValueImplArray;
            parsedValueImplArray = object3;
            object3 = object2;
        }
        object2 = parsedValueImplArray.token;
        int n2 = ((Token)object2).getType();
        if (n2 != 11 && n2 != 10) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '<font-family>'");
        }
        ParsedValueImpl<String, String> parsedValueImpl = this.parseFontFamily((CssParser$Term)parsedValueImplArray);
        object2 = parsedValueImplArray;
        object2 = ((CssParser$Term)object2).nextInSeries;
        if (object2 == null) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '<size>'");
        }
        if (((CssParser$Term)object2).token == null || !this.isSize(((CssParser$Term)object2).token)) {
            this.error((CssParser$Term)object2, "Expected '<size>'");
        }
        if ((object = ((CssParser$Term)object2).nextInSeries) != null && ((CssParser$Term)object).token != null && ((CssParser$Term)object).token.getType() == 32) {
            parsedValueImplArray = object;
            object2 = ((CssParser$Term)object).nextInSeries;
            if (object2 == null) {
                this.error((CssParser$Term)parsedValueImplArray, "Expected '<size>'");
            }
            if (((CssParser$Term)object2).token == null || !this.isSize(((CssParser$Term)object2).token)) {
                this.error((CssParser$Term)object2, "Expected '<size>'");
            }
            Token cfr_ignored_0 = ((CssParser$Term)object2).token;
        }
        if ((object = this.parseFontSize((CssParser$Term)object2)) == null) {
            this.error((CssParser$Term)parsedValueImplArray, "Expected '<size>'");
        }
        parsedValueImplArray = null;
        ParsedValueImpl<String, FontWeight> parsedValueImpl2 = null;
        String string = null;
        while ((object2 = ((CssParser$Term)object2).nextInSeries) != null) {
            if (((CssParser$Term)object2).token == null || ((CssParser$Term)object2).token.getType() != 11 || ((CssParser$Term)object2).token.getText() == null || ((CssParser$Term)object2).token.getText().isEmpty()) {
                this.error((CssParser$Term)object2, "Expected '<font-weight>', '<font-style>' or '<font-variant>'");
            }
            if (parsedValueImplArray == null && (parsedValueImplArray = this.parseFontStyle((CssParser$Term)object2)) != null) continue;
            if (string == null && "small-caps".equalsIgnoreCase(((CssParser$Term)object2).token.getText())) {
                string = ((CssParser$Term)object2).token.getText();
                continue;
            }
            if (parsedValueImpl2 != null || (parsedValueImpl2 = this.parseFontWeight((CssParser$Term)object2)) == null) continue;
        }
        parsedValueImplArray = new ParsedValueImpl[]{parsedValueImpl, object, parsedValueImpl2, parsedValueImplArray};
        return new ParsedValueImpl<ParsedValue[], Font>(parsedValueImplArray, FontConverter.getInstance());
    }

    private Token nextToken(CssLexer cssLexer) {
        Token token;
        while ((token = cssLexer.nextToken()) != null && token.getType() == 40 || token.getType() == 41) {
        }
        if (LOGGER.isLoggable(PlatformLogger$Level.FINEST)) {
            LOGGER.finest(token.toString());
        }
        return token;
    }

    private void parse(Stylesheet object, CssLexer cssLexer) {
        List<Declaration> list;
        List<Selector> list2;
        this.currentToken = this.nextToken(cssLexer);
        while (this.currentToken != null && this.currentToken.getType() == 47) {
            this.currentToken = this.nextToken(cssLexer);
            if (this.currentToken == null || this.currentToken.getType() != 11) {
                list2 = new CssParser$ParseException("Expected IDENT", this.currentToken, this);
                list = ((CssParser$ParseException)((Object)list2)).toString();
                list2 = this.createError((String)((Object)list));
                if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                    LOGGER.warning(((CssParser$ParseError)((Object)list2)).toString());
                }
                this.reportError((CssParser$ParseError)((Object)list2));
                do {
                    this.currentToken = cssLexer.nextToken();
                } while (this.currentToken != null && this.currentToken.getType() == 30 || this.currentToken.getType() == 40 || this.currentToken.getType() == 41);
                continue;
            }
            list2 = this.currentToken.getText().toLowerCase(Locale.ROOT);
            if ("font-face".equals(list2)) {
                list = this.fontFace(cssLexer);
                if (list != null) {
                    ((Stylesheet)object).getFontFaces().add((FontFace)((Object)list));
                }
                this.currentToken = this.nextToken(cssLexer);
                continue;
            }
            if (!"import".equals(list2)) continue;
            if (imports == null) {
                imports = new Stack();
            }
            if (!imports.contains(this.sourceOfStylesheet)) {
                imports.push(this.sourceOfStylesheet);
                list = this.handleImport(cssLexer);
                if (list != null) {
                    ((Stylesheet)object).importStylesheet((Stylesheet)((Object)list));
                }
                imports.pop();
                if (imports.isEmpty()) {
                    imports = null;
                }
            } else {
                int n2 = this.currentToken.getLine();
                int n3 = this.currentToken.getOffset();
                list = MessageFormat.format("Recursive @import at {2} [{0,number,#},{1,number,#}]", n2, n3, imports.peek());
                list2 = this.createError((String)((Object)list));
                if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                    LOGGER.warning(((CssParser$ParseError)((Object)list2)).toString());
                }
                this.reportError((CssParser$ParseError)((Object)list2));
            }
            do {
                this.currentToken = cssLexer.nextToken();
            } while (this.currentToken != null && this.currentToken.getType() == 30 || this.currentToken.getType() == 40 || this.currentToken.getType() == 41);
        }
        while (this.currentToken != null && this.currentToken.getType() != -1) {
            list2 = this.selectors(cssLexer);
            if (list2 == null) {
                return;
            }
            if (this.currentToken == null || this.currentToken.getType() != 28) {
                int n4 = this.currentToken != null ? this.currentToken.getLine() : -1;
                int n5 = this.currentToken != null ? this.currentToken.getOffset() : -1;
                String string = MessageFormat.format("Expected LBRACE at [{0,number,#},{1,number,#}]", n4, n5);
                CssParser$ParseError cssParser$ParseError = this.createError(string);
                if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                    LOGGER.warning(cssParser$ParseError.toString());
                }
                this.reportError(cssParser$ParseError);
                this.currentToken = null;
                return;
            }
            this.currentToken = this.nextToken(cssLexer);
            list = this.declarations(cssLexer);
            if (list == null) {
                return;
            }
            if (this.currentToken != null && this.currentToken.getType() != 29) {
                int n6 = this.currentToken.getLine();
                int n7 = this.currentToken.getOffset();
                String string = MessageFormat.format("Expected RBRACE at [{0,number,#},{1,number,#}]", n6, n7);
                object = this.createError(string);
                if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                    LOGGER.warning(((CssParser$ParseError)object).toString());
                }
                this.reportError((CssParser$ParseError)object);
                this.currentToken = null;
                return;
            }
            ((Stylesheet)object).getRules().add(new Rule(list2, list));
            this.currentToken = this.nextToken(cssLexer);
        }
        this.currentToken = null;
    }

    private FontFace fontFace(CssLexer cssLexer) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<FontFaceImpl$FontFaceSrc> arrayList = new ArrayList<FontFaceImpl$FontFaceSrc>();
        do {
            this.currentToken = this.nextToken(cssLexer);
            if (this.currentToken.getType() != 11) continue;
            Object object = this.currentToken.getText();
            this.currentToken = this.nextToken(cssLexer);
            this.currentToken = this.nextToken(cssLexer);
            if ("src".equalsIgnoreCase((String)object)) {
                while (this.currentToken != null && this.currentToken.getType() != 30 && this.currentToken.getType() != 29 && this.currentToken.getType() != -1) {
                    if (this.currentToken.getType() == 11) {
                        arrayList.add(new FontFaceImpl$FontFaceSrc(FontFaceImpl$FontFaceSrcType.REFERENCE, this.currentToken.getText()));
                    } else if (this.currentToken.getType() == 43) {
                        int n2;
                        Object object2 = new ParsedValueImpl[]{new ParsedValueImpl<String, String>(this.currentToken.getText(), StringConverter.getInstance()), new ParsedValueImpl(this.sourceOfStylesheet, null)};
                        object = new ParsedValueImpl<ParsedValue[], String>((ParsedValue[])object2, URLConverter.getInstance());
                        String string = (String)((ParsedValue)object).convert(null);
                        object = null;
                        try {
                            object2 = new URI(string);
                            object = object2.toURL();
                        }
                        catch (MalformedURLException | URISyntaxException exception) {
                            n2 = this.currentToken.getLine();
                            int n3 = this.currentToken.getOffset();
                            Object object3 = MessageFormat.format("Could not resolve @font-face url [{2}] at [{0,number,#},{1,number,#}]", n2, n3, string);
                            object3 = this.createError((String)object3);
                            if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                                LOGGER.warning(((CssParser$ParseError)object3).toString());
                            }
                            this.reportError((CssParser$ParseError)object3);
                            while (this.currentToken != null) {
                                int n4 = this.currentToken.getType();
                                if (n4 == 29 || n4 == -1) {
                                    return null;
                                }
                                this.currentToken = this.nextToken(cssLexer);
                            }
                        }
                        String string2 = null;
                        while (true) {
                            this.currentToken = this.nextToken(cssLexer);
                            n2 = this.currentToken != null ? this.currentToken.getType() : -1;
                            if (n2 == 12) {
                                if (!"format(".equalsIgnoreCase(this.currentToken.getText())) break;
                                continue;
                            }
                            if (n2 == 11 || n2 == 10) {
                                string2 = Utils.stripQuotes(this.currentToken.getText());
                                continue;
                            }
                            if (n2 != 35) break;
                        }
                        arrayList.add(new FontFaceImpl$FontFaceSrc(FontFaceImpl$FontFaceSrcType.URL, ((URL)object).toExternalForm(), string2));
                    } else if (this.currentToken.getType() == 12) {
                        if ("local(".equalsIgnoreCase(this.currentToken.getText())) {
                            this.currentToken = this.nextToken(cssLexer);
                            StringBuilder stringBuilder = new StringBuilder();
                            while (this.currentToken != null && this.currentToken.getType() != 35 && this.currentToken.getType() != -1) {
                                stringBuilder.append(this.currentToken.getText());
                                this.currentToken = this.nextToken(cssLexer);
                            }
                            int n5 = 0;
                            int n6 = stringBuilder.length();
                            if (stringBuilder.charAt(0) == '\'' || stringBuilder.charAt(0) == '\"') {
                                ++n5;
                            }
                            if (stringBuilder.charAt(n6 - 1) == '\'' || stringBuilder.charAt(n6 - 1) == '\"') {
                                --n6;
                            }
                            object = stringBuilder.substring(n5, n6);
                            arrayList.add(new FontFaceImpl$FontFaceSrc(FontFaceImpl$FontFaceSrcType.LOCAL, (String)object));
                        } else {
                            int n7 = this.currentToken.getLine();
                            int n8 = this.currentToken.getOffset();
                            String string = MessageFormat.format("Unknown @font-face src type [" + this.currentToken.getText() + ")] at [{0,number,#},{1,number,#}]", n7, n8);
                            object = this.createError(string);
                            if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                                LOGGER.warning(((CssParser$ParseError)object).toString());
                            }
                            this.reportError((CssParser$ParseError)object);
                        }
                    } else if (this.currentToken.getType() != 36) {
                        int n9 = this.currentToken.getLine();
                        int n10 = this.currentToken.getOffset();
                        String string = MessageFormat.format("Unexpected TOKEN [" + this.currentToken.getText() + "] at [{0,number,#},{1,number,#}]", n9, n10);
                        object = this.createError(string);
                        if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                            LOGGER.warning(((CssParser$ParseError)object).toString());
                        }
                        this.reportError((CssParser$ParseError)object);
                    }
                    this.currentToken = this.nextToken(cssLexer);
                }
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (this.currentToken != null && this.currentToken.getType() != 30 && this.currentToken.getType() != -1) {
                stringBuilder.append(this.currentToken.getText());
                this.currentToken = this.nextToken(cssLexer);
            }
            hashMap.put((String)object, stringBuilder.toString());
        } while (this.currentToken != null && this.currentToken.getType() != 29 && this.currentToken.getType() != -1);
        return new FontFaceImpl(hashMap, arrayList);
    }

    private Stylesheet handleImport(CssLexer cssLexer) {
        Object object;
        this.currentToken = this.nextToken(cssLexer);
        if (this.currentToken == null || this.currentToken.getType() == -1) {
            return null;
        }
        int n2 = this.currentToken.getType();
        String string = null;
        if (n2 == 10 || n2 == 43) {
            string = this.currentToken.getText();
        }
        Object object2 = null;
        String string2 = this.sourceOfStylesheet;
        if (string != null) {
            object = new ParsedValueImpl[]{new ParsedValueImpl<String, String>(string, StringConverter.getInstance()), new ParsedValueImpl(this.sourceOfStylesheet, null)};
            object = new ParsedValueImpl<ParsedValue[], String>((ParsedValue[])object, URLConverter.getInstance());
            object2 = (String)object.convert(null);
            object2 = StyleManager.loadStylesheet((String)object2);
            this.sourceOfStylesheet = string2;
        }
        if (object2 == null) {
            object = MessageFormat.format("Could not import {0}", string);
            object = this.createError((String)object);
            if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                LOGGER.warning(object.toString());
            }
            this.reportError((CssParser$ParseError)object);
        }
        return object2;
    }

    private List<Selector> selectors(CssLexer cssLexer) {
        ArrayList<Selector> arrayList = new ArrayList<Selector>();
        while (true) {
            Selector selector;
            if ((selector = this.selector(cssLexer)) == null) {
                while (this.currentToken != null && this.currentToken.getType() != 29 && this.currentToken.getType() != -1) {
                    this.currentToken = this.nextToken(cssLexer);
                }
                this.currentToken = this.nextToken(cssLexer);
                if (this.currentToken != null && this.currentToken.getType() != -1) continue;
                this.currentToken = null;
                return null;
            }
            arrayList.add(selector);
            if (this.currentToken == null || this.currentToken.getType() != 36) break;
            this.currentToken = this.nextToken(cssLexer);
        }
        return arrayList;
    }

    private Selector selector(CssLexer cssLexer) {
        Object object;
        ArrayList<Combinator> arrayList = null;
        ArrayList<SimpleSelector> arrayList2 = null;
        SimpleSelector simpleSelector = this.simpleSelector(cssLexer);
        if (simpleSelector == null) {
            return null;
        }
        while ((object = this.combinator(cssLexer)) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<Combinator>();
            }
            arrayList.add((Combinator)((Object)object));
            object = this.simpleSelector(cssLexer);
            if (object == null) {
                return null;
            }
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<SimpleSelector>();
                arrayList2.add(simpleSelector);
            }
            arrayList2.add((SimpleSelector)object);
        }
        if (this.currentToken != null && this.currentToken.getType() == 41) {
            this.currentToken = this.nextToken(cssLexer);
        }
        if (arrayList2 == null) {
            return simpleSelector;
        }
        return new CompoundSelector(arrayList2, arrayList);
    }

    private SimpleSelector simpleSelector(CssLexer cssLexer) {
        String string = "*";
        String string2 = "";
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        while (true) {
            int n2 = this.currentToken != null ? this.currentToken.getType() : 0;
            switch (n2) {
                case 11: 
                case 33: {
                    string = this.currentToken.getText();
                    break;
                }
                case 38: {
                    this.currentToken = this.nextToken(cssLexer);
                    if (this.currentToken != null && this.currentToken.getType() == 11) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(this.currentToken.getText());
                        break;
                    }
                    this.currentToken = Token.INVALID_TOKEN;
                    return null;
                }
                case 37: {
                    string2 = this.currentToken.getText().substring(1);
                    break;
                }
                case 31: {
                    this.currentToken = this.nextToken(cssLexer);
                    if (this.currentToken != null && arrayList2 == null) {
                        arrayList2 = new ArrayList<String>();
                    }
                    if (this.currentToken.getType() == 11) {
                        arrayList2.add(this.currentToken.getText());
                    } else if (this.currentToken.getType() == 12) {
                        String string3 = this.functionalPseudo(cssLexer);
                        arrayList2.add(string3);
                    } else {
                        this.currentToken = Token.INVALID_TOKEN;
                    }
                    if (this.currentToken.getType() != 0) break;
                    return null;
                }
                case -1: 
                case 27: 
                case 28: 
                case 36: 
                case 40: 
                case 41: {
                    return new SimpleSelector(string, arrayList, arrayList2, string2);
                }
                default: {
                    return null;
                }
            }
            this.currentToken = cssLexer.nextToken();
            if (!LOGGER.isLoggable(PlatformLogger$Level.FINEST)) continue;
            LOGGER.finest(this.currentToken.toString());
        }
    }

    private String functionalPseudo(CssLexer cssLexer) {
        StringBuilder stringBuilder = new StringBuilder(this.currentToken.getText());
        block4: while (true) {
            this.currentToken = this.nextToken(cssLexer);
            switch (this.currentToken.getType()) {
                case 10: 
                case 11: {
                    stringBuilder.append(this.currentToken.getText());
                    continue block4;
                }
                case 35: {
                    stringBuilder.append(')');
                    return stringBuilder.toString();
                }
            }
            break;
        }
        this.currentToken = Token.INVALID_TOKEN;
        return null;
    }

    private Combinator combinator(CssLexer cssLexer) {
        Combinator combinator = null;
        while (true) {
            int n2 = this.currentToken != null ? this.currentToken.getType() : 0;
            switch (n2) {
                case 40: {
                    if (combinator != null || !" ".equals(this.currentToken.getText())) break;
                    combinator = Combinator.DESCENDANT;
                    break;
                }
                case 27: {
                    combinator = Combinator.CHILD;
                    break;
                }
                case 11: 
                case 31: 
                case 33: 
                case 37: 
                case 38: {
                    return combinator;
                }
                default: {
                    return null;
                }
            }
            this.currentToken = cssLexer.nextToken();
            if (!LOGGER.isLoggable(PlatformLogger$Level.FINEST)) continue;
            LOGGER.finest(this.currentToken.toString());
        }
    }

    private List<Declaration> declarations(CssLexer cssLexer) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        do {
            Declaration declaration;
            if ((declaration = this.declaration(cssLexer)) != null) {
                arrayList.add(declaration);
            } else {
                while (this.currentToken != null && this.currentToken.getType() != 30 && this.currentToken.getType() != 29 && this.currentToken.getType() != -1) {
                    this.currentToken = this.nextToken(cssLexer);
                }
                if (this.currentToken != null && this.currentToken.getType() != 30) {
                    return arrayList;
                }
            }
            while (this.currentToken != null && this.currentToken.getType() == 30) {
                this.currentToken = this.nextToken(cssLexer);
            }
        } while (this.currentToken != null && this.currentToken.getType() == 11);
        return arrayList;
    }

    private Declaration declaration(CssLexer object) {
        ParsedValueImpl parsedValueImpl;
        if (this.currentToken != null) {
            this.currentToken.getType();
        }
        if (this.currentToken == null || this.currentToken.getType() != 11) {
            return null;
        }
        String string = this.currentToken.getText();
        this.currentToken = this.nextToken((CssLexer)object);
        if (this.currentToken == null || this.currentToken.getType() != 31) {
            int n2 = this.currentToken.getLine();
            int n3 = this.currentToken.getOffset();
            String string2 = MessageFormat.format("Expected COLON at [{0,number,#},{1,number,#}]", n2, n3);
            object = this.createError(string2);
            if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                LOGGER.warning(((CssParser$ParseError)object).toString());
            }
            this.reportError((CssParser$ParseError)object);
            return null;
        }
        this.currentToken = this.nextToken((CssLexer)object);
        Object object2 = this.expr((CssLexer)object);
        try {
            parsedValueImpl = object2 != null ? this.valueFor(string, (CssParser$Term)object2, (CssLexer)object) : null;
        }
        catch (CssParser$ParseException cssParser$ParseException) {
            object2 = cssParser$ParseException;
            object = cssParser$ParseException.tok;
            int n4 = object != null ? ((Token)object).getLine() : -1;
            int n5 = object != null ? ((Token)object).getOffset() : -1;
            Object object3 = MessageFormat.format("{2} while parsing ''{3}'' at [{0,number,#},{1,number,#}]", n4, n5, ((Throwable)object2).getMessage(), string);
            object3 = this.createError((String)object3);
            if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                LOGGER.warning(((CssParser$ParseError)object3).toString());
            }
            this.reportError((CssParser$ParseError)object3);
            return null;
        }
        boolean bl2 = this.currentToken.getType() == 39;
        if (bl2) {
            this.currentToken = this.nextToken((CssLexer)object);
        }
        object = parsedValueImpl != null ? new Declaration(string.toLowerCase(Locale.ROOT), parsedValueImpl, bl2) : null;
        return object;
    }

    private CssParser$Term expr(CssLexer cssLexer) {
        CssParser$Term cssParser$Term;
        CssParser$Term cssParser$Term2 = cssParser$Term = this.term(cssLexer);
        while (true) {
            int n2;
            if ((n2 = cssParser$Term2 != null && this.currentToken != null ? this.currentToken.getType() : 0) == 0) {
                this.skipExpr(cssLexer);
                return null;
            }
            if (n2 == 30 || n2 == 39 || n2 == 29 || n2 == -1) {
                return cssParser$Term;
            }
            if (n2 == 36) {
                this.currentToken = this.nextToken(cssLexer);
                cssParser$Term2 = cssParser$Term2.nextLayer = this.term(cssLexer);
                continue;
            }
            cssParser$Term2 = cssParser$Term2.nextInSeries = this.term(cssLexer);
        }
    }

    private void skipExpr(CssLexer cssLexer) {
        int n2;
        do {
            this.currentToken = this.nextToken(cssLexer);
        } while ((n2 = this.currentToken != null ? this.currentToken.getType() : 0) != 30 && n2 != 29 && n2 != -1);
    }

    private CssParser$Term term(CssLexer cssLexer) {
        int n2 = this.currentToken != null ? this.currentToken.getType() : 0;
        switch (n2) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 45: 
            case 46: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 37: {
                break;
            }
            case 12: 
            case 34: {
                CssParser$Term cssParser$Term;
                CssParser$Term cssParser$Term2 = new CssParser$Term(this.currentToken);
                this.currentToken = this.nextToken(cssLexer);
                cssParser$Term2.firstArg = cssParser$Term = this.term(cssLexer);
                while (true) {
                    int n3;
                    if ((n3 = this.currentToken != null ? this.currentToken.getType() : 0) == 35) {
                        this.currentToken = this.nextToken(cssLexer);
                        return cssParser$Term2;
                    }
                    if (n3 == 36) {
                        this.currentToken = this.nextToken(cssLexer);
                        cssParser$Term = cssParser$Term.nextArg = this.term(cssLexer);
                        continue;
                    }
                    cssParser$Term = cssParser$Term.nextInSeries = this.term(cssLexer);
                }
            }
            case 43: {
                break;
            }
            case 32: {
                break;
            }
            default: {
                int n4 = this.currentToken != null ? this.currentToken.getLine() : -1;
                int n5 = this.currentToken != null ? this.currentToken.getOffset() : -1;
                String string = this.currentToken != null ? this.currentToken.getText() : "";
                Object object = MessageFormat.format("Unexpected token {0}{1}{0} at [{2,number,#},{3,number,#}]", "'", string, n4, n5);
                object = this.createError((String)object);
                if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                    LOGGER.warning(((CssParser$ParseError)object).toString());
                }
                this.reportError((CssParser$ParseError)object);
                return null;
            }
        }
        CssParser$Term cssParser$Term = new CssParser$Term(this.currentToken);
        this.currentToken = this.nextToken(cssLexer);
        return cssParser$Term;
    }

    public static ObservableList<CssParser$ParseError> errorsProperty() {
        return StyleManager.errorsProperty();
    }
}

