/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import javafx.css.SizeUnits;
import javafx.scene.text.Font;

public final class Size {
    private final double value;
    private final SizeUnits units;

    public Size(double d2, SizeUnits sizeUnits) {
        this.value = d2;
        this.units = sizeUnits != null ? sizeUnits : SizeUnits.PX;
    }

    public final double getValue() {
        return this.value;
    }

    public final SizeUnits getUnits() {
        return this.units;
    }

    public final boolean isAbsolute() {
        return this.units.isAbsolute();
    }

    final double points(Font font) {
        return this.points(1.0, font);
    }

    final double points(double d2, Font font) {
        return this.units.points(this.value, d2, font);
    }

    public final double pixels(double d2, Font font) {
        return this.units.pixels(this.value, d2, font);
    }

    public final double pixels(Font font) {
        return this.pixels(1.0, font);
    }

    final double pixels(double d2) {
        return this.pixels(d2, null);
    }

    public final double pixels() {
        return this.pixels(1.0, null);
    }

    public final String toString() {
        return Double.toString(this.value) + this.units.toString();
    }

    public final int hashCode() {
        long l2 = 629L + Double.doubleToLongBits(this.value);
        l2 = 37L * l2 + (long)this.units.hashCode();
        return (int)(l2 ^ l2 >> 32);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (Size)object;
        if (this.units != ((Size)object).units) {
            return false;
        }
        if (this.value == ((Size)object).value) {
            return true;
        }
        if (this.value > 0.0 ? ((Size)object).value > 0.0 : ((Size)object).value < 0.0) {
            if (this.value > 0.0) {
            }
            if (((Size)object).value > 0.0) {
                double cfr_ignored_0 = ((Size)object).value;
            } else {
                double cfr_ignored_1 = ((Size)object).value;
            }
            double d2 = this.value - ((Size)object).value;
            return !(d2 < -1.0E-6) && !(1.0E-6 < d2);
        }
        return false;
    }
}

