/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.SimpleStyleableStringProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory$SimpleCssMetaData;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Insets;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;
import javafx.util.Pair;

public class StyleablePropertyFactory<S extends Styleable> {
    private final Map<String, Pair<Class, CssMetaData<S, ?>>> metaDataMap;
    private final List<CssMetaData<? extends Styleable, ?>> unmodifiableMetaDataList;
    private final List<CssMetaData<? extends Styleable, ?>> metaDataList = new ArrayList();

    public StyleablePropertyFactory(List<CssMetaData<? extends Styleable, ?>> list) {
        this.unmodifiableMetaDataList = Collections.unmodifiableList(this.metaDataList);
        if (list != null) {
            this.metaDataList.addAll(list);
        }
        this.metaDataMap = new HashMap();
    }

    public final List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return this.unmodifiableMetaDataList;
    }

    public final StyleableProperty<Boolean> createStyleableBooleanProperty(S s2, String string, String object, Function<S, StyleableProperty<Boolean>> function, boolean bl2, boolean bl3) {
        object = this.createBooleanCssMetaData((String)object, function, bl2, bl3);
        return new SimpleStyleableBooleanProperty((CssMetaData<? extends Styleable, Boolean>)object, s2, string, bl2);
    }

    public final StyleableProperty<Boolean> createStyleableBooleanProperty(S s2, String string, String string2, Function<S, StyleableProperty<Boolean>> function, boolean bl2) {
        return this.createStyleableBooleanProperty(s2, string, string2, function, bl2, false);
    }

    public final StyleableProperty<Boolean> createStyleableBooleanProperty(S s2, String string, String string2, Function<S, StyleableProperty<Boolean>> function) {
        return this.createStyleableBooleanProperty(s2, string, string2, function, false, false);
    }

    public final StyleableProperty<Boolean> createStyleableBooleanProperty(S s2, String string, String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(Boolean.class, (String)object);
        return new SimpleStyleableBooleanProperty((CssMetaData<? extends Styleable, Boolean>)object, s2, string, (Boolean)((CssMetaData)object).getInitialValue(s2));
    }

    public final StyleableProperty<Color> createStyleableColorProperty(S s2, String string, String object, Function<S, StyleableProperty<Color>> function, Color color, boolean bl2) {
        object = this.createColorCssMetaData((String)object, function, color, bl2);
        return new SimpleStyleableObjectProperty<Color>((CssMetaData<Styleable, Color>)object, s2, string, color);
    }

    public final StyleableProperty<Color> createStyleableColorProperty(S s2, String string, String string2, Function<S, StyleableProperty<Color>> function, Color color) {
        return this.createStyleableColorProperty(s2, string, string2, function, color, false);
    }

    public final StyleableProperty<Color> createStyleableColorProperty(S s2, String string, String string2, Function<S, StyleableProperty<Color>> function) {
        return this.createStyleableColorProperty(s2, string, string2, function, Color.BLACK, false);
    }

    public final StyleableProperty<Color> createStyleableColorProperty(S s2, String string, String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(Color.class, (String)object);
        return new SimpleStyleableObjectProperty<Color>((CssMetaData<Styleable, Color>)object, s2, string, (Color)((CssMetaData)object).getInitialValue(s2));
    }

    public final StyleableProperty<Duration> createStyleableDurationProperty(S s2, String string, String object, Function<S, StyleableProperty<Duration>> function, Duration duration, boolean bl2) {
        object = this.createDurationCssMetaData((String)object, function, duration, bl2);
        return new SimpleStyleableObjectProperty<Duration>((CssMetaData<Styleable, Duration>)object, s2, string, duration);
    }

    public final StyleableProperty<Duration> createStyleableDurationProperty(S s2, String string, String string2, Function<S, StyleableProperty<Duration>> function, Duration duration) {
        return this.createStyleableDurationProperty(s2, string, string2, function, duration, false);
    }

    public final StyleableProperty<Duration> createStyleableDurationProperty(S s2, String string, String string2, Function<S, StyleableProperty<Duration>> function) {
        return this.createStyleableDurationProperty(s2, string, string2, function, Duration.UNKNOWN, false);
    }

    public final StyleableProperty<Duration> createStyleableDurationProperty(S s2, String string, String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(Duration.class, (String)object);
        return new SimpleStyleableObjectProperty<Duration>((CssMetaData<Styleable, Duration>)object, s2, string, (Duration)((CssMetaData)object).getInitialValue(s2));
    }

    public final <E extends Effect> StyleableProperty<E> createStyleableEffectProperty(S s2, String string, String object, Function<S, StyleableProperty<E>> function, E e2, boolean bl2) {
        object = this.createEffectCssMetaData((String)object, function, e2, bl2);
        return new SimpleStyleableObjectProperty<E>(object, s2, string, e2);
    }

    public final <E extends Effect> StyleableProperty<E> createStyleableEffectProperty(S s2, String string, String string2, Function<S, StyleableProperty<E>> function, E e2) {
        return this.createStyleableEffectProperty(s2, string, string2, function, e2, false);
    }

    public final <E extends Effect> StyleableProperty<E> createStyleableEffectProperty(S s2, String string, String string2, Function<S, StyleableProperty<E>> function) {
        return this.createStyleableEffectProperty(s2, string, string2, function, null, false);
    }

    public final StyleableProperty<Effect> createStyleableEffectProperty(S s2, String string, String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(Effect.class, (String)object);
        return new SimpleStyleableObjectProperty<Effect>((CssMetaData<Styleable, Effect>)object, s2, string, (Effect)((CssMetaData)object).getInitialValue(s2));
    }

    public final <E extends Enum<E>> StyleableProperty<E> createStyleableEnumProperty(S s2, String string, String object, Function<S, StyleableProperty<E>> function, Class<E> clazz, E e2, boolean bl2) {
        object = this.createEnumCssMetaData(clazz, (String)object, function, e2, bl2);
        return new SimpleStyleableObjectProperty<E>(object, s2, string, e2);
    }

    public final <E extends Enum<E>> StyleableProperty<E> createStyleableEnumProperty(S s2, String string, String string2, Function<S, StyleableProperty<E>> function, Class<E> clazz, E e2) {
        return this.createStyleableEnumProperty(s2, string, string2, function, clazz, e2, false);
    }

    public final <E extends Enum<E>> StyleableProperty<E> createStyleableEnumProperty(S s2, String string, String string2, Function<S, StyleableProperty<E>> function, Class<E> clazz) {
        return this.createStyleableEnumProperty(s2, string, string2, function, clazz, null, false);
    }

    public final <E extends Enum<E>> StyleableProperty<E> createStyleableEffectProperty(S s2, String string, String object, Class<E> clazz) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(clazz, (String)object);
        return new SimpleStyleableObjectProperty<Enum>((CssMetaData<Styleable, Enum>)object, s2, string, (Enum)((CssMetaData)object).getInitialValue(s2));
    }

    public final StyleableProperty<Font> createStyleableFontProperty(S s2, String string, String object, Function<S, StyleableProperty<Font>> function, Font font, boolean bl2) {
        object = this.createFontCssMetaData((String)object, function, font, bl2);
        return new SimpleStyleableObjectProperty<Font>((CssMetaData<Styleable, Font>)object, s2, string, font);
    }

    public final StyleableProperty<Font> createStyleableFontProperty(S s2, String string, String string2, Function<S, StyleableProperty<Font>> function, Font font) {
        return this.createStyleableFontProperty(s2, string, string2, function, font, true);
    }

    public final StyleableProperty<Font> createStyleableFontProperty(S s2, String string, String string2, Function<S, StyleableProperty<Font>> function) {
        return this.createStyleableFontProperty(s2, string, string2, function, Font.getDefault(), true);
    }

    public final StyleableProperty<Font> createStyleableFontProperty(S s2, String string, String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(Font.class, (String)object);
        return new SimpleStyleableObjectProperty<Font>((CssMetaData<Styleable, Font>)object, s2, string, (Font)((CssMetaData)object).getInitialValue(s2));
    }

    public final StyleableProperty<Insets> createStyleableInsetsProperty(S s2, String string, String object, Function<S, StyleableProperty<Insets>> function, Insets insets, boolean bl2) {
        object = this.createInsetsCssMetaData((String)object, function, insets, bl2);
        return new SimpleStyleableObjectProperty<Insets>((CssMetaData<Styleable, Insets>)object, s2, string, insets);
    }

    public final StyleableProperty<Insets> createStyleableInsetsProperty(S s2, String string, String string2, Function<S, StyleableProperty<Insets>> function, Insets insets) {
        return this.createStyleableInsetsProperty(s2, string, string2, function, insets, false);
    }

    public final StyleableProperty<Insets> createStyleableInsetsProperty(S s2, String string, String string2, Function<S, StyleableProperty<Insets>> function) {
        return this.createStyleableInsetsProperty(s2, string, string2, function, Insets.EMPTY, false);
    }

    public final StyleableProperty<Insets> createStyleableInsetsProperty(S s2, String string, String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(Insets.class, (String)object);
        return new SimpleStyleableObjectProperty<Insets>((CssMetaData<Styleable, Insets>)object, s2, string, (Insets)((CssMetaData)object).getInitialValue(s2));
    }

    public final StyleableProperty<Paint> createStyleablePaintProperty(S s2, String string, String object, Function<S, StyleableProperty<Paint>> function, Paint paint, boolean bl2) {
        object = this.createPaintCssMetaData((String)object, function, paint, bl2);
        return new SimpleStyleableObjectProperty<Paint>((CssMetaData<Styleable, Paint>)object, s2, string, paint);
    }

    public final StyleableProperty<Paint> createStyleablePaintProperty(S s2, String string, String string2, Function<S, StyleableProperty<Paint>> function, Paint paint) {
        return this.createStyleablePaintProperty(s2, string, string2, function, paint, false);
    }

    public final StyleableProperty<Paint> createStyleablePaintProperty(S s2, String string, String string2, Function<S, StyleableProperty<Paint>> function) {
        return this.createStyleablePaintProperty(s2, string, string2, function, Color.BLACK, false);
    }

    public final StyleableProperty<Paint> createStyleablePaintProperty(S s2, String string, String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(Paint.class, (String)object);
        return new SimpleStyleableObjectProperty<Paint>((CssMetaData<Styleable, Paint>)object, s2, string, (Paint)((CssMetaData)object).getInitialValue(s2));
    }

    public final StyleableProperty<Number> createStyleableNumberProperty(S s2, String string, String object, Function<S, StyleableProperty<Number>> function, Number number, boolean bl2) {
        object = this.createSizeCssMetaData((String)object, function, number, bl2);
        return new SimpleStyleableObjectProperty<Number>((CssMetaData<Styleable, Number>)object, s2, string, number);
    }

    public final StyleableProperty<Number> createStyleableNumberProperty(S s2, String string, String string2, Function<S, StyleableProperty<Number>> function, Number number) {
        return this.createStyleableNumberProperty(s2, string, string2, function, number, false);
    }

    public final StyleableProperty<Number> createStyleableNumberProperty(S s2, String string, String string2, Function<S, StyleableProperty<Number>> function) {
        return this.createStyleableNumberProperty(s2, string, string2, function, 0.0, false);
    }

    public final StyleableProperty<Number> createStyleableNumberProperty(S s2, String string, String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(Number.class, (String)object);
        return new SimpleStyleableObjectProperty<Number>((CssMetaData<Styleable, Number>)object, s2, string, (Number)((CssMetaData)object).getInitialValue(s2));
    }

    public final StyleableProperty<String> createStyleableStringProperty(S s2, String string, String object, Function<S, StyleableProperty<String>> function, String string2, boolean bl2) {
        object = this.createStringCssMetaData((String)object, function, string2, bl2);
        return new SimpleStyleableStringProperty((CssMetaData<? extends Styleable, String>)object, s2, string, string2);
    }

    public final StyleableProperty<String> createStyleableStringProperty(S s2, String string, String string2, Function<S, StyleableProperty<String>> function, String string3) {
        return this.createStyleableStringProperty(s2, string, string2, function, string3, false);
    }

    public final StyleableProperty<String> createStyleableStringProperty(S s2, String string, String string2, Function<S, StyleableProperty<String>> function) {
        return this.createStyleableStringProperty(s2, string, string2, function, null, false);
    }

    public final StyleableProperty<String> createStyleableStringProperty(S s2, String string, String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(String.class, (String)object);
        return new SimpleStyleableStringProperty((CssMetaData<? extends Styleable, String>)object, s2, string, (String)((CssMetaData)object).getInitialValue(s2));
    }

    public final StyleableProperty<String> createStyleableUrlProperty(S s2, String string, String object, Function<S, StyleableProperty<String>> function, String string2, boolean bl2) {
        object = this.createUrlCssMetaData((String)object, function, string2, bl2);
        return new SimpleStyleableStringProperty((CssMetaData<? extends Styleable, String>)object, s2, string, string2);
    }

    public final StyleableProperty<String> createStyleableUrlProperty(S s2, String string, String string2, Function<S, StyleableProperty<String>> function, String string3) {
        return this.createStyleableUrlProperty(s2, string, string2, function, string3, false);
    }

    public final StyleableProperty<String> createStyleableUrlProperty(S s2, String string, String string2, Function<S, StyleableProperty<String>> function) {
        return this.createStyleableUrlProperty(s2, string, string2, function, null, false);
    }

    public final StyleableProperty<String> createStyleableUrlProperty(S s2, String string, String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        object = this.getCssMetaData(String.class, (String)object);
        return new SimpleStyleableStringProperty((CssMetaData<? extends Styleable, String>)object, s2, string, (String)((CssMetaData)object).getInitialValue(s2));
    }

    public final CssMetaData<S, Boolean> createBooleanCssMetaData(String object, Function<S, StyleableProperty<Boolean>> function, boolean bl2, boolean bl3) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        object = this.getCssMetaData(Boolean.class, (String)object, string -> {
            StyleConverter<String, Boolean> styleConverter = StyleConverter.getBooleanConverter();
            return new StyleablePropertyFactory$SimpleCssMetaData((String)string, function, styleConverter, Boolean.valueOf(bl2), bl3);
        });
        return object;
    }

    public final CssMetaData<S, Boolean> createBooleanCssMetaData(String string, Function<S, StyleableProperty<Boolean>> function, boolean bl2) {
        return this.createBooleanCssMetaData(string, function, bl2, false);
    }

    public final CssMetaData<S, Boolean> createBooleanCssMetaData(String string, Function<S, StyleableProperty<Boolean>> function) {
        return this.createBooleanCssMetaData(string, function, false, false);
    }

    public final CssMetaData<S, Color> createColorCssMetaData(String object2, Function<S, StyleableProperty<Color>> function, Color color, boolean bl2) {
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        String string = object2;
        object2 = this.getCssMetaData(Color.class, string, object -> {
            object = StyleConverter.getColorConverter();
            return new StyleablePropertyFactory$SimpleCssMetaData(string, function, (StyleConverter<?, Color>)object, color, bl2);
        });
        return object2;
    }

    public final CssMetaData<S, Color> createColorCssMetaData(String string, Function<S, StyleableProperty<Color>> function, Color color) {
        return this.createColorCssMetaData(string, function, color, false);
    }

    public final CssMetaData<S, Color> createColorCssMetaData(String string, Function<S, StyleableProperty<Color>> function) {
        return this.createColorCssMetaData(string, function, Color.BLACK, false);
    }

    public final CssMetaData<S, Duration> createDurationCssMetaData(String object2, Function<S, StyleableProperty<Duration>> function, Duration duration, boolean bl2) {
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        String string = object2;
        object2 = this.getCssMetaData(Duration.class, string, object -> {
            object = StyleConverter.getDurationConverter();
            return new StyleablePropertyFactory$SimpleCssMetaData(string, function, (StyleConverter<?, Duration>)object, duration, bl2);
        });
        return object2;
    }

    public final CssMetaData<S, Duration> createDurationCssMetaData(String string, Function<S, StyleableProperty<Duration>> function, Duration duration) {
        return this.createDurationCssMetaData(string, function, duration, false);
    }

    public final CssMetaData<S, Duration> createDurationCssMetaData(String string, Function<S, StyleableProperty<Duration>> function) {
        return this.createDurationCssMetaData(string, function, Duration.UNKNOWN, false);
    }

    public final <E extends Effect> CssMetaData<S, E> createEffectCssMetaData(String object2, Function<S, StyleableProperty<E>> function, E e2, boolean bl2) {
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        String string = object2;
        object2 = this.getCssMetaData(Effect.class, string, object -> {
            object = StyleConverter.getEffectConverter();
            return new StyleablePropertyFactory$SimpleCssMetaData(string, function, (StyleConverter<?, Effect>)object, e2, bl2);
        });
        return object2;
    }

    public final <E extends Effect> CssMetaData<S, E> createEffectCssMetaData(String string, Function<S, StyleableProperty<E>> function, E e2) {
        return this.createEffectCssMetaData(string, function, e2, false);
    }

    public final <E extends Effect> CssMetaData<S, E> createEffectCssMetaData(String string, Function<S, StyleableProperty<E>> function) {
        return this.createEffectCssMetaData(string, function, null, false);
    }

    public final <E extends Enum<E>> CssMetaData<S, E> createEnumCssMetaData(Class<? extends Enum> object, String string, Function<S, StyleableProperty<E>> function, E e2, boolean bl2) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        object = this.getCssMetaData((Class)object, string, string2 -> {
            object = new EnumConverter(object);
            return new StyleablePropertyFactory$SimpleCssMetaData(string, function, (StyleConverter<?, Enum>)object, e2, bl2);
        });
        return object;
    }

    public final <E extends Enum<E>> CssMetaData<S, E> createEnumCssMetaData(Class<? extends Enum> clazz, String string, Function<S, StyleableProperty<E>> function, E e2) {
        return this.createEnumCssMetaData(clazz, string, function, e2, false);
    }

    public final <E extends Enum<E>> CssMetaData<S, E> createEnumCssMetaData(Class<? extends Enum> clazz, String string, Function<S, StyleableProperty<E>> function) {
        return this.createEnumCssMetaData(clazz, string, function, null, false);
    }

    public final CssMetaData<S, Font> createFontCssMetaData(String object2, Function<S, StyleableProperty<Font>> function, Font font, boolean bl2) {
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        String string = object2;
        object2 = this.getCssMetaData(Font.class, string, object -> {
            object = StyleConverter.getFontConverter();
            return new StyleablePropertyFactory$SimpleCssMetaData(string, function, (StyleConverter<?, Font>)object, font, bl2);
        });
        return object2;
    }

    public final CssMetaData<S, Font> createFontCssMetaData(String string, Function<S, StyleableProperty<Font>> function, Font font) {
        return this.createFontCssMetaData(string, function, font, true);
    }

    public final CssMetaData<S, Font> createFontCssMetaData(String string, Function<S, StyleableProperty<Font>> function) {
        return this.createFontCssMetaData(string, function, Font.getDefault(), true);
    }

    public final CssMetaData<S, Insets> createInsetsCssMetaData(String object2, Function<S, StyleableProperty<Insets>> function, Insets insets, boolean bl2) {
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        String string = object2;
        object2 = this.getCssMetaData(Insets.class, string, object -> {
            object = StyleConverter.getInsetsConverter();
            return new StyleablePropertyFactory$SimpleCssMetaData(string, function, (StyleConverter<?, Insets>)object, insets, bl2);
        });
        return object2;
    }

    public final CssMetaData<S, Insets> createInsetsCssMetaData(String string, Function<S, StyleableProperty<Insets>> function, Insets insets) {
        return this.createInsetsCssMetaData(string, function, insets, false);
    }

    public final CssMetaData<S, Insets> createInsetsCssMetaData(String string, Function<S, StyleableProperty<Insets>> function) {
        return this.createInsetsCssMetaData(string, function, Insets.EMPTY, false);
    }

    public final CssMetaData<S, Paint> createPaintCssMetaData(String object2, Function<S, StyleableProperty<Paint>> function, Paint paint, boolean bl2) {
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        String string = object2;
        object2 = this.getCssMetaData(Paint.class, string, object -> {
            object = StyleConverter.getPaintConverter();
            return new StyleablePropertyFactory$SimpleCssMetaData(string, function, (StyleConverter<?, Paint>)object, paint, bl2);
        });
        return object2;
    }

    public final CssMetaData<S, Paint> createPaintCssMetaData(String string, Function<S, StyleableProperty<Paint>> function, Paint paint) {
        return this.createPaintCssMetaData(string, function, paint, false);
    }

    public final CssMetaData<S, Paint> createPaintCssMetaData(String string, Function<S, StyleableProperty<Paint>> function) {
        return this.createPaintCssMetaData(string, function, Color.BLACK, false);
    }

    public final CssMetaData<S, Number> createSizeCssMetaData(String object2, Function<S, StyleableProperty<Number>> function, Number number, boolean bl2) {
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        String string = object2;
        object2 = this.getCssMetaData(Number.class, string, object -> {
            object = StyleConverter.getSizeConverter();
            return new StyleablePropertyFactory$SimpleCssMetaData(string, function, (StyleConverter<?, Number>)object, number, bl2);
        });
        return object2;
    }

    public final CssMetaData<S, Number> createSizeCssMetaData(String string, Function<S, StyleableProperty<Number>> function, Number number) {
        return this.createSizeCssMetaData(string, function, number, false);
    }

    public final CssMetaData<S, Number> createSizeCssMetaData(String string, Function<S, StyleableProperty<Number>> function) {
        return this.createSizeCssMetaData(string, function, 0.0, false);
    }

    public final CssMetaData<S, String> createStringCssMetaData(String object2, Function<S, StyleableProperty<String>> function, String string, boolean bl2) {
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        String string2 = object2;
        object2 = this.getCssMetaData(String.class, string2, object -> {
            object = StyleConverter.getStringConverter();
            return new StyleablePropertyFactory$SimpleCssMetaData(string2, function, (StyleConverter<?, String>)object, string, bl2);
        });
        return object2;
    }

    public final CssMetaData<S, String> createStringCssMetaData(String string, Function<S, StyleableProperty<String>> function, String string2) {
        return this.createStringCssMetaData(string, function, string2, false);
    }

    public final CssMetaData<S, String> createStringCssMetaData(String string, Function<S, StyleableProperty<String>> function) {
        return this.createStringCssMetaData(string, function, null, false);
    }

    public final CssMetaData<S, String> createUrlCssMetaData(String object2, Function<S, StyleableProperty<String>> function, String string, boolean bl2) {
        if (object2 == null || ((String)object2).isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        String string2 = object2;
        object2 = this.getCssMetaData(URL.class, string2, object -> {
            object = StyleConverter.getUrlConverter();
            return new StyleablePropertyFactory$SimpleCssMetaData(string2, function, (StyleConverter<?, String>)object, string, bl2);
        });
        return object2;
    }

    public final CssMetaData<S, String> createUrlCssMetaData(String string, Function<S, StyleableProperty<String>> function, String string2) {
        return this.createUrlCssMetaData(string, function, string2, false);
    }

    public final CssMetaData<S, String> createUrlCssMetaData(String string, Function<S, StyleableProperty<String>> function) {
        return this.createUrlCssMetaData(string, function, null, false);
    }

    void clearDataForTesting() {
        this.metaDataMap.clear();
        this.metaDataList.clear();
    }

    private CssMetaData<S, ?> getCssMetaData(Class clazz, String string) {
        return this.getCssMetaData(clazz, string, null);
    }

    private CssMetaData<S, ?> getCssMetaData(Class clazz, String string, Function<String, CssMetaData<S, ?>> object) {
        Pair<Class, CssMetaData<S, ?>> pair = this.metaDataMap.get(string = string.toLowerCase());
        if (pair != null) {
            if (pair.getKey() == clazz) {
                return pair.getValue();
            }
            throw new ClassCastException("CssMetaData value is not " + String.valueOf(clazz) + ": " + String.valueOf(pair.getValue()));
        }
        if (object == null) {
            throw new NoSuchElementException("No CssMetaData for " + string);
        }
        object = object.apply((String)string);
        this.metaDataMap.put(string, new Pair<Class, Object>(clazz, object));
        this.metaDataList.add((CssMetaData<Styleable, ?>)object);
        return object;
    }
}

