/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.FontFaceImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.css.CssParser;
import javafx.css.Declaration;
import javafx.css.FontFace;
import javafx.css.Rule;
import javafx.css.Selector;
import javafx.css.StyleConverter$StringStore;
import javafx.css.StyleOrigin;
import javafx.css.Stylesheet$1;

public class Stylesheet {
    static final int BINARY_CSS_VERSION = 6;
    private final String url;
    private StyleOrigin origin = StyleOrigin.AUTHOR;
    private final ObservableList<Rule> rules = new Stylesheet$1(this);
    private final List<FontFace> fontFaces = new ArrayList<FontFace>();
    private String[] stringStore;

    public String getUrl() {
        return this.url;
    }

    public StyleOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(StyleOrigin styleOrigin) {
        this.origin = styleOrigin;
    }

    Stylesheet() {
        this(null);
    }

    Stylesheet(String string) {
        this.url = string;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public List<FontFace> getFontFaces() {
        return this.fontFaces;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Stylesheet) {
            object = (Stylesheet)object;
            if (this.url == null && ((Stylesheet)object).url == null) {
                return true;
            }
            if (this.url == null || ((Stylesheet)object).url == null) {
                return false;
            }
            return this.url.equals(((Stylesheet)object).url);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 91 + (this.url != null ? this.url.hashCode() : 0);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/* ");
        if (this.url != null) {
            stringBuilder.append(this.url);
        }
        if (this.rules.isEmpty()) {
            stringBuilder.append(" */");
        } else {
            stringBuilder.append(" */\n");
            for (int i2 = 0; i2 < this.rules.size(); ++i2) {
                stringBuilder.append(this.rules.get(i2));
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    final void writeBinary(DataOutputStream dataOutputStream, StyleConverter$StringStore styleConverter$StringStore) throws IOException {
        int n2 = styleConverter$StringStore.addString(this.origin.name());
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(this.rules.size());
        for (Rule rule : this.rules) {
            rule.writeBinary(dataOutputStream, styleConverter$StringStore);
        }
        List<FontFace> list = this.getFontFaces();
        int n3 = list != null ? list.size() : 0;
        dataOutputStream.writeShort(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            FontFace fontFace = (FontFace)list.get(i2);
            if (!(fontFace instanceof FontFaceImpl)) continue;
            ((FontFaceImpl)fontFace).writeBinary(dataOutputStream, styleConverter$StringStore);
        }
    }

    final void readBinary(int n2, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        this.stringStore = stringArray;
        int n3 = dataInputStream.readShort();
        this.setOrigin(StyleOrigin.valueOf(stringArray[n3]));
        n3 = dataInputStream.readShort();
        ArrayList<Rule> arrayList = new ArrayList<Rule>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            arrayList.add(Rule.readBinary(n2, dataInputStream, stringArray));
        }
        this.rules.addAll((Collection<Rule>)arrayList);
        if (n2 >= 5) {
            List<FontFace> list = this.getFontFaces();
            n3 = dataInputStream.readShort();
            for (int i3 = 0; i3 < n3; ++i3) {
                FontFaceImpl fontFaceImpl = FontFaceImpl.readBinary(n2, dataInputStream, stringArray);
                list.add(fontFaceImpl);
            }
        }
    }

    final String[] getStringStore() {
        return this.stringStore;
    }

    public static Stylesheet loadBinary(URL object) throws IOException {
        block9: {
            if (object == null) {
                return null;
            }
            InputStream inputStream = ((URL)object).openStream();
            try {
                object = Stylesheet.loadBinary(inputStream, ((URL)object).toExternalForm());
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
            inputStream.close();
        }
        return object;
    }

    public static Stylesheet loadBinary(InputStream inputStream) throws IOException {
        return Stylesheet.loadBinary(inputStream, null);
    }

    private static Stylesheet loadBinary(InputStream object, String string) throws IOException {
        block9: {
            try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream((InputStream)object, 40960));){
                short s2 = dataInputStream.readShort();
                if (s2 > 6) {
                    throw new IOException(String.format("Wrong binary CSS version %s, expected version less than or equal to %s", string != null ? s2 + " in stylesheet \"" + string + "\"" : Integer.valueOf(s2), 6));
                }
                String[] stringArray = StyleConverter$StringStore.readBinary(dataInputStream);
                object = new Stylesheet(string);
                try {
                    dataInputStream.mark(Integer.MAX_VALUE);
                    ((Stylesheet)object).readBinary(s2, dataInputStream, stringArray);
                }
                catch (Exception exception) {
                    object = new Stylesheet(string);
                    dataInputStream.reset();
                    if (s2 == 2) {
                        ((Stylesheet)object).readBinary(3, dataInputStream, stringArray);
                        break block9;
                    }
                    ((Stylesheet)object).readBinary(6, dataInputStream, stringArray);
                }
            }
        }
        return object;
    }

    public static void convertToBinary(File object, File file) throws IOException {
        if (object == null || file == null) {
            throw new IllegalArgumentException("parameters may not be null");
        }
        if (((File)object).getAbsolutePath().equals(file.getAbsolutePath())) {
            throw new IllegalArgumentException("source and destination may not be the same");
        }
        if (!((File)object).canRead()) {
            throw new IllegalArgumentException("cannot read source file");
        }
        if (file.exists() ? !file.canWrite() : !file.createNewFile()) {
            throw new IllegalArgumentException("cannot write destination file");
        }
        object = ((File)object).toURI();
        object = new CssParser().parse(((URI)object).toURL());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        StyleConverter$StringStore styleConverter$StringStore = new StyleConverter$StringStore();
        ((Stylesheet)object).writeBinary(dataOutputStream, styleConverter$StringStore);
        dataOutputStream.flush();
        dataOutputStream.close();
        object = new FileOutputStream(file);
        object = new DataOutputStream((OutputStream)object);
        ((DataOutputStream)object).writeShort(6);
        styleConverter$StringStore.writeBinary((DataOutputStream)object);
        ((FilterOutputStream)object).write(byteArrayOutputStream.toByteArray());
        ((DataOutputStream)object).flush();
        ((FilterOutputStream)object).close();
    }

    void importStylesheet(Stylesheet iterator) {
        if (iterator == null) {
            return;
        }
        if ((iterator = ((Stylesheet)((Object)iterator)).getRules()) == null || iterator.isEmpty()) {
            return;
        }
        ArrayList<Rule> arrayList = new ArrayList<Rule>(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = (Rule)iterator.next();
            ObservableList<Selector> observableList = ((Rule)object).getSelectors();
            object = ((Rule)object).getUnobservedDeclarationList();
            arrayList.add(new Rule(observableList, (List<Declaration>)object));
        }
        this.rules.addAll((Collection<Rule>)arrayList);
    }
}

