/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.nio.IntBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.paint.Color;

public class SwingFXUtils {
    private SwingFXUtils() {
    }

    public static WritableImage toFXImage(BufferedImage writablePixelFormat, WritableImage writableImage) {
        int[] nArray;
        Object object;
        Object object2;
        int n2 = ((BufferedImage)((Object)writablePixelFormat)).getWidth();
        int n3 = ((BufferedImage)((Object)writablePixelFormat)).getHeight();
        switch (((BufferedImage)((Object)writablePixelFormat)).getType()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                object2 = new BufferedImage(n2, n3, 3);
                object = ((BufferedImage)object2).createGraphics();
                ((Graphics)object).drawImage((Image)((Object)writablePixelFormat), 0, 0, null);
                ((Graphics)object).dispose();
                writablePixelFormat = object2;
            }
        }
        if (writableImage != null) {
            int n4 = (int)writableImage.getWidth();
            int n5 = (int)writableImage.getHeight();
            if (n4 < n2 || n5 < n3) {
                writableImage = null;
            } else if (n2 < n4 || n3 < n5) {
                nArray = new int[n4];
                PixelWriter pixelWriter = writableImage.getPixelWriter();
                WritablePixelFormat<IntBuffer> writablePixelFormat2 = PixelFormat.getIntArgbPreInstance();
                if (n2 < n4) {
                    pixelWriter.setPixels(n2, 0, n4 - n2, n3, writablePixelFormat2, nArray, 0, 0);
                }
                if (n3 < n5) {
                    pixelWriter.setPixels(0, n3, n4, n5 - n3, writablePixelFormat2, nArray, 0, 0);
                }
            }
        }
        if (writableImage == null) {
            writableImage = new WritableImage(n2, n3);
        }
        object2 = writableImage.getPixelWriter();
        object = (DataBufferInt)((BufferedImage)((Object)writablePixelFormat)).getRaster().getDataBuffer();
        nArray = ((DataBufferInt)object).getData();
        int n6 = ((BufferedImage)((Object)writablePixelFormat)).getRaster().getDataBuffer().getOffset();
        int n7 = 0;
        object = ((BufferedImage)((Object)writablePixelFormat)).getRaster().getSampleModel();
        if (object instanceof SinglePixelPackedSampleModel) {
            n7 = ((SinglePixelPackedSampleModel)object).getScanlineStride();
        }
        writablePixelFormat = ((BufferedImage)((Object)writablePixelFormat)).isAlphaPremultiplied() ? PixelFormat.getIntArgbPreInstance() : PixelFormat.getIntArgbInstance();
        object2.setPixels(0, 0, n2, n3, writablePixelFormat, nArray, n6, n7);
        return writableImage;
    }

    static int getBestBufferedImageType(PixelFormat<?> pixelFormat, BufferedImage bufferedImage, boolean bl2) {
        int n2;
        if (bufferedImage != null && ((n2 = bufferedImage.getType()) == 2 || n2 == 3 || bl2 && (n2 == 4 || n2 == 1))) {
            return n2;
        }
        switch (pixelFormat.getType()) {
            default: {
                return 3;
            }
            case BYTE_BGRA: 
            case INT_ARGB: {
                return 2;
            }
            case BYTE_RGB: {
                return 1;
            }
            case BYTE_INDEXED: 
        }
        if (pixelFormat.isPremultiplied()) {
            return 3;
        }
        return 2;
    }

    private static WritablePixelFormat<IntBuffer> getAssociatedPixelFormat(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 3: {
                return PixelFormat.getIntArgbPreInstance();
            }
            case 2: {
                return PixelFormat.getIntArgbInstance();
            }
        }
        throw new InternalError("Failed to validate BufferedImage type");
    }

    private static boolean checkFXImageOpaque(PixelReader pixelReader, int n2, int n3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                Color color = pixelReader.getColor(i2, i3);
                if (color.getOpacity() == 1.0) continue;
                return false;
            }
        }
        return true;
    }

    public static BufferedImage fromFXImage(javafx.scene.image.Image image, BufferedImage bufferedImage) {
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            return null;
        }
        int n2 = (int)image.getWidth();
        int n3 = (int)image.getHeight();
        PixelFormat pixelFormat = pixelReader.getPixelFormat();
        int n4 = 0;
        switch (pixelFormat.getType()) {
            case BYTE_BGRA_PRE: 
            case INT_ARGB_PRE: 
            case BYTE_BGRA: 
            case INT_ARGB: {
                if (bufferedImage == null || bufferedImage.getType() != 4 && bufferedImage.getType() != 1) break;
                n4 = SwingFXUtils.checkFXImageOpaque(pixelReader, n2, n3);
                break;
            }
            case BYTE_RGB: {
                n4 = 1;
            }
        }
        int n5 = SwingFXUtils.getBestBufferedImageType(pixelReader.getPixelFormat(), bufferedImage, n4 != 0);
        if (bufferedImage != null) {
            n4 = bufferedImage.getWidth();
            int n6 = bufferedImage.getHeight();
            if (n4 < n2 || n6 < n3 || bufferedImage.getType() != n5) {
                bufferedImage = null;
            } else if (n2 < n4 || n3 < n6) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, n4, n6);
                graphics2D.dispose();
            }
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n2, n3, n5);
        }
        Object object = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = ((DataBufferInt)object).getData();
        int n7 = bufferedImage.getRaster().getDataBuffer().getOffset();
        n5 = 0;
        object = bufferedImage.getRaster().getSampleModel();
        if (object instanceof SinglePixelPackedSampleModel) {
            n5 = ((SinglePixelPackedSampleModel)object).getScanlineStride();
        }
        object = SwingFXUtils.getAssociatedPixelFormat(bufferedImage);
        pixelReader.getPixels(0, 0, n2, n3, (WritablePixelFormat<IntBuffer>)object, nArray, n7, n5);
        return bufferedImage;
    }
}

