/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.swing.Disposer;
import com.sun.javafx.embed.swing.SwingNodeHelper;
import com.sun.javafx.embed.swing.newimpl.SwingNodeInteropN;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGExternalNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.stage.FocusUngrabEvent;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.TKStage;
import java.awt.event.WindowFocusListener;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.embed.swing.SwingNode$1;
import javafx.embed.swing.SwingNode$2;
import javafx.embed.swing.SwingNode$PostEventAction;
import javafx.embed.swing.SwingNode$SwingKeyEventHandler;
import javafx.embed.swing.SwingNode$SwingMouseEventHandler;
import javafx.embed.swing.SwingNode$SwingNodeWindowFocusListener;
import javafx.embed.swing.SwingNode$SwingScrollEventHandler;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.text.Font;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.swing.JComponent;
import javax.swing.Timer;

public class SwingNode
extends Node {
    private static boolean isThreadMerged;
    private double fxWidth;
    private double fxHeight;
    private int swingPrefWidth;
    private int swingPrefHeight;
    private int swingMaxWidth;
    private int swingMaxHeight;
    private int swingMinWidth;
    private int swingMinHeight;
    private volatile JComponent content;
    private volatile Object lwFrame;
    private NGExternalNode peer;
    private final ReentrantLock paintLock = new ReentrantLock();
    private boolean skipBackwardUnrgabNotification;
    private boolean grabbed;
    private Timer deactivate;
    private SwingNodeInteropN swNodeIOP;
    private EventHandler windowHiddenHandler;
    private Window hWindow;
    private List<Runnable> peerRequests;
    private final InvalidationListener locationListener;
    private final EventHandler<FocusUngrabEvent> ungrabHandler;
    private final ChangeListener<Boolean> windowVisibleListener;
    private final ChangeListener<Window> sceneWindowListener;

    private final Object getLightweightFrame() {
        return this.lwFrame;
    }

    private ReentrantLock getPaintLock() {
        return this.paintLock;
    }

    public SwingNode() {
        SwingNodeHelper.initHelper(this);
        this.windowHiddenHandler = object -> {
            if (this.lwFrame != null && ((Event)object).getTarget() instanceof Window) {
                object = (Window)((Event)object).getTarget();
                if ((object = WindowHelper.getPeer((Window)((Object)object))) != null) {
                    if (isThreadMerged) {
                        this.swNodeIOP.overrideNativeWindowHandle(this.lwFrame, 0L, null);
                        return;
                    }
                    object.postponeClose();
                    SwingNodeHelper.runOnEDT(() -> this.lambda$new$3((TKStage)((Object)object)));
                }
            }
        };
        this.hWindow = null;
        this.peerRequests = new ArrayList<Runnable>();
        this.locationListener = observable -> this.locateLwFrame();
        this.ungrabHandler = focusUngrabEvent -> {
            if (!this.skipBackwardUnrgabNotification && this.lwFrame != null) {
                SwingNode swingNode = this;
                AccessController.doPrivileged(new SwingNode$PostEventAction(swingNode, swingNode.swNodeIOP.createUngrabEvent(this.lwFrame)));
            }
        };
        this.windowVisibleListener = (observableValue, bl2, bl3) -> {
            if (!bl3.booleanValue()) {
                this.disposeLwFrame();
                return;
            }
            SwingNode swingNode = this;
            swingNode.setContent(swingNode.content);
        };
        this.sceneWindowListener = (observableValue, window, window2) -> {
            if (window != null) {
                this.removeWindowListeners((Window)window);
            }
            this.notifyNativeHandle((Window)window2);
            if (window2 != null) {
                this.addWindowListeners((Window)window2);
            }
        };
        this.swNodeIOP = new SwingNodeInteropN();
        this.setFocusTraversable(true);
        this.setEventHandler(MouseEvent.ANY, new SwingNode$SwingMouseEventHandler(this));
        this.setEventHandler(KeyEvent.ANY, new SwingNode$SwingKeyEventHandler(this));
        this.setEventHandler(ScrollEvent.SCROLL, new SwingNode$SwingScrollEventHandler(this));
        this.focusedProperty().addListener((observableValue, bl2, bl3) -> this.activateLwFrame((boolean)bl3));
        Font.getFamilies();
    }

    private void notifyNativeHandle(Window object) {
        if (this.hWindow != object) {
            if (this.hWindow != null) {
                this.hWindow.removeEventHandler(WindowEvent.WINDOW_HIDDEN, this.windowHiddenHandler);
            }
            if (object != null) {
                ((Window)object).addEventHandler(WindowEvent.WINDOW_HIDDEN, this.windowHiddenHandler);
            }
            this.hWindow = object;
        }
        if (this.lwFrame != null) {
            long l2 = 0L;
            if (object != null && (object = WindowHelper.getPeer((Window)object)) != null) {
                l2 = object.getRawHandle();
            }
            this.swNodeIOP.overrideNativeWindowHandle(this.lwFrame, l2, null);
        }
    }

    public void setContent(JComponent jComponent) {
        this.content = jComponent;
        SwingNodeHelper.runOnEDT(() -> this.setContentImpl(jComponent));
    }

    public JComponent getContent() {
        return this.content;
    }

    private void setContentImpl(JComponent jComponent) {
        if (this.lwFrame != null) {
            this.swNodeIOP.disposeFrame(this.lwFrame);
            this.lwFrame = null;
        }
        if (jComponent != null) {
            this.lwFrame = this.swNodeIOP.createLightweightFrame();
            Object object = new SwingNode$SwingNodeWindowFocusListener(this);
            this.swNodeIOP.addWindowFocusListener(this.lwFrame, (WindowFocusListener)object);
            if (this.getScene() != null && (object = this.getScene().getWindow()) != null) {
                this.swNodeIOP.notifyDisplayChanged(this.lwFrame, ((Window)object).getRenderScaleX(), ((Window)object).getRenderScaleY());
            }
            this.swNodeIOP.setContent(this.lwFrame, this.swNodeIOP.createSwingNodeContent(jComponent, this));
            this.swNodeIOP.setVisible(this.lwFrame, true);
            SwingNode swingNode = this;
            Disposer.addRecord(swingNode, swingNode.swNodeIOP.createSwingNodeDisposer(this.lwFrame));
            if (this.getScene() != null) {
                SwingNode swingNode2 = this;
                swingNode2.notifyNativeHandle(swingNode2.getScene().getWindow());
            }
            SwingNodeHelper.runOnFxThread(() -> {
                this.locateLwFrame();
                if (this.focusedProperty().get()) {
                    this.activateLwFrame(true);
                }
            });
        }
    }

    void setImageBuffer(int[] object, int n2, int n3, int n4, int n5, int n6, double d2, double d3) {
        object = () -> this.lambda$setImageBuffer$7((int[])object, n2, n3, n4, n5, n6, d2, d3);
        SwingNodeHelper.runOnFxThread(() -> this.lambda$setImageBuffer$8((Runnable)object));
    }

    void setImageBounds(int n2, int n3, int n4, int n5) {
        Runnable runnable = () -> this.peer.setImageBounds(n2, n3, n4, n5, n4, n5);
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.peer != null) {
                runnable.run();
                return;
            }
            this.peerRequests.add(runnable);
        });
    }

    void repaintDirtyRegion(int n2, int n3, int n4, int n5) {
        Runnable runnable = () -> {
            this.peer.repaintDirtyRegion(n2, n3, n4, n5);
            NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
        };
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.peer != null) {
                runnable.run();
                return;
            }
            this.peerRequests.add(runnable);
        });
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double d2, double d3) {
        super.resize(d2, d3);
        if (d2 != this.fxWidth || d3 != this.fxHeight) {
            this.fxWidth = d2;
            this.fxHeight = d3;
            NodeHelper.geomChanged(this);
            NodeHelper.markDirty(this, DirtyBits.NODE_GEOMETRY);
            SwingNodeHelper.runOnEDT(() -> {
                if (this.lwFrame != null) {
                    this.locateLwFrame();
                }
            });
        }
    }

    @Override
    public double prefWidth(double d2) {
        return this.swingPrefWidth;
    }

    @Override
    public double prefHeight(double d2) {
        return this.swingPrefHeight;
    }

    @Override
    public double maxWidth(double d2) {
        return this.swingMaxWidth;
    }

    @Override
    public double maxHeight(double d2) {
        return this.swingMaxHeight;
    }

    @Override
    public double minWidth(double d2) {
        return this.swingMinWidth;
    }

    @Override
    public double minHeight(double d2) {
        return this.swingMinHeight;
    }

    private boolean doComputeContains(double d2, double d3) {
        return true;
    }

    private void removeSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.removeWindowListeners(window);
        }
        scene.windowProperty().removeListener(this.sceneWindowListener);
    }

    private void addSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.addWindowListeners(window);
            this.notifyNativeHandle(window);
        }
        scene.windowProperty().addListener(this.sceneWindowListener);
    }

    private void addWindowListeners(Window window) {
        window.xProperty().addListener(this.locationListener);
        window.yProperty().addListener(this.locationListener);
        window.widthProperty().addListener(this.locationListener);
        window.heightProperty().addListener(this.locationListener);
        window.renderScaleXProperty().addListener(this.locationListener);
        window.addEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().addListener(this.windowVisibleListener);
        this.setLwFrameScale(window.getRenderScaleX(), window.getRenderScaleY());
    }

    private void removeWindowListeners(Window window) {
        window.xProperty().removeListener(this.locationListener);
        window.yProperty().removeListener(this.locationListener);
        window.widthProperty().removeListener(this.locationListener);
        window.heightProperty().removeListener(this.locationListener);
        window.renderScaleXProperty().removeListener(this.locationListener);
        window.removeEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().removeListener(this.windowVisibleListener);
    }

    private NGNode doCreatePeer() {
        this.peer = new NGExternalNode();
        this.peer.setLock(this.paintLock);
        for (Runnable runnable : this.peerRequests) {
            runnable.run();
        }
        this.peerRequests = null;
        if (this.getScene() != null) {
            SwingNode swingNode = this;
            swingNode.addSceneListeners(swingNode.getScene());
        }
        this.sceneProperty().addListener((observableValue, scene, scene2) -> {
            if (scene != null) {
                this.removeSceneListeners((Scene)scene);
                this.disposeLwFrame();
            }
            if (scene2 != null) {
                if (this.content != null && this.lwFrame == null) {
                    SwingNode swingNode = this;
                    swingNode.setContent(swingNode.content);
                }
                this.addSceneListeners((Scene)scene2);
            }
        });
        NodeHelper.treeVisibleProperty(this).addListener((observableValue, bl2, bl3) -> this.setLwFrameVisible((boolean)bl3));
        return this.peer;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.NODE_VISIBLE) || NodeHelper.isDirty(this, DirtyBits.NODE_BOUNDS)) {
            this.locateLwFrame();
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            this.peer.markContentDirty();
        }
    }

    private void locateLwFrame() {
        if (this.getScene() == null || this.lwFrame == null || this.getScene().getWindow() == null || !this.getScene().getWindow().isShowing()) {
            return;
        }
        Window window = this.getScene().getWindow();
        double d2 = window.getRenderScaleX();
        double d3 = window.getRenderScaleY();
        Point2D point2D = this.localToScene(0.0, 0.0);
        int n2 = (int)window.getX();
        int n3 = (int)window.getY();
        int n4 = (int)window.getWidth();
        int n5 = (int)window.getHeight();
        int n6 = (int)Math.round(window.getX() + this.getScene().getX() + point2D.getX());
        int n7 = (int)Math.round(window.getY() + this.getScene().getY() + point2D.getY());
        int n8 = (int)this.fxWidth;
        int n9 = (int)this.fxHeight;
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.notifyDisplayChanged(this.lwFrame, d2, d3);
                this.swNodeIOP.setBounds(this.lwFrame, n6, n7, n8, n9);
                this.swNodeIOP.setHostBounds(this.lwFrame, n2, n3, n4, n5);
            }
        });
    }

    private void activateLwFrame(boolean bl2) {
        if (this.lwFrame == null) {
            return;
        }
        if (PlatformUtil.isLinux()) {
            if (this.deactivate == null || !this.deactivate.isRunning()) {
                if (!bl2) {
                    this.deactivate = new Timer(50, actionEvent -> {
                        if (this.lwFrame != null) {
                            this.swNodeIOP.emulateActivation(this.lwFrame, false);
                        }
                    });
                    this.deactivate.start();
                    return;
                }
            } else {
                this.deactivate.stop();
            }
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.emulateActivation(this.lwFrame, bl2);
            }
        });
    }

    private void disposeLwFrame() {
        if (this.lwFrame == null) {
            return;
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.disposeFrame(this.lwFrame);
                this.lwFrame = null;
            }
        });
    }

    private void setLwFrameVisible(boolean bl2) {
        if (this.lwFrame == null) {
            return;
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.setVisible(this.lwFrame, bl2);
            }
        });
    }

    private void setLwFrameScale(double d2, double d3) {
        if (this.lwFrame == null) {
            return;
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.notifyDisplayChanged(this.lwFrame, d2, d3);
            }
        });
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        baseBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, (float)this.fxWidth, (float)this.fxHeight, 0.0f);
        BaseBounds baseBounds2 = baseBounds;
        baseTransform.transform(baseBounds2, baseBounds2);
        return baseBounds;
    }

    private void ungrabFocus(boolean bl2) {
        if (PlatformUtil.isLinux()) {
            return;
        }
        if (this.grabbed && this.getScene() != null && this.getScene().getWindow() != null && WindowHelper.getPeer(this.getScene().getWindow()) != null) {
            this.skipBackwardUnrgabNotification = !bl2;
            WindowHelper.getPeer(this.getScene().getWindow()).ungrabFocus();
            this.skipBackwardUnrgabNotification = false;
            this.grabbed = false;
        }
    }

    private /* synthetic */ void lambda$setImageBuffer$8(Runnable runnable) {
        if (this.peer != null) {
            runnable.run();
            return;
        }
        this.peerRequests.clear();
        this.peerRequests.add(runnable);
    }

    private /* synthetic */ void lambda$setImageBuffer$7(int[] nArray, int n2, int n3, int n4, int n5, int n6, double d2, double d3) {
        this.peer.setImageBuffer(IntBuffer.wrap(nArray), n2, n3, n4, n5, n4, n5, n6, d2, d3);
    }

    private /* synthetic */ void lambda$new$3(TKStage tKStage) {
        this.swNodeIOP.overrideNativeWindowHandle(this.lwFrame, 0L, () -> SwingNodeHelper.runOnFxThread(() -> tKStage.closePostponed()));
    }

    static {
        AccessController.doPrivileged(new SwingNode$1());
        SwingNodeHelper.setSwingNodeAccessor(new SwingNode$2());
    }
}

