/*
 * Decompiled with CFR 0.152.
 */
package javafx.print;

import java.util.Set;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.print.Collation;
import javafx.print.JobSettings$1;
import javafx.print.JobSettings$10;
import javafx.print.JobSettings$11;
import javafx.print.JobSettings$2;
import javafx.print.JobSettings$3;
import javafx.print.JobSettings$4;
import javafx.print.JobSettings$5;
import javafx.print.JobSettings$6;
import javafx.print.JobSettings$7;
import javafx.print.JobSettings$8;
import javafx.print.JobSettings$9;
import javafx.print.PageLayout;
import javafx.print.PageRange;
import javafx.print.PaperSource;
import javafx.print.PrintColor;
import javafx.print.PrintQuality;
import javafx.print.PrintResolution;
import javafx.print.PrintSides;
import javafx.print.Printer;
import javafx.print.PrinterAttributes;
import javafx.print.PrinterJob;

public final class JobSettings {
    private PrinterJob job;
    private Printer printer;
    private PrinterAttributes printerCaps;
    private boolean defaultCopies = true;
    private boolean hasOldCopies = false;
    private int oldCopies;
    private boolean defaultSides = true;
    private boolean hasOldSides = false;
    private PrintSides oldSides;
    private boolean defaultCollation = true;
    private boolean hasOldCollation = false;
    private Collation oldCollation;
    private boolean defaultPrintColor = true;
    private boolean hasOldPrintColor = false;
    private PrintColor oldPrintColor;
    private boolean defaultPrintQuality = true;
    private boolean hasOldPrintQuality = false;
    private PrintQuality oldPrintQuality;
    private boolean defaultPrintResolution = true;
    private boolean hasOldPrintResolution = false;
    private PrintResolution oldPrintResolution;
    private boolean defaultPaperSource = true;
    private boolean hasOldPaperSource = false;
    private PaperSource oldPaperSource;
    private boolean defaultPageLayout = true;
    private boolean hasOldPageLayout = false;
    private PageLayout oldPageLayout;
    private static final String DEFAULT_JOBNAME = "JavaFX Print Job";
    private SimpleStringProperty jobName;
    private SimpleStringProperty outputFile;
    private IntegerProperty copies;
    private ObjectProperty<PageRange[]> pageRanges = null;
    private ObjectProperty<PrintSides> sides = null;
    private ObjectProperty<Collation> collation = null;
    private ObjectProperty<PrintColor> color = null;
    private ObjectProperty<PrintQuality> quality = null;
    private ObjectProperty<PrintResolution> resolution = null;
    private ObjectProperty<PaperSource> paperSource = null;
    private ObjectProperty<PageLayout> layout = null;

    JobSettings(Printer printer) {
        this.printer = printer;
        this.printerCaps = printer.getPrinterAttributes();
    }

    final void setPrinterJob(PrinterJob printerJob) {
        this.job = printerJob;
    }

    private boolean isJobNew() {
        return this.job == null || this.job.isJobNew();
    }

    /*
     * Enabled aggressive block sorting
     */
    final void updateForPrinter(Printer object) {
        this.printer = object;
        this.printerCaps = ((Printer)object).getPrinterAttributes();
        if (this.defaultCopies) {
            if (this.getCopies() != this.printerCaps.getDefaultCopies()) {
                JobSettings jobSettings = this;
                jobSettings.setCopies(jobSettings.printerCaps.getDefaultCopies());
                this.defaultCopies = true;
            }
        } else {
            int n2 = this.getCopies();
            if (this.hasOldCopies && this.oldCopies > n2) {
                n2 = this.oldCopies;
            }
            int n3 = this.printerCaps.getMaxCopies();
            if (!this.hasOldCopies && this.getCopies() > n3) {
                this.hasOldCopies = true;
                this.oldCopies = this.getCopies();
            }
            if (n2 > n3) {
                n2 = n3;
            }
            this.setCopies(n2);
        }
        Object object2 = this.getPrintSides();
        Object object3 = this.printerCaps.getDefaultPrintSides();
        Set<Object> set = this.printerCaps.getSupportedPrintSides();
        if (this.defaultSides) {
            if (object2 != object3) {
                this.setPrintSides((PrintSides)((Object)object3));
                this.defaultSides = true;
            }
        } else if (this.hasOldSides) {
            if (set.contains((Object)this.oldSides)) {
                JobSettings jobSettings = this;
                jobSettings.setPrintSides(jobSettings.oldSides);
                this.hasOldSides = false;
            } else {
                this.setPrintSides((PrintSides)((Object)object3));
            }
        } else if (!set.contains(object2)) {
            this.hasOldSides = true;
            this.oldSides = object2;
            this.setPrintSides((PrintSides)((Object)object3));
        }
        object2 = this.getCollation();
        object3 = this.printerCaps.getDefaultCollation();
        set = this.printerCaps.getSupportedCollations();
        if (this.defaultCollation) {
            if (object2 != object3) {
                this.setCollation((Collation)((Object)object3));
                this.defaultCollation = true;
            }
        } else if (this.hasOldCollation) {
            if (set.contains((Object)this.oldCollation)) {
                JobSettings jobSettings = this;
                jobSettings.setCollation(jobSettings.oldCollation);
                this.hasOldCollation = false;
            } else {
                this.setCollation((Collation)((Object)object3));
            }
        } else if (!set.contains(object2)) {
            this.hasOldCollation = true;
            this.oldCollation = object2;
            this.setCollation((Collation)((Object)object3));
        }
        object2 = this.getPrintColor();
        object3 = this.printerCaps.getDefaultPrintColor();
        set = this.printerCaps.getSupportedPrintColors();
        if (this.defaultPrintColor) {
            if (object2 != object3) {
                this.setPrintColor((PrintColor)((Object)object3));
                this.defaultPrintColor = true;
            }
        } else if (this.hasOldPrintColor) {
            if (set.contains((Object)this.oldPrintColor)) {
                JobSettings jobSettings = this;
                jobSettings.setPrintColor(jobSettings.oldPrintColor);
                this.hasOldPrintColor = false;
            } else {
                this.setPrintColor((PrintColor)((Object)object3));
            }
        } else if (!set.contains(object2)) {
            this.hasOldPrintColor = true;
            this.oldPrintColor = object2;
            this.setPrintColor((PrintColor)((Object)object3));
        }
        object2 = this.getPrintQuality();
        object3 = this.printerCaps.getDefaultPrintQuality();
        set = this.printerCaps.getSupportedPrintQuality();
        if (this.defaultPrintQuality) {
            if (object2 != object3) {
                this.setPrintQuality((PrintQuality)((Object)object3));
                this.defaultPrintQuality = true;
            }
        } else if (this.hasOldPrintQuality) {
            if (set.contains((Object)this.oldPrintQuality)) {
                JobSettings jobSettings = this;
                jobSettings.setPrintQuality(jobSettings.oldPrintQuality);
                this.hasOldPrintQuality = false;
            } else {
                this.setPrintQuality((PrintQuality)((Object)object3));
            }
        } else if (!set.contains(object2)) {
            this.hasOldPrintQuality = true;
            this.oldPrintQuality = object2;
            this.setPrintQuality((PrintQuality)((Object)object3));
        }
        object2 = this.getPrintResolution();
        object3 = this.printerCaps.getDefaultPrintResolution();
        set = this.printerCaps.getSupportedPrintResolutions();
        if (this.defaultPrintResolution) {
            if (object2 != object3) {
                this.setPrintResolution((PrintResolution)object3);
                this.defaultPrintResolution = true;
            }
        } else if (this.hasOldPrintResolution) {
            if (set.contains(this.oldPrintResolution)) {
                JobSettings jobSettings = this;
                jobSettings.setPrintResolution(jobSettings.oldPrintResolution);
                this.hasOldPrintResolution = false;
            } else {
                this.setPrintResolution((PrintResolution)object3);
            }
        } else if (!set.contains(object2)) {
            this.hasOldPrintResolution = true;
            this.oldPrintResolution = object2;
            this.setPrintResolution((PrintResolution)object3);
        }
        object2 = this.getPaperSource();
        object3 = this.printerCaps.getDefaultPaperSource();
        set = this.printerCaps.getSupportedPaperSources();
        if (this.defaultPaperSource) {
            if (object2 != object3) {
                this.setPaperSource((PaperSource)object3);
                this.defaultPaperSource = true;
            }
        } else if (this.hasOldPaperSource) {
            if (set.contains(this.oldPaperSource)) {
                JobSettings jobSettings = this;
                jobSettings.setPaperSource(jobSettings.oldPaperSource);
                this.hasOldPaperSource = false;
            } else {
                this.setPaperSource((PaperSource)object3);
            }
        } else if (!set.contains(object2)) {
            this.hasOldPaperSource = true;
            this.oldPaperSource = object2;
            this.setPaperSource((PaperSource)object3);
        }
        object2 = this.getPageLayout();
        object = ((Printer)object).getDefaultPageLayout();
        if (this.defaultPageLayout) {
            if (((PageLayout)object2).equals(object)) return;
            this.setPageLayout((PageLayout)object);
            this.defaultPageLayout = true;
            return;
        }
        if (!this.hasOldPageLayout) {
            object3 = this.job.validatePageLayout((PageLayout)object2);
            if (((PageLayout)object3).equals(object2)) return;
            this.hasOldPageLayout = true;
            this.oldPageLayout = object2;
            this.setPageLayout((PageLayout)object);
            return;
        }
        object3 = this.job.validatePageLayout(this.oldPageLayout);
        if (((PageLayout)object3).equals(this.oldPageLayout)) {
            JobSettings jobSettings = this;
            jobSettings.setPageLayout(jobSettings.oldPageLayout);
            this.hasOldPageLayout = false;
            return;
        }
        this.setPageLayout((PageLayout)object);
    }

    public final StringProperty jobNameProperty() {
        if (this.jobName == null) {
            JobSettings jobSettings = this;
            this.jobName = new JobSettings$1(jobSettings, jobSettings, "jobName", DEFAULT_JOBNAME);
        }
        return this.jobName;
    }

    public final String getJobName() {
        return (String)this.jobNameProperty().get();
    }

    public final void setJobName(String string) {
        this.jobNameProperty().set(string);
    }

    public final StringProperty outputFileProperty() {
        if (this.outputFile == null) {
            JobSettings jobSettings = this;
            this.outputFile = new JobSettings$2(jobSettings, jobSettings, "outputFile", "");
        }
        return this.outputFile;
    }

    public final String getOutputFile() {
        return (String)this.outputFileProperty().get();
    }

    public final void setOutputFile(String string) {
        this.outputFileProperty().set(string);
    }

    public final IntegerProperty copiesProperty() {
        if (this.copies == null) {
            JobSettings jobSettings = this;
            this.copies = new JobSettings$3(jobSettings, jobSettings, "copies", this.printerCaps.getDefaultCopies());
        }
        return this.copies;
    }

    public final int getCopies() {
        return this.copiesProperty().get();
    }

    public final void setCopies(int n2) {
        this.copiesProperty().set(n2);
    }

    public final ObjectProperty pageRangesProperty() {
        if (this.pageRanges == null) {
            JobSettings jobSettings = this;
            this.pageRanges = new JobSettings$4(jobSettings, jobSettings, "pageRanges", null);
        }
        return this.pageRanges;
    }

    public final PageRange[] getPageRanges() {
        return (PageRange[])this.pageRangesProperty().get();
    }

    public final void setPageRanges(PageRange ... pageRangeArray) {
        this.pageRangesProperty().set(pageRangeArray);
    }

    public final ObjectProperty<PrintSides> printSidesProperty() {
        if (this.sides == null) {
            JobSettings jobSettings = this;
            this.sides = new JobSettings$5(jobSettings, jobSettings, "printSides", this.printerCaps.getDefaultPrintSides());
        }
        return this.sides;
    }

    public final PrintSides getPrintSides() {
        return (PrintSides)((Object)this.printSidesProperty().get());
    }

    public final void setPrintSides(PrintSides printSides) {
        if (printSides == this.getPrintSides()) {
            return;
        }
        this.printSidesProperty().set(printSides);
    }

    public final ObjectProperty<Collation> collationProperty() {
        if (this.collation == null) {
            Collation collation = this.printerCaps.getDefaultCollation();
            JobSettings jobSettings = this;
            this.collation = new JobSettings$6(jobSettings, jobSettings, "collation", collation);
        }
        return this.collation;
    }

    public final Collation getCollation() {
        return (Collation)((Object)this.collationProperty().get());
    }

    public final void setCollation(Collation collation) {
        if (collation == this.getCollation()) {
            return;
        }
        this.collationProperty().set(collation);
    }

    public final ObjectProperty<PrintColor> printColorProperty() {
        if (this.color == null) {
            JobSettings jobSettings = this;
            this.color = new JobSettings$7(jobSettings, jobSettings, "printColor", this.printerCaps.getDefaultPrintColor());
        }
        return this.color;
    }

    public final PrintColor getPrintColor() {
        return (PrintColor)((Object)this.printColorProperty().get());
    }

    public final void setPrintColor(PrintColor printColor) {
        if (printColor == this.getPrintColor()) {
            return;
        }
        this.printColorProperty().set(printColor);
    }

    public final ObjectProperty<PrintQuality> printQualityProperty() {
        if (this.quality == null) {
            JobSettings jobSettings = this;
            this.quality = new JobSettings$8(jobSettings, jobSettings, "printQuality", this.printerCaps.getDefaultPrintQuality());
        }
        return this.quality;
    }

    public final PrintQuality getPrintQuality() {
        return (PrintQuality)((Object)this.printQualityProperty().get());
    }

    public final void setPrintQuality(PrintQuality printQuality) {
        if (printQuality == this.getPrintQuality()) {
            return;
        }
        this.printQualityProperty().set(printQuality);
    }

    public final ObjectProperty<PrintResolution> printResolutionProperty() {
        if (this.resolution == null) {
            JobSettings jobSettings = this;
            this.resolution = new JobSettings$9(jobSettings, jobSettings, "printResolution", this.printerCaps.getDefaultPrintResolution());
        }
        return this.resolution;
    }

    public final PrintResolution getPrintResolution() {
        return (PrintResolution)this.printResolutionProperty().get();
    }

    public final void setPrintResolution(PrintResolution printResolution) {
        if (printResolution == null || printResolution == this.getPrintResolution()) {
            return;
        }
        this.printResolutionProperty().set(printResolution);
    }

    public final ObjectProperty<PaperSource> paperSourceProperty() {
        if (this.paperSource == null) {
            JobSettings jobSettings = this;
            this.paperSource = new JobSettings$10(jobSettings, jobSettings, "paperSource", this.printerCaps.getDefaultPaperSource());
        }
        return this.paperSource;
    }

    public final PaperSource getPaperSource() {
        return (PaperSource)this.paperSourceProperty().get();
    }

    public final void setPaperSource(PaperSource paperSource) {
        this.paperSourceProperty().set(paperSource);
    }

    public final ObjectProperty<PageLayout> pageLayoutProperty() {
        if (this.layout == null) {
            JobSettings jobSettings = this;
            this.layout = new JobSettings$11(jobSettings, jobSettings, "pageLayout", this.printer.getDefaultPageLayout());
        }
        return this.layout;
    }

    public final PageLayout getPageLayout() {
        return (PageLayout)this.pageLayoutProperty().get();
    }

    public final void setPageLayout(PageLayout pageLayout) {
        this.pageLayoutProperty().set(pageLayout);
    }

    public final String toString() {
        String string = System.lineSeparator();
        return " Collation = " + String.valueOf((Object)this.getCollation()) + string + " Copies = " + this.getCopies() + string + " Sides = " + String.valueOf((Object)this.getPrintSides()) + string + " JobName = " + this.getJobName() + string + " Output file = " + this.getOutputFile() + string + " Page ranges = " + ((ReadOnlyObjectProperty)this.pageRangesProperty()).toString() + string + " Print color = " + String.valueOf((Object)this.getPrintColor()) + string + " Print quality = " + String.valueOf((Object)this.getPrintQuality()) + string + " Print resolution = " + String.valueOf(this.getPrintResolution()) + string + " Paper source = " + String.valueOf(this.getPaperSource()) + string + " Page layout = " + String.valueOf(this.getPageLayout());
    }
}

