/*
 * Decompiled with CFR 0.152.
 */
package javafx.print;

import com.sun.javafx.print.PrinterJobImpl;
import com.sun.javafx.tk.PrintPipeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.print.JobSettings;
import javafx.print.PageLayout;
import javafx.print.Printer;
import javafx.print.PrinterJob$1;
import javafx.print.PrinterJob$JobStatus;
import javafx.scene.Node;
import javafx.stage.Window;

public final class PrinterJob {
    private PrinterJobImpl jobImpl;
    private ObjectProperty<Printer> printer;
    private JobSettings settings;
    private ReadOnlyObjectWrapper<PrinterJob$JobStatus> jobStatus = new ReadOnlyObjectWrapper<PrinterJob$JobStatus>(PrinterJob$JobStatus.NOT_STARTED);

    public static final PrinterJob createPrinterJob() {
        Object object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPrintJobAccess();
        }
        if ((object = Printer.getDefaultPrinter()) == null) {
            return null;
        }
        return new PrinterJob((Printer)object);
    }

    public static final PrinterJob createPrinterJob(Printer printer) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new PrinterJob(printer);
    }

    private PrinterJob(Printer printer) {
        this.printer = this.createPrinterProperty(printer);
        this.settings = printer.getDefaultJobSettings();
        this.settings.setPrinterJob(this);
        this.createImplJob(printer, this.settings);
    }

    private synchronized PrinterJobImpl createImplJob(Printer printer, JobSettings jobSettings) {
        if (this.jobImpl == null) {
            this.jobImpl = PrintPipeline.getPrintPipeline().createPrinterJob(this);
        }
        return this.jobImpl;
    }

    final boolean isJobNew() {
        return this.getJobStatus() == PrinterJob$JobStatus.NOT_STARTED;
    }

    private ObjectProperty<Printer> createPrinterProperty(Printer printer) {
        return new PrinterJob$1(this, printer);
    }

    public final ObjectProperty<Printer> printerProperty() {
        return this.printer;
    }

    public final synchronized Printer getPrinter() {
        return (Printer)this.printerProperty().get();
    }

    public final synchronized void setPrinter(Printer printer) {
        this.printerProperty().set(printer);
    }

    public final synchronized JobSettings getJobSettings() {
        return this.settings;
    }

    public final synchronized boolean showPrintDialog(Window window) {
        if (!this.isJobNew()) {
            return false;
        }
        return this.jobImpl.showPrintDialog(window);
    }

    public final synchronized boolean showPageSetupDialog(Window window) {
        if (!this.isJobNew()) {
            return false;
        }
        return this.jobImpl.showPageDialog(window);
    }

    final synchronized PageLayout validatePageLayout(PageLayout pageLayout) {
        if (pageLayout == null) {
            throw new NullPointerException("pageLayout cannot be null");
        }
        return this.jobImpl.validatePageLayout(pageLayout);
    }

    public final synchronized boolean printPage(PageLayout pageLayout, Node node) {
        if (((PrinterJob$JobStatus)((Object)this.jobStatus.get())).ordinal() > PrinterJob$JobStatus.PRINTING.ordinal()) {
            return false;
        }
        if (this.jobStatus.get() == PrinterJob$JobStatus.NOT_STARTED) {
            this.jobStatus.set(PrinterJob$JobStatus.PRINTING);
        }
        if (pageLayout == null || node == null) {
            this.jobStatus.set(PrinterJob$JobStatus.ERROR);
            throw new NullPointerException("Parameters cannot be null");
        }
        boolean bl2 = this.jobImpl.print(pageLayout, node);
        if (!bl2) {
            this.jobStatus.set(PrinterJob$JobStatus.ERROR);
        }
        return bl2;
    }

    public final synchronized boolean printPage(Node node) {
        PrinterJob printerJob = this;
        return printerJob.printPage(printerJob.settings.getPageLayout(), node);
    }

    public final ReadOnlyObjectProperty<PrinterJob$JobStatus> jobStatusProperty() {
        return this.jobStatus.getReadOnlyProperty();
    }

    public final PrinterJob$JobStatus getJobStatus() {
        return (PrinterJob$JobStatus)((Object)this.jobStatus.get());
    }

    public final void cancelJob() {
        if (((PrinterJob$JobStatus)((Object)this.jobStatus.get())).ordinal() <= PrinterJob$JobStatus.PRINTING.ordinal()) {
            this.jobStatus.set(PrinterJob$JobStatus.CANCELED);
            this.jobImpl.cancelJob();
        }
    }

    public final synchronized boolean endJob() {
        if (this.jobStatus.get() == PrinterJob$JobStatus.NOT_STARTED) {
            this.cancelJob();
            return false;
        }
        if (this.jobStatus.get() == PrinterJob$JobStatus.PRINTING) {
            boolean bl2 = this.jobImpl.endJob();
            this.jobStatus.set(bl2 ? PrinterJob$JobStatus.DONE : PrinterJob$JobStatus.ERROR);
            return bl2;
        }
        return false;
    }

    public final String toString() {
        return "JavaFX PrinterJob " + String.valueOf(this.getPrinter()) + "\n" + String.valueOf(this.getJobSettings()) + "\nJob Status = " + String.valueOf((Object)this.getJobStatus());
    }
}

