/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.css.CalculatedValue;
import com.sun.javafx.css.CascadingStyle;
import com.sun.javafx.css.ParsedValueImpl;
import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.css.StyleCache;
import com.sun.javafx.css.StyleCacheEntry;
import com.sun.javafx.css.StyleCacheEntry$Key;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleMap;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.CssParser$ParseError;
import javafx.css.CssParser$ParseError$PropertySetError;
import javafx.css.ParsedValue;
import javafx.css.PseudoClass;
import javafx.css.Rule;
import javafx.css.Selector;
import javafx.css.Style;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.Stylesheet;
import javafx.css.converter.FontConverter;
import javafx.scene.CssStyleHelper$1;
import javafx.scene.CssStyleHelper$CacheContainer;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

final class CssStyleHelper {
    private static final PlatformLogger LOGGER = Logging.getCSSLogger();
    private static final WeakReference<Node> EMPTY_NODE = new WeakReference<Object>(null);
    private WeakReference<Node> firstStyleableAncestor = EMPTY_NODE;
    private CssStyleHelper$CacheContainer cacheContainer;
    private boolean resetInProgress = false;
    private PseudoClassState triggerStates = new PseudoClassState();
    private boolean transitionStateInProgress = false;
    private static final Set<PseudoClass> NULL_PSEUDO_CLASS_STATE = null;
    private static final CssMetaData dummyFontProperty = new CssStyleHelper$1("-fx-font", Font.getDefault());

    private CssStyleHelper() {
    }

    static CssStyleHelper createStyleHelper(Node pseudoClassStateArray) {
        PseudoClassState[] pseudoClassStateArray2;
        int n2 = 0;
        for (pseudoClassStateArray2 = pseudoClassStateArray; pseudoClassStateArray2 != null; pseudoClassStateArray2 = pseudoClassStateArray2.getStyleableParent()) {
            ++n2;
        }
        pseudoClassStateArray2 = new PseudoClassState[n2];
        StyleMap styleMap = StyleManager.getInstance().findMatchingStyles((Node)pseudoClassStateArray, pseudoClassStateArray.getSubScene(), pseudoClassStateArray2);
        if (CssStyleHelper.canReuseStyleHelper((Node)pseudoClassStateArray, styleMap)) {
            if (pseudoClassStateArray.styleHelper.cacheContainer != null && pseudoClassStateArray.styleHelper.isUserSetFont((Styleable)pseudoClassStateArray)) {
                pseudoClassStateArray.styleHelper.cacheContainer.fontSizeCache.clear();
            }
            pseudoClassStateArray.styleHelper.cacheContainer.forceSlowpath = true;
            if (pseudoClassStateArray2[0] != null) {
                pseudoClassStateArray.styleHelper.triggerStates.addAll((Collection)pseudoClassStateArray2[0]);
            }
            CssStyleHelper.updateParentTriggerStates((Styleable)pseudoClassStateArray, n2, pseudoClassStateArray2);
            return pseudoClassStateArray.styleHelper;
        }
        if (styleMap == null || styleMap.isEmpty()) {
            boolean bl2 = false;
            List<CssMetaData<Styleable, ?>> list = pseudoClassStateArray.getCssMetaData();
            int n3 = list != null ? list.size() : 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                CssMetaData<Styleable, ?> cssMetaData = list.get(i2);
                if (!cssMetaData.isInherits()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                if (pseudoClassStateArray.styleHelper != null) {
                    pseudoClassStateArray.styleHelper.resetToInitialValues((Styleable)pseudoClassStateArray);
                }
                return null;
            }
        }
        CssStyleHelper cssStyleHelper = new CssStyleHelper();
        if (pseudoClassStateArray2[0] != null) {
            cssStyleHelper.triggerStates.addAll((Collection)pseudoClassStateArray2[0]);
        }
        CssStyleHelper.updateParentTriggerStates((Styleable)pseudoClassStateArray, n2, pseudoClassStateArray2);
        cssStyleHelper.cacheContainer = new CssStyleHelper$CacheContainer((Node)pseudoClassStateArray, styleMap, n2);
        cssStyleHelper.firstStyleableAncestor = new WeakReference<Node>(CssStyleHelper.findFirstStyleableAncestor((Styleable)pseudoClassStateArray));
        if (pseudoClassStateArray.styleHelper != null) {
            pseudoClassStateArray.styleHelper.resetToInitialValues((Styleable)pseudoClassStateArray);
        }
        return cssStyleHelper;
    }

    private static void updateParentTriggerStates(Styleable styleable, int n2, PseudoClassState[] pseudoClassStateArray) {
        styleable = styleable.getStyleableParent();
        for (int i2 = 1; i2 < n2; ++i2) {
            if (styleable instanceof Node) {
                Node node = (Node)styleable;
                PseudoClassState pseudoClassState = pseudoClassStateArray[i2];
                if (pseudoClassState != null && pseudoClassState.size() > 0) {
                    if (node.styleHelper == null) {
                        node.styleHelper = new CssStyleHelper();
                        node.styleHelper.firstStyleableAncestor = new WeakReference<Node>(CssStyleHelper.findFirstStyleableAncestor(node));
                    }
                    node.styleHelper.triggerStates.addAll((Collection)pseudoClassState);
                }
            }
            styleable = styleable.getStyleableParent();
        }
    }

    private boolean isUserSetFont(Styleable object) {
        while (true) {
            if (object == null) {
                return false;
            }
            Object object2 = ((CssStyleHelper)object3).cacheContainer != null ? ((CssStyleHelper)object3).cacheContainer.fontProp : null;
            if (object2 != null && (object = object2 != null ? ((CssMetaData)object2).getStyleableProperty((Styleable)object) : null) != null && object.getStyleOrigin() == StyleOrigin.USER) {
                return true;
            }
            object = (Styleable)((CssStyleHelper)object3).firstStyleableAncestor.get();
            object2 = CssStyleHelper.getStyleHelper((Node)((CssStyleHelper)object3).firstStyleableAncestor.get());
            if (object2 == null) break;
            Object object3 = object2;
        }
        return false;
    }

    private static CssStyleHelper getStyleHelper(Node node) {
        if (node != null) {
            return node.styleHelper;
        }
        return null;
    }

    private static Node findFirstStyleableAncestor(Styleable styleable) {
        Node node = null;
        for (styleable = styleable.getStyleableParent(); styleable != null; styleable = styleable.getStyleableParent()) {
            if (!(styleable instanceof Node) || ((Node)styleable).styleHelper == null) continue;
            node = (Node)styleable;
            break;
        }
        return node;
    }

    private static boolean isTrue(WritableValue<Boolean> writableValue) {
        return writableValue != null && writableValue.getValue() != false;
    }

    private static void setTrue(WritableValue<Boolean> writableValue) {
        if (writableValue != null) {
            writableValue.setValue(Boolean.TRUE);
        }
    }

    private static boolean canReuseStyleHelper(Node object, StyleMap object2) {
        if (object == null || ((Node)object).styleHelper == null) {
            return false;
        }
        if (object2 == null) {
            return false;
        }
        StyleMap styleMap = ((Node)object).styleHelper.getStyleMap((Styleable)object);
        if (styleMap != object2) {
            return false;
        }
        ((Node)object).styleHelper.firstStyleableAncestor = new WeakReference<Node>(CssStyleHelper.findFirstStyleableAncestor((Styleable)object));
        if (((Node)object).styleHelper.cacheContainer == null) {
            return true;
        }
        object2 = ((Node)object).getStyleableParent();
        if (object2 == null) {
            return true;
        }
        object2 = CssStyleHelper.getStyleHelper((Node)((Node)object).styleHelper.firstStyleableAncestor.get());
        if (object2 != null && ((CssStyleHelper)object2).cacheContainer != null && ((Object)(object2 = (Object)((CssStyleHelper)object2).cacheContainer.styleCacheKey.getStyleMapIds())).length == ((Object)(object = (Object)((Node)object).styleHelper.cacheContainer.styleCacheKey.getStyleMapIds())).length - 1) {
            boolean bl2 = true;
            for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
                if (object[i2 + 1] == object2[i2]) continue;
                bl2 = false;
                break;
            }
            return bl2;
        }
        return false;
    }

    private void resetToInitialValues(Styleable styleable) {
        if (this.cacheContainer == null || this.cacheContainer.cssSetProperties == null || this.cacheContainer.cssSetProperties.isEmpty()) {
            return;
        }
        this.resetInProgress = true;
        Object object = new HashSet<Map.Entry<CssMetaData, CalculatedValue>>(this.cacheContainer.cssSetProperties.entrySet());
        this.cacheContainer.cssSetProperties.clear();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Map.Entry)object.next();
            Object object3 = (CssMetaData)object2.getKey();
            StyleOrigin styleOrigin = (object3 = ((CssMetaData)object3).getStyleableProperty(styleable)).getStyleOrigin();
            if (styleOrigin == null || styleOrigin == StyleOrigin.USER) continue;
            object2 = (CalculatedValue)object2.getValue();
            object3.applyStyle(((CalculatedValue)object2).getOrigin(), ((CalculatedValue)object2).getValue());
        }
        this.resetInProgress = false;
    }

    private StyleMap getStyleMap(Styleable styleable) {
        if (this.cacheContainer == null || styleable == null) {
            return null;
        }
        return this.cacheContainer.getStyleMap(styleable);
    }

    final boolean pseudoClassStateChanged(PseudoClass pseudoClass) {
        return this.triggerStates.contains(pseudoClass);
    }

    private Set<PseudoClass>[] getTransitionStates(Node object) {
        Object object2;
        if (this.cacheContainer == null) {
            return null;
        }
        int n2 = 0;
        for (object2 = object; object2 != null; object2 = object2.getParent()) {
            ++n2;
        }
        PseudoClassState[] pseudoClassStateArray = new PseudoClassState[n2];
        int n3 = 0;
        for (object2 = object; object2 != null; object2 = object2.getParent()) {
            object = object2 instanceof Node ? object2.styleHelper : null;
            if (object == null) continue;
            ObservableSet<PseudoClass> observableSet = object2.pseudoClassStates;
            pseudoClassStateArray[n3] = new PseudoClassState();
            pseudoClassStateArray[n3].addAll(observableSet);
            pseudoClassStateArray[n3].retainAll(object.triggerStates);
            ++n3;
        }
        object = new PseudoClassState[n3];
        System.arraycopy(pseudoClassStateArray, 0, object, 0, n3);
        return object;
    }

    final void recalculateRelativeSizeProperties(Node node, Font object) {
        if (this.transitionStateInProgress || this.resetInProgress) {
            return;
        }
        if (this.cacheContainer == null) {
            return;
        }
        StyleMap styleMap = this.getStyleMap(node);
        if (styleMap == null) {
            return;
        }
        boolean bl2 = styleMap.isEmpty();
        Set<PseudoClass>[] setArray = this.getTransitionStates(node);
        object = new CalculatedValue(object, null, false);
        List<CssMetaData<Styleable, ?>> list = node.getCssMetaData();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            Object object2;
            Object object3;
            boolean bl3;
            Object object4;
            Object object5;
            boolean bl4;
            CssMetaData<Styleable, ?> cssMetaData = list.get(i2);
            if (bl2 && !cssMetaData.isInherits() || !cssMetaData.isSettable(node) || (bl4 = ((String)(object5 = cssMetaData.getProperty())).equals("-fx-font") || ((String)object5).equals("-fx-font-size")) || !((object4 = this.getStyle(node, (String)object5, styleMap, setArray[0])) != null ? (bl3 = ParsedValueImpl.containsFontRelativeSize((ParsedValue)(object3 = this.resolveLookups(node, (ParsedValue)(object2 = ((CascadingStyle)object4).getParsedValue()), styleMap, setArray[0], (ObjectProperty<StyleOrigin>)(object4 = new SimpleObjectProperty<StyleOrigin>(((CascadingStyle)object4).getOrigin())), new HashSet<ParsedValue>())), false)) : (n3 = (object2 = cssMetaData.getSubProperties()) != null ? object2.size() : 0) != 0) || (object2 = this.lookup(node, cssMetaData, styleMap, setArray[0], node, (CalculatedValue)object)) == null || object2 == CalculatedValue.SKIP) continue;
            try {
                StyleableProperty<?> styleableProperty = cssMetaData.getStyleableProperty(node);
                object3 = styleableProperty.getStyleOrigin();
                StyleOrigin styleOrigin = ((CalculatedValue)object2).getOrigin();
                if (styleOrigin == null || object3 == StyleOrigin.USER && styleOrigin == StyleOrigin.USER_AGENT) continue;
                object2 = ((CalculatedValue)object2).getValue();
                Object t2 = styleableProperty.getValue();
                if (object3 == styleOrigin && !(t2 != null ? !t2.equals(object2) : object2 != null)) continue;
                if (LOGGER.isLoggable(PlatformLogger$Level.FINER)) {
                    LOGGER.finer((String)object5 + ", call applyStyle: " + String.valueOf(styleableProperty) + ", value =" + String.valueOf(object2) + ", originOfCalculatedValue=" + String.valueOf((Object)styleOrigin));
                }
                styleableProperty.applyStyle(styleOrigin, object2);
                object5 = new CalculatedValue(t2, (StyleOrigin)((Object)object3), true);
                this.cacheContainer.cssSetProperties.put(cssMetaData, (CalculatedValue)object5);
                continue;
            }
            catch (Exception exception) {
                object3 = cssMetaData.getStyleableProperty(node);
                String string = String.format("Failed to recalculate and set css [%s] on [%s] due to '%s'\n", cssMetaData.getProperty(), object3, exception.getMessage());
                object2 = Logging.getCSSLogger();
                if (!((PlatformLogger)object2).isLoggable(PlatformLogger$Level.WARNING)) continue;
                ((PlatformLogger)object2).warning(string);
            }
        }
    }

    final void transitionToState(Node node) {
        boolean bl2;
        if (this.cacheContainer == null) {
            return;
        }
        StyleMap styleMap = this.getStyleMap(node);
        if (styleMap == null) {
            this.cacheContainer = null;
            node.reapplyCSS();
            return;
        }
        boolean bl3 = styleMap.isEmpty();
        Node node2 = node;
        Object object = StyleManager.getInstance().getSharedCache(node2, node2.getSubScene(), this.cacheContainer.styleCacheKey);
        if (object == null) {
            this.cacheContainer = null;
            node.reapplyCSS();
            return;
        }
        Set<PseudoClass>[] setArray = this.getTransitionStates(node);
        Object object2 = new StyleCacheEntry$Key(setArray, Font.getDefault());
        CalculatedValue calculatedValue = this.cacheContainer.fontSizeCache.get(object2);
        if (calculatedValue == null) {
            if ((calculatedValue = this.lookupFont(node, "-fx-font", styleMap, calculatedValue)) == CalculatedValue.SKIP) {
                calculatedValue = this.getCachedFont(node.getStyleableParent());
            }
            if (calculatedValue == null) {
                calculatedValue = new CalculatedValue(Font.getDefault(), null, false);
            }
            this.cacheContainer.fontSizeCache.put((StyleCacheEntry$Key)object2, calculatedValue);
        }
        object2 = (Font)calculatedValue.getValue();
        StyleCacheEntry styleCacheEntry = ((StyleCache)object).getStyleCacheEntry((StyleCacheEntry$Key)(object2 = new StyleCacheEntry$Key(setArray, (Font)object2)));
        boolean bl4 = bl2 = styleCacheEntry != null;
        if (styleCacheEntry == null) {
            styleCacheEntry = new StyleCacheEntry();
            ((StyleCache)object).addStyleCacheEntry((StyleCacheEntry$Key)object2, styleCacheEntry);
        }
        object = node.getCssMetaData();
        int n2 = object.size();
        boolean bl5 = this.cacheContainer.forceSlowpath;
        this.cacheContainer.forceSlowpath = false;
        this.transitionStateInProgress = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object3;
            Object object4;
            boolean bl6;
            CssMetaData cssMetaData = (CssMetaData)object.get(i2);
            if (bl3 && !cssMetaData.isInherits() || !cssMetaData.isSettable(node)) continue;
            Object object5 = cssMetaData.getProperty();
            Object object6 = styleCacheEntry.get((String)object5);
            boolean bl7 = bl2 && object6 == null && bl5;
            boolean bl8 = bl6 = !bl2 && object6 == null || bl7;
            if (bl2 && !bl7) {
                if (object6 == CalculatedValue.SKIP) {
                    continue;
                }
            } else if (object6 == null && (object6 = this.lookup(node, cssMetaData, styleMap, setArray[0], node, calculatedValue)) == null) {
                assert (false) : "lookup returned null for " + (String)object5;
                continue;
            }
            try {
                if (object6 == null || object6 == CalculatedValue.SKIP) {
                    StyleableProperty styleableProperty;
                    CalculatedValue calculatedValue2 = this.cacheContainer.cssSetProperties.get(cssMetaData);
                    if (calculatedValue2 == null || (styleableProperty = cssMetaData.getStyleableProperty(node)).getStyleOrigin() == StyleOrigin.USER) continue;
                    styleableProperty.applyStyle(calculatedValue2.getOrigin(), calculatedValue2.getValue());
                    continue;
                }
                if (bl6) {
                    styleCacheEntry.put((String)object5, (CalculatedValue)object6);
                }
                StyleableProperty styleableProperty = cssMetaData.getStyleableProperty(node);
                StyleOrigin styleOrigin = styleableProperty.getStyleOrigin();
                object4 = ((CalculatedValue)object6).getOrigin();
                if (object4 == null) {
                    assert (false) : styleableProperty.toString();
                    continue;
                }
                if (styleOrigin == StyleOrigin.USER && object4 == StyleOrigin.USER_AGENT) continue;
                object6 = ((CalculatedValue)object6).getValue();
                object3 = styleableProperty.getValue();
                if (styleOrigin == object4 && !(object3 != null ? !object3.equals(object6) : object6 != null)) continue;
                if (LOGGER.isLoggable(PlatformLogger$Level.FINER)) {
                    LOGGER.finer((String)object5 + ", call applyStyle: " + String.valueOf(styleableProperty) + ", value =" + String.valueOf(object6) + ", originOfCalculatedValue=" + String.valueOf(object4));
                }
                styleableProperty.applyStyle((StyleOrigin)((Object)object4), object6);
                if (this.cacheContainer.cssSetProperties.containsKey(cssMetaData)) continue;
                object6 = new CalculatedValue(object3, styleOrigin, false);
                this.cacheContainer.cssSetProperties.put(cssMetaData, (CalculatedValue)object6);
                continue;
            }
            catch (Exception exception) {
                StyleableProperty styleableProperty = cssMetaData.getStyleableProperty(node);
                object4 = String.format("Failed to set css [%s] on [%s] due to '%s'\n", cssMetaData.getProperty(), styleableProperty, exception.getMessage());
                object6 = StyleManager.getErrors();
                if (object6 != null) {
                    object3 = new CssParser$ParseError$PropertySetError(cssMetaData, node, (String)object4);
                    object6.add((CssParser$ParseError)object3);
                }
                if (((PlatformLogger)(object3 = Logging.getCSSLogger())).isLoggable(PlatformLogger$Level.WARNING)) {
                    ((PlatformLogger)object3).warning((String)object4);
                }
                styleCacheEntry.put((String)object5, CalculatedValue.SKIP);
                object6 = null;
                if (this.cacheContainer != null && this.cacheContainer.cssSetProperties != null) {
                    object6 = this.cacheContainer.cssSetProperties.get(cssMetaData);
                }
                object5 = object6 != null ? ((CalculatedValue)object6).getValue() : cssMetaData.getInitialValue(node);
                object6 = object6 != null ? ((CalculatedValue)object6).getOrigin() : null;
                try {
                    styleableProperty.applyStyle((StyleOrigin)((Object)object6), object5);
                    continue;
                }
                catch (Exception exception2) {
                    if (!((PlatformLogger)object3).isLoggable(PlatformLogger$Level.SEVERE)) continue;
                    ((PlatformLogger)object3).severe(String.format("Could not reset [%s] on [%s] due to %s\n", cssMetaData.getProperty(), styleableProperty, exception.getMessage()));
                }
            }
        }
        this.transitionStateInProgress = false;
    }

    private CascadingStyle getStyle(Styleable styleable, String object, StyleMap object2, Set<PseudoClass> set) {
        if (object2 == null || ((StyleMap)object2).isEmpty()) {
            return null;
        }
        if ((object2 = ((StyleMap)object2).getCascadingStyles()) == null || object2.isEmpty()) {
            return null;
        }
        if ((object = (List)object2.get(object)) == null || object.isEmpty()) {
            return null;
        }
        object2 = null;
        int n2 = object == null ? 0 : object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CascadingStyle cascadingStyle = (CascadingStyle)object.get(i2);
            Selector selector = cascadingStyle == null ? null : cascadingStyle.getSelector();
            if (selector == null || !selector.stateMatches(styleable, set)) continue;
            object2 = cascadingStyle;
            break;
        }
        return object2;
    }

    private CalculatedValue lookup(Styleable styleable, CssMetaData cssMetaData, StyleMap object, Set<PseudoClass> set, Styleable styleable2, CalculatedValue calculatedValue) {
        int n2;
        if (cssMetaData.getConverter() == FontConverter.getInstance()) {
            return this.lookupFont(styleable, cssMetaData.getProperty(), (StyleMap)object, calculatedValue);
        }
        Object object2 = cssMetaData.getProperty();
        CascadingStyle cascadingStyle = this.getStyle(styleable, (String)object2, (StyleMap)object, set);
        List<CssMetaData<Styleable, ?>> list = cssMetaData.getSubProperties();
        int n3 = n2 = list != null ? list.size() : 0;
        if (cascadingStyle == null) {
            Object object3;
            CssMetaData<Styleable, ?> cssMetaData2;
            if (n2 == 0) {
                return this.handleNoStyleFound(styleable, cssMetaData, (StyleMap)object, set, styleable2, calculatedValue);
            }
            HashMap<Object, Object> hashMap = null;
            object2 = null;
            boolean bl2 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                cssMetaData2 = list.get(i2);
                object3 = this.lookup(styleable, cssMetaData2, (StyleMap)object, set, styleable2, calculatedValue);
                if (object3 == CalculatedValue.SKIP) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<Object, Object>();
                }
                hashMap.put(cssMetaData2, ((CalculatedValue)object3).getValue());
                if (object2 != null && ((CalculatedValue)object3).getOrigin() != null ? ((Enum)object2).compareTo(((CalculatedValue)object3).getOrigin()) < 0 : ((CalculatedValue)object3).getOrigin() != null) {
                    object2 = ((CalculatedValue)object3).getOrigin();
                }
                bl2 = bl2 || ((CalculatedValue)object3).isRelative();
            }
            if (hashMap == null || hashMap.isEmpty()) {
                return this.handleNoStyleFound(styleable, cssMetaData, (StyleMap)object, set, styleable2, calculatedValue);
            }
            try {
                StyleConverter styleConverter = cssMetaData.getConverter();
                cssMetaData2 = styleConverter.convert(hashMap);
                return new CalculatedValue(cssMetaData2, (StyleOrigin)((Object)object2), bl2);
            }
            catch (ClassCastException classCastException) {
                cssMetaData2 = this.formatExceptionMessage(styleable, cssMetaData, null, classCastException);
                object3 = StyleManager.getErrors();
                if (object3 != null) {
                    object = new CssParser$ParseError$PropertySetError(cssMetaData, styleable, (String)((Object)cssMetaData2));
                    object3.add(object);
                }
                if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                    LOGGER.warning((String)((Object)cssMetaData2));
                    LOGGER.fine("caught: ", classCastException);
                    LOGGER.fine("styleable = " + String.valueOf(cssMetaData));
                    LOGGER.fine("node = " + styleable.toString());
                }
                return CalculatedValue.SKIP;
            }
        }
        ParsedValue parsedValue = cascadingStyle.getParsedValue();
        if (parsedValue != null && "inherit".equals(parsedValue.getValue()) && (cascadingStyle = this.getInheritedStyle(styleable, (String)object2)) == null) {
            return CalculatedValue.SKIP;
        }
        return this.calculateValue(cascadingStyle, styleable, cssMetaData, (StyleMap)object, set, styleable2, calculatedValue);
    }

    private CalculatedValue handleNoStyleFound(Styleable object, CssMetaData cssMetaData, StyleMap styleMap, Set<PseudoClass> set, Styleable styleable, CalculatedValue calculatedValue) {
        if (cssMetaData.isInherits()) {
            Object object2 = cssMetaData.getStyleableProperty(object);
            object2 = object2 != null ? object2.getStyleOrigin() : null;
            if (object2 == StyleOrigin.USER) {
                return CalculatedValue.SKIP;
            }
            object2 = this.getInheritedStyle((Styleable)object, cssMetaData.getProperty());
            if (object2 == null) {
                return CalculatedValue.SKIP;
            }
            object = this.calculateValue((CascadingStyle)object2, (Styleable)object, cssMetaData, styleMap, set, styleable, calculatedValue);
            return object;
        }
        return CalculatedValue.SKIP;
    }

    private CascadingStyle getInheritedStyle(Styleable styleable, String string) {
        block1: {
            Object object;
            Object object2;
            do {
                ObservableSet<PseudoClass> observableSet;
                styleable = (Styleable)((Node)styleable).styleHelper.firstStyleableAncestor.get();
                object = CssStyleHelper.getStyleHelper((Node)styleable);
                if (styleable == null || object == null || (object = ((CssStyleHelper)object).getStyle(styleable, string, (StyleMap)(object2 = ((CssStyleHelper)object).getStyleMap(styleable)), observableSet = ((Node)styleable).pseudoClassStates)) == null) break block1;
            } while ("inherit".equals(((ParsedValue)(object2 = ((CascadingStyle)object).getParsedValue())).getValue()));
            return object;
        }
        return null;
    }

    private CascadingStyle resolveRef(Styleable object, String string, StyleMap object2, Set<PseudoClass> object3) {
        Object object4;
        while ((object4 = ((CssStyleHelper)object7).getStyle((Styleable)object, string, (StyleMap)object2, (Set<PseudoClass>)object3)) == null) {
            if (object3 != null && object3.size() > 0) {
                object3 = NULL_PSEUDO_CLASS_STATE;
                continue;
            }
            object2 = (Styleable)((Node)object).styleHelper.firstStyleableAncestor.get();
            object3 = CssStyleHelper.getStyleHelper((Node)object2);
            if (object2 == null || object3 == null) {
                return null;
            }
            object4 = ((CssStyleHelper)object3).getStyleMap((Styleable)object2);
            object = object2 instanceof Node ? ((Node)object2).pseudoClassStates : object.getPseudoClassStates();
            Object object5 = object3;
            Object object6 = object2;
            object3 = object;
            object2 = object4;
            object = object6;
            Object object7 = object5;
        }
        return object4;
    }

    private ParsedValue resolveLookups(Styleable object, ParsedValue parsedValue, StyleMap styleMap, Set<PseudoClass> set, ObjectProperty<StyleOrigin> objectProperty, Set<ParsedValue> set2) {
        Object object2;
        Object object3;
        if (parsedValue.isLookup() && (object3 = parsedValue.getValue()) instanceof String && (object2 = this.resolveRef((Styleable)object, (String)(object3 = ((String)object3).toLowerCase(Locale.ROOT)), styleMap, set)) != null) {
            if (set2.contains(((CascadingStyle)object2).getParsedValue())) {
                if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                    LOGGER.warning("Loop detected in " + ((CascadingStyle)object2).getRule().toString() + " while resolving '" + object3 + "'");
                }
                throw new IllegalArgumentException("Loop detected in " + ((CascadingStyle)object2).getRule().toString() + " while resolving '" + object3 + "'");
            }
            set2.add(parsedValue);
            StyleOrigin styleOrigin = (StyleOrigin)((Object)objectProperty.get());
            StyleOrigin styleOrigin2 = ((CascadingStyle)object2).getOrigin();
            if (styleOrigin2 != null && (styleOrigin == null || styleOrigin.compareTo(styleOrigin2) < 0)) {
                objectProperty.set(styleOrigin2);
            }
            object = this.resolveLookups((Styleable)object, ((CascadingStyle)object2).getParsedValue(), styleMap, set, objectProperty, set2);
            if (set2 != null) {
                set2.remove(parsedValue);
            }
            return object;
        }
        if (!parsedValue.isContainsLookups()) {
            return parsedValue;
        }
        object3 = parsedValue.getValue();
        if (object3 instanceof ParsedValue[][]) {
            object3 = (ParsedValue[][])object3;
            object2 = new ParsedValue[((ParsedValue[][])object3).length][0];
            for (int i2 = 0; i2 < ((V)object3).length; ++i2) {
                object2[i2] = new ParsedValue[((V)object3[i2]).length];
                for (int i3 = 0; i3 < ((V)object3[i2]).length; ++i3) {
                    if (object3[i2][i3] == null) continue;
                    object2[i2][i3] = this.resolveLookups((Styleable)object, (ParsedValue)object3[i2][i3], styleMap, set, objectProperty, set2);
                }
            }
            set2.clear();
            return new ParsedValueImpl(object2, parsedValue.getConverter(), false);
        }
        if (object3 instanceof ParsedValueImpl[]) {
            object3 = (ParsedValue[])object3;
            object2 = new ParsedValue[((ParsedValue[])object3).length];
            for (int i4 = 0; i4 < ((V)object3).length; ++i4) {
                if (object3[i4] == null) continue;
                object2[i4] = this.resolveLookups((Styleable)object, (ParsedValue)object3[i4], styleMap, set, objectProperty, set2);
            }
            set2.clear();
            return new ParsedValueImpl(object2, parsedValue.getConverter(), false);
        }
        return parsedValue;
    }

    private String getUnresolvedLookup(ParsedValue parsedValueArray) {
        block5: {
            Object v2;
            block4: {
                v2 = parsedValueArray.getValue();
                if (parsedValueArray.isLookup() && v2 instanceof String) {
                    return (String)v2;
                }
                if (!(v2 instanceof ParsedValue[][])) break block4;
                parsedValueArray = (ParsedValue[][])v2;
                for (int i2 = 0; i2 < parsedValueArray.length; ++i2) {
                    for (int i3 = 0; i3 < parsedValueArray[i2].length; ++i3) {
                        String string;
                        if (parsedValueArray[i2][i3] == null || (string = this.getUnresolvedLookup(parsedValueArray[i2][i3])) == null) continue;
                        return string;
                    }
                }
                break block5;
            }
            if (!(v2 instanceof ParsedValue[])) break block5;
            parsedValueArray = (ParsedValue[])v2;
            for (int i4 = 0; i4 < parsedValueArray.length; ++i4) {
                String string;
                if (parsedValueArray[i4] == null || (string = this.getUnresolvedLookup((ParsedValue)parsedValueArray[i4])) == null) continue;
                return string;
            }
        }
        return null;
    }

    private String formatUnresolvedLookupMessage(Styleable styleable, CssMetaData object, Style style, ParsedValue object2, ClassCastException classCastException) {
        object2 = object2 != null && ((ParsedValue)object2).isContainsLookups() ? this.getUnresolvedLookup((ParsedValue)object2) : null;
        StringBuilder stringBuilder = new StringBuilder();
        if (object2 != null) {
            stringBuilder.append("Could not resolve '").append((String)object2).append("' while resolving lookups for '").append(((CssMetaData)object).getProperty()).append("'");
        } else {
            stringBuilder.append("Caught '").append(classCastException).append("' while converting value for '").append(((CssMetaData)object).getProperty()).append("'");
        }
        object = style != null ? style.getDeclaration().getRule() : null;
        object = object != null ? ((Rule)object).getStylesheet() : null;
        object2 = object != null ? ((Stylesheet)object).getUrl() : null;
        if (object2 != null) {
            stringBuilder.append(" from rule '").append(style.getSelector()).append("' in stylesheet ").append((String)object2);
        } else if (object != null && StyleOrigin.INLINE == ((Stylesheet)object).getOrigin()) {
            stringBuilder.append(" from inline style on ").append(styleable.toString());
        }
        return stringBuilder.toString();
    }

    private String formatExceptionMessage(Styleable styleable, CssMetaData object, Style style, Exception object2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Caught ").append(String.valueOf(object2));
        if (object != null) {
            stringBuilder.append("' while calculating value for '").append(((CssMetaData)object).getProperty()).append("'");
        }
        if (style != null) {
            object = style.getDeclaration().getRule();
            object = object != null ? ((Rule)object).getStylesheet() : null;
            object2 = object != null ? ((Stylesheet)object).getUrl() : null;
            if (object2 != null) {
                stringBuilder.append(" from rule '").append(style.getSelector()).append("' in stylesheet ").append((String)object2);
            } else if (styleable != null && object != null && StyleOrigin.INLINE == ((Stylesheet)object).getOrigin()) {
                stringBuilder.append(" from inline style on ").append(styleable.toString());
            } else {
                stringBuilder.append(" from style '").append(String.valueOf(style)).append("'");
            }
        }
        return stringBuilder.toString();
    }

    private CalculatedValue calculateValue(CascadingStyle cascadingStyle, Styleable styleable, CssMetaData cssMetaData, StyleMap object, Set<PseudoClass> object2, Styleable object3, CalculatedValue calculatedValue) {
        object3 = cascadingStyle.getParsedValue();
        if (object3 != null && !"null".equals(((ParsedValue)object3).getValue()) && !"none".equals(((ParsedValue)object3).getValue())) {
            ParsedValueImpl parsedValueImpl = null;
            try {
                Object object4;
                Object object5;
                SimpleObjectProperty<StyleOrigin> simpleObjectProperty = new SimpleObjectProperty<StyleOrigin>(cascadingStyle.getOrigin());
                parsedValueImpl = this.resolveLookups(styleable, (ParsedValue)object3, (StyleMap)object, (Set<PseudoClass>)object2, (ObjectProperty<StyleOrigin>)simpleObjectProperty, (Set<ParsedValue>)new HashSet<ParsedValue>());
                object = cssMetaData.getProperty();
                boolean bl2 = "-fx-font".equals(object) || "-fx-font-size".equals(object);
                boolean bl3 = ParsedValueImpl.containsFontRelativeSize(parsedValueImpl, bl2);
                object2 = null;
                if (bl3 && bl2 && (calculatedValue == null || calculatedValue.isRelative())) {
                    object5 = styleable;
                    object4 = calculatedValue;
                    do {
                        CalculatedValue calculatedValue2;
                        if ((calculatedValue2 = this.getCachedFont(object5.getStyleableParent())) == null) continue;
                        if (calculatedValue2.isRelative()) {
                            if (object4 == null || calculatedValue2.equals(object4)) {
                                object4 = calculatedValue2;
                                continue;
                            }
                            object2 = (Font)calculatedValue2.getValue();
                            continue;
                        }
                        object2 = (Font)calculatedValue2.getValue();
                    } while (object2 == null && (object5 = object5.getStyleableParent()) != null);
                }
                if (object2 == null) {
                    object2 = calculatedValue != null && (!calculatedValue.isRelative() || !bl2) ? (Font)calculatedValue.getValue() : Font.getDefault();
                }
                if ((object5 = cssMetaData.getConverter()) == StyleConverter.getInsetsConverter()) {
                    if (parsedValueImpl.getValue() instanceof ParsedValue) {
                        parsedValueImpl = new ParsedValueImpl(new ParsedValue[]{(ParsedValue)parsedValueImpl.getValue()}, null, false);
                    }
                    object2 = ((StyleConverter)object5).convert(parsedValueImpl, (Font)object2);
                } else {
                    object2 = parsedValueImpl.getConverter() != null ? ((ParsedValue)parsedValueImpl).convert((Font)object2) : cssMetaData.getConverter().convert(parsedValueImpl, (Font)object2);
                }
                object4 = (StyleOrigin)((Object)simpleObjectProperty.get());
                return new CalculatedValue(object2, (StyleOrigin)((Object)object4), bl3);
            }
            catch (ClassCastException classCastException) {
                object = this.formatUnresolvedLookupMessage(styleable, cssMetaData, cascadingStyle.getStyle(), parsedValueImpl, classCastException);
                object2 = StyleManager.getErrors();
                if (object2 != null) {
                    object3 = new CssParser$ParseError$PropertySetError(cssMetaData, styleable, (String)object);
                    object2.add((Object)object3);
                }
                if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                    LOGGER.warning((String)object);
                    LOGGER.fine("node = " + styleable.toString());
                    LOGGER.fine("cssMetaData = " + String.valueOf(cssMetaData));
                    LOGGER.fine("styles = " + String.valueOf(CssStyleHelper.getMatchingStyles(styleable, cssMetaData)));
                }
                return CalculatedValue.SKIP;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = this.formatExceptionMessage(styleable, cssMetaData, cascadingStyle.getStyle(), illegalArgumentException);
                object2 = StyleManager.getErrors();
                if (object2 != null) {
                    object3 = new CssParser$ParseError$PropertySetError(cssMetaData, styleable, (String)object);
                    object2.add((Object)object3);
                }
                if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                    LOGGER.warning((String)object);
                    LOGGER.fine("caught: ", illegalArgumentException);
                    LOGGER.fine("styleable = " + String.valueOf(cssMetaData));
                    LOGGER.fine("node = " + styleable.toString());
                }
                return CalculatedValue.SKIP;
            }
            catch (NullPointerException nullPointerException) {
                object = this.formatExceptionMessage(styleable, cssMetaData, cascadingStyle.getStyle(), nullPointerException);
                object2 = StyleManager.getErrors();
                if (object2 != null) {
                    object3 = new CssParser$ParseError$PropertySetError(cssMetaData, styleable, (String)object);
                    object2.add((Object)object3);
                }
                if (LOGGER.isLoggable(PlatformLogger$Level.WARNING)) {
                    LOGGER.warning((String)object);
                    LOGGER.fine("caught: ", nullPointerException);
                    LOGGER.fine("styleable = " + String.valueOf(cssMetaData));
                    LOGGER.fine("node = " + styleable.toString());
                }
                return CalculatedValue.SKIP;
            }
        }
        return new CalculatedValue(null, cascadingStyle.getOrigin(), false);
    }

    private CalculatedValue getCachedFont(Styleable styleable) {
        if (!(styleable instanceof Node)) {
            return null;
        }
        Object object = null;
        styleable = (Node)styleable;
        CssStyleHelper cssStyleHelper = ((Node)styleable).styleHelper;
        if (cssStyleHelper == null || cssStyleHelper.cacheContainer == null) {
            object = this.getCachedFont(((Node)styleable).getStyleableParent());
        } else {
            CssStyleHelper$CacheContainer cssStyleHelper$CacheContainer = cssStyleHelper.cacheContainer;
            if (cssStyleHelper$CacheContainer != null && cssStyleHelper$CacheContainer.fontSizeCache != null && !cssStyleHelper$CacheContainer.fontSizeCache.isEmpty()) {
                object = cssStyleHelper.getTransitionStates((Node)styleable);
                object = new StyleCacheEntry$Key((Set<PseudoClass>[])object, Font.getDefault());
                object = cssStyleHelper$CacheContainer.fontSizeCache.get(object);
            }
            if (object == null) {
                object = cssStyleHelper.getStyleMap(styleable);
                object = cssStyleHelper.lookupFont(styleable, "-fx-font", (StyleMap)object, null);
            }
        }
        if (object != CalculatedValue.SKIP) {
            return object;
        }
        return null;
    }

    final FontPosture getFontPosture(Font object) {
        if (object == null) {
            return FontPosture.REGULAR;
        }
        if (((String)(object = ((Font)object).getName().toLowerCase(Locale.ROOT))).contains("italic")) {
            return FontPosture.ITALIC;
        }
        return FontPosture.REGULAR;
    }

    final FontWeight getFontWeight(Font object) {
        if (object == null) {
            return FontWeight.NORMAL;
        }
        if (((String)(object = ((Font)object).getName().toLowerCase(Locale.ROOT))).contains("bold")) {
            if (((String)object).contains("extra")) {
                return FontWeight.EXTRA_BOLD;
            }
            if (((String)object).contains("ultra")) {
                return FontWeight.EXTRA_BOLD;
            }
            if (((String)object).contains("semi")) {
                return FontWeight.SEMI_BOLD;
            }
            if (((String)object).contains("demi")) {
                return FontWeight.SEMI_BOLD;
            }
            return FontWeight.BOLD;
        }
        if (((String)object).contains("light")) {
            if (((String)object).contains("extra")) {
                return FontWeight.EXTRA_LIGHT;
            }
            if (((String)object).contains("ultra")) {
                return FontWeight.EXTRA_LIGHT;
            }
            return FontWeight.LIGHT;
        }
        if (((String)object).contains("black")) {
            return FontWeight.BLACK;
        }
        if (((String)object).contains("heavy")) {
            return FontWeight.BLACK;
        }
        if (((String)object).contains("medium")) {
            return FontWeight.MEDIUM;
        }
        return FontWeight.NORMAL;
    }

    final String getFontFamily(Font font) {
        if (font == null) {
            return Font.getDefault().getFamily();
        }
        return font.getFamily();
    }

    final Font deriveFont(Font font, String string, FontWeight fontWeight, FontPosture fontPosture, double d2) {
        if (font != null && string == null) {
            string = this.getFontFamily(font);
        } else if (string != null) {
            string = Utils.stripQuotes(string);
        }
        if (font != null && fontWeight == null) {
            fontWeight = this.getFontWeight(font);
        }
        if (font != null && fontPosture == null) {
            fontPosture = this.getFontPosture(font);
        }
        if (font != null && d2 <= 0.0) {
            d2 = font.getSize();
        }
        return Font.font(string, fontWeight, fontPosture, d2);
    }

    final CalculatedValue lookupFont(Styleable styleable, String string, StyleMap styleMap, CalculatedValue calculatedValue) {
        Object object;
        CalculatedValue calculatedValue2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        ObservableSet<PseudoClass> observableSet;
        Object object7 = null;
        int n2 = 0;
        boolean bl2 = false;
        String string2 = null;
        double d2 = -1.0;
        FontWeight fontWeight = null;
        FontPosture fontPosture = null;
        Object object8 = calculatedValue;
        ObservableSet<PseudoClass> observableSet2 = observableSet = styleable instanceof Node ? ((Node)styleable).pseudoClassStates : styleable.getPseudoClassStates();
        if (this.cacheContainer.fontProp != null) {
            object6 = this.cacheContainer.fontProp.getStyleableProperty(styleable);
            object5 = object6.getStyleOrigin();
            object4 = (Font)object6.getValue();
            if (object4 == null) {
                object4 = Font.getDefault();
            }
            if (object5 == StyleOrigin.USER) {
                object7 = object5;
                string2 = this.getFontFamily((Font)object4);
                d2 = ((Font)object4).getSize();
                fontWeight = this.getFontWeight((Font)object4);
                fontPosture = this.getFontPosture((Font)object4);
                object8 = new CalculatedValue(object4, (StyleOrigin)((Object)object5), false);
            }
        }
        if ((object6 = this.getCachedFont(styleable.getStyleableParent())) == null) {
            object6 = new CalculatedValue(Font.getDefault(), null, false);
        }
        if ((object5 = this.getStyle(styleable, string, styleMap, observableSet)) == null && object7 != StyleOrigin.USER) {
            Object object9 = object4 = styleable != null ? styleable.getStyleableParent() : null;
            while (object9 != null) {
                object3 = object4 instanceof Node ? ((Node)object4).styleHelper : null;
                if (object3 != null) {
                    ++n2;
                    Object object10 = ((CssStyleHelper)object3).getStyleMap((Styleable)object4);
                    if ((object3 = ((CssStyleHelper)object3).getStyle((Styleable)object4, string, (StyleMap)object10, (Set<PseudoClass>)(object2 = ((Node)object4).pseudoClassStates))) != null && !"inherit".equals(((ParsedValue)(object10 = ((CascadingStyle)object3).getParsedValue())).getValue())) {
                        object5 = object3;
                        break;
                    }
                }
                object9 = object4.getStyleableParent();
            }
        }
        if (object5 != null && (object7 == null || object7.compareTo(((CascadingStyle)object5).getOrigin()) <= 0) && ((CalculatedValue)(object4 = this.calculateValue((CascadingStyle)object5, styleable, dummyFontProperty, styleMap, observableSet, styleable, (CalculatedValue)object6))).getValue() instanceof Font) {
            object7 = ((CalculatedValue)object4).getOrigin();
            object3 = (Font)((CalculatedValue)object4).getValue();
            string2 = this.getFontFamily((Font)object3);
            d2 = ((Font)object3).getSize();
            fontWeight = this.getFontWeight((Font)object3);
            fontPosture = this.getFontPosture((Font)object3);
            object8 = object4;
            bl2 = true;
        }
        if ((object4 = this.getStyle(styleable, string.concat("-size"), styleMap, observableSet)) != null) {
            if (object5 != null && ((CascadingStyle)object5).compareTo((CascadingStyle)object4) < 0) {
                object4 = null;
            } else if (object7 == StyleOrigin.USER && StyleOrigin.USER.compareTo(((CascadingStyle)object4).getOrigin()) > 0) {
                object4 = null;
            }
        } else if (object7 != StyleOrigin.USER) {
            object4 = this.lookupInheritedFontProperty(styleable, string.concat("-size"), styleMap, n2, (CascadingStyle)object5);
        }
        if (object4 != null && ((CalculatedValue)(object3 = this.calculateValue((CascadingStyle)object4, styleable, dummyFontProperty, styleMap, observableSet, styleable, (CalculatedValue)object6))).getValue() instanceof Double) {
            if (object7 == null || object7.compareTo(((CascadingStyle)object4).getOrigin()) <= 0) {
                object7 = ((CalculatedValue)object3).getOrigin();
            }
            d2 = (Double)((CalculatedValue)object3).getValue();
            if (object8 != null) {
                var19_19 = ((CalculatedValue)object8).isRelative() || ((CalculatedValue)object3).isRelative();
                object2 = this.deriveFont((Font)((CalculatedValue)object8).getValue(), string2, fontWeight, fontPosture, d2);
                object8 = new CalculatedValue(object2, (StyleOrigin)((Object)object7), var19_19);
            } else {
                var19_19 = ((CalculatedValue)object3).isRelative();
                object2 = this.deriveFont(Font.getDefault(), string2, fontWeight, fontPosture, d2);
                object8 = new CalculatedValue(object2, (StyleOrigin)((Object)object7), var19_19);
            }
            bl2 = true;
        }
        if (calculatedValue == null) {
            if (object8 != null) {
                return object8;
            }
            return CalculatedValue.SKIP;
        }
        object3 = this.getStyle(styleable, string.concat("-weight"), styleMap, observableSet);
        if (object3 != null) {
            if (object5 != null && ((CascadingStyle)object5).compareTo((CascadingStyle)object3) < 0) {
                object3 = null;
            }
        } else if (object7 != StyleOrigin.USER) {
            object3 = this.lookupInheritedFontProperty(styleable, string.concat("-weight"), styleMap, n2, (CascadingStyle)object5);
        }
        if (object3 != null && (calculatedValue2 = this.calculateValue((CascadingStyle)object3, styleable, dummyFontProperty, styleMap, observableSet, styleable, null)).getValue() instanceof FontWeight) {
            if (object7 == null || object7.compareTo(((CascadingStyle)object3).getOrigin()) <= 0) {
                object7 = calculatedValue2.getOrigin();
            }
            fontWeight = (FontWeight)((Object)calculatedValue2.getValue());
            bl2 = true;
        }
        if ((object = this.getStyle(styleable, string.concat("-style"), styleMap, observableSet)) != null) {
            if (object5 != null && ((CascadingStyle)object5).compareTo((CascadingStyle)object) < 0) {
                object = null;
            }
        } else if (object7 != StyleOrigin.USER) {
            object = this.lookupInheritedFontProperty(styleable, string.concat("-style"), styleMap, n2, (CascadingStyle)object5);
        }
        if (object != null && ((CalculatedValue)(object2 = this.calculateValue((CascadingStyle)object, styleable, dummyFontProperty, styleMap, observableSet, styleable, null))).getValue() instanceof FontPosture) {
            if (object7 == null || object7.compareTo(((CascadingStyle)object).getOrigin()) <= 0) {
                object7 = ((CalculatedValue)object2).getOrigin();
            }
            fontPosture = (FontPosture)((Object)((CalculatedValue)object2).getValue());
            bl2 = true;
        }
        if ((object2 = this.getStyle(styleable, string.concat("-family"), styleMap, observableSet)) != null) {
            if (object5 != null && ((CascadingStyle)object5).compareTo((CascadingStyle)object2) < 0) {
                object2 = null;
            }
        } else if (object7 != StyleOrigin.USER) {
            object2 = this.lookupInheritedFontProperty(styleable, string.concat("-family"), styleMap, n2, (CascadingStyle)object5);
        }
        if (object2 != null && ((CalculatedValue)(object3 = this.calculateValue((CascadingStyle)object2, styleable, dummyFontProperty, styleMap, observableSet, styleable, null))).getValue() instanceof String) {
            if (object7 == null || object7.compareTo(((CascadingStyle)object2).getOrigin()) <= 0) {
                object7 = ((CalculatedValue)object3).getOrigin();
            }
            string2 = (String)((CalculatedValue)object3).getValue();
            bl2 = true;
        }
        if (bl2) {
            object3 = object8 != null ? (Font)((CalculatedValue)object8).getValue() : Font.getDefault();
            object = this.deriveFont((Font)object3, string2, fontWeight, fontPosture, d2);
            return new CalculatedValue(object, (StyleOrigin)((Object)object7), false);
        }
        return CalculatedValue.SKIP;
    }

    private CascadingStyle lookupInheritedFontProperty(Styleable styleable, String string, StyleMap styleMap, int n2, CascadingStyle cascadingStyle) {
        int n3 = n2;
        for (styleable = styleable != null ? styleable.getStyleableParent() : null; styleable != null && n3 > 0; styleable = styleable.getStyleableParent()) {
            ObservableSet<PseudoClass> observableSet;
            Object object = styleable instanceof Node ? ((Node)styleable).styleHelper : null;
            if (object == null) continue;
            --n3;
            Object object2 = ((CssStyleHelper)object).getStyleMap(styleable);
            if ((object = ((CssStyleHelper)object).getStyle(styleable, string, (StyleMap)object2, observableSet = ((Node)styleable).pseudoClassStates)) == null) continue;
            if (cascadingStyle != null && n3 == 0 && cascadingStyle.compareTo((CascadingStyle)object) < 0) {
                return null;
            }
            object2 = ((CascadingStyle)object).getParsedValue();
            if ("inherit".equals(((ParsedValue)object2).getValue())) continue;
            return object;
        }
        return null;
    }

    static List<Style> getMatchingStyles(Styleable styleable, CssMetaData cssMetaData) {
        if (!(styleable instanceof Node)) {
            return Collections.emptyList();
        }
        styleable = (Node)styleable;
        CssStyleHelper cssStyleHelper = ((Node)styleable).styleHelper != null ? ((Node)styleable).styleHelper : CssStyleHelper.createStyleHelper((Node)styleable);
        if (cssStyleHelper != null) {
            return cssStyleHelper.getMatchingStyles(styleable, cssMetaData, false);
        }
        return Collections.emptyList();
    }

    static Map<StyleableProperty<?>, List<Style>> getMatchingStyles(Map<StyleableProperty<?>, List<Style>> map, Node node) {
        CssStyleHelper cssStyleHelper = node.styleHelper != null ? node.styleHelper : CssStyleHelper.createStyleHelper(node);
        if (cssStyleHelper != null) {
            if (map == null) {
                map = new HashMap();
            }
            for (CssMetaData<Styleable, Object> cssMetaData : node.getCssMetaData()) {
                List<Style> list = cssStyleHelper.getMatchingStyles(node, cssMetaData, true);
                if (list == null || list.isEmpty()) continue;
                StyleableProperty<Object> styleableProperty = cssMetaData.getStyleableProperty(node);
                map.put(styleableProperty, list);
            }
        }
        if (node instanceof Parent) {
            for (Node node2 : ((Parent)node).getChildren()) {
                map = CssStyleHelper.getMatchingStyles(map, node2);
            }
        }
        return map;
    }

    private List<Style> getMatchingStyles(Styleable object, CssMetaData object2, boolean bl2) {
        int n2;
        ArrayList<CascadingStyle> arrayList = new ArrayList<CascadingStyle>();
        this.getMatchingStyles((Styleable)object, (CssMetaData)object2, arrayList, bl2);
        object2 = ((CssMetaData)object2).getSubProperties();
        if (object2 != null) {
            n2 = object2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                CssMetaData cssMetaData = (CssMetaData)object2.get(i2);
                this.getMatchingStyles((Styleable)object, cssMetaData, arrayList, bl2);
            }
        }
        Collections.sort(arrayList);
        ArrayList<Style> arrayList2 = new ArrayList<Style>(arrayList.size());
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = ((CascadingStyle)arrayList.get(n2)).getStyle();
            if (arrayList2.contains(object)) continue;
            arrayList2.add((Style)object);
        }
        return arrayList2;
    }

    private void getMatchingStyles(Styleable styleable, CssMetaData cssMetaData, List<CascadingStyle> list, boolean bl2) {
        if (styleable != null) {
            Object object = cssMetaData.getProperty();
            Map<String, List<CascadingStyle>> map = styleable instanceof Node ? (Node)styleable : null;
            StyleMap styleMap = this.getStyleMap((Styleable)((Object)map));
            if (styleMap == null) {
                return;
            }
            if (bl2) {
                map = this.getStyle(styleable, cssMetaData.getProperty(), styleMap, ((Node)((Object)map)).pseudoClassStates);
                if (map != null) {
                    list.add((CascadingStyle)((Object)map));
                    object = ((CascadingStyle)((Object)map)).getParsedValue();
                    this.getMatchingLookupStyles(styleable, (ParsedValue)object, list, bl2);
                }
            } else {
                map = styleMap.getCascadingStyles();
                object = map.get(object);
                if (object != null) {
                    list.addAll((Collection<CascadingStyle>)object);
                    int n2 = object.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Object object2 = (CascadingStyle)object.get(i2);
                        object2 = ((CascadingStyle)object2).getParsedValue();
                        this.getMatchingLookupStyles(styleable, (ParsedValue)object2, list, bl2);
                    }
                }
            }
            if (cssMetaData.isInherits()) {
                for (Styleable styleable2 = styleable.getStyleableParent(); styleable2 != null; styleable2 = styleable2.getStyleableParent()) {
                    object = styleable2 instanceof Node ? ((Node)styleable2).styleHelper : null;
                    if (object == null) continue;
                    ((CssStyleHelper)object).getMatchingStyles(styleable2, cssMetaData, list, bl2);
                }
            }
        }
    }

    private void getMatchingLookupStyles(Styleable styleable, ParsedValue parsedValue, List<CascadingStyle> list, boolean bl2) {
        Object object;
        if (parsedValue.isLookup() && (object = parsedValue.getValue()) instanceof String) {
            object = (String)object;
            Styleable styleable2 = styleable;
            do {
                Object object2;
                Map<String, List<CascadingStyle>> map;
                List<CascadingStyle> list2;
                if ((list2 = (map = styleable2 instanceof Node ? (Node)styleable2 : null) != null ? ((Node)((Object)map)).styleHelper : null) == null || (object2 = ((CssStyleHelper)((Object)list2)).getStyleMap(styleable2)) == null || ((StyleMap)object2).isEmpty()) continue;
                int n2 = list.size();
                if (bl2) {
                    if ((map = ((CssStyleHelper)((Object)list2)).resolveRef((Styleable)((Object)map), (String)object, (StyleMap)object2, (Set<PseudoClass>)((Node)((Object)map)).pseudoClassStates)) != null) {
                        list.add((CascadingStyle)((Object)map));
                    }
                } else {
                    map = ((StyleMap)object2).getCascadingStyles();
                    list2 = map.get(object);
                    if (list2 != null) {
                        list.addAll((Collection<CascadingStyle>)list2);
                    }
                }
                int n3 = list.size();
                for (int i2 = n2; i2 < n3; ++i2) {
                    object2 = list.get(i2);
                    this.getMatchingLookupStyles(styleable2, ((CascadingStyle)object2).getParsedValue(), list, bl2);
                }
            } while ((styleable2 = styleable2.getStyleableParent()) != null);
        }
        if (!parsedValue.isContainsLookups()) {
            return;
        }
        object = parsedValue.getValue();
        if (object instanceof ParsedValue[][]) {
            object = (ParsedValue[][])object;
            for (int i3 = 0; i3 < ((V)object).length; ++i3) {
                for (int i4 = 0; i4 < ((V)object[i3]).length; ++i4) {
                    if (object[i3][i4] == null) continue;
                    this.getMatchingLookupStyles(styleable, (ParsedValue)object[i3][i4], list, bl2);
                }
            }
            return;
        }
        if (object instanceof ParsedValue[]) {
            object = (ParsedValue[])object;
            for (int i5 = 0; i5 < ((V)object).length; ++i5) {
                if (object[i5] == null) continue;
                this.getMatchingLookupStyles(styleable, (ParsedValue)object[i5], list, bl2);
            }
        }
    }
}

