/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.cursor.ImageCursorFrame;
import com.sun.javafx.tk.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor$DelayedInitialization;
import javafx.scene.ImageCursor$DoublePropertyImpl;
import javafx.scene.ImageCursor$ObjectPropertyImpl;
import javafx.scene.image.Image;

public class ImageCursor
extends Cursor {
    private ImageCursor$ObjectPropertyImpl<Image> image;
    private ImageCursor$DoublePropertyImpl hotspotX;
    private ImageCursor$DoublePropertyImpl hotspotY;
    private CursorFrame currentCursorFrame;
    private ImageCursorFrame firstCursorFrame;
    private Map<Object, ImageCursorFrame> otherCursorFrames;
    private int activeCounter;
    private InvalidationListener imageListener;

    public final Image getImage() {
        if (this.image == null) {
            return null;
        }
        return this.image.get();
    }

    public final ReadOnlyObjectProperty<Image> imageProperty() {
        return this.imagePropertyImpl();
    }

    private ImageCursor$ObjectPropertyImpl<Image> imagePropertyImpl() {
        if (this.image == null) {
            this.image = new ImageCursor$ObjectPropertyImpl(this, "image");
        }
        return this.image;
    }

    public final double getHotspotX() {
        if (this.hotspotX == null) {
            return 0.0;
        }
        return this.hotspotX.get();
    }

    public final ReadOnlyDoubleProperty hotspotXProperty() {
        return this.hotspotXPropertyImpl();
    }

    private ImageCursor$DoublePropertyImpl hotspotXPropertyImpl() {
        if (this.hotspotX == null) {
            this.hotspotX = new ImageCursor$DoublePropertyImpl(this, "hotspotX");
        }
        return this.hotspotX;
    }

    public final double getHotspotY() {
        if (this.hotspotY == null) {
            return 0.0;
        }
        return this.hotspotY.get();
    }

    public final ReadOnlyDoubleProperty hotspotYProperty() {
        return this.hotspotYPropertyImpl();
    }

    private ImageCursor$DoublePropertyImpl hotspotYPropertyImpl() {
        if (this.hotspotY == null) {
            this.hotspotY = new ImageCursor$DoublePropertyImpl(this, "hotspotY");
        }
        return this.hotspotY;
    }

    public ImageCursor() {
    }

    public ImageCursor(@NamedArg(value="image") Image image) {
        this(image, 0.0, 0.0);
    }

    public ImageCursor(@NamedArg(value="image") Image image, @NamedArg(value="hotspotX") double d2, @NamedArg(value="hotspotY") double d3) {
        if (image != null && image.getProgress() < 1.0) {
            ImageCursor$DelayedInitialization.applyTo(this, image, d2, d3);
            return;
        }
        this.initialize(image, d2, d3);
    }

    public static Dimension2D getBestSize(double d2, double d3) {
        return Toolkit.getToolkit().getBestCursorSize((int)d2, (int)d3);
    }

    public static int getMaximumColors() {
        return Toolkit.getToolkit().getMaximumCursorColors();
    }

    public static ImageCursor chooseBestCursor(Image[] imageArray, double d2, double d3) {
        ImageCursor imageCursor = new ImageCursor();
        if (ImageCursor.needsDelayedInitialization(imageArray)) {
            ImageCursor$DelayedInitialization.applyTo(imageCursor, imageArray, d2, d3);
        } else {
            imageCursor.initialize(imageArray, d2, d3);
        }
        return imageCursor;
    }

    @Override
    CursorFrame getCurrentFrame() {
        if (this.currentCursorFrame != null) {
            return this.currentCursorFrame;
        }
        Object object = this.getImage();
        if (object == null) {
            this.currentCursorFrame = Cursor.DEFAULT.getCurrentFrame();
            return this.currentCursorFrame;
        }
        Object object2 = Toolkit.getImageAccessor().getPlatformImage((Image)object);
        if (object2 == null) {
            this.currentCursorFrame = Cursor.DEFAULT.getCurrentFrame();
            return this.currentCursorFrame;
        }
        if (this.firstCursorFrame == null) {
            this.firstCursorFrame = new ImageCursorFrame(object2, ((Image)object).getWidth(), ((Image)object).getHeight(), this.getHotspotX(), this.getHotspotY());
            this.currentCursorFrame = this.firstCursorFrame;
        } else if (this.firstCursorFrame.getPlatformImage() == object2) {
            this.currentCursorFrame = this.firstCursorFrame;
        } else {
            if (this.otherCursorFrames == null) {
                this.otherCursorFrames = new HashMap<Object, ImageCursorFrame>();
            }
            this.currentCursorFrame = this.otherCursorFrames.get(object2);
            if (this.currentCursorFrame == null) {
                object = new ImageCursorFrame(object2, ((Image)object).getWidth(), ((Image)object).getHeight(), this.getHotspotX(), this.getHotspotY());
                this.otherCursorFrames.put(object2, (ImageCursorFrame)object);
                this.currentCursorFrame = object;
            }
        }
        return this.currentCursorFrame;
    }

    private void invalidateCurrentFrame() {
        this.currentCursorFrame = null;
    }

    @Override
    void activate() {
        if (++this.activeCounter == 1) {
            ImageCursor imageCursor = this;
            imageCursor.bindImage(imageCursor.getImage());
            this.invalidateCurrentFrame();
        }
    }

    @Override
    void deactivate() {
        if (--this.activeCounter == 0) {
            ImageCursor imageCursor = this;
            imageCursor.unbindImage(imageCursor.getImage());
        }
    }

    private void initialize(Image[] imageArray, double d2, double d3) {
        Object object = ImageCursor.getBestSize(1.0, 1.0);
        if (imageArray.length == 0 || ((Dimension2D)object).getWidth() == 0.0 || ((Dimension2D)object).getHeight() == 0.0) {
            return;
        }
        if (imageArray.length == 1) {
            this.initialize(imageArray[0], d2, d3);
            return;
        }
        object = ImageCursor.findBestImage(imageArray);
        double d4 = ((Image)object).getWidth() / imageArray[0].getWidth();
        double d5 = ((Image)object).getHeight() / imageArray[0].getHeight();
        this.initialize((Image)object, d2 * d4, d3 * d5);
    }

    private void initialize(Image image, double d2, double d3) {
        Image image2 = this.getImage();
        double d4 = this.getHotspotX();
        double d5 = this.getHotspotY();
        if (image == null || image.getWidth() < 1.0 || image.getHeight() < 1.0) {
            d2 = 0.0;
            d3 = 0.0;
        } else {
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            if (d2 > image.getWidth() - 1.0) {
                d2 = image.getWidth() - 1.0;
            }
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            if (d3 > image.getHeight() - 1.0) {
                d3 = image.getHeight() - 1.0;
            }
        }
        this.imagePropertyImpl().store(image);
        this.hotspotXPropertyImpl().store(d2);
        this.hotspotYPropertyImpl().store(d3);
        if (image2 != image) {
            if (this.activeCounter > 0) {
                this.unbindImage(image2);
                this.bindImage(image);
            }
            this.invalidateCurrentFrame();
            this.image.fireValueChangedEvent();
        }
        if (d4 != d2) {
            this.hotspotX.fireValueChangedEvent();
        }
        if (d5 != d3) {
            this.hotspotY.fireValueChangedEvent();
        }
    }

    private InvalidationListener getImageListener() {
        if (this.imageListener == null) {
            this.imageListener = observable -> this.invalidateCurrentFrame();
        }
        return this.imageListener;
    }

    private void bindImage(Image image) {
        if (image == null) {
            return;
        }
        Toolkit.getImageAccessor().getImageProperty(image).addListener(this.getImageListener());
    }

    private void unbindImage(Image image) {
        if (image == null) {
            return;
        }
        Toolkit.getImageAccessor().getImageProperty(image).removeListener(this.getImageListener());
    }

    private static boolean needsDelayedInitialization(Image[] imageArray) {
        for (Image image : imageArray) {
            Image image2;
            if (!(image2.getProgress() < 1.0)) continue;
            return true;
        }
        return false;
    }

    private static Image findBestImage(Image[] imageArray) {
        double d2;
        double d3;
        double d4;
        Dimension2D dimension2D;
        Image image;
        int n2;
        Image[] imageArray2;
        Object object = imageArray;
        int n3 = imageArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            imageArray2 = object[i2];
            Dimension2D dimension2D2 = ImageCursor.getBestSize((int)imageArray2.getWidth(), (int)imageArray2.getHeight());
            if (dimension2D2.getWidth() != imageArray2.getWidth() || dimension2D2.getHeight() != imageArray2.getHeight()) continue;
            return imageArray2;
        }
        object = null;
        double d5 = Double.MAX_VALUE;
        imageArray2 = imageArray;
        int n4 = imageArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            double d6;
            Image image2;
            image = imageArray2[n2];
            if (!(image2.getWidth() > 0.0) || !(image.getHeight() > 0.0)) continue;
            dimension2D = ImageCursor.getBestSize(image.getWidth(), image.getHeight());
            d4 = dimension2D.getWidth() / image.getWidth();
            d3 = dimension2D.getHeight() / image.getHeight();
            if (!(d4 >= 1.0) || !(d3 >= 1.0)) continue;
            d2 = Math.max(d4, d3);
            if (!(d6 < d5)) continue;
            object = image;
            d5 = d2;
        }
        if (object != null) {
            return object;
        }
        imageArray2 = imageArray;
        n4 = imageArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            double d7;
            double d8;
            double d9;
            Dimension2D dimension2D3;
            Image image3;
            image = imageArray2[n2];
            if (!(image3.getWidth() > 0.0) || !(image.getHeight() > 0.0)) continue;
            dimension2D = ImageCursor.getBestSize(image.getWidth(), image.getHeight());
            if (!(dimension2D3.getWidth() > 0.0) || !(dimension2D.getHeight() > 0.0)) continue;
            d4 = dimension2D.getWidth() / image.getWidth();
            if (d9 < 1.0) {
                d4 = 1.0 / d4;
            }
            d3 = dimension2D.getHeight() / image.getHeight();
            if (d8 < 1.0) {
                d3 = 1.0 / d3;
            }
            d2 = Math.max(d4, d3);
            if (!(d7 < d5)) continue;
            object = image;
            d5 = d2;
        }
        if (object != null) {
            return object;
        }
        return imageArray[0];
    }
}

