/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.LightBaseHelper;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.transform.TransformHelper;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.scene.LightBase$1;
import javafx.scene.LightBase$2;
import javafx.scene.LightBase$3;
import javafx.scene.LightBase$4;
import javafx.scene.LightBase$5;
import javafx.scene.LightBase$6;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.paint.Color;
import javafx.scene.shape.Shape3D;

public abstract class LightBase
extends Node {
    private Affine3D localToSceneTx = new Affine3D();
    private ObjectProperty<Color> color;
    private BooleanProperty lightOn;
    private ObservableList<Node> scope;
    private ObservableList<Node> exclusionScope;

    protected LightBase() {
        this(Color.WHITE);
    }

    protected LightBase(Color color) {
        LightBaseHelper.initHelper(this);
        if (!Platform.isSupported(ConditionalFeature.SCENE3D)) {
            String string = LightBase.class.getName();
            PlatformLogger.getLogger(string).warning("System can't support ConditionalFeature.SCENE3D");
        }
        this.setColor(color);
        this.localToSceneTransformProperty().addListener(observable -> NodeHelper.markDirty(this, DirtyBits.NODE_LIGHT_TRANSFORM));
    }

    public final void setColor(Color color) {
        this.colorProperty().set(color);
    }

    public final Color getColor() {
        if (this.color == null) {
            return null;
        }
        return (Color)this.color.get();
    }

    public final ObjectProperty<Color> colorProperty() {
        if (this.color == null) {
            LightBase lightBase = this;
            this.color = new LightBase$2(lightBase, lightBase, "color");
        }
        return this.color;
    }

    public final void setLightOn(boolean bl2) {
        this.lightOnProperty().set(bl2);
    }

    public final boolean isLightOn() {
        if (this.lightOn == null) {
            return true;
        }
        return this.lightOn.get();
    }

    public final BooleanProperty lightOnProperty() {
        if (this.lightOn == null) {
            LightBase lightBase = this;
            this.lightOn = new LightBase$3(lightBase, lightBase, "lightOn", true);
        }
        return this.lightOn;
    }

    public ObservableList<Node> getScope() {
        if (this.scope == null) {
            this.scope = new LightBase$4(this);
        }
        return this.scope;
    }

    public ObservableList<Node> getExclusionScope() {
        if (this.exclusionScope == null) {
            this.exclusionScope = new LightBase$5(this);
        }
        return this.exclusionScope;
    }

    private void doOnChanged(ListChangeListener$Change<Node> listChangeListener$Change, ObservableList<Node> observableList) {
        NodeHelper.markDirty(this, DirtyBits.NODE_LIGHT_SCOPE);
        while (listChangeListener$Change.next()) {
            listChangeListener$Change.getRemoved().forEach(this::markChildrenDirty);
            listChangeListener$Change.getAddedSubList().forEach(node -> {
                if (observableList != null && observableList.remove(node)) {
                    return;
                }
                this.markChildrenDirty((Node)node);
            });
        }
    }

    @Override
    void scenesChanged(Scene scene, SubScene subScene, Scene scene2, SubScene subScene2) {
        if (subScene2 != null) {
            subScene2.removeLight(this);
        } else if (scene2 != null) {
            scene2.removeLight(this);
        }
        if (subScene != null) {
            subScene.addLight(this);
            return;
        }
        if (scene != null) {
            scene.addLight(this);
        }
    }

    DoubleProperty getLightDoubleProperty(String string, double d2) {
        LightBase lightBase = this;
        return new LightBase$6(lightBase, lightBase, string, d2);
    }

    private void markOwnerDirty() {
        EventTarget eventTarget = this.getSubScene();
        if (eventTarget != null) {
            ((SubScene)eventTarget).markContentDirty();
            return;
        }
        eventTarget = this.getScene();
        if (eventTarget != null) {
            ((Scene)eventTarget).setNeedsRepaint();
        }
    }

    private void markChildrenDirty(Node object) {
        if (object instanceof Shape3D) {
            NodeHelper.markDirty((Node)object, DirtyBits.NODE_DRAWMODE);
            return;
        }
        if (object instanceof Parent) {
            for (Node node : ((Parent)object).getChildren()) {
                if (this.scope != null && this.getScope().contains(node) || this.exclusionScope != null && this.getExclusionScope().contains(node)) continue;
                this.markChildrenDirty(node);
            }
        }
    }

    private void doMarkDirty(DirtyBits dirtyBits) {
        if (this.scope == null || this.getScope().isEmpty()) {
            this.markOwnerDirty();
            return;
        }
        if (dirtyBits != DirtyBits.NODE_LIGHT_SCOPE) {
            this.getScope().forEach(this::markChildrenDirty);
        }
    }

    private void doUpdatePeer() {
        NGLightBase nGLightBase = (NGLightBase)this.getPeer();
        if (this.isDirty(DirtyBits.NODE_LIGHT)) {
            nGLightBase.setColor(this.getColor() == null ? Toolkit.getPaintAccessor().getPlatformPaint(Color.WHITE) : Toolkit.getPaintAccessor().getPlatformPaint(this.getColor()));
            nGLightBase.setLightOn(this.isLightOn());
        }
        if (this.isDirty(DirtyBits.NODE_LIGHT_SCOPE)) {
            if (this.scope != null) {
                if (this.getScope().isEmpty()) {
                    nGLightBase.setScope(List.of());
                } else {
                    nGLightBase.setScope(this.getScope().stream().map(node -> node.getPeer()).collect(Collectors.toList()));
                }
            }
            if (this.exclusionScope != null) {
                if (this.getExclusionScope().isEmpty()) {
                    nGLightBase.setExclusionScope(List.of());
                } else {
                    nGLightBase.setExclusionScope(this.getExclusionScope().stream().map(node -> node.getPeer()).collect(Collectors.toList()));
                }
            }
        }
        if (this.isDirty(DirtyBits.NODE_LIGHT_TRANSFORM)) {
            ((BaseTransform)this.localToSceneTx).setToIdentity();
            TransformHelper.apply(this.getLocalToSceneTransform(), this.localToSceneTx);
            nGLightBase.setWorldTransform(this.localToSceneTx);
        }
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        return new BoxBounds();
    }

    private boolean doComputeContains(double d2, double d3) {
        return false;
    }

    static {
        LightBaseHelper.setLightBaseAccessor(new LightBase$1());
    }
}

