/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Application;
import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.collections.UnmodifiableListSet;
import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.geometry.BoundsUtils;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.scene.CameraHelper;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.EventHandlerProperties;
import com.sun.javafx.scene.LayoutFlags;
import com.sun.javafx.scene.NodeEventDispatcher;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.SceneUtils;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.transform.TransformHelper;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalMethod;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.TempState;
import com.sun.javafx.util.Utils;
import com.sun.prism.impl.PrismSettings;
import com.sun.scenario.effect.EffectHelper;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.animation.Interpolatable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.Style;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.CacheHint;
import javafx.scene.Camera;
import javafx.scene.CssStyleHelper;
import javafx.scene.Cursor;
import javafx.scene.DepthTest;
import javafx.scene.Group;
import javafx.scene.Node$1;
import javafx.scene.Node$10;
import javafx.scene.Node$11;
import javafx.scene.Node$12;
import javafx.scene.Node$13;
import javafx.scene.Node$14;
import javafx.scene.Node$15;
import javafx.scene.Node$16;
import javafx.scene.Node$17;
import javafx.scene.Node$18;
import javafx.scene.Node$19;
import javafx.scene.Node$2;
import javafx.scene.Node$20;
import javafx.scene.Node$21;
import javafx.scene.Node$22;
import javafx.scene.Node$3;
import javafx.scene.Node$4;
import javafx.scene.Node$5;
import javafx.scene.Node$6;
import javafx.scene.Node$7;
import javafx.scene.Node$8;
import javafx.scene.Node$9;
import javafx.scene.Node$AccessibilityProperties;
import javafx.scene.Node$EffectiveOrientationProperty;
import javafx.scene.Node$FocusPropertyBase;
import javafx.scene.Node$FocusWithinProperty;
import javafx.scene.Node$LazyBoundsProperty;
import javafx.scene.Node$MiscProperties;
import javafx.scene.Node$NodeTransformation;
import javafx.scene.Node$ReadOnlyObjectWrapperManualFire;
import javafx.scene.Node$StyleableProperties;
import javafx.scene.Node$TreeVisibleProperty;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.SnapshotResult;
import javafx.scene.SubScene;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;
import javafx.scene.shape.Shape3D;
import javafx.scene.text.Font;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.stage.Window;
import javafx.util.Callback;

@IDProperty(value="id")
public abstract class Node
implements Styleable,
EventTarget {
    private NodeHelper nodeHelper = null;
    private Set<DirtyBits> dirtyBits = EnumSet.allOf(DirtyBits.class);
    private BaseBounds _geomBounds = new RectBounds(0.0f, 0.0f, -1.0f, -1.0f);
    private BaseBounds _txBounds = new RectBounds(0.0f, 0.0f, -1.0f, -1.0f);
    private boolean pendingUpdateBounds = false;
    private static final Object USER_DATA_KEY;
    private ObservableMap<Object, Object> properties;
    private ReadOnlyObjectWrapper<Parent> parent;
    private SubScene subScene = null;
    private Node$ReadOnlyObjectWrapperManualFire<Scene> scene = new Node$ReadOnlyObjectWrapperManualFire(this);
    private StringProperty id;
    private ObservableList<String> styleClass = new Node$4(this);
    private StringProperty style;
    private BooleanProperty visible;
    private DoubleProperty opacity;
    private ObjectProperty<BlendMode> blendMode;
    private boolean derivedDepthTest = true;
    private BooleanProperty pickOnBounds;
    private ReadOnlyBooleanWrapper disabled;
    private Node clipParent;
    private NGNode peer;
    private BooleanProperty managed;
    private DoubleProperty layoutX;
    private DoubleProperty layoutY;
    public static final double BASELINE_OFFSET_SAME_AS_HEIGHT = Double.NEGATIVE_INFINITY;
    private Node$LazyBoundsProperty layoutBounds = new Node$13(this);
    private BaseTransform localToParentTx = BaseTransform.IDENTITY_TRANSFORM;
    private boolean transformDirty = true;
    private BaseBounds txBounds = new RectBounds();
    private BaseBounds geomBounds = new RectBounds();
    private BaseBounds localBounds = null;
    boolean boundsChanged;
    private boolean geomBoundsInvalid = true;
    private boolean localBoundsInvalid = true;
    private boolean txBoundsInvalid = true;
    private static final double EPSILON_ABSOLUTE = 1.0E-5;
    private Node$NodeTransformation nodeTransformation;
    private static final double DEFAULT_TRANSLATE_X = 0.0;
    private static final double DEFAULT_TRANSLATE_Y = 0.0;
    private static final double DEFAULT_TRANSLATE_Z = 0.0;
    private static final double DEFAULT_SCALE_X = 1.0;
    private static final double DEFAULT_SCALE_Y = 1.0;
    private static final double DEFAULT_SCALE_Z = 1.0;
    private static final double DEFAULT_ROTATE = 0.0;
    private static final Point3D DEFAULT_ROTATION_AXIS;
    private EventHandlerProperties eventHandlerProperties;
    private ObjectProperty<NodeOrientation> nodeOrientation;
    private Node$EffectiveOrientationProperty effectiveNodeOrientationProperty;
    private static final byte EFFECTIVE_ORIENTATION_LTR = 0;
    private static final byte EFFECTIVE_ORIENTATION_RTL = 1;
    private static final byte EFFECTIVE_ORIENTATION_MASK = 1;
    private static final byte AUTOMATIC_ORIENTATION_LTR = 0;
    private static final byte AUTOMATIC_ORIENTATION_RTL = 2;
    private static final byte AUTOMATIC_ORIENTATION_MASK = 2;
    private byte resolvedNodeOrientation = 0;
    private Node$MiscProperties miscProperties;
    private static final double DEFAULT_VIEW_ORDER = 0.0;
    private static final boolean DEFAULT_CACHE = false;
    private static final CacheHint DEFAULT_CACHE_HINT;
    private static final Node DEFAULT_CLIP;
    private static final Cursor DEFAULT_CURSOR;
    private static final DepthTest DEFAULT_DEPTH_TEST;
    private static final boolean DEFAULT_DISABLE = false;
    private static final Effect DEFAULT_EFFECT;
    private static final InputMethodRequests DEFAULT_INPUT_METHOD_REQUESTS;
    private static final boolean DEFAULT_MOUSE_TRANSPARENT = false;
    private ReadOnlyBooleanWrapper hover;
    private ReadOnlyBooleanWrapper pressed;
    private final Node$FocusPropertyBase focused = new Node$17(this);
    final Node$FocusPropertyBase focusVisible = new Node$18(this);
    private final Node$FocusWithinProperty focusWithin = new Node$FocusWithinProperty(this);
    private BooleanProperty focusTraversable;
    private boolean treeVisible = true;
    private Node$TreeVisibleProperty treeVisibleProperty;
    private boolean canReceiveFocus = false;
    private BooleanProperty showMnemonics;
    private Node labeledBy = null;
    private ObjectProperty<EventDispatcher> eventDispatcher;
    private NodeEventDispatcher internalEventDispatcher;
    private EventDispatcher preprocessMouseEventDispatcher;
    CssFlags cssFlag = CssFlags.CLEAN;
    final ObservableSet<PseudoClass> pseudoClassStates = new PseudoClassState();
    private final ObservableSet<PseudoClass> unmodifiablePseudoClassStates = FXCollections.unmodifiableObservableSet(this.pseudoClassStates);
    CssStyleHelper styleHelper;
    private static final PseudoClass HOVER_PSEUDOCLASS_STATE;
    private static final PseudoClass PRESSED_PSEUDOCLASS_STATE;
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE;
    private static final PseudoClass FOCUSED_PSEUDOCLASS_STATE;
    private static final PseudoClass FOCUS_VISIBLE_PSEUDOCLASS_STATE;
    private static final PseudoClass FOCUS_WITHIN_PSEUDOCLASS_STATE;
    private static final PseudoClass SHOW_MNEMONICS_PSEUDOCLASS_STATE;
    private static final BoundsAccessor boundsAccessor;
    private ObjectProperty<AccessibleRole> accessibleRole;
    Node$AccessibilityProperties accessibilityProperties;
    Accessible accessible;

    private void doMarkDirty(DirtyBits dirtyBits) {
        if (this.isDirtyEmpty()) {
            this.addToSceneDirtyList();
        }
        this.dirtyBits.add(dirtyBits);
    }

    private void addToSceneDirtyList() {
        Scene scene = this.getScene();
        if (scene != null) {
            scene.addToDirtyList(this);
            if (this.getSubScene() != null) {
                this.getSubScene().setDirty(this);
            }
        }
    }

    final boolean isDirty(DirtyBits dirtyBits) {
        return this.dirtyBits.contains((Object)dirtyBits);
    }

    final void clearDirty(DirtyBits dirtyBits) {
        this.dirtyBits.remove((Object)dirtyBits);
    }

    private void clearDirty() {
        this.dirtyBits.clear();
    }

    private boolean isDirtyEmpty() {
        return this.dirtyBits.isEmpty();
    }

    final void syncPeer() {
        if (!this.isDirtyEmpty() && (this.treeVisible || this.isDirty(DirtyBits.NODE_VISIBLE) || this.isDirty(DirtyBits.NODE_FORCE_SYNC))) {
            NodeHelper.updatePeer(this);
            this.clearDirty();
        }
    }

    void updateBounds() {
        Node node = this.getClip();
        if (node != null) {
            node.updateBounds();
        }
        if (!this.treeVisible && !this.isDirty(DirtyBits.NODE_VISIBLE)) {
            if (this.isDirty(DirtyBits.NODE_TRANSFORM) || this.isDirty(DirtyBits.NODE_TRANSFORMED_BOUNDS) || this.isDirty(DirtyBits.NODE_BOUNDS)) {
                this.pendingUpdateBounds = true;
            }
            return;
        }
        if (this.pendingUpdateBounds) {
            NodeHelper.markDirty(this, DirtyBits.NODE_TRANSFORM);
            NodeHelper.markDirty(this, DirtyBits.NODE_TRANSFORMED_BOUNDS);
            NodeHelper.markDirty(this, DirtyBits.NODE_BOUNDS);
            this.pendingUpdateBounds = false;
        }
        if (this.isDirty(DirtyBits.NODE_TRANSFORM) || this.isDirty(DirtyBits.NODE_TRANSFORMED_BOUNDS)) {
            if (this.isDirty(DirtyBits.NODE_TRANSFORM)) {
                this.updateLocalToParentTransform();
            }
            this._txBounds = this.getTransformedBounds(this._txBounds, BaseTransform.IDENTITY_TRANSFORM);
        }
        if (this.isDirty(DirtyBits.NODE_BOUNDS)) {
            this._geomBounds = this.getGeomBounds(this._geomBounds, BaseTransform.IDENTITY_TRANSFORM);
        }
    }

    private void doUpdatePeer() {
        Object object;
        Object p2 = this.getPeer();
        if (PrismSettings.printRenderGraph && this.isDirty(DirtyBits.DEBUG)) {
            object = this.getId();
            String string = this.getClass().getSimpleName();
            if (string.isEmpty()) {
                string = this.getClass().getName();
            }
            ((NGNode)p2).setName((String)(object == null ? string : object + "(" + string + ")"));
        }
        if (this.isDirty(DirtyBits.NODE_TRANSFORM)) {
            ((NGNode)p2).setTransformMatrix(this.localToParentTx);
        }
        if (this.isDirty(DirtyBits.NODE_VIEW_ORDER)) {
            ((NGNode)p2).setViewOrder(this.getViewOrder());
        }
        if (this.isDirty(DirtyBits.NODE_BOUNDS)) {
            ((NGNode)p2).setContentBounds(this._geomBounds);
        }
        if (this.isDirty(DirtyBits.NODE_TRANSFORMED_BOUNDS)) {
            ((NGNode)p2).setTransformedBounds(this._txBounds, !this.isDirty(DirtyBits.NODE_BOUNDS));
        }
        if (this.isDirty(DirtyBits.NODE_OPACITY)) {
            ((NGNode)p2).setOpacity((float)Utils.clamp(0.0, this.getOpacity(), 1.0));
        }
        if (this.isDirty(DirtyBits.NODE_CACHE)) {
            ((NGNode)p2).setCachedAsBitmap(this.isCache(), this.getCacheHint());
        }
        if (this.isDirty(DirtyBits.NODE_CLIP)) {
            ((NGNode)p2).setClipNode(this.getClip() != null ? (NGNode)this.getClip().getPeer() : null);
        }
        if (this.isDirty(DirtyBits.EFFECT_EFFECT) && this.getEffect() != null) {
            EffectHelper.sync(this.getEffect());
            ((NGNode)p2).effectChanged();
        }
        if (this.isDirty(DirtyBits.NODE_EFFECT)) {
            ((NGNode)p2).setEffect(this.getEffect() != null ? EffectHelper.getPeer(this.getEffect()) : null);
        }
        if (this.isDirty(DirtyBits.NODE_VISIBLE)) {
            ((NGNode)p2).setVisible(this.isVisible());
        }
        if (this.isDirty(DirtyBits.NODE_DEPTH_TEST)) {
            ((NGNode)p2).setDepthTest(this.isDerivedDepthTest());
        }
        if (this.isDirty(DirtyBits.NODE_BLENDMODE)) {
            object = this.getBlendMode();
            ((NGNode)p2).setNodeBlendMode(object == null ? null : EffectHelper.getToolkitBlendMode((BlendMode)((Object)object)));
        }
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object object) {
        this.getProperties().put(USER_DATA_KEY, object);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    final void setParent(Parent parent) {
        this.parentPropertyImpl().set(parent);
    }

    public final Parent getParent() {
        if (this.parent == null) {
            return null;
        }
        return (Parent)this.parent.get();
    }

    public final ReadOnlyObjectProperty<Parent> parentProperty() {
        return this.parentPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Parent> parentPropertyImpl() {
        if (this.parent == null) {
            this.parent = new Node$2(this);
        }
        return this.parent;
    }

    private void invalidatedScenes(Scene scene, SubScene subScene) {
        Scene scene2 = (Scene)this.sceneProperty().get();
        boolean bl2 = scene != scene2;
        SubScene subScene2 = this.subScene;
        if (this.getClip() != null) {
            this.getClip().setScenes(scene2, subScene2);
        }
        if (bl2) {
            this.updateCanReceiveFocus();
            if (this.isFocusTraversable() && scene2 != null) {
                scene2.initializeInternalEventDispatcher();
            }
            this.focusSetDirty(scene);
            this.focusSetDirty(scene2);
        }
        this.scenesChanged(scene2, subScene2, scene, subScene);
        if (bl2) {
            this.reapplyCSS();
        }
        if (bl2 && !this.isDirtyEmpty()) {
            this.addToSceneDirtyList();
        }
        if (scene2 == null && this.peer != null) {
            this.peer.release();
        }
        if (scene != null) {
            scene.clearNodeMnemonics(this);
        }
        if (this.getParent() == null) {
            this.parentResolvedOrientationInvalidated();
        }
        if (bl2) {
            this.scene.fireSuperValueChangedEvent();
        }
        if (this.accessible != null) {
            if (scene != null && scene != scene2 && scene2 == null) {
                Node node = this;
                scene.addAccessible(node, node.accessible);
            } else {
                this.accessible.dispose();
            }
            this.accessible = null;
        }
    }

    final void setScenes(Scene scene, SubScene subScene) {
        Scene scene2;
        while (scene != (scene2 = (Scene)node.sceneProperty().get()) || subScene != node.subScene) {
            node.scene.set(scene);
            SubScene subScene2 = node.subScene;
            node.subScene = subScene;
            node.invalidatedScenes(scene2, subScene2);
            if (!(node instanceof SubScene)) break;
            SubScene subScene3 = (SubScene)node;
            subScene = subScene3;
            Node node = subScene3.getRoot();
        }
    }

    final SubScene getSubScene() {
        return this.subScene;
    }

    public final Scene getScene() {
        return (Scene)this.scene.get();
    }

    public final ReadOnlyObjectProperty<Scene> sceneProperty() {
        return this.scene.getReadOnlyProperty();
    }

    void scenesChanged(Scene scene, SubScene subScene, Scene scene2, SubScene subScene2) {
    }

    public final void setId(String string) {
        this.idProperty().set(string);
    }

    @Override
    public final String getId() {
        if (this.id == null) {
            return null;
        }
        return (String)this.id.get();
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new Node$3(this);
        }
        return this.id;
    }

    @Override
    public final ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public final void setStyle(String string) {
        this.styleProperty().set(string);
    }

    @Override
    public final String getStyle() {
        if (this.style == null) {
            return "";
        }
        return (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new Node$5(this, "");
        }
        return this.style;
    }

    public final void setVisible(boolean bl2) {
        this.visibleProperty().set(bl2);
    }

    public final boolean isVisible() {
        if (this.visible == null) {
            return true;
        }
        return this.visible.get();
    }

    public final BooleanProperty visibleProperty() {
        if (this.visible == null) {
            this.visible = new Node$6(this, true);
        }
        return this.visible;
    }

    public final void setCursor(Cursor cursor) {
        this.cursorProperty().set(cursor);
    }

    public final Cursor getCursor() {
        if (this.miscProperties == null) {
            return DEFAULT_CURSOR;
        }
        return this.miscProperties.getCursor();
    }

    public final ObjectProperty<Cursor> cursorProperty() {
        return this.getMiscProperties().cursorProperty();
    }

    public final void setOpacity(double d2) {
        this.opacityProperty().set(d2);
    }

    public final double getOpacity() {
        if (this.opacity == null) {
            return 1.0;
        }
        return this.opacity.get();
    }

    public final DoubleProperty opacityProperty() {
        if (this.opacity == null) {
            this.opacity = new Node$7(this, 1.0);
        }
        return this.opacity;
    }

    public final void setBlendMode(BlendMode blendMode) {
        this.blendModeProperty().set(blendMode);
    }

    public final BlendMode getBlendMode() {
        if (this.blendMode == null) {
            return null;
        }
        return (BlendMode)((Object)this.blendMode.get());
    }

    public final ObjectProperty<BlendMode> blendModeProperty() {
        if (this.blendMode == null) {
            this.blendMode = new Node$8(this, null);
        }
        return this.blendMode;
    }

    public final void setClip(Node node) {
        this.clipProperty().set(node);
    }

    public final Node getClip() {
        if (this.miscProperties == null) {
            return DEFAULT_CLIP;
        }
        return this.miscProperties.getClip();
    }

    public final ObjectProperty<Node> clipProperty() {
        return this.getMiscProperties().clipProperty();
    }

    public final void setCache(boolean bl2) {
        this.cacheProperty().set(bl2);
    }

    public final boolean isCache() {
        if (this.miscProperties == null) {
            return false;
        }
        return this.miscProperties.isCache();
    }

    public final BooleanProperty cacheProperty() {
        return this.getMiscProperties().cacheProperty();
    }

    public final void setCacheHint(CacheHint cacheHint) {
        this.cacheHintProperty().set(cacheHint);
    }

    public final CacheHint getCacheHint() {
        if (this.miscProperties == null) {
            return DEFAULT_CACHE_HINT;
        }
        return this.miscProperties.getCacheHint();
    }

    public final ObjectProperty<CacheHint> cacheHintProperty() {
        return this.getMiscProperties().cacheHintProperty();
    }

    public final void setEffect(Effect effect) {
        this.effectProperty().set(effect);
    }

    public final Effect getEffect() {
        if (this.miscProperties == null) {
            return DEFAULT_EFFECT;
        }
        return this.miscProperties.getEffect();
    }

    public final ObjectProperty<Effect> effectProperty() {
        return this.getMiscProperties().effectProperty();
    }

    public final void setDepthTest(DepthTest depthTest) {
        this.depthTestProperty().set(depthTest);
    }

    public final DepthTest getDepthTest() {
        if (this.miscProperties == null) {
            return DEFAULT_DEPTH_TEST;
        }
        return this.miscProperties.getDepthTest();
    }

    public final ObjectProperty<DepthTest> depthTestProperty() {
        return this.getMiscProperties().depthTestProperty();
    }

    void computeDerivedDepthTest() {
        boolean bl2 = this.getDepthTest() == DepthTest.INHERIT ? (this.getParent() != null ? this.getParent().isDerivedDepthTest() : true) : this.getDepthTest() == DepthTest.ENABLE;
        if (this.isDerivedDepthTest() != bl2) {
            NodeHelper.markDirty(this, DirtyBits.NODE_DEPTH_TEST);
            this.setDerivedDepthTest(bl2);
        }
    }

    void setDerivedDepthTest(boolean bl2) {
        this.derivedDepthTest = bl2;
    }

    boolean isDerivedDepthTest() {
        return this.derivedDepthTest;
    }

    public final void setDisable(boolean bl2) {
        this.disableProperty().set(bl2);
    }

    public final boolean isDisable() {
        if (this.miscProperties == null) {
            return false;
        }
        return this.miscProperties.isDisable();
    }

    public final BooleanProperty disableProperty() {
        return this.getMiscProperties().disableProperty();
    }

    public final void setPickOnBounds(boolean bl2) {
        this.pickOnBoundsProperty().set(bl2);
    }

    public final boolean isPickOnBounds() {
        if (this.pickOnBounds == null) {
            return false;
        }
        return this.pickOnBounds.get();
    }

    public final BooleanProperty pickOnBoundsProperty() {
        if (this.pickOnBounds == null) {
            this.pickOnBounds = new SimpleBooleanProperty(this, "pickOnBounds");
        }
        return this.pickOnBounds;
    }

    protected final void setDisabled(boolean bl2) {
        this.disabledPropertyImpl().set(bl2);
    }

    public final boolean isDisabled() {
        if (this.disabled == null) {
            return false;
        }
        return this.disabled.get();
    }

    public final ReadOnlyBooleanProperty disabledProperty() {
        return this.disabledPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper disabledPropertyImpl() {
        if (this.disabled == null) {
            this.disabled = new Node$9(this);
        }
        return this.disabled;
    }

    private void updateDisabled() {
        boolean bl2 = this.isDisable();
        if (!bl2) {
            bl2 = this.getParent() != null ? this.getParent().isDisabled() : this.getSubScene() != null && this.getSubScene().isDisabled();
        }
        this.setDisabled(bl2);
        if (this instanceof SubScene) {
            ((SubScene)this).getRoot().setDisabled(bl2);
        }
    }

    public Node lookup(String object) {
        if (object == null) {
            return null;
        }
        if ((object = Selector.createSelector((String)object)) != null && ((Selector)object).applies(this)) {
            return this;
        }
        return null;
    }

    public Set<Node> lookupAll(String list) {
        list = Selector.createSelector((String)((Object)list));
        Set<Node> set = Collections.emptySet();
        if (list == null) {
            return set;
        }
        if ((list = this.lookupAll((Selector)((Object)list), null)) == null) {
            return set;
        }
        return new UnmodifiableListSet<Node>(list);
    }

    List<Node> lookupAll(Selector selector, List<Node> list) {
        if (selector.applies(this)) {
            if (list == null) {
                list = new LinkedList<Node>();
            }
            list.add(this);
        }
        return list;
    }

    public void toBack() {
        if (this.getParent() != null) {
            this.getParent().toBack(this);
        }
    }

    public void toFront() {
        if (this.getParent() != null) {
            this.getParent().toFront(this);
        }
    }

    private void doCSSPass() {
        if (this.cssFlag != CssFlags.CLEAN) {
            this.processCSS();
        }
    }

    private static void syncAll(Node node) {
        while (true) {
            node.syncPeer();
            if (node instanceof Parent) {
                Parent parent = (Parent)node;
                int n2 = parent.getChildren().size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Node node2 = (Node)parent.getChildren().get(i2);
                    if (node2 == null) continue;
                    Node.syncAll(node2);
                }
            }
            if (node.getClip() == null) break;
            node = node.getClip();
        }
    }

    private void doLayoutPass() {
        if (this instanceof Parent) {
            Parent parent = (Parent)this;
            for (int i2 = 0; i2 < 3; ++i2) {
                parent.layout();
            }
        }
    }

    private void doCSSLayoutSyncForSnapshot() {
        this.doCSSPass();
        this.doLayoutPass();
        this.updateBounds();
        Scene.setAllowPGAccess(true);
        Node.syncAll(this);
        Scene.setAllowPGAccess(false);
    }

    private WritableImage doSnapshot(SnapshotParameters snapshotParameters, WritableImage writableImage) {
        double d2;
        double d3;
        double d4;
        double d5;
        Object object;
        if (this.getScene() != null) {
            this.getScene().doCSSLayoutSyncForSnapshot(this);
        } else {
            this.doCSSLayoutSyncForSnapshot();
        }
        BaseTransform baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        if (snapshotParameters.getTransform() != null) {
            Affine3D affine3D = new Affine3D();
            TransformHelper.apply(snapshotParameters.getTransform(), affine3D);
            baseTransform = affine3D;
        }
        if ((object = snapshotParameters.getViewport()) != null) {
            d5 = ((Rectangle2D)object).getMinX();
            d4 = ((Rectangle2D)object).getMinY();
            d3 = ((Rectangle2D)object).getWidth();
            d2 = ((Rectangle2D)object).getHeight();
        } else {
            object = TempState.getInstance().bounds;
            object = this.getTransformedBounds((BaseBounds)object, baseTransform);
            d5 = ((BaseBounds)object).getMinX();
            d4 = ((BaseBounds)object).getMinY();
            d3 = ((BaseBounds)object).getWidth();
            d2 = ((BaseBounds)object).getHeight();
        }
        WritableImage writableImage2 = Scene.doSnapshot(this.getScene(), d5, d4, d3, d2, this, baseTransform, snapshotParameters.isDepthBufferInternal(), snapshotParameters.getFill(), snapshotParameters.getEffectiveCamera(), writableImage);
        return writableImage2;
    }

    public WritableImage snapshot(SnapshotParameters snapshotParameters, WritableImage writableImage) {
        Toolkit.getToolkit().checkFxUserThread();
        if (snapshotParameters == null) {
            snapshotParameters = new SnapshotParameters();
            Scene scene = this.getScene();
            if (scene != null) {
                snapshotParameters.setCamera(scene.getEffectiveCamera());
                snapshotParameters.setDepthBuffer(scene.isDepthBufferInternal());
                snapshotParameters.setFill(scene.getFill());
            }
        }
        return this.doSnapshot(snapshotParameters, writableImage);
    }

    public void snapshot(Callback<SnapshotResult, Void> object, SnapshotParameters object2, WritableImage writableImage) {
        Object object3;
        Toolkit.getToolkit().checkFxUserThread();
        if (object == null) {
            throw new NullPointerException("The callback must not be null");
        }
        if (object2 == null) {
            object2 = new SnapshotParameters();
            object3 = this.getScene();
            if (object3 != null) {
                ((SnapshotParameters)object2).setCamera(((Scene)object3).getEffectiveCamera());
                ((SnapshotParameters)object2).setDepthBuffer(((Scene)object3).isDepthBufferInternal());
                ((SnapshotParameters)object2).setFill(((Scene)object3).getFill());
            }
        } else {
            object2 = ((SnapshotParameters)object2).copy();
        }
        object3 = object2;
        object2 = writableImage;
        object = () -> this.lambda$snapshot$0((SnapshotParameters)object3, (WritableImage)object2, object);
        Scene.addSnapshotRunnable((Runnable)object);
    }

    public final void setOnDragEntered(EventHandler<? super DragEvent> eventHandler) {
        this.onDragEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragEntered() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnDragEntered();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragEnteredProperty() {
        return this.getEventHandlerProperties().onDragEnteredProperty();
    }

    public final void setOnDragExited(EventHandler<? super DragEvent> eventHandler) {
        this.onDragExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragExited() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnDragExited();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragExitedProperty() {
        return this.getEventHandlerProperties().onDragExitedProperty();
    }

    public final void setOnDragOver(EventHandler<? super DragEvent> eventHandler) {
        this.onDragOverProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragOver() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnDragOver();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragOverProperty() {
        return this.getEventHandlerProperties().onDragOverProperty();
    }

    public final void setOnDragDropped(EventHandler<? super DragEvent> eventHandler) {
        this.onDragDroppedProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragDropped() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnDragDropped();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDroppedProperty() {
        return this.getEventHandlerProperties().onDragDroppedProperty();
    }

    public final void setOnDragDone(EventHandler<? super DragEvent> eventHandler) {
        this.onDragDoneProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragDone() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnDragDone();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDoneProperty() {
        return this.getEventHandlerProperties().onDragDoneProperty();
    }

    public Dragboard startDragAndDrop(TransferMode ... transferModeArray) {
        if (this.getScene() != null) {
            return this.getScene().startDragAndDrop(this, transferModeArray);
        }
        throw new IllegalStateException("Cannot start drag and drop on node that is not in scene");
    }

    public void startFullDrag() {
        if (this.getScene() != null) {
            this.getScene().startFullDrag(this);
            return;
        }
        throw new IllegalStateException("Cannot start full drag on node that is not in scene");
    }

    final Node getClipParent() {
        return this.clipParent;
    }

    boolean isConnected() {
        return this.getParent() != null || this.clipParent != null;
    }

    boolean wouldCreateCycle(Node node, Node node2) {
        if (node2 != null && node2.getClip() == null && !(node2 instanceof Parent)) {
            return false;
        }
        while (node != node2) {
            if (node.getParent() != null) {
                node = node.getParent();
                continue;
            }
            if (node.getSubScene() != null) {
                node = node.getSubScene();
                continue;
            }
            if (node.clipParent != null) {
                node = node.clipParent;
                continue;
            }
            return false;
        }
        return true;
    }

    <P extends NGNode> P getPeer() {
        if (Utils.assertionEnabled() && this.getScene() != null && !Scene.isPGAccessAllowed()) {
            System.err.println();
            System.err.println("*** unexpected PG access");
            Thread.dumpStack();
        }
        if (this.peer == null) {
            this.peer = NodeHelper.createPeer(this);
        }
        return (P)this.peer;
    }

    protected Node() {
    }

    public final void setManaged(boolean bl2) {
        this.managedProperty().set(bl2);
    }

    public final boolean isManaged() {
        return this.managed == null || this.managed.get();
    }

    public final BooleanProperty managedProperty() {
        if (this.managed == null) {
            this.managed = new Node$10(this, true);
        }
        return this.managed;
    }

    void notifyManagedChanged() {
    }

    public final void setLayoutX(double d2) {
        this.layoutXProperty().set(d2);
    }

    public final double getLayoutX() {
        if (this.layoutX == null) {
            return 0.0;
        }
        return this.layoutX.get();
    }

    public final DoubleProperty layoutXProperty() {
        if (this.layoutX == null) {
            this.layoutX = new Node$11(this, 0.0);
        }
        return this.layoutX;
    }

    public final void setLayoutY(double d2) {
        this.layoutYProperty().set(d2);
    }

    public final double getLayoutY() {
        if (this.layoutY == null) {
            return 0.0;
        }
        return this.layoutY.get();
    }

    public final DoubleProperty layoutYProperty() {
        if (this.layoutY == null) {
            this.layoutY = new Node$12(this, 0.0);
        }
        return this.layoutY;
    }

    public void relocate(double d2, double d3) {
        this.setLayoutX(d2 - this.getLayoutBounds().getMinX());
        this.setLayoutY(d3 - this.getLayoutBounds().getMinY());
        PlatformLogger platformLogger = Logging.getLayoutLogger();
        if (platformLogger.isLoggable(PlatformLogger$Level.FINER)) {
            platformLogger.finer(this.toString() + " moved to (" + d2 + "," + d3 + ")");
        }
    }

    public boolean isResizable() {
        return false;
    }

    public Orientation getContentBias() {
        return null;
    }

    public double minWidth(double d2) {
        return this.prefWidth(d2);
    }

    public double minHeight(double d2) {
        return this.prefHeight(d2);
    }

    public double prefWidth(double d2) {
        double d3 = this.getLayoutBounds().getWidth();
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    public double prefHeight(double d2) {
        double d3 = this.getLayoutBounds().getHeight();
        if (Double.isNaN(d3) || d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    public double maxWidth(double d2) {
        return this.prefWidth(d2);
    }

    public double maxHeight(double d2) {
        return this.prefHeight(d2);
    }

    public void resize(double d2, double d3) {
    }

    public final void autosize() {
        if (this.isResizable()) {
            double d2;
            double d3;
            Orientation orientation = this.getContentBias();
            if (orientation == null) {
                Node node = this;
                d3 = node.boundedSize(node.prefWidth(-1.0), this.minWidth(-1.0), this.maxWidth(-1.0));
                Node node2 = this;
                d2 = node2.boundedSize(node2.prefHeight(-1.0), this.minHeight(-1.0), this.maxHeight(-1.0));
            } else if (orientation == Orientation.HORIZONTAL) {
                Node node = this;
                d3 = node.boundedSize(node.prefWidth(-1.0), this.minWidth(-1.0), this.maxWidth(-1.0));
                Node node3 = this;
                d2 = node3.boundedSize(node3.prefHeight(d3), this.minHeight(d3), this.maxHeight(d3));
            } else {
                Node node = this;
                d2 = node.boundedSize(node.prefHeight(-1.0), this.minHeight(-1.0), this.maxHeight(-1.0));
                Node node4 = this;
                d3 = node4.boundedSize(node4.prefWidth(d2), this.minWidth(d2), this.maxWidth(d2));
            }
            this.resize(d3, d2);
        }
    }

    double boundedSize(double d2, double d3, double d4) {
        return Math.min(Math.max(d2, d3), Math.max(d3, d4));
    }

    public void resizeRelocate(double d2, double d3, double d4, double d5) {
        this.resize(d4, d5);
        this.relocate(d2, d3);
    }

    public double getBaselineOffset() {
        if (this.isResizable()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.getLayoutBounds().getHeight();
    }

    public double computeAreaInScreen() {
        return this.doComputeAreaInScreen();
    }

    private double doComputeAreaInScreen() {
        EventTarget eventTarget = this.getScene();
        if (eventTarget != null) {
            Object object;
            Bounds bounds = this.getBoundsInLocal();
            boolean bl2 = (eventTarget = ((Scene)eventTarget).getEffectiveCamera()) instanceof PerspectiveCamera;
            Transform transform = this.getLocalToSceneTransform();
            Affine3D affine3D = TempState.getInstance().tempTx;
            BaseBounds baseBounds = new BoxBounds((float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getMinZ(), (float)bounds.getMaxX(), (float)bounds.getMaxY(), (float)bounds.getMaxZ());
            if (bl2) {
                object = ((Node)eventTarget).getLocalToSceneTransform();
                if (((Transform)object).getMxx() == 1.0 && ((Transform)object).getMxy() == 0.0 && ((Transform)object).getMxz() == 0.0 && ((Transform)object).getMyx() == 0.0 && ((Transform)object).getMyy() == 1.0 && ((Transform)object).getMyz() == 0.0 && ((Transform)object).getMzx() == 0.0 && ((Transform)object).getMzy() == 0.0 && ((Transform)object).getMzz() == 1.0) {
                    double d2;
                    double d3;
                    if (transform.getMxx() == 1.0 && transform.getMxy() == 0.0 && transform.getMxz() == 0.0 && transform.getMyx() == 0.0 && transform.getMyy() == 1.0 && transform.getMyz() == 0.0 && transform.getMzx() == 0.0 && transform.getMzy() == 0.0 && transform.getMzz() == 1.0) {
                        object = TempState.getInstance().vec3d;
                        ((Vec3d)object).set(0.0, 0.0, bounds.getMinZ());
                        this.localToScene((Vec3d)object);
                        d3 = ((Vec3d)object).z;
                        ((Vec3d)object).set(0.0, 0.0, bounds.getMaxZ());
                        this.localToScene((Vec3d)object);
                        d2 = ((Vec3d)object).z;
                    } else {
                        object = this.localToScene(bounds);
                        d3 = ((Bounds)object).getMinZ();
                        d2 = ((Bounds)object).getMaxZ();
                    }
                    if (d3 > ((Camera)eventTarget).getFarClipInScene() || d2 < ((Camera)eventTarget).getNearClipInScene()) {
                        return 0.0;
                    }
                } else {
                    BoxBounds boxBounds = new BoxBounds();
                    ((BaseTransform)affine3D).setToIdentity();
                    TransformHelper.apply(transform, affine3D);
                    affine3D.preConcatenate(((Camera)eventTarget).getSceneToLocalTransform());
                    ((BaseTransform)affine3D).transform(baseBounds, boxBounds);
                    if ((double)((BaseBounds)boxBounds).getMinZ() > ((Camera)eventTarget).getFarClip() || (double)((BaseBounds)boxBounds).getMaxZ() < ((Camera)eventTarget).getNearClip()) {
                        return 0.0;
                    }
                }
            }
            object = TempState.getInstance().projViewTx;
            ((GeneralTransform3D)object).set(((Camera)eventTarget).getProjViewTransform());
            ((BaseTransform)affine3D).setToIdentity();
            TransformHelper.apply(transform, affine3D);
            GeneralTransform3D generalTransform3D = ((GeneralTransform3D)object).mul(affine3D);
            BoxBounds boxBounds = baseBounds;
            baseBounds = generalTransform3D.transform(boxBounds, boxBounds);
            double d4 = baseBounds.getWidth() * baseBounds.getHeight();
            if (bl2) {
                baseBounds.intersectWith(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                d4 = baseBounds.getWidth() < 0.0f || baseBounds.getHeight() < 0.0f ? 0.0 : d4;
            }
            return d4 * (((Camera)eventTarget).getViewWidth() / 2.0 * ((Camera)eventTarget).getViewHeight() / 2.0);
        }
        return 0.0;
    }

    public final Bounds getBoundsInParent() {
        return (Bounds)this.boundsInParentProperty().get();
    }

    public final ReadOnlyObjectProperty<Bounds> boundsInParentProperty() {
        return this.getMiscProperties().boundsInParentProperty();
    }

    private void invalidateBoundsInParent() {
        if (this.miscProperties != null) {
            this.miscProperties.invalidateBoundsInParent();
        }
    }

    public final Bounds getBoundsInLocal() {
        return (Bounds)this.boundsInLocalProperty().get();
    }

    public final ReadOnlyObjectProperty<Bounds> boundsInLocalProperty() {
        return this.getMiscProperties().boundsInLocalProperty();
    }

    private void invalidateBoundsInLocal() {
        if (this.miscProperties != null) {
            this.miscProperties.invalidateBoundsInLocal();
        }
    }

    public final Bounds getLayoutBounds() {
        return (Bounds)this.layoutBoundsProperty().get();
    }

    public final ReadOnlyObjectProperty<Bounds> layoutBoundsProperty() {
        return this.layoutBounds;
    }

    private Bounds doComputeLayoutBounds() {
        BaseBounds baseBounds = TempState.getInstance().bounds;
        baseBounds = this.getGeomBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM);
        return new BoundingBox(baseBounds.getMinX(), baseBounds.getMinY(), baseBounds.getMinZ(), baseBounds.getWidth(), baseBounds.getHeight(), baseBounds.getDepth());
    }

    final void layoutBoundsChanged() {
        if (!this.layoutBounds.valid) {
            return;
        }
        this.layoutBounds.invalidate();
        if (this.nodeTransformation != null && this.nodeTransformation.hasScaleOrRotate() || this.hasMirroring()) {
            NodeHelper.transformsChanged(this);
        }
    }

    BaseBounds getTransformedBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        this.updateLocalToParentTransform();
        if (baseTransform.isTranslateOrIdentity()) {
            this.updateTxBounds();
            baseBounds = baseBounds.deriveWithNewBounds(this.txBounds);
            if (!baseTransform.isIdentity()) {
                double d2 = baseTransform.getMxt();
                double d3 = baseTransform.getMyt();
                double d4 = baseTransform.getMzt();
                BaseBounds baseBounds2 = baseBounds;
                baseBounds = baseBounds2.deriveWithNewBounds((float)((double)baseBounds2.getMinX() + d2), (float)((double)baseBounds.getMinY() + d3), (float)((double)baseBounds.getMinZ() + d4), (float)((double)baseBounds.getMaxX() + d2), (float)((double)baseBounds.getMaxY() + d3), (float)((double)baseBounds.getMaxZ() + d4));
            }
            return baseBounds;
        }
        if (this.localToParentTx.isIdentity()) {
            return this.getLocalBounds(baseBounds, baseTransform);
        }
        double d5 = baseTransform.getMxx();
        double d6 = baseTransform.getMxy();
        double d7 = baseTransform.getMxz();
        double d8 = baseTransform.getMxt();
        double d9 = baseTransform.getMyx();
        double d10 = baseTransform.getMyy();
        double d11 = baseTransform.getMyz();
        double d12 = baseTransform.getMyt();
        double d13 = baseTransform.getMzx();
        double d14 = baseTransform.getMzy();
        double d15 = baseTransform.getMzz();
        double d16 = baseTransform.getMzt();
        BaseTransform baseTransform2 = baseTransform.deriveWithConcatenation(this.localToParentTx);
        baseBounds = this.getLocalBounds(baseBounds, baseTransform2);
        if (baseTransform2 == baseTransform) {
            baseTransform.restoreTransform(d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16);
        }
        return baseBounds;
    }

    BaseBounds getLocalBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.getEffect() == null && this.getClip() == null) {
            return this.getGeomBounds(baseBounds, baseTransform);
        }
        if (baseTransform.isTranslateOrIdentity()) {
            this.updateLocalBounds();
            baseBounds = baseBounds.deriveWithNewBounds(this.localBounds);
            if (!baseTransform.isIdentity()) {
                double d2 = baseTransform.getMxt();
                double d3 = baseTransform.getMyt();
                double d4 = baseTransform.getMzt();
                BaseBounds baseBounds2 = baseBounds;
                baseBounds = baseBounds2.deriveWithNewBounds((float)((double)baseBounds2.getMinX() + d2), (float)((double)baseBounds.getMinY() + d3), (float)((double)baseBounds.getMinZ() + d4), (float)((double)baseBounds.getMaxX() + d2), (float)((double)baseBounds.getMaxY() + d3), (float)((double)baseBounds.getMaxZ() + d4));
            }
            return baseBounds;
        }
        if (baseTransform.is2D() && (baseTransform.getType() & 0xFFFFFFB4) != 0) {
            return this.computeLocalBounds(baseBounds, baseTransform);
        }
        this.updateLocalBounds();
        return baseTransform.transform(this.localBounds, baseBounds);
    }

    BaseBounds getGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (baseTransform.isTranslateOrIdentity()) {
            this.updateGeomBounds();
            baseBounds = baseBounds.deriveWithNewBounds(this.geomBounds);
            if (!baseTransform.isIdentity()) {
                double d2 = baseTransform.getMxt();
                double d3 = baseTransform.getMyt();
                double d4 = baseTransform.getMzt();
                BaseBounds baseBounds2 = baseBounds;
                baseBounds = baseBounds2.deriveWithNewBounds((float)((double)baseBounds2.getMinX() + d2), (float)((double)baseBounds.getMinY() + d3), (float)((double)baseBounds.getMinZ() + d4), (float)((double)baseBounds.getMaxX() + d2), (float)((double)baseBounds.getMaxY() + d3), (float)((double)baseBounds.getMaxZ() + d4));
            }
            return baseBounds;
        }
        if (baseTransform.is2D() && (baseTransform.getType() & 0xFFFFFFB4) != 0) {
            return NodeHelper.computeGeomBounds(this, baseBounds, baseTransform);
        }
        this.updateGeomBounds();
        return baseTransform.transform(this.geomBounds, baseBounds);
    }

    void updateGeomBounds() {
        if (this.geomBoundsInvalid) {
            this.geomBounds = NodeHelper.computeGeomBounds(this, this.geomBounds, BaseTransform.IDENTITY_TRANSFORM);
            this.geomBoundsInvalid = false;
        }
    }

    private BaseBounds computeLocalBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.getEffect() != null) {
            BaseBounds baseBounds2 = EffectHelper.getBounds(this.getEffect(), baseBounds, baseTransform, this, boundsAccessor);
            baseBounds = baseBounds.deriveWithNewBounds(baseBounds2);
        } else {
            baseBounds = this.getGeomBounds(baseBounds, baseTransform);
        }
        if (this.getClip() != null && !(this instanceof Shape3D) && !(this.getClip() instanceof Shape3D)) {
            double d2 = baseBounds.getMinX();
            double d3 = baseBounds.getMinY();
            double d4 = baseBounds.getMaxX();
            double d5 = baseBounds.getMaxY();
            double d6 = baseBounds.getMinZ();
            double d7 = baseBounds.getMaxZ();
            baseBounds = this.getClip().getTransformedBounds(baseBounds, baseTransform);
            baseBounds.intersectWith((float)d2, (float)d3, (float)d6, (float)d4, (float)d5, (float)d7);
        }
        return baseBounds;
    }

    private void updateLocalBounds() {
        if (this.localBoundsInvalid) {
            this.localBounds = this.getClip() != null || this.getEffect() != null ? this.computeLocalBounds(this.localBounds == null ? new RectBounds() : this.localBounds, BaseTransform.IDENTITY_TRANSFORM) : null;
            this.localBoundsInvalid = false;
        }
    }

    void updateTxBounds() {
        if (this.txBoundsInvalid) {
            this.updateLocalToParentTransform();
            this.txBounds = this.getLocalBounds(this.txBounds, this.localToParentTx);
            this.txBoundsInvalid = false;
        }
    }

    private void doGeomChanged() {
        if (this.geomBoundsInvalid) {
            NodeHelper.notifyLayoutBoundsChanged(this);
            this.transformedBoundsChanged();
            return;
        }
        this.geomBounds.makeEmpty();
        this.geomBoundsInvalid = true;
        NodeHelper.markDirty(this, DirtyBits.NODE_BOUNDS);
        NodeHelper.notifyLayoutBoundsChanged(this);
        this.localBoundsChanged();
    }

    void localBoundsChanged() {
        this.localBoundsInvalid = true;
        this.invalidateBoundsInLocal();
        this.transformedBoundsChanged();
    }

    void transformedBoundsChanged() {
        if (!this.txBoundsInvalid) {
            this.txBounds.makeEmpty();
            this.txBoundsInvalid = true;
            this.invalidateBoundsInParent();
            NodeHelper.markDirty(this, DirtyBits.NODE_TRANSFORMED_BOUNDS);
        }
        if (this.isVisible()) {
            this.notifyParentOfBoundsChange();
        }
    }

    private void doNotifyLayoutBoundsChanged() {
        this.layoutBoundsChanged();
        Parent parent = this.getParent();
        if (this.isManaged() && parent != null && (!(parent instanceof Group) || this.isResizable()) && !parent.isPerformingLayout()) {
            parent.requestLayout(true);
        }
    }

    void notifyParentOfBoundsChange() {
        Parent parent = this.getParent();
        if (parent != null) {
            parent.childBoundsChanged(this);
        }
        if (this.clipParent != null) {
            this.clipParent.localBoundsChanged();
        }
    }

    public boolean contains(double d2, double d3) {
        if (this.containsBounds(d2, d3)) {
            return this.isPickOnBounds() || NodeHelper.computeContains(this, d2, d3);
        }
        return false;
    }

    private boolean containsBounds(double d2, double d3) {
        TempState tempState = TempState.getInstance();
        BaseBounds baseBounds = tempState.bounds;
        if ((baseBounds = this.getLocalBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM)).contains((float)d2, (float)d3)) {
            if (this.getClip() != null) {
                tempState.point.x = (float)d2;
                tempState.point.y = (float)d3;
                try {
                    this.getClip().parentToLocal(tempState.point);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    return false;
                }
                if (!this.getClip().contains(tempState.point.x, tempState.point.y)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        BaseBounds baseBounds = TempState.getInstance().bounds;
        baseBounds = this.getLocalBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM);
        return baseBounds.intersects((float)d2, (float)d3, (float)d4, (float)d5);
    }

    public boolean intersects(Bounds bounds) {
        return this.intersects(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    public Point2D screenToLocal(double d2, double d3) {
        Scene scene = this.getScene();
        if (scene == null) {
            return null;
        }
        Window window = scene.getWindow();
        if (window == null) {
            return null;
        }
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)(d2 - scene.getX() - window.getX()), (float)(d3 - scene.getY() - window.getY()));
        Object object = this.getSubScene();
        if (object != null) {
            if ((object = SceneUtils.sceneToSubScenePlane((SubScene)object, new Point2D(point2D.x, point2D.y))) == null) {
                return null;
            }
            point2D.setLocation((float)((Point2D)object).getX(), (float)((Point2D)object).getY());
        }
        object = scene.getEffectiveCamera().pickProjectPlane(point2D.x, point2D.y);
        point2D.setLocation((float)((Point3D)object).getX(), (float)((Point3D)object).getY());
        try {
            this.sceneToLocal(point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return new Point2D(point2D.x, point2D.y);
    }

    public Point2D screenToLocal(Point2D point2D) {
        return this.screenToLocal(point2D.getX(), point2D.getY());
    }

    public Bounds screenToLocal(Bounds object) {
        Point2D point2D = this.screenToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMinY());
        Point2D point2D2 = this.screenToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMaxY());
        Point2D point2D3 = this.screenToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMinY());
        object = this.screenToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY());
        return BoundsUtils.createBoundingBox(point2D, point2D2, point2D3, (Point2D)object);
    }

    public Point2D sceneToLocal(double d2, double d3, boolean bl2) {
        if (!bl2) {
            return this.sceneToLocal(d2, d3);
        }
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)d2, (float)d3);
        Object object = this.getSubScene();
        if (object != null) {
            if ((object = SceneUtils.sceneToSubScenePlane((SubScene)object, new Point2D(point2D.x, point2D.y))) == null) {
                return null;
            }
            point2D.setLocation((float)((Point2D)object).getX(), (float)((Point2D)object).getY());
        }
        try {
            this.sceneToLocal(point2D);
            return new Point2D(point2D.x, point2D.y);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public Point2D sceneToLocal(Point2D point2D, boolean bl2) {
        return this.sceneToLocal(point2D.getX(), point2D.getY(), bl2);
    }

    public Bounds sceneToLocal(Bounds object, boolean bl2) {
        if (!bl2) {
            return this.sceneToLocal((Bounds)object);
        }
        if (((Bounds)object).getMinZ() != 0.0 || ((Bounds)object).getMaxZ() != 0.0) {
            return null;
        }
        Point2D point2D = this.sceneToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), true);
        Point2D point2D2 = this.sceneToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), true);
        Point2D point2D3 = this.sceneToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), true);
        object = this.sceneToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), true);
        return BoundsUtils.createBoundingBox(point2D, point2D2, point2D3, (Point2D)object);
    }

    public Point2D sceneToLocal(double d2, double d3) {
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)d2, (float)d3);
        try {
            this.sceneToLocal(point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return new Point2D(point2D.x, point2D.y);
    }

    public Point2D sceneToLocal(Point2D point2D) {
        return this.sceneToLocal(point2D.getX(), point2D.getY());
    }

    public Point3D sceneToLocal(Point3D point3D) {
        return this.sceneToLocal(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Point3D sceneToLocal(double d2, double d3, double d4) {
        try {
            return this.sceneToLocal0(d2, d3, d4);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    private Point3D sceneToLocal0(double d2, double d3, double d4) throws NoninvertibleTransformException {
        Vec3d vec3d = TempState.getInstance().vec3d;
        vec3d.set(d2, d3, d4);
        this.sceneToLocal(vec3d);
        return new Point3D(vec3d.x, vec3d.y, vec3d.z);
    }

    public Bounds sceneToLocal(Bounds object) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && ((Bounds)object).getMinZ() == 0.0 && ((Bounds)object).getMaxZ() == 0.0) {
            Point2D point2D = this.sceneToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMinY());
            Point2D point2D2 = this.sceneToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMinY());
            Point2D point2D3 = this.sceneToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY());
            Point2D point2D4 = this.sceneToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMaxY());
            return BoundsUtils.createBoundingBox(point2D, point2D2, point2D3, point2D4);
        }
        try {
            Point3D point3D = this.sceneToLocal0(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ());
            Point3D point3D2 = this.sceneToLocal0(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ());
            Point3D point3D3 = this.sceneToLocal0(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ());
            Point3D point3D4 = this.sceneToLocal0(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ());
            Point3D point3D5 = this.sceneToLocal0(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ());
            Point3D point3D6 = this.sceneToLocal0(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ());
            Point3D point3D7 = this.sceneToLocal0(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ());
            object = this.sceneToLocal0(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ());
            return BoundsUtils.createBoundingBox(point3D, point3D2, point3D3, point3D4, point3D5, point3D6, point3D7, (Point3D)object);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public Point2D localToScreen(double d2, double d3) {
        return this.localToScreen(d2, d3, 0.0);
    }

    public Point2D localToScreen(Point2D point2D) {
        return this.localToScreen(point2D.getX(), point2D.getY());
    }

    public Point2D localToScreen(double d2, double d3, double d4) {
        Scene scene = this.getScene();
        if (scene == null) {
            return null;
        }
        Window window = scene.getWindow();
        if (window == null) {
            return null;
        }
        Interpolatable<Point3D> interpolatable = this.localToScene(d2, d3, d4);
        SubScene subScene = this.getSubScene();
        if (subScene != null) {
            interpolatable = SceneUtils.subSceneToScene(subScene, (Point3D)interpolatable);
        }
        interpolatable = CameraHelper.project(SceneHelper.getEffectiveCamera(this.getScene()), (Point3D)interpolatable);
        return new Point2D(((Point2D)interpolatable).getX() + scene.getX() + window.getX(), ((Point2D)interpolatable).getY() + scene.getY() + window.getY());
    }

    public Point2D localToScreen(Point3D point3D) {
        return this.localToScreen(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Bounds localToScreen(Bounds object) {
        Point2D point2D = this.localToScreen(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ());
        Point2D point2D2 = this.localToScreen(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ());
        Point2D point2D3 = this.localToScreen(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ());
        Point2D point2D4 = this.localToScreen(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ());
        Point2D point2D5 = this.localToScreen(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ());
        Point2D point2D6 = this.localToScreen(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ());
        Point2D point2D7 = this.localToScreen(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ());
        object = this.localToScreen(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ());
        return BoundsUtils.createBoundingBox(point2D, point2D2, point2D3, point2D4, point2D5, point2D6, point2D7, (Point2D)object);
    }

    public Point2D localToScene(double d2, double d3) {
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)d2, (float)d3);
        this.localToScene(point2D);
        return new Point2D(point2D.x, point2D.y);
    }

    public Point2D localToScene(Point2D point2D) {
        return this.localToScene(point2D.getX(), point2D.getY());
    }

    public Point3D localToScene(Point3D point3D) {
        return this.localToScene(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Point3D localToScene(double d2, double d3, double d4) {
        Vec3d vec3d = TempState.getInstance().vec3d;
        vec3d.set(d2, d3, d4);
        this.localToScene(vec3d);
        return new Point3D(vec3d.x, vec3d.y, vec3d.z);
    }

    public Point3D localToScene(Point3D point3D, boolean bl2) {
        SubScene subScene;
        point3D = this.localToScene(point3D);
        if (bl2 && (subScene = this.getSubScene()) != null) {
            point3D = SceneUtils.subSceneToScene(subScene, point3D);
        }
        return point3D;
    }

    public Point3D localToScene(double d2, double d3, double d4, boolean bl2) {
        return this.localToScene(new Point3D(d2, d3, d4), bl2);
    }

    public Point2D localToScene(Point2D interpolatable, boolean bl2) {
        if (!bl2) {
            return this.localToScene((Point2D)interpolatable);
        }
        interpolatable = this.localToScene(((Point2D)interpolatable).getX(), ((Point2D)interpolatable).getY(), 0.0, bl2);
        return new Point2D(((Point3D)interpolatable).getX(), ((Point3D)interpolatable).getY());
    }

    public Point2D localToScene(double d2, double d3, boolean bl2) {
        return this.localToScene(new Point2D(d2, d3), bl2);
    }

    public Bounds localToScene(Bounds object, boolean bl2) {
        if (!bl2) {
            return this.localToScene((Bounds)object);
        }
        Point3D point3D = this.localToScene(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ(), true);
        Point3D point3D2 = this.localToScene(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ(), true);
        Point3D point3D3 = this.localToScene(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ(), true);
        Point3D point3D4 = this.localToScene(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ(), true);
        Point3D point3D5 = this.localToScene(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ(), true);
        Point3D point3D6 = this.localToScene(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ(), true);
        Point3D point3D7 = this.localToScene(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ(), true);
        object = this.localToScene(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ(), true);
        return BoundsUtils.createBoundingBox(point3D, point3D2, point3D3, point3D4, point3D5, point3D6, point3D7, (Point3D)object);
    }

    public Bounds localToScene(Bounds object) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && ((Bounds)object).getMinZ() == 0.0 && ((Bounds)object).getMaxZ() == 0.0) {
            Point2D point2D = this.localToScene(((Bounds)object).getMinX(), ((Bounds)object).getMinY());
            Point2D point2D2 = this.localToScene(((Bounds)object).getMaxX(), ((Bounds)object).getMinY());
            Point2D point2D3 = this.localToScene(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY());
            Point2D point2D4 = this.localToScene(((Bounds)object).getMinX(), ((Bounds)object).getMaxY());
            return BoundsUtils.createBoundingBox(point2D, point2D2, point2D3, point2D4);
        }
        Point3D point3D = this.localToScene(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ());
        Point3D point3D2 = this.localToScene(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ());
        Point3D point3D3 = this.localToScene(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ());
        Point3D point3D4 = this.localToScene(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ());
        Point3D point3D5 = this.localToScene(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ());
        Point3D point3D6 = this.localToScene(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ());
        Point3D point3D7 = this.localToScene(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ());
        object = this.localToScene(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ());
        return BoundsUtils.createBoundingBox(point3D, point3D2, point3D3, point3D4, point3D5, point3D6, point3D7, (Point3D)object);
    }

    public Point2D parentToLocal(double d2, double d3) {
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)d2, (float)d3);
        try {
            this.parentToLocal(point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return new Point2D(point2D.x, point2D.y);
    }

    public Point2D parentToLocal(Point2D point2D) {
        return this.parentToLocal(point2D.getX(), point2D.getY());
    }

    public Point3D parentToLocal(Point3D point3D) {
        return this.parentToLocal(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Point3D parentToLocal(double d2, double d3, double d4) {
        Vec3d vec3d = TempState.getInstance().vec3d;
        vec3d.set(d2, d3, d4);
        try {
            this.parentToLocal(vec3d);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return new Point3D(vec3d.x, vec3d.y, vec3d.z);
    }

    public Bounds parentToLocal(Bounds object) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && ((Bounds)object).getMinZ() == 0.0 && ((Bounds)object).getMaxZ() == 0.0) {
            Point2D point2D = this.parentToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMinY());
            Point2D point2D2 = this.parentToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMinY());
            Point2D point2D3 = this.parentToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY());
            Point2D point2D4 = this.parentToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMaxY());
            return BoundsUtils.createBoundingBox(point2D, point2D2, point2D3, point2D4);
        }
        Point3D point3D = this.parentToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ());
        Point3D point3D2 = this.parentToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ());
        Point3D point3D3 = this.parentToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ());
        Point3D point3D4 = this.parentToLocal(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ());
        Point3D point3D5 = this.parentToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ());
        Point3D point3D6 = this.parentToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ());
        Point3D point3D7 = this.parentToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ());
        object = this.parentToLocal(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ());
        return BoundsUtils.createBoundingBox(point3D, point3D2, point3D3, point3D4, point3D5, point3D6, point3D7, (Point3D)object);
    }

    public Point2D localToParent(double d2, double d3) {
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)d2, (float)d3);
        this.localToParent(point2D);
        return new Point2D(point2D.x, point2D.y);
    }

    public Point2D localToParent(Point2D point2D) {
        return this.localToParent(point2D.getX(), point2D.getY());
    }

    public Point3D localToParent(Point3D point3D) {
        return this.localToParent(point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Point3D localToParent(double d2, double d3, double d4) {
        Vec3d vec3d = TempState.getInstance().vec3d;
        vec3d.set(d2, d3, d4);
        this.localToParent(vec3d);
        return new Point3D(vec3d.x, vec3d.y, vec3d.z);
    }

    public Bounds localToParent(Bounds object) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && ((Bounds)object).getMinZ() == 0.0 && ((Bounds)object).getMaxZ() == 0.0) {
            Point2D point2D = this.localToParent(((Bounds)object).getMinX(), ((Bounds)object).getMinY());
            Point2D point2D2 = this.localToParent(((Bounds)object).getMaxX(), ((Bounds)object).getMinY());
            Point2D point2D3 = this.localToParent(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY());
            Point2D point2D4 = this.localToParent(((Bounds)object).getMinX(), ((Bounds)object).getMaxY());
            return BoundsUtils.createBoundingBox(point2D, point2D2, point2D3, point2D4);
        }
        Point3D point3D = this.localToParent(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ());
        Point3D point3D2 = this.localToParent(((Bounds)object).getMinX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ());
        Point3D point3D3 = this.localToParent(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ());
        Point3D point3D4 = this.localToParent(((Bounds)object).getMinX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ());
        Point3D point3D5 = this.localToParent(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMinZ());
        Point3D point3D6 = this.localToParent(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Bounds)object).getMaxZ());
        Point3D point3D7 = this.localToParent(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMinZ());
        object = this.localToParent(((Bounds)object).getMaxX(), ((Bounds)object).getMinY(), ((Bounds)object).getMaxZ());
        return BoundsUtils.createBoundingBox(point3D, point3D2, point3D3, point3D4, point3D5, point3D6, point3D7, (Point3D)object);
    }

    BaseTransform getLocalToParentTransform(BaseTransform baseTransform) {
        this.updateLocalToParentTransform();
        baseTransform.setTransform(this.localToParentTx);
        return baseTransform;
    }

    final BaseTransform getLeafTransform() {
        return this.getLocalToParentTransform(TempState.getInstance().leafTx);
    }

    private void doTransformsChanged() {
        if (!this.transformDirty) {
            NodeHelper.markDirty(this, DirtyBits.NODE_TRANSFORM);
            this.transformDirty = true;
            this.transformedBoundsChanged();
        }
        this.invalidateLocalToParentTransform();
        this.invalidateLocalToSceneTransform();
    }

    final double getPivotX() {
        Bounds bounds = this.getLayoutBounds();
        return bounds.getMinX() + bounds.getWidth() / 2.0;
    }

    final double getPivotY() {
        Bounds bounds = this.getLayoutBounds();
        return bounds.getMinY() + bounds.getHeight() / 2.0;
    }

    final double getPivotZ() {
        Bounds bounds = this.getLayoutBounds();
        return bounds.getMinZ() + bounds.getDepth() / 2.0;
    }

    void updateLocalToParentTransform() {
        if (this.transformDirty) {
            this.localToParentTx.setToIdentity();
            boolean bl2 = false;
            double d2 = 0.0;
            if (this.hasMirroring()) {
                Scene scene = this.getScene();
                if (scene != null && scene.getRoot() == this) {
                    d2 = scene.getWidth() / 2.0;
                    if (d2 == 0.0) {
                        d2 = this.getPivotX();
                    }
                    this.localToParentTx = this.localToParentTx.deriveWithTranslation(d2, 0.0);
                    this.localToParentTx = this.localToParentTx.deriveWithScale(-1.0, 1.0, 1.0);
                    this.localToParentTx = this.localToParentTx.deriveWithTranslation(-d2, 0.0);
                } else {
                    bl2 = true;
                    d2 = this.getPivotX();
                }
            }
            if (this.getScaleX() != 1.0 || this.getScaleY() != 1.0 || this.getScaleZ() != 1.0 || this.getRotate() != 0.0) {
                double d3 = this.getPivotX();
                double d4 = this.getPivotY();
                double d5 = this.getPivotZ();
                this.localToParentTx = this.localToParentTx.deriveWithTranslation(this.getTranslateX() + this.getLayoutX() + d3, this.getTranslateY() + this.getLayoutY() + d4, this.getTranslateZ() + d5);
                this.localToParentTx = this.localToParentTx.deriveWithRotation(Math.toRadians(this.getRotate()), this.getRotationAxis().getX(), this.getRotationAxis().getY(), this.getRotationAxis().getZ());
                this.localToParentTx = this.localToParentTx.deriveWithScale(this.getScaleX(), this.getScaleY(), this.getScaleZ());
                this.localToParentTx = this.localToParentTx.deriveWithTranslation(-d3, -d4, -d5);
            } else {
                this.localToParentTx = this.localToParentTx.deriveWithTranslation(this.getTranslateX() + this.getLayoutX(), this.getTranslateY() + this.getLayoutY(), this.getTranslateZ());
            }
            if (this.hasTransforms()) {
                for (Transform transform : this.getTransforms()) {
                    this.localToParentTx = TransformHelper.derive(transform, this.localToParentTx);
                }
            }
            if (bl2) {
                this.localToParentTx = this.localToParentTx.deriveWithTranslation(d2, 0.0);
                this.localToParentTx = this.localToParentTx.deriveWithScale(-1.0, 1.0, 1.0);
                this.localToParentTx = this.localToParentTx.deriveWithTranslation(-d2, 0.0);
            }
            this.transformDirty = false;
        }
    }

    void parentToLocal(com.sun.javafx.geom.Point2D point2D) throws NoninvertibleTransformException {
        this.updateLocalToParentTransform();
        com.sun.javafx.geom.Point2D point2D2 = point2D;
        this.localToParentTx.inverseTransform(point2D2, point2D2);
    }

    void parentToLocal(Vec3d vec3d) throws NoninvertibleTransformException {
        this.updateLocalToParentTransform();
        Vec3d vec3d2 = vec3d;
        this.localToParentTx.inverseTransform(vec3d2, vec3d2);
    }

    void sceneToLocal(com.sun.javafx.geom.Point2D point2D) throws NoninvertibleTransformException {
        if (this.getParent() != null) {
            this.getParent().sceneToLocal(point2D);
        }
        this.parentToLocal(point2D);
    }

    void sceneToLocal(Vec3d vec3d) throws NoninvertibleTransformException {
        if (this.getParent() != null) {
            this.getParent().sceneToLocal(vec3d);
        }
        this.parentToLocal(vec3d);
    }

    void localToScene(com.sun.javafx.geom.Point2D point2D) {
        this.localToParent(point2D);
        if (this.getParent() != null) {
            this.getParent().localToScene(point2D);
        }
    }

    void localToScene(Vec3d vec3d) {
        this.localToParent(vec3d);
        if (this.getParent() != null) {
            this.getParent().localToScene(vec3d);
        }
    }

    void localToParent(com.sun.javafx.geom.Point2D point2D) {
        this.updateLocalToParentTransform();
        com.sun.javafx.geom.Point2D point2D2 = point2D;
        this.localToParentTx.transform(point2D2, point2D2);
    }

    void localToParent(Vec3d vec3d) {
        this.updateLocalToParentTransform();
        Vec3d vec3d2 = vec3d;
        this.localToParentTx.transform(vec3d2, vec3d2);
    }

    private void doPickNodeLocal(PickRay pickRay, PickResultChooser pickResultChooser) {
        this.intersects(pickRay, pickResultChooser);
    }

    final void pickNode(PickRay pickRay, PickResultChooser pickResultChooser) {
        if (!this.isVisible() || this.isDisable() || this.isMouseTransparent()) {
            return;
        }
        Vec3d vec3d = pickRay.getOriginNoClone();
        double d2 = vec3d.x;
        double d3 = vec3d.y;
        double d4 = vec3d.z;
        Vec3d vec3d2 = pickRay.getDirectionNoClone();
        double d5 = vec3d2.x;
        double d6 = vec3d2.y;
        double d7 = vec3d2.z;
        this.updateLocalToParentTransform();
        try {
            Vec3d vec3d3 = vec3d;
            this.localToParentTx.inverseTransform(vec3d3, vec3d3);
            Vec3d vec3d4 = vec3d2;
            this.localToParentTx.inverseDeltaTransform(vec3d4, vec3d4);
            NodeHelper.pickNodeLocal(this, pickRay, pickResultChooser);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        pickRay.setOrigin(d2, d3, d4);
        pickRay.setDirection(d5, d6, d7);
    }

    final boolean intersects(PickRay pickRay, PickResultChooser pickResultChooser) {
        double d2 = this.intersectsBounds(pickRay);
        if (!Double.isNaN(d2)) {
            if (this.isPickOnBounds()) {
                if (pickResultChooser != null) {
                    pickResultChooser.offer(this, d2, PickResultChooser.computePoint(pickRay, d2));
                }
                return true;
            }
            return NodeHelper.computeIntersects(this, pickRay, pickResultChooser);
        }
        return false;
    }

    private boolean doComputeIntersects(PickRay pickRay, PickResultChooser pickResultChooser) {
        double d2 = pickRay.getOriginNoClone().z;
        double d3 = pickRay.getDirectionNoClone().z;
        if (Node.almostZero(d3)) {
            return false;
        }
        double d4 = -d2 / d3;
        if (d4 < pickRay.getNearClip() || d4 > pickRay.getFarClip()) {
            return false;
        }
        double d5 = pickRay.getOriginNoClone().x + pickRay.getDirectionNoClone().x * d4;
        double d6 = pickRay.getOriginNoClone().y + pickRay.getDirectionNoClone().y * d4;
        if (this.contains((float)d5, (float)d6)) {
            if (pickResultChooser != null) {
                pickResultChooser.offer(this, d4, PickResultChooser.computePoint(pickRay, d4));
            }
            return true;
        }
        return false;
    }

    final double intersectsBounds(PickRay pickRay) {
        double d2;
        boolean bl2;
        double d3;
        double d4;
        double d5;
        double d6;
        Vec3d vec3d = pickRay.getDirectionNoClone();
        Vec3d vec3d2 = pickRay.getOriginNoClone();
        double d7 = vec3d2.x;
        double d8 = vec3d2.y;
        double d9 = vec3d2.z;
        TempState tempState = TempState.getInstance();
        BaseBounds baseBounds = tempState.bounds;
        baseBounds = this.getLocalBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM);
        if (vec3d.x == 0.0 && vec3d.y == 0.0) {
            double d10;
            if (vec3d.z == 0.0) {
                return Double.NaN;
            }
            if (d7 < (double)baseBounds.getMinX() || d7 > (double)baseBounds.getMaxX() || d8 < (double)baseBounds.getMinY() || d8 > (double)baseBounds.getMaxY()) {
                return Double.NaN;
            }
            var16_10 = 1.0 / vec3d.z;
            boolean bl3 = d10 < 0.0;
            d6 = baseBounds.getMinZ();
            d5 = baseBounds.getMaxZ();
            d4 = ((bl3 ? d5 : d6) - d9) * var16_10;
            d3 = ((bl3 ? d6 : d5) - d9) * var16_10;
        } else if ((double)baseBounds.getDepth() == 0.0) {
            if (Node.almostZero(vec3d.z)) {
                return Double.NaN;
            }
            var16_10 = ((double)baseBounds.getMinZ() - d9) / vec3d.z;
            double d11 = d7 + vec3d.x * var16_10;
            double d12 = d8 + vec3d.y * var16_10;
            if (d11 < (double)baseBounds.getMinX() || d11 > (double)baseBounds.getMaxX() || d12 < (double)baseBounds.getMinY() || d12 > (double)baseBounds.getMaxY()) {
                return Double.NaN;
            }
            d4 = d3 = var16_10;
        } else {
            double d13;
            double d14;
            var16_10 = vec3d.x == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / vec3d.x;
            double d15 = vec3d.y == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / vec3d.y;
            double d16 = vec3d.z == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / vec3d.z;
            boolean bl4 = var16_10 < 0.0;
            bl2 = d15 < 0.0;
            boolean bl5 = d16 < 0.0;
            double d17 = baseBounds.getMinX();
            double d18 = baseBounds.getMinY();
            double d19 = baseBounds.getMaxX();
            double d20 = baseBounds.getMaxY();
            d4 = Double.NEGATIVE_INFINITY;
            d3 = Double.POSITIVE_INFINITY;
            if (Double.isInfinite(var16_10)) {
                if (!(d17 <= d7) || !(d19 >= d7)) {
                    return Double.NaN;
                }
            } else {
                d4 = ((bl4 ? d19 : d17) - d7) * var16_10;
                d3 = ((bl4 ? d17 : d19) - d7) * var16_10;
            }
            if (Double.isInfinite(d15)) {
                if (!(d18 <= d8) || !(d20 >= d8)) {
                    return Double.NaN;
                }
            } else {
                d14 = ((bl2 ? d20 : d18) - d8) * d15;
                d13 = ((bl2 ? d18 : d20) - d8) * d15;
                if (d4 > d13 || d14 > d3) {
                    return Double.NaN;
                }
                if (d14 > d4) {
                    d4 = d14;
                }
                if (d13 < d3) {
                    d3 = d13;
                }
            }
            d14 = baseBounds.getMinZ();
            d13 = baseBounds.getMaxZ();
            if (Double.isInfinite(d16)) {
                if (!(d14 <= d9) || !(d13 >= d9)) {
                    return Double.NaN;
                }
            } else {
                double d21 = ((bl5 ? d13 : d14) - d9) * d16;
                double d22 = ((bl5 ? d14 : d13) - d9) * d16;
                if (d4 > d22 || d21 > d3) {
                    return Double.NaN;
                }
                if (d21 > d4) {
                    d4 = d21;
                }
                if (d22 < d3) {
                    d3 = d22;
                }
            }
        }
        Node node = this.getClip();
        if (node != null && !(this instanceof Shape3D) && !(node instanceof Shape3D)) {
            d2 = vec3d.x;
            d6 = vec3d.y;
            d5 = vec3d.z;
            node.updateLocalToParentTransform();
            bl2 = true;
            try {
                Vec3d vec3d3 = vec3d2;
                node.localToParentTx.inverseTransform(vec3d3, vec3d3);
                Vec3d vec3d4 = vec3d;
                node.localToParentTx.inverseDeltaTransform(vec3d4, vec3d4);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                bl2 = false;
            }
            bl2 = bl2 && node.intersects(pickRay, null);
            pickRay.setOrigin(d7, d8, d9);
            pickRay.setDirection(d2, d6, d5);
            if (!bl2) {
                return Double.NaN;
            }
        }
        if (Double.isInfinite(d4) || Double.isNaN(d4)) {
            return Double.NaN;
        }
        d2 = pickRay.getNearClip();
        d6 = pickRay.getFarClip();
        if (d4 < d2) {
            if (d3 >= d2) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (d4 > d6) {
            return Double.NaN;
        }
        return d4;
    }

    static boolean almostZero(double d2) {
        return d2 < 1.0E-5 && d2 > -1.0E-5;
    }

    public final DoubleProperty viewOrderProperty() {
        return this.getMiscProperties().viewOrderProperty();
    }

    public final void setViewOrder(double d2) {
        this.viewOrderProperty().set(d2);
    }

    public final double getViewOrder() {
        if (this.miscProperties == null) {
            return 0.0;
        }
        return this.miscProperties.getViewOrder();
    }

    public final ObservableList<Transform> getTransforms() {
        return this.transformsProperty();
    }

    private ObservableList<Transform> transformsProperty() {
        return this.getNodeTransformation().getTransforms();
    }

    public final void setTranslateX(double d2) {
        this.translateXProperty().set(d2);
    }

    public final double getTranslateX() {
        if (this.nodeTransformation == null) {
            return 0.0;
        }
        return this.nodeTransformation.getTranslateX();
    }

    public final DoubleProperty translateXProperty() {
        return this.getNodeTransformation().translateXProperty();
    }

    public final void setTranslateY(double d2) {
        this.translateYProperty().set(d2);
    }

    public final double getTranslateY() {
        if (this.nodeTransformation == null) {
            return 0.0;
        }
        return this.nodeTransformation.getTranslateY();
    }

    public final DoubleProperty translateYProperty() {
        return this.getNodeTransformation().translateYProperty();
    }

    public final void setTranslateZ(double d2) {
        this.translateZProperty().set(d2);
    }

    public final double getTranslateZ() {
        if (this.nodeTransformation == null) {
            return 0.0;
        }
        return this.nodeTransformation.getTranslateZ();
    }

    public final DoubleProperty translateZProperty() {
        return this.getNodeTransformation().translateZProperty();
    }

    public final void setScaleX(double d2) {
        this.scaleXProperty().set(d2);
    }

    public final double getScaleX() {
        if (this.nodeTransformation == null) {
            return 1.0;
        }
        return this.nodeTransformation.getScaleX();
    }

    public final DoubleProperty scaleXProperty() {
        return this.getNodeTransformation().scaleXProperty();
    }

    public final void setScaleY(double d2) {
        this.scaleYProperty().set(d2);
    }

    public final double getScaleY() {
        if (this.nodeTransformation == null) {
            return 1.0;
        }
        return this.nodeTransformation.getScaleY();
    }

    public final DoubleProperty scaleYProperty() {
        return this.getNodeTransformation().scaleYProperty();
    }

    public final void setScaleZ(double d2) {
        this.scaleZProperty().set(d2);
    }

    public final double getScaleZ() {
        if (this.nodeTransformation == null) {
            return 1.0;
        }
        return this.nodeTransformation.getScaleZ();
    }

    public final DoubleProperty scaleZProperty() {
        return this.getNodeTransformation().scaleZProperty();
    }

    public final void setRotate(double d2) {
        this.rotateProperty().set(d2);
    }

    public final double getRotate() {
        if (this.nodeTransformation == null) {
            return 0.0;
        }
        return this.nodeTransformation.getRotate();
    }

    public final DoubleProperty rotateProperty() {
        return this.getNodeTransformation().rotateProperty();
    }

    public final void setRotationAxis(Point3D point3D) {
        this.rotationAxisProperty().set(point3D);
    }

    public final Point3D getRotationAxis() {
        if (this.nodeTransformation == null) {
            return DEFAULT_ROTATION_AXIS;
        }
        return this.nodeTransformation.getRotationAxis();
    }

    public final ObjectProperty<Point3D> rotationAxisProperty() {
        return this.getNodeTransformation().rotationAxisProperty();
    }

    public final ReadOnlyObjectProperty<Transform> localToParentTransformProperty() {
        return this.getNodeTransformation().localToParentTransformProperty();
    }

    private void invalidateLocalToParentTransform() {
        if (this.nodeTransformation != null) {
            this.nodeTransformation.invalidateLocalToParentTransform();
        }
    }

    public final Transform getLocalToParentTransform() {
        return (Transform)this.localToParentTransformProperty().get();
    }

    public final ReadOnlyObjectProperty<Transform> localToSceneTransformProperty() {
        return this.getNodeTransformation().localToSceneTransformProperty();
    }

    private void invalidateLocalToSceneTransform() {
        if (this.nodeTransformation != null) {
            this.nodeTransformation.invalidateLocalToSceneTransform();
        }
    }

    public final Transform getLocalToSceneTransform() {
        return (Transform)this.localToSceneTransformProperty().get();
    }

    private Node$NodeTransformation getNodeTransformation() {
        if (this.nodeTransformation == null) {
            this.nodeTransformation = new Node$NodeTransformation(this);
        }
        return this.nodeTransformation;
    }

    private boolean hasTransforms() {
        return this.nodeTransformation != null && this.nodeTransformation.hasTransforms();
    }

    Transform getCurrentLocalToSceneTransformState() {
        if (this.nodeTransformation == null || this.nodeTransformation.localToSceneTransform == null) {
            return null;
        }
        return this.nodeTransformation.localToSceneTransform.transform;
    }

    private EventHandlerProperties getEventHandlerProperties() {
        if (this.eventHandlerProperties == null) {
            this.eventHandlerProperties = new EventHandlerProperties(this.getInternalEventDispatcher().getEventHandlerManager(), this);
        }
        return this.eventHandlerProperties;
    }

    public final void setNodeOrientation(NodeOrientation nodeOrientation) {
        this.nodeOrientationProperty().set(nodeOrientation);
    }

    public final NodeOrientation getNodeOrientation() {
        if (this.nodeOrientation == null) {
            return NodeOrientation.INHERIT;
        }
        return (NodeOrientation)((Object)this.nodeOrientation.get());
    }

    public final ObjectProperty<NodeOrientation> nodeOrientationProperty() {
        if (this.nodeOrientation == null) {
            this.nodeOrientation = new Node$14(this, NodeOrientation.INHERIT);
        }
        return this.nodeOrientation;
    }

    public final NodeOrientation getEffectiveNodeOrientation() {
        if (Node.getEffectiveOrientation(this.resolvedNodeOrientation) == 0) {
            return NodeOrientation.LEFT_TO_RIGHT;
        }
        return NodeOrientation.RIGHT_TO_LEFT;
    }

    public final ReadOnlyObjectProperty<NodeOrientation> effectiveNodeOrientationProperty() {
        if (this.effectiveNodeOrientationProperty == null) {
            this.effectiveNodeOrientationProperty = new Node$EffectiveOrientationProperty(this);
        }
        return this.effectiveNodeOrientationProperty;
    }

    public boolean usesMirroring() {
        return true;
    }

    final void parentResolvedOrientationInvalidated() {
        if (this.getNodeOrientation() == NodeOrientation.INHERIT) {
            this.nodeResolvedOrientationInvalidated();
            return;
        }
        NodeHelper.transformsChanged(this);
    }

    final void nodeResolvedOrientationInvalidated() {
        byte by2 = this.resolvedNodeOrientation;
        this.resolvedNodeOrientation = (byte)(this.calcEffectiveNodeOrientation() | this.calcAutomaticNodeOrientation());
        if (this.effectiveNodeOrientationProperty != null && Node.getEffectiveOrientation(this.resolvedNodeOrientation) != Node.getEffectiveOrientation(by2)) {
            this.effectiveNodeOrientationProperty.invalidate();
        }
        NodeHelper.transformsChanged(this);
        if (this.resolvedNodeOrientation != by2) {
            this.nodeResolvedOrientationChanged();
        }
    }

    void nodeResolvedOrientationChanged() {
    }

    private Node getMirroringOrientationParent() {
        Node node;
        for (node = this.getParent(); node != null; node = node.getParent()) {
            if (!node.usesMirroring()) continue;
            return node;
        }
        node = this.getSubScene();
        if (node != null) {
            return node;
        }
        return null;
    }

    private Node getOrientationParent() {
        Node node = this.getParent();
        if (node != null) {
            return node;
        }
        node = this.getSubScene();
        if (node != null) {
            return node;
        }
        return null;
    }

    private byte calcEffectiveNodeOrientation() {
        Object object = this.getNodeOrientation();
        if (object != NodeOrientation.INHERIT) {
            if (object == NodeOrientation.LEFT_TO_RIGHT) {
                return 0;
            }
            return 1;
        }
        object = this.getOrientationParent();
        if (object != null) {
            return Node.getEffectiveOrientation(((Node)object).resolvedNodeOrientation);
        }
        object = this.getScene();
        if (object != null) {
            if (((Scene)object).getEffectiveNodeOrientation() == NodeOrientation.LEFT_TO_RIGHT) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private byte calcAutomaticNodeOrientation() {
        if (!this.usesMirroring()) {
            return 0;
        }
        Object object = this.getNodeOrientation();
        if (object != NodeOrientation.INHERIT) {
            if (object == NodeOrientation.LEFT_TO_RIGHT) {
                return 0;
            }
            return 2;
        }
        object = this.getMirroringOrientationParent();
        if (object != null) {
            return Node.getAutomaticOrientation(((Node)object).resolvedNodeOrientation);
        }
        object = this.getScene();
        if (object != null) {
            if (((Scene)object).getEffectiveNodeOrientation() == NodeOrientation.LEFT_TO_RIGHT) {
                return 0;
            }
            return 2;
        }
        return 0;
    }

    final boolean hasMirroring() {
        byte by2;
        Node node = this.getOrientationParent();
        byte by3 = Node.getAutomaticOrientation(this.resolvedNodeOrientation);
        byte by4 = by2 = node != null ? Node.getAutomaticOrientation(node.resolvedNodeOrientation) : (byte)0;
        return by3 != by2;
    }

    private static byte getEffectiveOrientation(byte by2) {
        return (byte)(by2 & 1);
    }

    private static byte getAutomaticOrientation(byte by2) {
        return (byte)(by2 & 2);
    }

    private Node$MiscProperties getMiscProperties() {
        if (this.miscProperties == null) {
            this.miscProperties = new Node$MiscProperties(this);
        }
        return this.miscProperties;
    }

    public final void setMouseTransparent(boolean bl2) {
        this.mouseTransparentProperty().set(bl2);
    }

    public final boolean isMouseTransparent() {
        if (this.miscProperties == null) {
            return false;
        }
        return this.miscProperties.isMouseTransparent();
    }

    public final BooleanProperty mouseTransparentProperty() {
        return this.getMiscProperties().mouseTransparentProperty();
    }

    protected final void setHover(boolean bl2) {
        this.hoverPropertyImpl().set(bl2);
    }

    public final boolean isHover() {
        if (this.hover == null) {
            return false;
        }
        return this.hover.get();
    }

    public final ReadOnlyBooleanProperty hoverProperty() {
        return this.hoverPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper hoverPropertyImpl() {
        if (this.hover == null) {
            this.hover = new Node$15(this);
        }
        return this.hover;
    }

    protected final void setPressed(boolean bl2) {
        this.pressedPropertyImpl().set(bl2);
    }

    public final boolean isPressed() {
        if (this.pressed == null) {
            return false;
        }
        return this.pressed.get();
    }

    public final ReadOnlyBooleanProperty pressedProperty() {
        return this.pressedPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper pressedPropertyImpl() {
        if (this.pressed == null) {
            this.pressed = new Node$16(this);
        }
        return this.pressed;
    }

    public final void setOnContextMenuRequested(EventHandler<? super ContextMenuEvent> eventHandler) {
        this.onContextMenuRequestedProperty().set(eventHandler);
    }

    public final EventHandler<? super ContextMenuEvent> getOnContextMenuRequested() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.onContextMenuRequested();
    }

    public final ObjectProperty<EventHandler<? super ContextMenuEvent>> onContextMenuRequestedProperty() {
        return this.getEventHandlerProperties().onContextMenuRequestedProperty();
    }

    public final void setOnMouseClicked(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseClickedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseClicked() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMouseClicked();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseClickedProperty() {
        return this.getEventHandlerProperties().onMouseClickedProperty();
    }

    public final void setOnMouseDragged(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseDraggedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseDragged() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMouseDragged();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseDraggedProperty() {
        return this.getEventHandlerProperties().onMouseDraggedProperty();
    }

    public final void setOnMouseEntered(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseEntered() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMouseEntered();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseEnteredProperty() {
        return this.getEventHandlerProperties().onMouseEnteredProperty();
    }

    public final void setOnMouseExited(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseExited() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMouseExited();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseExitedProperty() {
        return this.getEventHandlerProperties().onMouseExitedProperty();
    }

    public final void setOnMouseMoved(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseMovedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseMoved() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMouseMoved();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseMovedProperty() {
        return this.getEventHandlerProperties().onMouseMovedProperty();
    }

    public final void setOnMousePressed(EventHandler<? super MouseEvent> eventHandler) {
        this.onMousePressedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMousePressed() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMousePressed();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMousePressedProperty() {
        return this.getEventHandlerProperties().onMousePressedProperty();
    }

    public final void setOnMouseReleased(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseReleased() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMouseReleased();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleasedProperty() {
        return this.getEventHandlerProperties().onMouseReleasedProperty();
    }

    public final void setOnDragDetected(EventHandler<? super MouseEvent> eventHandler) {
        this.onDragDetectedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnDragDetected() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnDragDetected();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onDragDetectedProperty() {
        return this.getEventHandlerProperties().onDragDetectedProperty();
    }

    public final void setOnMouseDragOver(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragOverProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragOver() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMouseDragOver();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragOverProperty() {
        return this.getEventHandlerProperties().onMouseDragOverProperty();
    }

    public final void setOnMouseDragReleased(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragReleased() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMouseDragReleased();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragReleasedProperty() {
        return this.getEventHandlerProperties().onMouseDragReleasedProperty();
    }

    public final void setOnMouseDragEntered(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragEntered() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMouseDragEntered();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragEnteredProperty() {
        return this.getEventHandlerProperties().onMouseDragEnteredProperty();
    }

    public final void setOnMouseDragExited(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragExited() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnMouseDragExited();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragExitedProperty() {
        return this.getEventHandlerProperties().onMouseDragExitedProperty();
    }

    public final void setOnScrollStarted(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollStartedProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScrollStarted() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnScrollStarted();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollStartedProperty() {
        return this.getEventHandlerProperties().onScrollStartedProperty();
    }

    public final void setOnScroll(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScroll() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnScroll();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollProperty() {
        return this.getEventHandlerProperties().onScrollProperty();
    }

    public final void setOnScrollFinished(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollFinishedProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScrollFinished() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnScrollFinished();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollFinishedProperty() {
        return this.getEventHandlerProperties().onScrollFinishedProperty();
    }

    public final void setOnRotationStarted(EventHandler<? super RotateEvent> eventHandler) {
        this.onRotationStartedProperty().set(eventHandler);
    }

    public final EventHandler<? super RotateEvent> getOnRotationStarted() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnRotationStarted();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotationStartedProperty() {
        return this.getEventHandlerProperties().onRotationStartedProperty();
    }

    public final void setOnRotate(EventHandler<? super RotateEvent> eventHandler) {
        this.onRotateProperty().set(eventHandler);
    }

    public final EventHandler<? super RotateEvent> getOnRotate() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnRotate();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotateProperty() {
        return this.getEventHandlerProperties().onRotateProperty();
    }

    public final void setOnRotationFinished(EventHandler<? super RotateEvent> eventHandler) {
        this.onRotationFinishedProperty().set(eventHandler);
    }

    public final EventHandler<? super RotateEvent> getOnRotationFinished() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnRotationFinished();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotationFinishedProperty() {
        return this.getEventHandlerProperties().onRotationFinishedProperty();
    }

    public final void setOnZoomStarted(EventHandler<? super ZoomEvent> eventHandler) {
        this.onZoomStartedProperty().set(eventHandler);
    }

    public final EventHandler<? super ZoomEvent> getOnZoomStarted() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnZoomStarted();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomStartedProperty() {
        return this.getEventHandlerProperties().onZoomStartedProperty();
    }

    public final void setOnZoom(EventHandler<? super ZoomEvent> eventHandler) {
        this.onZoomProperty().set(eventHandler);
    }

    public final EventHandler<? super ZoomEvent> getOnZoom() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnZoom();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomProperty() {
        return this.getEventHandlerProperties().onZoomProperty();
    }

    public final void setOnZoomFinished(EventHandler<? super ZoomEvent> eventHandler) {
        this.onZoomFinishedProperty().set(eventHandler);
    }

    public final EventHandler<? super ZoomEvent> getOnZoomFinished() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnZoomFinished();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomFinishedProperty() {
        return this.getEventHandlerProperties().onZoomFinishedProperty();
    }

    public final void setOnSwipeUp(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeUpProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeUp() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnSwipeUp();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeUpProperty() {
        return this.getEventHandlerProperties().onSwipeUpProperty();
    }

    public final void setOnSwipeDown(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeDownProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeDown() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnSwipeDown();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeDownProperty() {
        return this.getEventHandlerProperties().onSwipeDownProperty();
    }

    public final void setOnSwipeLeft(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeLeftProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeLeft() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnSwipeLeft();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeLeftProperty() {
        return this.getEventHandlerProperties().onSwipeLeftProperty();
    }

    public final void setOnSwipeRight(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeRightProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeRight() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnSwipeRight();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeRightProperty() {
        return this.getEventHandlerProperties().onSwipeRightProperty();
    }

    public final void setOnTouchPressed(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchPressedProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchPressed() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnTouchPressed();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchPressedProperty() {
        return this.getEventHandlerProperties().onTouchPressedProperty();
    }

    public final void setOnTouchMoved(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchMovedProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchMoved() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnTouchMoved();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchMovedProperty() {
        return this.getEventHandlerProperties().onTouchMovedProperty();
    }

    public final void setOnTouchReleased(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchReleased() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnTouchReleased();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchReleasedProperty() {
        return this.getEventHandlerProperties().onTouchReleasedProperty();
    }

    public final void setOnTouchStationary(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchStationaryProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchStationary() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnTouchStationary();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchStationaryProperty() {
        return this.getEventHandlerProperties().onTouchStationaryProperty();
    }

    public final void setOnKeyPressed(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyPressedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyPressed() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnKeyPressed();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressedProperty() {
        return this.getEventHandlerProperties().onKeyPressedProperty();
    }

    public final void setOnKeyReleased(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyReleased() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnKeyReleased();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleasedProperty() {
        return this.getEventHandlerProperties().onKeyReleasedProperty();
    }

    public final void setOnKeyTyped(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyTypedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyTyped() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnKeyTyped();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyTypedProperty() {
        return this.getEventHandlerProperties().onKeyTypedProperty();
    }

    public final void setOnInputMethodTextChanged(EventHandler<? super InputMethodEvent> eventHandler) {
        this.onInputMethodTextChangedProperty().set(eventHandler);
    }

    public final EventHandler<? super InputMethodEvent> getOnInputMethodTextChanged() {
        if (this.eventHandlerProperties == null) {
            return null;
        }
        return this.eventHandlerProperties.getOnInputMethodTextChanged();
    }

    public final ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChangedProperty() {
        return this.getEventHandlerProperties().onInputMethodTextChangedProperty();
    }

    public final void setInputMethodRequests(InputMethodRequests inputMethodRequests) {
        this.inputMethodRequestsProperty().set(inputMethodRequests);
    }

    public final InputMethodRequests getInputMethodRequests() {
        if (this.miscProperties == null) {
            return DEFAULT_INPUT_METHOD_REQUESTS;
        }
        return this.miscProperties.getInputMethodRequests();
    }

    public final ObjectProperty<InputMethodRequests> inputMethodRequestsProperty() {
        return this.getMiscProperties().inputMethodRequestsProperty();
    }

    final void setFocusQuietly(boolean bl2, boolean bl3) {
        this.focused.set(bl2);
        this.focusVisible.set(bl2 && bl3);
    }

    final void notifyFocusListeners() {
        this.focused.notifyListeners();
        this.focusVisible.notifyListeners();
        Node node = this;
        do {
            node.focusWithin.notifyListeners();
        } while ((node = node.getParent()) != null);
    }

    private void clearParentsFocusWithin(Node node) {
        if (node != null && this.focusWithin.get()) {
            for (Node node2 = node; node2 != null; node2 = node2.getParent()) {
                node2.focusWithin.adjust(-this.focusWithin.count);
            }
            node.notifyFocusListeners();
        }
    }

    protected final void setFocused(boolean bl2) {
        this.setFocusQuietly(bl2, false);
        this.notifyFocusListeners();
    }

    public final boolean isFocused() {
        return this.focused.get();
    }

    public final ReadOnlyBooleanProperty focusedProperty() {
        return this.focused;
    }

    public final boolean isFocusVisible() {
        return this.focusVisible.get();
    }

    public final ReadOnlyBooleanProperty focusVisibleProperty() {
        return this.focusVisible;
    }

    public final boolean isFocusWithin() {
        return this.focusWithin.get();
    }

    public final ReadOnlyBooleanProperty focusWithinProperty() {
        return this.focusWithin;
    }

    public final void setFocusTraversable(boolean bl2) {
        this.focusTraversableProperty().set(bl2);
    }

    public final boolean isFocusTraversable() {
        if (this.focusTraversable == null) {
            return false;
        }
        return this.focusTraversable.get();
    }

    public final BooleanProperty focusTraversableProperty() {
        if (this.focusTraversable == null) {
            this.focusTraversable = new Node$19(this, false);
        }
        return this.focusTraversable;
    }

    private void focusSetDirty(Scene scene) {
        if (scene != null && (this == scene.getFocusOwner() || this.isFocusTraversable())) {
            scene.setFocusDirty(true);
        }
    }

    public void requestFocus() {
        if (this.getScene() != null) {
            this.getScene().requestFocus(this, false);
        }
    }

    private void requestFocusVisible() {
        if (this.getScene() != null) {
            this.getScene().requestFocus(this, true);
        }
    }

    final boolean traverse(Direction direction, TraversalMethod traversalMethod) {
        if (this.getScene() == null) {
            return false;
        }
        return this.getScene().traverse(this, direction, traversalMethod);
    }

    public String toString() {
        boolean bl2;
        CharSequence charSequence = this.getClass().getName();
        charSequence = ((String)charSequence).substring(((String)charSequence).lastIndexOf(46) + 1);
        charSequence = new StringBuilder((String)charSequence);
        boolean bl3 = this.id != null && !"".equals(this.getId());
        boolean bl4 = bl2 = !this.getStyleClass().isEmpty();
        if (!bl3) {
            ((StringBuilder)charSequence).append('@');
            ((StringBuilder)charSequence).append(Integer.toHexString(this.hashCode()));
        } else {
            ((StringBuilder)charSequence).append("[id=");
            ((StringBuilder)charSequence).append(this.getId());
            if (!bl2) {
                ((StringBuilder)charSequence).append("]");
            }
        }
        if (bl2) {
            if (!bl3) {
                ((StringBuilder)charSequence).append('[');
            } else {
                ((StringBuilder)charSequence).append(", ");
            }
            ((StringBuilder)charSequence).append("styleClass=");
            ((StringBuilder)charSequence).append(this.getStyleClass());
            ((StringBuilder)charSequence).append("]");
        }
        return ((StringBuilder)charSequence).toString();
    }

    private void preprocessMouseEvent(MouseEvent mouseEvent) {
        EventType<? extends Event> eventType = ((Event)mouseEvent).getEventType();
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            for (eventType = this; eventType != null; eventType = ((Node)((Object)eventType)).getParent()) {
                ((Node)((Object)eventType)).setPressed(mouseEvent.isPrimaryButtonDown());
            }
            return;
        }
        if (eventType == MouseEvent.MOUSE_RELEASED) {
            for (eventType = this; eventType != null; eventType = ((Node)((Object)eventType)).getParent()) {
                ((Node)((Object)eventType)).setPressed(mouseEvent.isPrimaryButtonDown());
            }
            return;
        }
        if (mouseEvent.getTarget() == this) {
            if (eventType == MouseEvent.MOUSE_ENTERED || eventType == MouseEvent.MOUSE_ENTERED_TARGET) {
                this.setHover(true);
                return;
            }
            if (eventType == MouseEvent.MOUSE_EXITED || eventType == MouseEvent.MOUSE_EXITED_TARGET) {
                this.setHover(false);
                return;
            }
        }
    }

    void markDirtyLayoutBranch() {
        for (Parent parent = this.getParent(); parent != null && parent.layoutFlag == LayoutFlags.CLEAN; parent = parent.getParent()) {
            parent.setLayoutFlag(LayoutFlags.DIRTY_BRANCH);
            if (!parent.isSceneRoot()) continue;
            Toolkit.getToolkit().requestNextPulse();
            if (this.getSubScene() == null) continue;
            this.getSubScene().setDirtyLayout(parent);
        }
    }

    private boolean isWindowShowing() {
        EventTarget eventTarget = this.getScene();
        if (eventTarget == null) {
            return false;
        }
        return (eventTarget = ((Scene)eventTarget).getWindow()) != null && ((Window)eventTarget).isShowing();
    }

    final boolean isTreeShowing() {
        return this.isTreeVisible() && this.isWindowShowing();
    }

    private void updateTreeVisible(boolean bl2) {
        Parent parent;
        boolean bl3 = this.isVisible();
        Node node = this.getParent() != null ? this.getParent() : (this.clipParent != null ? this.clipParent : (parent = this.getSubScene() != null ? this.getSubScene() : null));
        if (bl3) {
            boolean bl4 = bl3 = parent == null || parent.isTreeVisible();
        }
        if (bl2 && parent != null && parent.isTreeVisible() && this.isDirty(DirtyBits.NODE_VISIBLE)) {
            this.addToSceneDirtyList();
        }
        this.setTreeVisible(bl3);
    }

    final void setTreeVisible(boolean bl2) {
        boolean node22;
        Object object2;
        while (((Node)object2).treeVisible != node22) {
            Object object;
            ((Node)object2).treeVisible = node22;
            ((Node)object2).updateCanReceiveFocus();
            Node node = object2;
            node.focusSetDirty(node.getScene());
            if (((Node)object2).getClip() != null) {
                ((Node)object2).getClip().updateTreeVisible(true);
            }
            if (((Node)object2).treeVisible && !((Node)object2).isDirtyEmpty()) {
                ((Node)object2).addToSceneDirtyList();
            }
            if (((Node)object2).treeVisibleProperty != null) {
                ((Node)object2).treeVisibleProperty.invalidate();
            }
            if ((object = object2) instanceof Parent) {
                Parent parent = (Parent)object;
                for (Node node2 : parent.getChildren()) {
                    node2.updateTreeVisible(true);
                }
                return;
            }
            object = object2;
            if (!(object instanceof SubScene)) break;
            object = (SubScene)object;
            if ((object = ((SubScene)object).getRoot()) == null) break;
            node22 = node22 && ((Node)object).isVisible();
            object2 = object;
        }
    }

    final boolean isTreeVisible() {
        return this.treeVisibleProperty().get();
    }

    final ReadOnlyBooleanProperty treeVisibleProperty() {
        if (this.treeVisibleProperty == null) {
            this.treeVisibleProperty = new Node$TreeVisibleProperty(this);
        }
        return this.treeVisibleProperty;
    }

    private void setCanReceiveFocus(boolean bl2) {
        this.canReceiveFocus = bl2;
    }

    final boolean isCanReceiveFocus() {
        return this.canReceiveFocus;
    }

    private void updateCanReceiveFocus() {
        Node node = this;
        node.setCanReceiveFocus(node.getScene() != null && !this.isDisabled() && this.isTreeVisible());
    }

    String indent() {
        Object object = "";
        for (Parent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            object = (String)object + "  ";
        }
        return object;
    }

    final void setShowMnemonics(boolean bl2) {
        this.showMnemonicsProperty().set(bl2);
    }

    final boolean isShowMnemonics() {
        if (this.showMnemonics == null) {
            return false;
        }
        return this.showMnemonics.get();
    }

    final BooleanProperty showMnemonicsProperty() {
        if (this.showMnemonics == null) {
            this.showMnemonics = new Node$20(this, false);
        }
        return this.showMnemonics;
    }

    public final void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcherProperty().set(eventDispatcher);
    }

    public final EventDispatcher getEventDispatcher() {
        return (EventDispatcher)this.eventDispatcherProperty().get();
    }

    public final ObjectProperty<EventDispatcher> eventDispatcherProperty() {
        this.initializeInternalEventDispatcher();
        return this.eventDispatcher;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventFilter(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventFilter(eventType, eventHandler);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().setEventHandler(eventType, eventHandler);
    }

    private NodeEventDispatcher getInternalEventDispatcher() {
        this.initializeInternalEventDispatcher();
        return this.internalEventDispatcher;
    }

    private void initializeInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = this.createInternalEventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty<NodeEventDispatcher>(this, "eventDispatcher", this.internalEventDispatcher);
        }
    }

    private NodeEventDispatcher createInternalEventDispatcher() {
        return new NodeEventDispatcher(this);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain2) {
        Object object;
        if (this.preprocessMouseEventDispatcher == null) {
            this.preprocessMouseEventDispatcher = (event, eventDispatchChain) -> {
                if ((event = eventDispatchChain.dispatchEvent(event)) instanceof MouseEvent) {
                    this.preprocessMouseEvent((MouseEvent)event);
                }
                return event;
            };
        }
        eventDispatchChain2 = eventDispatchChain2.prepend(this.preprocessMouseEventDispatcher);
        Object object2 = this;
        do {
            if (((Node)object2).eventDispatcher == null || (object = (EventDispatcher)((Node)object2).eventDispatcher.get()) == null) continue;
            eventDispatchChain2 = eventDispatchChain2.prepend((EventDispatcher)object);
        } while ((object2 = (object = ((Node)object2).getParent()) != null ? object : ((Node)object2).getSubScene()) != null);
        if (this.getScene() != null) {
            eventDispatchChain2 = this.getScene().buildEventDispatchChain(eventDispatchChain2);
        }
        return eventDispatchChain2;
    }

    public final void fireEvent(Event event) {
        PlatformLogger platformLogger;
        if (event instanceof InputEvent && (platformLogger = Logging.getInputLogger()).isLoggable(PlatformLogger$Level.FINE)) {
            EventType<? extends Event> eventType = event.getEventType();
            if (eventType == MouseEvent.MOUSE_ENTERED || eventType == MouseEvent.MOUSE_EXITED) {
                platformLogger.finer(event.toString());
            } else if (eventType == MouseEvent.MOUSE_MOVED || eventType == MouseEvent.MOUSE_DRAGGED) {
                platformLogger.finest(event.toString());
            } else {
                platformLogger.fine(event.toString());
            }
        }
        Event.fireEvent(this, event);
    }

    @Override
    public String getTypeSelector() {
        Class<?> clazz = this.getClass();
        Package package_ = clazz.getPackage();
        int n2 = 0;
        if (package_ != null) {
            n2 = package_.getName().length();
        }
        int n3 = clazz.getName().length();
        n3 = n2 > 0 && n2 < n3 ? n2 + 1 : 0;
        return clazz.getName().substring(n3);
    }

    @Override
    public Styleable getStyleableParent() {
        return this.getParent();
    }

    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }

    protected Cursor getInitialCursor() {
        return null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Node$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Node.getClassCssMetaData();
    }

    static List<Style> getMatchingStyles(CssMetaData cssMetaData, Styleable styleable) {
        return CssStyleHelper.getMatchingStyles(styleable, cssMetaData);
    }

    final ObservableMap<StyleableProperty<?>, List<Style>> getStyleMap() {
        Map<Object, Object> map = (ObservableMap)this.getProperties().get("STYLEMAP");
        if ((map = CssStyleHelper.getMatchingStyles(map, this)) != null) {
            if (map instanceof ObservableMap) {
                return map;
            }
            return FXCollections.observableMap(map);
        }
        return FXCollections.emptyObservableMap();
    }

    final void setStyleMap(ObservableMap<StyleableProperty<?>, List<Style>> observableMap) {
        if (observableMap != null) {
            this.getProperties().put("STYLEMAP", observableMap);
            return;
        }
        this.getProperties().remove("STYLEMAP");
    }

    Map<StyleableProperty<?>, List<Style>> findStyles(Map<StyleableProperty<?>, List<Style>> map) {
        if ((map = CssStyleHelper.getMatchingStyles(map, this)) != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    final CssFlags getCSSFlags() {
        return this.cssFlag;
    }

    private void requestCssStateTransition() {
        if (this.getScene() == null) {
            return;
        }
        if (this.cssFlag == CssFlags.CLEAN || this.cssFlag == CssFlags.DIRTY_BRANCH) {
            this.cssFlag = CssFlags.UPDATE;
            this.notifyParentsOfInvalidatedCSS();
        }
    }

    public final void pseudoClassStateChanged(PseudoClass pseudoClass, boolean bl2) {
        boolean bl3;
        if ((bl2 = bl2 ? this.pseudoClassStates.add(pseudoClass) : this.pseudoClassStates.remove(pseudoClass)) && this.styleHelper != null && (bl3 = this.styleHelper.pseudoClassStateChanged(pseudoClass))) {
            this.requestCssStateTransition();
        }
    }

    @Override
    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return this.unmodifiablePseudoClassStates;
    }

    final void notifyParentsOfInvalidatedCSS() {
        Node node = this.getSubScene();
        Parent parent = node != null ? ((SubScene)node).getRoot() : this.getScene().getRoot();
        if (!parent.isDirty(DirtyBits.NODE_CSS)) {
            NodeHelper.markDirty(parent, DirtyBits.NODE_CSS);
            if (node != null) {
                node.cssFlag = CssFlags.UPDATE;
                node.notifyParentsOfInvalidatedCSS();
            }
        }
        node = this.getParent();
        while (node != null) {
            if (node.cssFlag == CssFlags.CLEAN) {
                node.cssFlag = CssFlags.DIRTY_BRANCH;
                node = node.getParent();
                continue;
            }
            node = null;
        }
    }

    final void recalculateRelativeSizeProperties(Font font) {
        if (this.styleHelper != null) {
            this.styleHelper.recalculateRelativeSizeProperties(this, font);
        }
    }

    final void reapplyCSS() {
        if (this.getScene() == null) {
            return;
        }
        if (this.cssFlag == CssFlags.REAPPLY) {
            return;
        }
        if (this.cssFlag == CssFlags.DIRTY_BRANCH) {
            this.cssFlag = CssFlags.REAPPLY;
            return;
        }
        if (this.cssFlag == CssFlags.UPDATE) {
            this.cssFlag = CssFlags.REAPPLY;
            this.notifyParentsOfInvalidatedCSS();
            return;
        }
        this.reapplyCss();
        if (this.getParent() != null && this.getParent().isPerformingLayout()) {
            NodeHelper.processCSS(this);
            return;
        }
        this.notifyParentsOfInvalidatedCSS();
    }

    private void reapplyCss() {
        Object object = this.styleHelper;
        this.cssFlag = CssFlags.REAPPLY;
        this.styleHelper = CssStyleHelper.createStyleHelper(this);
        if (this instanceof Parent) {
            boolean bl2 = this.styleHelper == null || object != this.styleHelper || this.getParent() == null || this.getParent().cssFlag != CssFlags.CLEAN;
            if (bl2) {
                ObservableList<Node> observableList = ((Parent)this).getChildren();
                int n2 = observableList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Node node = (Node)observableList.get(i2);
                    node.reapplyCss();
                }
            }
        } else if (this instanceof SubScene) {
            object = ((SubScene)this).getRoot();
            if (object != null) {
                ((Node)object).reapplyCss();
            }
        } else if (this.styleHelper == null) {
            this.cssFlag = CssFlags.CLEAN;
            return;
        }
        this.cssFlag = CssFlags.UPDATE;
    }

    void processCSS() {
        switch (this.cssFlag) {
            case CLEAN: {
                return;
            }
            case DIRTY_BRANCH: {
                Object object = (Parent)this;
                ((Parent)this).cssFlag = CssFlags.CLEAN;
                object = ((Parent)object).getChildren();
                int n2 = object.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((Node)object.get(i2)).processCSS();
                }
                return;
            }
        }
        NodeHelper.processCSS(this);
    }

    public final void applyCss() {
        if (this.getScene() == null) {
            return;
        }
        if (this.cssFlag != CssFlags.REAPPLY) {
            this.cssFlag = CssFlags.UPDATE;
        }
        Node node = this;
        boolean bl2 = this.getScene().getRoot().isDirty(DirtyBits.NODE_CSS);
        if (bl2) {
            for (Parent parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.cssFlag != CssFlags.UPDATE && parent.cssFlag != CssFlags.REAPPLY) continue;
                node = parent;
            }
            if (node == this.getScene().getRoot()) {
                this.getScene().getRoot().clearDirty(DirtyBits.NODE_CSS);
            }
        }
        node.processCSS();
    }

    private void doProcessCSS() {
        if (this.cssFlag == CssFlags.CLEAN) {
            return;
        }
        if (this.cssFlag == CssFlags.REAPPLY) {
            this.reapplyCss();
        }
        this.cssFlag = CssFlags.CLEAN;
        if (this.styleHelper != null && this.getScene() != null) {
            this.styleHelper.transitionToState(this);
        }
    }

    public final void setAccessibleRole(AccessibleRole accessibleRole) {
        if (accessibleRole == null) {
            accessibleRole = AccessibleRole.NODE;
        }
        this.accessibleRoleProperty().set(accessibleRole);
    }

    public final AccessibleRole getAccessibleRole() {
        if (this.accessibleRole == null) {
            return AccessibleRole.NODE;
        }
        return (AccessibleRole)((Object)this.accessibleRoleProperty().get());
    }

    public final ObjectProperty<AccessibleRole> accessibleRoleProperty() {
        if (this.accessibleRole == null) {
            this.accessibleRole = new SimpleObjectProperty<AccessibleRole>(this, "accessibleRole", AccessibleRole.NODE);
        }
        return this.accessibleRole;
    }

    public final void setAccessibleRoleDescription(String string) {
        this.accessibleRoleDescriptionProperty().set(string);
    }

    public final String getAccessibleRoleDescription() {
        if (this.accessibilityProperties == null) {
            return null;
        }
        if (this.accessibilityProperties.accessibleRoleDescription == null) {
            return null;
        }
        return (String)this.accessibleRoleDescriptionProperty().get();
    }

    public final ObjectProperty<String> accessibleRoleDescriptionProperty() {
        return this.getAccessibilityProperties().getAccessibleRoleDescription();
    }

    public final void setAccessibleText(String string) {
        this.accessibleTextProperty().set(string);
    }

    public final String getAccessibleText() {
        if (this.accessibilityProperties == null) {
            return null;
        }
        if (this.accessibilityProperties.accessibleText == null) {
            return null;
        }
        return (String)this.accessibleTextProperty().get();
    }

    public final ObjectProperty<String> accessibleTextProperty() {
        return this.getAccessibilityProperties().getAccessibleText();
    }

    public final void setAccessibleHelp(String string) {
        this.accessibleHelpProperty().set(string);
    }

    public final String getAccessibleHelp() {
        if (this.accessibilityProperties == null) {
            return null;
        }
        if (this.accessibilityProperties.accessibleHelp == null) {
            return null;
        }
        return (String)this.accessibleHelpProperty().get();
    }

    public final ObjectProperty<String> accessibleHelpProperty() {
        return this.getAccessibilityProperties().getAccessibleHelp();
    }

    private Node$AccessibilityProperties getAccessibilityProperties() {
        if (this.accessibilityProperties == null) {
            this.accessibilityProperties = new Node$AccessibilityProperties(this);
        }
        return this.accessibilityProperties;
    }

    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case ROLE: {
                return this.getAccessibleRole();
            }
            case ROLE_DESCRIPTION: {
                return this.getAccessibleRoleDescription();
            }
            case TEXT: {
                return this.getAccessibleText();
            }
            case HELP: {
                return this.getAccessibleHelp();
            }
            case PARENT: {
                return this.getParent();
            }
            case SCENE: {
                return this.getScene();
            }
            case BOUNDS: {
                Node node = this;
                return node.localToScreen(node.getBoundsInLocal());
            }
            case DISABLED: {
                return this.isDisabled();
            }
            case FOCUSED: {
                return this.isFocused();
            }
            case VISIBLE: {
                return this.isVisible();
            }
            case LABELED_BY: {
                return this.labeledBy;
            }
        }
        return null;
    }

    public void executeAccessibleAction(AccessibleAction object, Object ... object2) {
        switch (Node$22.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                if (!this.isFocusTraversable()) break;
                this.requestFocus();
                return;
            }
            case 2: {
                object = this.getBoundsInLocal();
                object2 = this.localToScreen(((Bounds)object).getMaxX(), ((Bounds)object).getMaxY());
                object = new ContextMenuEvent(ContextMenuEvent.CONTEXT_MENU_REQUESTED, ((Bounds)object).getMaxX(), ((Bounds)object).getMaxY(), ((Point2D)object2).getX(), ((Point2D)object2).getY(), false, new PickResult((EventTarget)this, ((Bounds)object).getMaxX(), ((Bounds)object).getMaxY()));
                Event.fireEvent(this, (Event)object);
            }
        }
    }

    public final void notifyAccessibleAttributeChanged(AccessibleAttribute accessibleAttribute) {
        Scene scene;
        if (this.accessible == null && (scene = this.getScene()) != null) {
            this.accessible = scene.removeAccessible(this);
        }
        if (this.accessible != null) {
            this.accessible.sendNotification(accessibleAttribute);
        }
    }

    Accessible getAccessible() {
        Scene scene;
        if (this.accessible == null && (scene = this.getScene()) != null) {
            this.accessible = scene.removeAccessible(this);
        }
        if (this.accessible == null) {
            this.accessible = Application.GetApplication().createAccessible();
            this.accessible.setEventHandler(new Node$21(this));
        }
        return this.accessible;
    }

    void releaseAccessible() {
        Accessible accessible = this.accessible;
        if (accessible != null) {
            this.accessible = null;
            accessible.dispose();
        }
    }

    private /* synthetic */ void lambda$snapshot$0(SnapshotParameters object, WritableImage writableImage, Callback callback) {
        writableImage = this.doSnapshot((SnapshotParameters)object, writableImage);
        object = new SnapshotResult(writableImage, this, (SnapshotParameters)object);
        try {
            Void cfr_ignored_0 = (Void)callback.call(object);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Exception in snapshot callback");
            throwable.printStackTrace(System.err);
            return;
        }
    }

    static {
        PerformanceTracker.logEvent("Node class loaded");
        NodeHelper.setNodeAccessor(new Node$1());
        USER_DATA_KEY = new Object();
        DEFAULT_ROTATION_AXIS = Rotate.Z_AXIS;
        DEFAULT_CACHE_HINT = CacheHint.DEFAULT;
        DEFAULT_CLIP = null;
        DEFAULT_CURSOR = null;
        DEFAULT_DEPTH_TEST = DepthTest.INHERIT;
        DEFAULT_EFFECT = null;
        DEFAULT_INPUT_METHOD_REQUESTS = null;
        HOVER_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("hover");
        PRESSED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("pressed");
        DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("disabled");
        FOCUSED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("focused");
        FOCUS_VISIBLE_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("focus-visible");
        FOCUS_WITHIN_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("focus-within");
        SHOW_MNEMONICS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("show-mnemonics");
        boundsAccessor = (baseBounds, baseTransform, node) -> node.getGeomBounds(baseBounds, baseTransform);
    }
}

