/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Scene$ClickCounter;
import javafx.scene.Scene$TargetWrapper;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

class Scene$ClickGenerator {
    private Scene$ClickCounter lastPress = null;
    private Map<MouseButton, Scene$ClickCounter> counters = new EnumMap<MouseButton, Scene$ClickCounter>(MouseButton.class);
    private List<EventTarget> pressedTargets = new ArrayList<EventTarget>();
    private List<EventTarget> releasedTargets = new ArrayList<EventTarget>();

    public Scene$ClickGenerator() {
        for (MouseButton mouseButton : MouseButton.values()) {
            if (mouseButton == MouseButton.NONE) continue;
            this.counters.put(mouseButton, new Scene$ClickCounter());
        }
    }

    private MouseEvent preProcess(MouseEvent mouseEvent) {
        boolean bl2;
        for (Scene$ClickCounter scene$ClickCounter : this.counters.values()) {
            scene$ClickCounter.moved(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        }
        Scene$ClickCounter scene$ClickCounter = this.counters.get((Object)mouseEvent.getButton());
        boolean bl3 = bl2 = this.lastPress != null ? this.lastPress.isStill() : false;
        if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_PRESSED) {
            if (!mouseEvent.isPrimaryButtonDown()) {
                this.counters.get((Object)MouseButton.PRIMARY).clear();
            }
            if (!mouseEvent.isSecondaryButtonDown()) {
                this.counters.get((Object)MouseButton.SECONDARY).clear();
            }
            if (!mouseEvent.isMiddleButtonDown()) {
                this.counters.get((Object)MouseButton.MIDDLE).clear();
            }
            if (!mouseEvent.isBackButtonDown()) {
                this.counters.get((Object)MouseButton.BACK).clear();
            }
            if (!mouseEvent.isForwardButtonDown()) {
                this.counters.get((Object)MouseButton.FORWARD).clear();
            }
            scene$ClickCounter.applyOut();
            scene$ClickCounter.inc();
            scene$ClickCounter.start(mouseEvent.getSceneX(), mouseEvent.getSceneY());
            this.lastPress = scene$ClickCounter;
        }
        return new MouseEvent(((Event)mouseEvent).getEventType(), mouseEvent.getSceneX(), mouseEvent.getSceneY(), mouseEvent.getScreenX(), mouseEvent.getScreenY(), mouseEvent.getButton(), scene$ClickCounter != null && ((Event)mouseEvent).getEventType() != MouseEvent.MOUSE_MOVED ? scene$ClickCounter.get() : 0, mouseEvent.isShiftDown(), mouseEvent.isControlDown(), mouseEvent.isAltDown(), mouseEvent.isMetaDown(), mouseEvent.isPrimaryButtonDown(), mouseEvent.isMiddleButtonDown(), mouseEvent.isSecondaryButtonDown(), mouseEvent.isBackButtonDown(), mouseEvent.isForwardButtonDown(), mouseEvent.isSynthesized(), mouseEvent.isPopupTrigger(), bl2, mouseEvent.getPickResult());
    }

    private void postProcess(MouseEvent mouseEvent, Scene$TargetWrapper scene$TargetWrapper, Scene$TargetWrapper scene$TargetWrapper2) {
        if (((Event)mouseEvent).getEventType() == MouseEvent.MOUSE_RELEASED) {
            Scene$ClickCounter scene$ClickCounter = this.counters.get((Object)mouseEvent.getButton());
            scene$TargetWrapper.fillHierarchy(this.pressedTargets);
            scene$TargetWrapper2.fillHierarchy(this.releasedTargets);
            int n2 = this.pressedTargets.size() - 1;
            EventTarget eventTarget = null;
            for (int i2 = this.releasedTargets.size() - 1; n2 >= 0 && i2 >= 0 && this.pressedTargets.get(n2) == this.releasedTargets.get(i2); --n2, --i2) {
                eventTarget = this.pressedTargets.get(n2);
            }
            this.pressedTargets.clear();
            this.releasedTargets.clear();
            if (eventTarget != null && this.lastPress != null) {
                mouseEvent = new MouseEvent(null, eventTarget, MouseEvent.MOUSE_CLICKED, mouseEvent.getSceneX(), mouseEvent.getSceneY(), mouseEvent.getScreenX(), mouseEvent.getScreenY(), mouseEvent.getButton(), scene$ClickCounter.get(), mouseEvent.isShiftDown(), mouseEvent.isControlDown(), mouseEvent.isAltDown(), mouseEvent.isMetaDown(), mouseEvent.isPrimaryButtonDown(), mouseEvent.isMiddleButtonDown(), mouseEvent.isSecondaryButtonDown(), mouseEvent.isBackButtonDown(), mouseEvent.isForwardButtonDown(), mouseEvent.isSynthesized(), mouseEvent.isPopupTrigger(), this.lastPress.isStill(), mouseEvent.getPickResult());
                Event.fireEvent(eventTarget, mouseEvent);
            }
        }
    }
}

