/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Application;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.LayoutFlags;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneEventDispatcher;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.scene.input.TouchPointHelper;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.SceneTraversalEngine;
import com.sun.javafx.scene.traversal.TopMostTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalMethod;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.Toolkit$ImageRenderingContext;
import com.sun.javafx.tk.Toolkit$WritableImageAccessor;
import com.sun.javafx.util.Utils;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Camera;
import javafx.scene.Cursor;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene$1;
import javafx.scene.Scene$10;
import javafx.scene.Scene$11;
import javafx.scene.Scene$12;
import javafx.scene.Scene$13;
import javafx.scene.Scene$14;
import javafx.scene.Scene$15;
import javafx.scene.Scene$16;
import javafx.scene.Scene$17;
import javafx.scene.Scene$18;
import javafx.scene.Scene$19;
import javafx.scene.Scene$2;
import javafx.scene.Scene$20;
import javafx.scene.Scene$21;
import javafx.scene.Scene$22;
import javafx.scene.Scene$23;
import javafx.scene.Scene$24;
import javafx.scene.Scene$25;
import javafx.scene.Scene$26;
import javafx.scene.Scene$27;
import javafx.scene.Scene$28;
import javafx.scene.Scene$29;
import javafx.scene.Scene$3;
import javafx.scene.Scene$30;
import javafx.scene.Scene$31;
import javafx.scene.Scene$32;
import javafx.scene.Scene$33;
import javafx.scene.Scene$34;
import javafx.scene.Scene$35;
import javafx.scene.Scene$36;
import javafx.scene.Scene$37;
import javafx.scene.Scene$38;
import javafx.scene.Scene$39;
import javafx.scene.Scene$4;
import javafx.scene.Scene$40;
import javafx.scene.Scene$41;
import javafx.scene.Scene$42;
import javafx.scene.Scene$43;
import javafx.scene.Scene$44;
import javafx.scene.Scene$45;
import javafx.scene.Scene$46;
import javafx.scene.Scene$47;
import javafx.scene.Scene$48;
import javafx.scene.Scene$49;
import javafx.scene.Scene$5;
import javafx.scene.Scene$50;
import javafx.scene.Scene$51;
import javafx.scene.Scene$52;
import javafx.scene.Scene$6;
import javafx.scene.Scene$7;
import javafx.scene.Scene$8;
import javafx.scene.Scene$9;
import javafx.scene.Scene$ClickGenerator;
import javafx.scene.Scene$DirtyBits;
import javafx.scene.Scene$DnDGesture;
import javafx.scene.Scene$DragDetectedState;
import javafx.scene.Scene$DragGestureListener;
import javafx.scene.Scene$DropTargetListener;
import javafx.scene.Scene$EffectiveOrientationProperty;
import javafx.scene.Scene$FocusOwnerProperty;
import javafx.scene.Scene$InputMethodRequestsDelegate;
import javafx.scene.Scene$MouseHandler;
import javafx.scene.Scene$ScenePeerListener;
import javafx.scene.Scene$ScenePeerPaintListener;
import javafx.scene.Scene$ScenePulseListener;
import javafx.scene.Scene$TargetWrapper;
import javafx.scene.Scene$TouchGesture;
import javafx.scene.Scene$TouchMap;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SnapshotResult;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.GestureEvent;
import javafx.scene.input.InputEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.Mnemonic;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.input.TouchPoint;
import javafx.scene.input.TouchPoint$State;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;

@DefaultProperty(value="root")
public class Scene
implements EventTarget {
    private double widthSetByUser = -1.0;
    private double heightSetByUser = -1.0;
    private boolean sizeInitialized = false;
    private final boolean depthBuffer;
    private final SceneAntialiasing antiAliasing;
    private EnumSet<Scene$DirtyBits> dirtyBits = EnumSet.noneOf(Scene$DirtyBits.class);
    final AccessControlContext acc = AccessController.getContext();
    private Camera defaultCamera;
    private Node transientFocusContainer;
    private static final int MIN_DIRTY_CAPACITY = 30;
    private static boolean inSynchronizer;
    private static boolean inMousePick;
    private static boolean allowPGAccess;
    private static int pgAccessCount;
    private static final boolean PLATFORM_DRAG_GESTURE_INITIATION = false;
    private Node[] dirtyNodes;
    private int dirtyNodesSize;
    private TKScene peer;
    Scene$ScenePulseListener scenePulseListener = new Scene$ScenePulseListener(this);
    private List<Runnable> preLayoutPulseListeners;
    private List<Runnable> postLayoutPulseListeners;
    private ReadOnlyObjectWrapper<Window> window;
    Scene$DnDGesture dndGesture = null;
    Scene$DragGestureListener dragGestureListener;
    private ReadOnlyDoubleWrapper x;
    private ReadOnlyDoubleWrapper y;
    private ReadOnlyDoubleWrapper width;
    private ReadOnlyDoubleWrapper height;
    private Scene$TargetWrapper tmpTargetWrapper = new Scene$TargetWrapper();
    private ObjectProperty<Camera> camera;
    private ObjectProperty<Paint> fill;
    private ObjectProperty<Parent> root;
    Parent oldRoot;
    private static TKPulseListener snapshotPulseListener;
    private static List<Runnable> snapshotRunnableListA;
    private static List<Runnable> snapshotRunnableListB;
    private static List<Runnable> snapshotRunnableList;
    private ObjectProperty<Cursor> cursor;
    private final ObservableList<String> stylesheets = new Scene$10(this);
    private ObjectProperty<String> userAgentStylesheet = null;
    private PerformanceTracker tracker;
    private static final Object trackerMonitor;
    private Scene$MouseHandler mouseHandler;
    private Scene$ClickGenerator clickGenerator;
    private Point2D cursorScreenPos;
    private Point2D cursorScenePos;
    private final Scene$TouchGesture scrollGesture = new Scene$TouchGesture();
    private final Scene$TouchGesture zoomGesture = new Scene$TouchGesture();
    private final Scene$TouchGesture rotateGesture = new Scene$TouchGesture();
    private final Scene$TouchGesture swipeGesture = new Scene$TouchGesture();
    private Scene$TouchMap touchMap = new Scene$TouchMap();
    private TouchEvent nextTouchEvent = null;
    private TouchPoint[] touchPoints = null;
    private int touchEventSetId = 0;
    private int touchPointIndex = 0;
    private Map<Integer, EventTarget> touchTargets = new HashMap<Integer, EventTarget>();
    private final InvalidationListener sceneWindowFocusedListener = observable -> this.setWindowFocused(((ReadOnlyBooleanProperty)observable).get());
    private boolean windowFocused;
    private boolean focusDirty = true;
    private TopMostTraversalEngine traversalEngine = new SceneTraversalEngine(this);
    private Scene$FocusOwnerProperty focusOwner = new Scene$FocusOwnerProperty(this);
    Runnable testPulseListener = null;
    private List<LightBase> lights = new ArrayList<LightBase>();
    private ObjectProperty<EventDispatcher> eventDispatcher;
    private SceneEventDispatcher internalEventDispatcher;
    private ObjectProperty<EventHandler<? super ContextMenuEvent>> onContextMenuRequested;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseClicked;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseDragged;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseEntered;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseExited;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseMoved;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMousePressed;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleased;
    private ObjectProperty<EventHandler<? super MouseEvent>> onDragDetected;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragOver;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragReleased;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragEntered;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragExited;
    private ObjectProperty<EventHandler<? super ScrollEvent>> onScrollStarted;
    private ObjectProperty<EventHandler<? super ScrollEvent>> onScroll;
    private ObjectProperty<EventHandler<? super ScrollEvent>> onScrollFinished;
    private ObjectProperty<EventHandler<? super RotateEvent>> onRotationStarted;
    private ObjectProperty<EventHandler<? super RotateEvent>> onRotate;
    private ObjectProperty<EventHandler<? super RotateEvent>> onRotationFinished;
    private ObjectProperty<EventHandler<? super ZoomEvent>> onZoomStarted;
    private ObjectProperty<EventHandler<? super ZoomEvent>> onZoom;
    private ObjectProperty<EventHandler<? super ZoomEvent>> onZoomFinished;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeUp;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeDown;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeLeft;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeRight;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchPressed;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchMoved;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchReleased;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchStationary;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragEntered;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragExited;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragOver;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragDropped;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragDone;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressed;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleased;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyTyped;
    private ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChanged;
    private static final Object USER_DATA_KEY;
    private ObservableMap<Object, Object> properties;
    private static final NodeOrientation defaultNodeOrientation;
    private ObjectProperty<NodeOrientation> nodeOrientation;
    private Scene$EffectiveOrientationProperty effectiveNodeOrientationProperty;
    private NodeOrientation effectiveNodeOrientation;
    private Map<Node, Accessible> accMap;
    private Accessible accessible;

    public Scene(@NamedArg(value="root") Parent parent) {
        this(parent, -1.0, -1.0, Color.WHITE, false, SceneAntialiasing.DISABLED);
    }

    public Scene(@NamedArg(value="root") Parent parent, @NamedArg(value="width") double d2, @NamedArg(value="height") double d3) {
        this(parent, d2, d3, Color.WHITE, false, SceneAntialiasing.DISABLED);
    }

    public Scene(@NamedArg(value="root") Parent parent, @NamedArg(value="fill", defaultValue="WHITE") Paint paint) {
        this(parent, -1.0, -1.0, paint, false, SceneAntialiasing.DISABLED);
    }

    public Scene(@NamedArg(value="root") Parent parent, @NamedArg(value="width") double d2, @NamedArg(value="height") double d3, @NamedArg(value="fill", defaultValue="WHITE") Paint paint) {
        this(parent, d2, d3, paint, false, SceneAntialiasing.DISABLED);
    }

    public Scene(@NamedArg(value="root") Parent parent, @NamedArg(value="width", defaultValue="-1") double d2, @NamedArg(value="height", defaultValue="-1") double d3, @NamedArg(value="depthBuffer") boolean bl2) {
        this(parent, d2, d3, Color.WHITE, bl2, SceneAntialiasing.DISABLED);
    }

    public Scene(@NamedArg(value="root") Parent object, @NamedArg(value="width", defaultValue="-1") double d2, @NamedArg(value="height", defaultValue="-1") double d3, @NamedArg(value="depthBuffer") boolean bl2, @NamedArg(value="antiAliasing", defaultValue="DISABLED") SceneAntialiasing sceneAntialiasing) {
        this((Parent)object, d2, d3, Color.WHITE, bl2, sceneAntialiasing);
        if (sceneAntialiasing != null && sceneAntialiasing != SceneAntialiasing.DISABLED && !Toolkit.getToolkit().isMSAASupported()) {
            object = Scene.class.getName();
            PlatformLogger.getLogger((String)object).warning("System can't support antiAliasing");
        }
    }

    private Scene(Parent parent, double d2, double d3, Paint paint, boolean bl2, SceneAntialiasing sceneAntialiasing) {
        this.depthBuffer = bl2;
        this.antiAliasing = sceneAntialiasing;
        if (parent == null) {
            throw new NullPointerException("Root cannot be null");
        }
        if ((bl2 || sceneAntialiasing != null && sceneAntialiasing != SceneAntialiasing.DISABLED) && !Platform.isSupported(ConditionalFeature.SCENE3D)) {
            String string = Scene.class.getName();
            PlatformLogger.getLogger(string).warning("System can't support ConditionalFeature.SCENE3D");
        }
        this.init();
        this.setRoot(parent);
        this.init(d2, d3);
        this.setFill(paint);
        EventHandler<InputEvent> eventHandler = object -> {
            object = this.getFocusOwner();
            if (object != null) {
                this.setFocusOwner((Node)((Object)object), false);
            }
        };
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)eventHandler);
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, (EventHandler)eventHandler);
    }

    static boolean isPGAccessAllowed() {
        return inSynchronizer || inMousePick || allowPGAccess;
    }

    static void setAllowPGAccess(boolean bl2) {
        if (Utils.assertionEnabled()) {
            if (bl2) {
                ++pgAccessCount;
                allowPGAccess = true;
                return;
            }
            if (pgAccessCount <= 0) {
                throw new AssertionError((Object)"*** pgAccessCount underflow");
            }
            if (--pgAccessCount == 0) {
                allowPGAccess = false;
            }
        }
    }

    void addToDirtyList(Node node) {
        if ((this.dirtyNodes == null || this.dirtyNodesSize == 0) && this.peer != null) {
            Toolkit.getToolkit().requestNextPulse();
        }
        if (this.dirtyNodes != null) {
            if (this.dirtyNodesSize == this.dirtyNodes.length) {
                Node[] nodeArray = new Node[this.dirtyNodesSize + (this.dirtyNodesSize >> 1)];
                System.arraycopy(this.dirtyNodes, 0, nodeArray, 0, this.dirtyNodesSize);
                this.dirtyNodes = nodeArray;
            }
            this.dirtyNodes[this.dirtyNodesSize++] = node;
        }
    }

    private void doCSSPass() {
        Parent parent = this.getRoot();
        if (parent.cssFlag != CssFlags.CLEAN) {
            parent.clearDirty(DirtyBits.NODE_CSS);
            parent.processCSS();
        }
    }

    void doLayoutPass() {
        Parent parent = this.getRoot();
        if (parent != null) {
            parent.layout();
        }
    }

    TKScene getPeer() {
        return this.peer;
    }

    public final void addPreLayoutPulseListener(Runnable runnable) {
        Toolkit.getToolkit().checkFxUserThread();
        if (runnable == null) {
            throw new NullPointerException("Scene pulse listener should not be null");
        }
        if (this.preLayoutPulseListeners == null) {
            this.preLayoutPulseListeners = new CopyOnWriteArrayList<Runnable>();
        }
        this.preLayoutPulseListeners.add(runnable);
    }

    public final void removePreLayoutPulseListener(Runnable runnable) {
        Toolkit.getToolkit().checkFxUserThread();
        if (this.preLayoutPulseListeners == null) {
            return;
        }
        this.preLayoutPulseListeners.remove(runnable);
    }

    public final void addPostLayoutPulseListener(Runnable runnable) {
        Toolkit.getToolkit().checkFxUserThread();
        if (runnable == null) {
            throw new NullPointerException("Scene pulse listener should not be null");
        }
        if (this.postLayoutPulseListeners == null) {
            this.postLayoutPulseListeners = new CopyOnWriteArrayList<Runnable>();
        }
        this.postLayoutPulseListeners.add(runnable);
    }

    public final void removePostLayoutPulseListener(Runnable runnable) {
        Toolkit.getToolkit().checkFxUserThread();
        if (this.postLayoutPulseListeners == null) {
            return;
        }
        this.postLayoutPulseListeners.remove(runnable);
    }

    public final SceneAntialiasing getAntiAliasing() {
        return this.antiAliasing;
    }

    private boolean getAntiAliasingInternal() {
        if (this.antiAliasing != null && Toolkit.getToolkit().isMSAASupported() && Platform.isSupported(ConditionalFeature.SCENE3D)) {
            return this.antiAliasing != SceneAntialiasing.DISABLED;
        }
        return false;
    }

    void setWindow(Window window) {
        this.windowPropertyImpl().set(window);
    }

    public final Window getWindow() {
        if (this.window == null) {
            return null;
        }
        return (Window)this.window.get();
    }

    public final ReadOnlyObjectProperty<Window> windowProperty() {
        return this.windowPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Window> windowPropertyImpl() {
        if (this.window == null) {
            this.window = new Scene$3(this);
        }
        return this.window;
    }

    void initPeer() {
        assert (this.peer == null);
        Object object = this.getWindow();
        assert (object != null);
        if ((object = WindowHelper.getPeer((Window)object)) == null) {
            return;
        }
        boolean bl2 = Platform.isSupported(ConditionalFeature.TRANSPARENT_WINDOW);
        if (!bl2) {
            PlatformImpl.addNoTransparencyStylesheetToScene(this);
        }
        PerformanceTracker.logEvent("Scene.initPeer started");
        Scene.setAllowPGAccess(true);
        Toolkit toolkit = Toolkit.getToolkit();
        this.peer = object.createTKScene(this.isDepthBufferInternal(), this.getAntiAliasingInternal(), this.acc);
        PerformanceTracker.logEvent("Scene.initPeer TKScene created");
        this.peer.setTKSceneListener(new Scene$ScenePeerListener(this));
        this.peer.setTKScenePaintListener(new Scene$ScenePeerPaintListener(this));
        PerformanceTracker.logEvent("Scene.initPeer TKScene set");
        this.peer.setRoot((NGNode)this.getRoot().getPeer());
        this.peer.setFillPaint(this.getFill() == null ? null : toolkit.getPaint(this.getFill()));
        NodeHelper.updatePeer(this.getEffectiveCamera());
        this.peer.setCamera((NGCamera)this.getEffectiveCamera().getPeer());
        this.peer.markDirty();
        PerformanceTracker.logEvent("Scene.initPeer TKScene initialized");
        Scene.setAllowPGAccess(false);
        toolkit.addSceneTkPulseListener(this.scenePulseListener);
        toolkit.enableDrop(this.peer, new Scene$DropTargetListener(this));
        toolkit.installInputMethodRequests(this.peer, new Scene$InputMethodRequestsDelegate(this));
        PerformanceTracker.logEvent("Scene.initPeer finished");
    }

    void disposePeer() {
        if (this.peer == null) {
            return;
        }
        PerformanceTracker.logEvent("Scene.disposePeer started");
        Object object = Toolkit.getToolkit();
        ((Toolkit)object).removeSceneTkPulseListener(this.scenePulseListener);
        if (this.accessible != null) {
            this.disposeAccessibles();
            object = this.getRoot();
            if (object != null) {
                ((Node)object).releaseAccessible();
            }
            this.accessible.dispose();
            this.accessible = null;
        }
        this.peer.dispose();
        this.peer = null;
        PerformanceTracker.logEvent("Scene.disposePeer finished");
    }

    private final void setX(double d2) {
        this.xPropertyImpl().set(d2);
    }

    public final double getX() {
        if (this.x == null) {
            return 0.0;
        }
        return this.x.get();
    }

    public final ReadOnlyDoubleProperty xProperty() {
        return this.xPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper xPropertyImpl() {
        if (this.x == null) {
            this.x = new ReadOnlyDoubleWrapper(this, "x");
        }
        return this.x;
    }

    private final void setY(double d2) {
        this.yPropertyImpl().set(d2);
    }

    public final double getY() {
        if (this.y == null) {
            return 0.0;
        }
        return this.y.get();
    }

    public final ReadOnlyDoubleProperty yProperty() {
        return this.yPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper yPropertyImpl() {
        if (this.y == null) {
            this.y = new ReadOnlyDoubleWrapper(this, "y");
        }
        return this.y;
    }

    private final void setWidth(double d2) {
        this.widthPropertyImpl().set(d2);
    }

    public final double getWidth() {
        if (this.width == null) {
            return 0.0;
        }
        return this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.widthPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper widthPropertyImpl() {
        if (this.width == null) {
            this.width = new Scene$4(this);
        }
        return this.width;
    }

    private final void setHeight(double d2) {
        this.heightPropertyImpl().set(d2);
    }

    public final double getHeight() {
        if (this.height == null) {
            return 0.0;
        }
        return this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.heightPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper heightPropertyImpl() {
        if (this.height == null) {
            this.height = new Scene$5(this);
        }
        return this.height;
    }

    void resizeRootOnSceneSizeChange(double d2, double d3) {
        this.getRoot().resize(d2, d3);
    }

    public final void setCamera(Camera camera) {
        this.cameraProperty().set(camera);
    }

    public final Camera getCamera() {
        if (this.camera == null) {
            return null;
        }
        return (Camera)this.camera.get();
    }

    public final ObjectProperty<Camera> cameraProperty() {
        if (this.camera == null) {
            this.camera = new Scene$6(this);
        }
        return this.camera;
    }

    Camera getEffectiveCamera() {
        Camera camera = this.getCamera();
        if (camera == null || camera instanceof PerspectiveCamera && !Platform.isSupported(ConditionalFeature.SCENE3D)) {
            if (this.defaultCamera == null) {
                this.defaultCamera = new ParallelCamera();
                this.defaultCamera.setOwnerScene(this);
                this.defaultCamera.setViewWidth(this.getWidth());
                this.defaultCamera.setViewHeight(this.getHeight());
            }
            return this.defaultCamera;
        }
        return camera;
    }

    void markCameraDirty() {
        this.markDirty(Scene$DirtyBits.CAMERA_DIRTY);
        this.setNeedsRepaint();
    }

    void markCursorDirty() {
        this.markDirty(Scene$DirtyBits.CURSOR_DIRTY);
    }

    public final void setFill(Paint paint) {
        this.fillProperty().set(paint);
    }

    public final Paint getFill() {
        if (this.fill == null) {
            return Color.WHITE;
        }
        return (Paint)this.fill.get();
    }

    public final ObjectProperty<Paint> fillProperty() {
        if (this.fill == null) {
            this.fill = new Scene$7(this, Color.WHITE);
        }
        return this.fill;
    }

    public final void setRoot(Parent parent) {
        this.rootProperty().set(parent);
    }

    public final Parent getRoot() {
        if (this.root == null) {
            return null;
        }
        return (Parent)this.root.get();
    }

    public final ObjectProperty<Parent> rootProperty() {
        if (this.root == null) {
            this.root = new Scene$8(this);
        }
        return this.root;
    }

    void setNeedsRepaint() {
        if (this.peer != null) {
            this.peer.entireSceneNeedsRepaint();
        }
    }

    void doCSSLayoutSyncForSnapshot(Node node) {
        if (!this.sizeInitialized) {
            this.preferredSize();
        } else {
            this.doCSSPass();
        }
        this.doLayoutPass();
        this.getRoot().updateBounds();
        if (this.peer != null) {
            this.peer.waitForRenderingToComplete();
            this.peer.waitForSynchronization();
            try {
                this.scenePulseListener.synchronizeSceneNodes();
            }
            finally {
                this.peer.releaseSynchronization(false);
            }
        } else {
            this.scenePulseListener.synchronizeSceneNodes();
        }
    }

    static WritableImage doSnapshot(Scene scene, double d2, double d3, double d4, double d5, Node node, BaseTransform baseTransform, boolean bl2, Paint paint, Camera camera, WritableImage writableImage) {
        int n2;
        int n3;
        Toolkit toolkit = Toolkit.getToolkit();
        Toolkit$ImageRenderingContext toolkit$ImageRenderingContext = new Toolkit$ImageRenderingContext();
        int n4 = (int)Math.floor(d2);
        int n5 = (int)Math.floor(d3);
        if (writableImage == null) {
            int n6 = (int)Math.ceil(d2 + d4);
            int n7 = (int)Math.ceil(d3 + d5);
            n3 = Math.max(n6 - n4, 1);
            n2 = Math.max(n7 - n5, 1);
            writableImage = new WritableImage(n3, n2);
        } else {
            n3 = (int)writableImage.getWidth();
            n2 = (int)writableImage.getHeight();
        }
        Scene.setAllowPGAccess(true);
        toolkit$ImageRenderingContext.x = n4;
        toolkit$ImageRenderingContext.y = n5;
        toolkit$ImageRenderingContext.width = n3;
        toolkit$ImageRenderingContext.height = n2;
        toolkit$ImageRenderingContext.transform = baseTransform;
        toolkit$ImageRenderingContext.depthBuffer = bl2;
        toolkit$ImageRenderingContext.root = node.getPeer();
        toolkit$ImageRenderingContext.platformPaint = paint == null ? null : toolkit.getPaint(paint);
        double d6 = 1.0;
        double d7 = 1.0;
        if (camera != null) {
            d6 = camera.getViewWidth();
            d7 = camera.getViewHeight();
            camera.setViewWidth(n3);
            camera.setViewHeight(n2);
            NodeHelper.updatePeer(camera);
            toolkit$ImageRenderingContext.camera = (NGCamera)camera.getPeer();
        } else {
            toolkit$ImageRenderingContext.camera = null;
        }
        toolkit$ImageRenderingContext.lights = null;
        if (scene != null && !scene.lights.isEmpty()) {
            toolkit$ImageRenderingContext.lights = new NGLightBase[scene.lights.size()];
            for (n3 = 0; n3 < scene.lights.size(); ++n3) {
                toolkit$ImageRenderingContext.lights[n3] = (NGLightBase)scene.lights.get(n3).getPeer();
            }
        }
        Toolkit$WritableImageAccessor toolkit$WritableImageAccessor = Toolkit.getWritableImageAccessor();
        toolkit$ImageRenderingContext.platformImage = toolkit$WritableImageAccessor.getTkImageLoader(writableImage);
        Scene.setAllowPGAccess(false);
        Object object = toolkit.renderToImage(toolkit$ImageRenderingContext);
        if (object != null) {
            toolkit$WritableImageAccessor.loadTkImage(writableImage, object);
        }
        if (camera != null) {
            Scene.setAllowPGAccess(true);
            camera.setViewWidth(d6);
            camera.setViewHeight(d7);
            NodeHelper.updatePeer(camera);
            Scene.setAllowPGAccess(false);
        }
        if (scene != null && scene.peer != null) {
            scene.setNeedsRepaint();
        }
        return writableImage;
    }

    private WritableImage doSnapshot(WritableImage writableImage) {
        Scene scene = this;
        scene.doCSSLayoutSyncForSnapshot(scene.getRoot());
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        BaseTransform baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        return Scene.doSnapshot(this, 0.0, 0.0, d2, d3, this.getRoot(), baseTransform, this.isDepthBufferInternal(), this.getFill(), this.getEffectiveCamera(), writableImage);
    }

    static void addSnapshotRunnable(Runnable runnable) {
        Toolkit.getToolkit().checkFxUserThread();
        if (snapshotPulseListener == null) {
            snapshotRunnableListA = new ArrayList<Runnable>();
            snapshotRunnableListB = new ArrayList<Runnable>();
            snapshotRunnableList = snapshotRunnableListA;
            snapshotPulseListener = () -> {
                if (snapshotRunnableList.size() > 0) {
                    List<Runnable> list = snapshotRunnableList;
                    snapshotRunnableList = snapshotRunnableList == snapshotRunnableListA ? snapshotRunnableListB : snapshotRunnableListA;
                    for (Runnable runnable : list) {
                        try {
                            runnable.run();
                        }
                        catch (Throwable throwable) {
                            System.err.println("Exception in snapshot runnable");
                            throwable.printStackTrace(System.err);
                        }
                    }
                    list.clear();
                }
            };
            Toolkit.getToolkit().addPostSceneTkPulseListener(snapshotPulseListener);
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        snapshotRunnableList.add(() -> AccessController.doPrivileged(() -> {
            runnable.run();
            return null;
        }, accessControlContext));
        Toolkit.getToolkit().requestNextPulse();
    }

    public WritableImage snapshot(WritableImage writableImage) {
        Toolkit.getToolkit().checkFxUserThread();
        return this.doSnapshot(writableImage);
    }

    public void snapshot(Callback<SnapshotResult, Void> object, WritableImage writableImage) {
        Toolkit.getToolkit().checkFxUserThread();
        if (object == null) {
            throw new NullPointerException("The callback must not be null");
        }
        object = () -> {
            writableImage = this.doSnapshot(writableImage);
            writableImage = new SnapshotResult(writableImage, this, null);
            try {
                Void cfr_ignored_0 = (Void)object.call(writableImage);
                return;
            }
            catch (Throwable throwable) {
                System.err.println("Exception in snapshot callback");
                throwable.printStackTrace(System.err);
                return;
            }
        };
        Scene.addSnapshotRunnable((Runnable)object);
    }

    public final void setCursor(Cursor cursor) {
        this.cursorProperty().set(cursor);
    }

    public final Cursor getCursor() {
        if (this.cursor == null) {
            return null;
        }
        return (Cursor)this.cursor.get();
    }

    public final ObjectProperty<Cursor> cursorProperty() {
        if (this.cursor == null) {
            this.cursor = new Scene$9(this);
        }
        return this.cursor;
    }

    public Node lookup(String string) {
        return ((Node)this.getRoot()).lookup(string);
    }

    public final ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }

    public final ObjectProperty<String> userAgentStylesheetProperty() {
        if (this.userAgentStylesheet == null) {
            Scene scene = this;
            this.userAgentStylesheet = new Scene$11(scene, scene, "userAgentStylesheet", null);
        }
        return this.userAgentStylesheet;
    }

    public final String getUserAgentStylesheet() {
        if (this.userAgentStylesheet == null) {
            return null;
        }
        return (String)this.userAgentStylesheet.get();
    }

    public final void setUserAgentStylesheet(String string) {
        this.userAgentStylesheetProperty().set(string);
    }

    public final boolean isDepthBuffer() {
        return this.depthBuffer;
    }

    boolean isDepthBufferInternal() {
        if (!Platform.isSupported(ConditionalFeature.SCENE3D)) {
            return false;
        }
        return this.depthBuffer;
    }

    private void init(double d2, double d3) {
        Scene scene;
        if (d2 >= 0.0) {
            this.widthSetByUser = d2;
            this.setWidth((float)d2);
        }
        if (d3 >= 0.0) {
            this.heightSetByUser = d3;
            this.setHeight((float)d3);
        }
        this.sizeInitialized = scene.widthSetByUser >= 0.0 && this.heightSetByUser >= 0.0;
    }

    private void init() {
        if (PerformanceTracker.isLoggingEnabled()) {
            PerformanceTracker.logEvent("Scene.init for [" + String.valueOf(this) + "]");
        }
        this.mouseHandler = new Scene$MouseHandler(this);
        this.clickGenerator = new Scene$ClickGenerator();
        if (PerformanceTracker.isLoggingEnabled()) {
            PerformanceTracker.logEvent("Scene.init for [" + String.valueOf(this) + "] - finished");
        }
    }

    void preferredSize() {
        Scene scene;
        Parent parent = this.getRoot();
        this.doCSSPass();
        this.resizeRootToPreferredSize(parent);
        this.doLayoutPass();
        if (this.widthSetByUser < 0.0) {
            this.setWidth(parent.isResizable() ? parent.getLayoutX() + parent.getTranslateX() + parent.getLayoutBounds().getWidth() : parent.getBoundsInParent().getMaxX());
        } else {
            Scene scene2 = this;
            scene2.setWidth(scene2.widthSetByUser);
        }
        if (this.heightSetByUser < 0.0) {
            this.setHeight(parent.isResizable() ? parent.getLayoutY() + parent.getTranslateY() + parent.getLayoutBounds().getHeight() : parent.getBoundsInParent().getMaxY());
        } else {
            Scene scene3 = this;
            scene3.setHeight(scene3.heightSetByUser);
        }
        this.sizeInitialized = scene.getWidth() > 0.0 && this.getHeight() > 0.0;
        PerformanceTracker.logEvent("Scene preferred bounds computation complete");
    }

    final void resizeRootToPreferredSize(Parent parent) {
        double d2;
        double d3;
        Orientation orientation = parent.getContentBias();
        if (orientation == null) {
            d3 = Scene.getPreferredWidth(parent, this.widthSetByUser, -1.0);
            d2 = Scene.getPreferredHeight(parent, this.heightSetByUser, -1.0);
        } else if (orientation == Orientation.HORIZONTAL) {
            d3 = Scene.getPreferredWidth(parent, this.widthSetByUser, -1.0);
            d2 = Scene.getPreferredHeight(parent, this.heightSetByUser, d3);
        } else {
            d2 = Scene.getPreferredHeight(parent, this.heightSetByUser, -1.0);
            d3 = Scene.getPreferredWidth(parent, this.widthSetByUser, d2);
        }
        parent.resize(d3, d2);
    }

    private static double getPreferredWidth(Parent parent, double d2, double d3) {
        if (d2 >= 0.0) {
            return d2;
        }
        double d4 = d3 >= 0.0 ? d3 : -1.0;
        Parent parent2 = parent;
        return parent2.boundedSize(((Node)parent2).prefWidth(d4), ((Node)parent).minWidth(d4), parent.maxWidth(d4));
    }

    private static double getPreferredHeight(Parent parent, double d2, double d3) {
        if (d2 >= 0.0) {
            return d2;
        }
        double d4 = d3 >= 0.0 ? d3 : -1.0;
        Parent parent2 = parent;
        return parent2.boundedSize(((Node)parent2).prefHeight(d4), ((Node)parent).minHeight(d4), parent.maxHeight(d4));
    }

    void processMouseEvent(MouseEvent mouseEvent) {
        this.mouseHandler.process(mouseEvent, false);
    }

    private void processMenuEvent(double d2, double d3, double d4, double d5, boolean bl2) {
        Object object;
        Object object2 = null;
        inMousePick = true;
        if (bl2) {
            object = this.getFocusOwner();
            double d6 = d4 - d2;
            double d7 = d5 - d3;
            if (object != null) {
                Object object3 = object;
                Bounds bounds = ((Node)object3).localToScene(((Node)object3).getBoundsInLocal());
                d2 = bounds.getMinX() + bounds.getWidth() / 4.0;
                d3 = bounds.getMinY() + bounds.getHeight() / 2.0;
                object2 = object;
            } else {
                d2 = this.getWidth() / 4.0;
                d3 = this.getWidth() / 2.0;
                object2 = this;
            }
            d4 = d2 + d6;
            d5 = d3 + d7;
        }
        object = this.pick(d2, d3);
        if (!bl2 && (object2 = ((PickResult)object).getIntersectedNode()) == null) {
            object2 = this;
        }
        if (object2 != null) {
            ContextMenuEvent contextMenuEvent = new ContextMenuEvent(ContextMenuEvent.CONTEXT_MENU_REQUESTED, d2, d3, d4, d5, bl2, (PickResult)object);
            Event.fireEvent((EventTarget)object2, contextMenuEvent);
        }
        inMousePick = false;
    }

    private void processGestureEvent(GestureEvent gestureEvent, Scene$TouchGesture scene$TouchGesture) {
        EventTarget eventTarget;
        if (((Event)gestureEvent).getEventType() == ZoomEvent.ZOOM_STARTED || ((Event)gestureEvent).getEventType() == RotateEvent.ROTATION_STARTED || ((Event)gestureEvent).getEventType() == ScrollEvent.SCROLL_STARTED) {
            scene$TouchGesture.target = null;
            scene$TouchGesture.finished = false;
        }
        if (scene$TouchGesture.target != null && (!scene$TouchGesture.finished || gestureEvent.isInertia())) {
            eventTarget = (EventTarget)scene$TouchGesture.target.get();
        } else {
            eventTarget = gestureEvent.getPickResult().getIntersectedNode();
            if (eventTarget == null) {
                eventTarget = this;
            }
        }
        if (((Event)gestureEvent).getEventType() == ZoomEvent.ZOOM_STARTED || ((Event)gestureEvent).getEventType() == RotateEvent.ROTATION_STARTED || ((Event)gestureEvent).getEventType() == ScrollEvent.SCROLL_STARTED) {
            scene$TouchGesture.target = new WeakReference<Node>((Node)eventTarget);
        }
        if (((Event)gestureEvent).getEventType() != ZoomEvent.ZOOM_FINISHED && ((Event)gestureEvent).getEventType() != RotateEvent.ROTATION_FINISHED && ((Event)gestureEvent).getEventType() != ScrollEvent.SCROLL_FINISHED && !gestureEvent.isInertia()) {
            scene$TouchGesture.sceneCoords = new Point2D(gestureEvent.getSceneX(), gestureEvent.getSceneY());
            scene$TouchGesture.screenCoords = new Point2D(gestureEvent.getScreenX(), gestureEvent.getScreenY());
        }
        if (eventTarget != null) {
            Event.fireEvent(eventTarget, gestureEvent);
        }
        if (((Event)gestureEvent).getEventType() == ZoomEvent.ZOOM_FINISHED || ((Event)gestureEvent).getEventType() == RotateEvent.ROTATION_FINISHED || ((Event)gestureEvent).getEventType() == ScrollEvent.SCROLL_FINISHED) {
            scene$TouchGesture.finished = true;
        }
    }

    private void processTouchEvent(TouchEvent touchEvent, TouchPoint[] touchPointArray) {
        Object object;
        TouchPoint touchPoint;
        int n2;
        inMousePick = true;
        ++this.touchEventSetId;
        List<TouchPoint> list = Arrays.asList(touchPointArray);
        TouchPoint[] touchPointArray2 = touchPointArray;
        int n3 = touchPointArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            touchPoint = touchPointArray2[n2];
            if (touchPoint.getTarget() == null) continue;
            object = null;
            switch (touchPoint.getState()) {
                case MOVED: {
                    object = TouchEvent.TOUCH_MOVED;
                    break;
                }
                case PRESSED: {
                    object = TouchEvent.TOUCH_PRESSED;
                    break;
                }
                case RELEASED: {
                    object = TouchEvent.TOUCH_RELEASED;
                    break;
                }
                case STATIONARY: {
                    object = TouchEvent.TOUCH_STATIONARY;
                }
            }
            Object object2 = touchPointArray;
            int n4 = touchPointArray.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                TouchPoint touchPoint2 = object2[i2];
                TouchPointHelper.reset(touchPoint2);
            }
            object2 = new TouchEvent((EventType<TouchEvent>)object, touchPoint, list, this.touchEventSetId, touchEvent.isShiftDown(), touchEvent.isControlDown(), touchEvent.isAltDown(), touchEvent.isMetaDown());
            Event.fireEvent(touchPoint.getTarget(), (Event)object2);
        }
        touchPointArray2 = touchPointArray;
        n3 = touchPointArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            touchPoint = touchPointArray2[n2];
            object = touchPoint.getGrabbed();
            if (object != null) {
                this.touchTargets.put(touchPoint.getId(), (EventTarget)object);
            }
            if (object != null && touchPoint.getState() != TouchPoint$State.RELEASED) continue;
            this.touchTargets.remove(touchPoint.getId());
        }
        inMousePick = false;
    }

    Node test_pick(double d2, double d3) {
        inMousePick = true;
        PickResult pickResult = this.mouseHandler.pickNode(new PickRay(d2, d3, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        inMousePick = false;
        if (pickResult != null) {
            return pickResult.getIntersectedNode();
        }
        return null;
    }

    private PickResult pick(double d2, double d3) {
        Scene scene = this;
        scene.pick(scene.tmpTargetWrapper, d2, d3);
        return this.tmpTargetWrapper.getResult();
    }

    private boolean isInScene(double d2, double d3) {
        if (d2 < 0.0 || d3 < 0.0 || d2 > this.getWidth() || d3 > this.getHeight()) {
            return false;
        }
        Window window = this.getWindow();
        return !(window instanceof Stage) || ((Stage)window).getStyle() != StageStyle.TRANSPARENT || this.getFill() != null;
    }

    private void pick(Scene$TargetWrapper scene$TargetWrapper, double d2, double d3) {
        Object object = this.getEffectiveCamera().computePickRay(d2, d3, null);
        double d4 = ((PickRay)object).getDirectionNoClone().length();
        ((PickRay)object).getDirectionNoClone().normalize();
        Object object2 = this.mouseHandler.pickNode((PickRay)object);
        if (object2 != null) {
            scene$TargetWrapper.setNodeResult((PickResult)object2);
            return;
        }
        object2 = ((PickRay)object).getOriginNoClone();
        object = ((PickRay)object).getDirectionNoClone();
        scene$TargetWrapper.setSceneResult(new PickResult(null, new Point3D(((Vec3d)object2).x + d4 * ((Vec3d)object).x, ((Vec3d)object2).y + d4 * ((Vec3d)object).y, ((Vec3d)object2).z + d4 * ((Vec3d)object).z), d4), this.isInScene(d2, d3) ? this : null);
    }

    private void windowForSceneChanged(Window window, Window window2) {
        if (window != null) {
            window.focusedProperty().removeListener(this.sceneWindowFocusedListener);
        }
        if (window2 != null) {
            window2.focusedProperty().addListener(this.sceneWindowFocusedListener);
            this.setWindowFocused(window2.isFocused());
            return;
        }
        this.setWindowFocused(false);
    }

    private void setWindowFocused(boolean bl2) {
        this.windowFocused = bl2;
        Node node = this.getFocusOwner();
        if (node != null) {
            node.setFocusQuietly(this.windowFocused, this.focusOwner.focusVisible);
            node.notifyFocusListeners();
        }
        if (this.windowFocused && this.accessible != null) {
            this.accessible.sendNotification(AccessibleAttribute.FOCUS_NODE);
        }
        if (!this.windowFocused) {
            this.getInternalEventDispatcher().getKeyboardShortcutsHandler().setMnemonicsDisplayEnabled(false);
        }
    }

    final void setFocusDirty(boolean bl2) {
        if (!this.focusDirty) {
            Toolkit.getToolkit().requestNextPulse();
        }
        this.focusDirty = bl2;
    }

    final boolean isFocusDirty() {
        return this.focusDirty;
    }

    boolean traverse(Node node, Direction direction, TraversalMethod traversalMethod) {
        if (node.getSubScene() != null) {
            return node.getSubScene().traverse(node, direction, traversalMethod);
        }
        return this.traversalEngine.trav(node, direction, traversalMethod) != null;
    }

    private void focusInitial() {
        this.traversalEngine.traverseToFirst();
    }

    private void focusIneligible(Node node) {
        this.traverse(node, Direction.NEXT, TraversalMethod.DEFAULT);
    }

    void processKeyEvent(KeyEvent keyEvent) {
        EventTarget eventTarget;
        if (this.dndGesture != null && !this.dndGesture.processKey(keyEvent)) {
            this.dndGesture = null;
        }
        eventTarget = (eventTarget = this.getFocusOwner()) != null && eventTarget.getScene() == this ? eventTarget : this;
        Event.fireEvent(eventTarget, keyEvent);
    }

    void requestFocus(Node node, boolean bl2) {
        if (node == null) {
            this.setFocusOwner(null, false);
            return;
        }
        if (node.isCanReceiveFocus()) {
            this.setFocusOwner(node, bl2);
        }
    }

    public final ReadOnlyObjectProperty<Node> focusOwnerProperty() {
        return this.focusOwner.getReadOnlyProperty();
    }

    public final Node getFocusOwner() {
        return (Node)this.focusOwner.get();
    }

    private void setFocusOwner(Node node, boolean bl2) {
        Object object;
        if (this.focusOwner.oldFocusOwner != null && (object = this.focusOwner.oldFocusOwner.getScene()) != null && (object = ((Scene)object).getPeer()) != null) {
            object.finishInputMethodComposition();
        }
        this.focusOwner.focusVisible = bl2;
        if (this.focusOwner.get() != node) {
            this.focusOwner.set(node);
            return;
        }
        if (node != null) {
            node.focusVisible.set(bl2);
            node.focusVisible.notifyListeners();
        }
    }

    void focusCleanup() {
        this.scenePulseListener.focusCleanup();
    }

    private void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        Node node = this.getFocusOwner();
        if (node != null) {
            node.fireEvent(inputMethodEvent);
        }
    }

    void enableInputMethodEvents(boolean bl2) {
        if (this.peer != null) {
            this.peer.enableInputMethodEvents(bl2);
        }
    }

    boolean isQuiescent() {
        Parent parent = this.getRoot();
        return !this.isFocusDirty() && (parent == null || parent.cssFlag == CssFlags.CLEAN && parent.layoutFlag == LayoutFlags.CLEAN);
    }

    private void markDirty(Scene$DirtyBits scene$DirtyBits) {
        this.setDirty(scene$DirtyBits);
        if (this.peer != null) {
            Toolkit.getToolkit().requestNextPulse();
        }
    }

    private void setDirty(Scene$DirtyBits scene$DirtyBits) {
        this.dirtyBits.add(scene$DirtyBits);
    }

    private boolean isDirty(Scene$DirtyBits scene$DirtyBits) {
        return this.dirtyBits.contains((Object)scene$DirtyBits);
    }

    private boolean isDirtyEmpty() {
        return this.dirtyBits.isEmpty();
    }

    private void clearDirty() {
        this.dirtyBits.clear();
    }

    final void addLight(LightBase lightBase) {
        if (!this.lights.contains(lightBase)) {
            this.lights.add(lightBase);
            this.markDirty(Scene$DirtyBits.LIGHTS_DIRTY);
        }
    }

    final void removeLight(LightBase lightBase) {
        if (this.lights.remove(lightBase)) {
            this.markDirty(Scene$DirtyBits.LIGHTS_DIRTY);
        }
    }

    private void syncLights() {
        if (!this.isDirty(Scene$DirtyBits.LIGHTS_DIRTY)) {
            return;
        }
        inSynchronizer = true;
        NGLightBase[] nGLightBaseArray = this.peer.getLights();
        if (!this.lights.isEmpty() || nGLightBaseArray != null) {
            if (this.lights.isEmpty()) {
                this.peer.setLights(null);
            } else {
                int n2;
                if (nGLightBaseArray == null || nGLightBaseArray.length < this.lights.size()) {
                    nGLightBaseArray = new NGLightBase[this.lights.size()];
                }
                for (n2 = 0; n2 < this.lights.size(); ++n2) {
                    nGLightBaseArray[n2] = (NGLightBase)this.lights.get(n2).getPeer();
                }
                while (n2 < nGLightBaseArray.length && nGLightBaseArray[n2] != null) {
                    nGLightBaseArray[n2++] = null;
                }
                this.peer.setLights(nGLightBaseArray);
            }
        }
        inSynchronizer = false;
    }

    void generateMouseExited(Node node) {
        this.mouseHandler.handleNodeRemoval(node);
    }

    public final void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcherProperty().set(eventDispatcher);
    }

    public final EventDispatcher getEventDispatcher() {
        return (EventDispatcher)this.eventDispatcherProperty().get();
    }

    public final ObjectProperty<EventDispatcher> eventDispatcherProperty() {
        this.initializeInternalEventDispatcher();
        return this.eventDispatcher;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventFilter(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventFilter(eventType, eventHandler);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().setEventHandler(eventType, eventHandler);
    }

    private SceneEventDispatcher getInternalEventDispatcher() {
        this.initializeInternalEventDispatcher();
        return this.internalEventDispatcher;
    }

    final void initializeInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = this.createInternalEventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty<SceneEventDispatcher>(this, "eventDispatcher", this.internalEventDispatcher);
        }
    }

    private SceneEventDispatcher createInternalEventDispatcher() {
        return new SceneEventDispatcher(this);
    }

    public void addMnemonic(Mnemonic mnemonic) {
        this.getInternalEventDispatcher().getKeyboardShortcutsHandler().addMnemonic(mnemonic);
    }

    public void removeMnemonic(Mnemonic mnemonic) {
        this.getInternalEventDispatcher().getKeyboardShortcutsHandler().removeMnemonic(mnemonic);
    }

    final void clearNodeMnemonics(Node node) {
        this.getInternalEventDispatcher().getKeyboardShortcutsHandler().clearNodeMnemonics(node);
    }

    public ObservableMap<KeyCombination, ObservableList<Mnemonic>> getMnemonics() {
        return this.getInternalEventDispatcher().getKeyboardShortcutsHandler().getMnemonics();
    }

    public ObservableMap<KeyCombination, Runnable> getAccelerators() {
        return this.getInternalEventDispatcher().getKeyboardShortcutsHandler().getAccelerators();
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        EventDispatcher eventDispatcher;
        if (this.eventDispatcher != null && (eventDispatcher = (EventDispatcher)this.eventDispatcher.get()) != null) {
            eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
        }
        if (this.getWindow() != null) {
            eventDispatchChain = this.getWindow().buildEventDispatchChain(eventDispatchChain);
        }
        return eventDispatchChain;
    }

    public final void setOnContextMenuRequested(EventHandler<? super ContextMenuEvent> eventHandler) {
        this.onContextMenuRequestedProperty().set(eventHandler);
    }

    public final EventHandler<? super ContextMenuEvent> getOnContextMenuRequested() {
        if (this.onContextMenuRequested == null) {
            return null;
        }
        return (EventHandler)this.onContextMenuRequested.get();
    }

    public final ObjectProperty<EventHandler<? super ContextMenuEvent>> onContextMenuRequestedProperty() {
        if (this.onContextMenuRequested == null) {
            this.onContextMenuRequested = new Scene$12(this);
        }
        return this.onContextMenuRequested;
    }

    public final void setOnMouseClicked(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseClickedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseClicked() {
        if (this.onMouseClicked == null) {
            return null;
        }
        return (EventHandler)this.onMouseClicked.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseClickedProperty() {
        if (this.onMouseClicked == null) {
            this.onMouseClicked = new Scene$13(this);
        }
        return this.onMouseClicked;
    }

    public final void setOnMouseDragged(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseDraggedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseDragged() {
        if (this.onMouseDragged == null) {
            return null;
        }
        return (EventHandler)this.onMouseDragged.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseDraggedProperty() {
        if (this.onMouseDragged == null) {
            this.onMouseDragged = new Scene$14(this);
        }
        return this.onMouseDragged;
    }

    public final void setOnMouseEntered(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseEntered() {
        if (this.onMouseEntered == null) {
            return null;
        }
        return (EventHandler)this.onMouseEntered.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseEnteredProperty() {
        if (this.onMouseEntered == null) {
            this.onMouseEntered = new Scene$15(this);
        }
        return this.onMouseEntered;
    }

    public final void setOnMouseExited(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseExited() {
        if (this.onMouseExited == null) {
            return null;
        }
        return (EventHandler)this.onMouseExited.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseExitedProperty() {
        if (this.onMouseExited == null) {
            this.onMouseExited = new Scene$16(this);
        }
        return this.onMouseExited;
    }

    public final void setOnMouseMoved(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseMovedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseMoved() {
        if (this.onMouseMoved == null) {
            return null;
        }
        return (EventHandler)this.onMouseMoved.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseMovedProperty() {
        if (this.onMouseMoved == null) {
            this.onMouseMoved = new Scene$17(this);
        }
        return this.onMouseMoved;
    }

    public final void setOnMousePressed(EventHandler<? super MouseEvent> eventHandler) {
        this.onMousePressedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMousePressed() {
        if (this.onMousePressed == null) {
            return null;
        }
        return (EventHandler)this.onMousePressed.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMousePressedProperty() {
        if (this.onMousePressed == null) {
            this.onMousePressed = new Scene$18(this);
        }
        return this.onMousePressed;
    }

    public final void setOnMouseReleased(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseReleased() {
        if (this.onMouseReleased == null) {
            return null;
        }
        return (EventHandler)this.onMouseReleased.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleasedProperty() {
        if (this.onMouseReleased == null) {
            this.onMouseReleased = new Scene$19(this);
        }
        return this.onMouseReleased;
    }

    public final void setOnDragDetected(EventHandler<? super MouseEvent> eventHandler) {
        this.onDragDetectedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnDragDetected() {
        if (this.onDragDetected == null) {
            return null;
        }
        return (EventHandler)this.onDragDetected.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onDragDetectedProperty() {
        if (this.onDragDetected == null) {
            this.onDragDetected = new Scene$20(this);
        }
        return this.onDragDetected;
    }

    public final void setOnMouseDragOver(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragOverProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragOver() {
        if (this.onMouseDragOver == null) {
            return null;
        }
        return (EventHandler)this.onMouseDragOver.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragOverProperty() {
        if (this.onMouseDragOver == null) {
            this.onMouseDragOver = new Scene$21(this);
        }
        return this.onMouseDragOver;
    }

    public final void setOnMouseDragReleased(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragReleased() {
        if (this.onMouseDragReleased == null) {
            return null;
        }
        return (EventHandler)this.onMouseDragReleased.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragReleasedProperty() {
        if (this.onMouseDragReleased == null) {
            this.onMouseDragReleased = new Scene$22(this);
        }
        return this.onMouseDragReleased;
    }

    public final void setOnMouseDragEntered(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragEntered() {
        if (this.onMouseDragEntered == null) {
            return null;
        }
        return (EventHandler)this.onMouseDragEntered.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragEnteredProperty() {
        if (this.onMouseDragEntered == null) {
            this.onMouseDragEntered = new Scene$23(this);
        }
        return this.onMouseDragEntered;
    }

    public final void setOnMouseDragExited(EventHandler<? super MouseDragEvent> eventHandler) {
        this.onMouseDragExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragExited() {
        if (this.onMouseDragExited == null) {
            return null;
        }
        return (EventHandler)this.onMouseDragExited.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragExitedProperty() {
        if (this.onMouseDragExited == null) {
            this.onMouseDragExited = new Scene$24(this);
        }
        return this.onMouseDragExited;
    }

    public final void setOnScrollStarted(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollStartedProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScrollStarted() {
        if (this.onScrollStarted == null) {
            return null;
        }
        return (EventHandler)this.onScrollStarted.get();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollStartedProperty() {
        if (this.onScrollStarted == null) {
            this.onScrollStarted = new Scene$25(this);
        }
        return this.onScrollStarted;
    }

    public final void setOnScroll(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScroll() {
        if (this.onScroll == null) {
            return null;
        }
        return (EventHandler)this.onScroll.get();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollProperty() {
        if (this.onScroll == null) {
            this.onScroll = new Scene$26(this);
        }
        return this.onScroll;
    }

    public final void setOnScrollFinished(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollFinishedProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScrollFinished() {
        if (this.onScrollFinished == null) {
            return null;
        }
        return (EventHandler)this.onScrollFinished.get();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollFinishedProperty() {
        if (this.onScrollFinished == null) {
            this.onScrollFinished = new Scene$27(this);
        }
        return this.onScrollFinished;
    }

    public final void setOnRotationStarted(EventHandler<? super RotateEvent> eventHandler) {
        this.onRotationStartedProperty().set(eventHandler);
    }

    public final EventHandler<? super RotateEvent> getOnRotationStarted() {
        if (this.onRotationStarted == null) {
            return null;
        }
        return (EventHandler)this.onRotationStarted.get();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotationStartedProperty() {
        if (this.onRotationStarted == null) {
            this.onRotationStarted = new Scene$28(this);
        }
        return this.onRotationStarted;
    }

    public final void setOnRotate(EventHandler<? super RotateEvent> eventHandler) {
        this.onRotateProperty().set(eventHandler);
    }

    public final EventHandler<? super RotateEvent> getOnRotate() {
        if (this.onRotate == null) {
            return null;
        }
        return (EventHandler)this.onRotate.get();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotateProperty() {
        if (this.onRotate == null) {
            this.onRotate = new Scene$29(this);
        }
        return this.onRotate;
    }

    public final void setOnRotationFinished(EventHandler<? super RotateEvent> eventHandler) {
        this.onRotationFinishedProperty().set(eventHandler);
    }

    public final EventHandler<? super RotateEvent> getOnRotationFinished() {
        if (this.onRotationFinished == null) {
            return null;
        }
        return (EventHandler)this.onRotationFinished.get();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotationFinishedProperty() {
        if (this.onRotationFinished == null) {
            this.onRotationFinished = new Scene$30(this);
        }
        return this.onRotationFinished;
    }

    public final void setOnZoomStarted(EventHandler<? super ZoomEvent> eventHandler) {
        this.onZoomStartedProperty().set(eventHandler);
    }

    public final EventHandler<? super ZoomEvent> getOnZoomStarted() {
        if (this.onZoomStarted == null) {
            return null;
        }
        return (EventHandler)this.onZoomStarted.get();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomStartedProperty() {
        if (this.onZoomStarted == null) {
            this.onZoomStarted = new Scene$31(this);
        }
        return this.onZoomStarted;
    }

    public final void setOnZoom(EventHandler<? super ZoomEvent> eventHandler) {
        this.onZoomProperty().set(eventHandler);
    }

    public final EventHandler<? super ZoomEvent> getOnZoom() {
        if (this.onZoom == null) {
            return null;
        }
        return (EventHandler)this.onZoom.get();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomProperty() {
        if (this.onZoom == null) {
            this.onZoom = new Scene$32(this);
        }
        return this.onZoom;
    }

    public final void setOnZoomFinished(EventHandler<? super ZoomEvent> eventHandler) {
        this.onZoomFinishedProperty().set(eventHandler);
    }

    public final EventHandler<? super ZoomEvent> getOnZoomFinished() {
        if (this.onZoomFinished == null) {
            return null;
        }
        return (EventHandler)this.onZoomFinished.get();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomFinishedProperty() {
        if (this.onZoomFinished == null) {
            this.onZoomFinished = new Scene$33(this);
        }
        return this.onZoomFinished;
    }

    public final void setOnSwipeUp(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeUpProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeUp() {
        if (this.onSwipeUp == null) {
            return null;
        }
        return (EventHandler)this.onSwipeUp.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeUpProperty() {
        if (this.onSwipeUp == null) {
            this.onSwipeUp = new Scene$34(this);
        }
        return this.onSwipeUp;
    }

    public final void setOnSwipeDown(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeDownProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeDown() {
        if (this.onSwipeDown == null) {
            return null;
        }
        return (EventHandler)this.onSwipeDown.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeDownProperty() {
        if (this.onSwipeDown == null) {
            this.onSwipeDown = new Scene$35(this);
        }
        return this.onSwipeDown;
    }

    public final void setOnSwipeLeft(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeLeftProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeLeft() {
        if (this.onSwipeLeft == null) {
            return null;
        }
        return (EventHandler)this.onSwipeLeft.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeLeftProperty() {
        if (this.onSwipeLeft == null) {
            this.onSwipeLeft = new Scene$36(this);
        }
        return this.onSwipeLeft;
    }

    public final void setOnSwipeRight(EventHandler<? super SwipeEvent> eventHandler) {
        this.onSwipeRightProperty().set(eventHandler);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeRight() {
        if (this.onSwipeRight == null) {
            return null;
        }
        return (EventHandler)this.onSwipeRight.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeRightProperty() {
        if (this.onSwipeRight == null) {
            this.onSwipeRight = new Scene$37(this);
        }
        return this.onSwipeRight;
    }

    public final void setOnTouchPressed(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchPressedProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchPressed() {
        if (this.onTouchPressed == null) {
            return null;
        }
        return (EventHandler)this.onTouchPressed.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchPressedProperty() {
        if (this.onTouchPressed == null) {
            this.onTouchPressed = new Scene$38(this);
        }
        return this.onTouchPressed;
    }

    public final void setOnTouchMoved(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchMovedProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchMoved() {
        if (this.onTouchMoved == null) {
            return null;
        }
        return (EventHandler)this.onTouchMoved.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchMovedProperty() {
        if (this.onTouchMoved == null) {
            this.onTouchMoved = new Scene$39(this);
        }
        return this.onTouchMoved;
    }

    public final void setOnTouchReleased(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchReleased() {
        if (this.onTouchReleased == null) {
            return null;
        }
        return (EventHandler)this.onTouchReleased.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchReleasedProperty() {
        if (this.onTouchReleased == null) {
            this.onTouchReleased = new Scene$40(this);
        }
        return this.onTouchReleased;
    }

    public final void setOnTouchStationary(EventHandler<? super TouchEvent> eventHandler) {
        this.onTouchStationaryProperty().set(eventHandler);
    }

    public final EventHandler<? super TouchEvent> getOnTouchStationary() {
        if (this.onTouchStationary == null) {
            return null;
        }
        return (EventHandler)this.onTouchStationary.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchStationaryProperty() {
        if (this.onTouchStationary == null) {
            this.onTouchStationary = new Scene$41(this);
        }
        return this.onTouchStationary;
    }

    public final void setOnDragEntered(EventHandler<? super DragEvent> eventHandler) {
        this.onDragEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragEntered() {
        if (this.onDragEntered == null) {
            return null;
        }
        return (EventHandler)this.onDragEntered.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragEnteredProperty() {
        if (this.onDragEntered == null) {
            this.onDragEntered = new Scene$42(this);
        }
        return this.onDragEntered;
    }

    public final void setOnDragExited(EventHandler<? super DragEvent> eventHandler) {
        this.onDragExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragExited() {
        if (this.onDragExited == null) {
            return null;
        }
        return (EventHandler)this.onDragExited.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragExitedProperty() {
        if (this.onDragExited == null) {
            this.onDragExited = new Scene$43(this);
        }
        return this.onDragExited;
    }

    public final void setOnDragOver(EventHandler<? super DragEvent> eventHandler) {
        this.onDragOverProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragOver() {
        if (this.onDragOver == null) {
            return null;
        }
        return (EventHandler)this.onDragOver.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragOverProperty() {
        if (this.onDragOver == null) {
            this.onDragOver = new Scene$44(this);
        }
        return this.onDragOver;
    }

    public final void setOnDragDropped(EventHandler<? super DragEvent> eventHandler) {
        this.onDragDroppedProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragDropped() {
        if (this.onDragDropped == null) {
            return null;
        }
        return (EventHandler)this.onDragDropped.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDroppedProperty() {
        if (this.onDragDropped == null) {
            this.onDragDropped = new Scene$45(this);
        }
        return this.onDragDropped;
    }

    public final void setOnDragDone(EventHandler<? super DragEvent> eventHandler) {
        this.onDragDoneProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragDone() {
        if (this.onDragDone == null) {
            return null;
        }
        return (EventHandler)this.onDragDone.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDoneProperty() {
        if (this.onDragDone == null) {
            this.onDragDone = new Scene$46(this);
        }
        return this.onDragDone;
    }

    public Dragboard startDragAndDrop(TransferMode ... transferModeArray) {
        Scene scene = this;
        return scene.startDragAndDrop(scene, transferModeArray);
    }

    public void startFullDrag() {
        Scene scene = this;
        scene.startFullDrag(scene);
    }

    Dragboard startDragAndDrop(EventTarget eventTarget, TransferMode ... object) {
        Toolkit.getToolkit().checkFxUserThread();
        if (this.dndGesture == null || this.dndGesture.dragDetected != Scene$DragDetectedState.PROCESSING) {
            throw new IllegalStateException("Cannot start drag and drop outside of DRAG_DETECTED event handler");
        }
        EnumSet<TransferMode> enumSet = EnumSet.noneOf(TransferMode.class);
        for (TransferMode transferMode : InputEventUtils.safeTransferModes((TransferMode[])object)) {
            enumSet.add(transferMode);
        }
        return this.dndGesture.startDrag(eventTarget, enumSet);
    }

    void startFullDrag(EventTarget eventTarget) {
        Toolkit.getToolkit().checkFxUserThread();
        if (this.dndGesture.dragDetected != Scene$DragDetectedState.PROCESSING) {
            throw new IllegalStateException("Cannot start full drag outside of DRAG_DETECTED event handler");
        }
        if (this.dndGesture != null) {
            this.dndGesture.startFullPDR(eventTarget);
            return;
        }
        throw new IllegalStateException("Cannot start full drag when mouse button is not pressed");
    }

    public final void setOnKeyPressed(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyPressedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyPressed() {
        if (this.onKeyPressed == null) {
            return null;
        }
        return (EventHandler)this.onKeyPressed.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressedProperty() {
        if (this.onKeyPressed == null) {
            this.onKeyPressed = new Scene$47(this);
        }
        return this.onKeyPressed;
    }

    public final void setOnKeyReleased(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyReleased() {
        if (this.onKeyReleased == null) {
            return null;
        }
        return (EventHandler)this.onKeyReleased.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleasedProperty() {
        if (this.onKeyReleased == null) {
            this.onKeyReleased = new Scene$48(this);
        }
        return this.onKeyReleased;
    }

    public final void setOnKeyTyped(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyTypedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyTyped() {
        if (this.onKeyTyped == null) {
            return null;
        }
        return (EventHandler)this.onKeyTyped.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyTypedProperty() {
        if (this.onKeyTyped == null) {
            this.onKeyTyped = new Scene$49(this);
        }
        return this.onKeyTyped;
    }

    public final void setOnInputMethodTextChanged(EventHandler<? super InputMethodEvent> eventHandler) {
        this.onInputMethodTextChangedProperty().set(eventHandler);
    }

    public final EventHandler<? super InputMethodEvent> getOnInputMethodTextChanged() {
        if (this.onInputMethodTextChanged == null) {
            return null;
        }
        return (EventHandler)this.onInputMethodTextChanged.get();
    }

    public final ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChangedProperty() {
        if (this.onInputMethodTextChanged == null) {
            this.onInputMethodTextChanged = new Scene$50(this);
        }
        return this.onInputMethodTextChanged;
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object object) {
        this.getProperties().put(USER_DATA_KEY, object);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    public final void setNodeOrientation(NodeOrientation nodeOrientation) {
        this.nodeOrientationProperty().set(nodeOrientation);
    }

    public final NodeOrientation getNodeOrientation() {
        if (this.nodeOrientation == null) {
            return defaultNodeOrientation;
        }
        return (NodeOrientation)((Object)this.nodeOrientation.get());
    }

    public final ObjectProperty<NodeOrientation> nodeOrientationProperty() {
        if (this.nodeOrientation == null) {
            this.nodeOrientation = new Scene$51(this, defaultNodeOrientation);
        }
        return this.nodeOrientation;
    }

    public final NodeOrientation getEffectiveNodeOrientation() {
        if (this.effectiveNodeOrientation == null) {
            this.effectiveNodeOrientation = this.calcEffectiveNodeOrientation();
        }
        return this.effectiveNodeOrientation;
    }

    public final ReadOnlyObjectProperty<NodeOrientation> effectiveNodeOrientationProperty() {
        if (this.effectiveNodeOrientationProperty == null) {
            this.effectiveNodeOrientationProperty = new Scene$EffectiveOrientationProperty(this);
        }
        return this.effectiveNodeOrientationProperty;
    }

    private void parentEffectiveOrientationInvalidated() {
        if (this.getNodeOrientation() == NodeOrientation.INHERIT) {
            this.sceneEffectiveOrientationInvalidated();
        }
    }

    private void sceneEffectiveOrientationInvalidated() {
        this.effectiveNodeOrientation = null;
        if (this.effectiveNodeOrientationProperty != null) {
            this.effectiveNodeOrientationProperty.invalidate();
        }
        this.getRoot().parentResolvedOrientationInvalidated();
    }

    private NodeOrientation calcEffectiveNodeOrientation() {
        Object object = this.getNodeOrientation();
        if (object == NodeOrientation.INHERIT) {
            object = this.getWindow();
            if (object != null) {
                Window window = null;
                if (object instanceof Stage) {
                    window = ((Stage)object).getOwner();
                } else if (object instanceof PopupWindow) {
                    window = ((PopupWindow)object).getOwnerWindow();
                }
                if (window != null && (object = window.getScene()) != null) {
                    return ((Scene)object).getEffectiveNodeOrientation();
                }
            }
            return NodeOrientation.LEFT_TO_RIGHT;
        }
        return object;
    }

    Accessible removeAccessible(Node node) {
        if (this.accMap == null) {
            return null;
        }
        return this.accMap.remove(node);
    }

    void addAccessible(Node node, Accessible accessible) {
        if (this.accMap == null) {
            this.accMap = new HashMap<Node, Accessible>();
        }
        this.accMap.put(node, accessible);
    }

    private void disposeAccessibles() {
        if (this.accMap != null) {
            for (Map.Entry<Node, Accessible> entry : this.accMap.entrySet()) {
                Node node = entry.getKey();
                Accessible object = entry.getValue();
                if (node.accessible != null) {
                    if (node.accessible == object) {
                        System.err.println("[A11y] 'node.accessible == acc' should never happen.");
                    }
                    if (node.getScene() == this) {
                        System.err.println("[A11y] 'node.getScene() == this' should never happen.");
                    }
                    object.dispose();
                    continue;
                }
                if (node.getScene() == this) {
                    node.accessible = object;
                    continue;
                }
                object.dispose();
            }
            this.accMap.clear();
        }
    }

    Accessible getAccessible() {
        if (this.peer == null) {
            return null;
        }
        if (this.accessible == null) {
            this.accessible = Application.GetApplication().createAccessible();
            this.accessible.setEventHandler(new Scene$52(this));
            PlatformImpl.accessibilityActiveProperty().set(true);
        }
        return this.accessible;
    }

    static {
        PerformanceTracker.setSceneAccessor(new Scene$1());
        SceneHelper.setSceneAccessor(new Scene$2());
        inSynchronizer = false;
        inMousePick = false;
        allowPGAccess = false;
        pgAccessCount = 0;
        snapshotPulseListener = null;
        trackerMonitor = new Object();
        USER_DATA_KEY = new Object();
        defaultNodeOrientation = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.scene.nodeOrientation.RTL")) != false ? NodeOrientation.RIGHT_TO_LEFT : NodeOrientation.INHERIT;
    }
}

