/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SubSceneHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.SubSceneTraversalEngine;
import com.sun.javafx.scene.traversal.TopMostTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalMethod;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGSubScene;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Point3D;
import javafx.scene.Camera;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene$1;
import javafx.scene.SubScene$2;
import javafx.scene.SubScene$3;
import javafx.scene.SubScene$4;
import javafx.scene.SubScene$5;
import javafx.scene.SubScene$6;
import javafx.scene.SubScene$7;
import javafx.scene.SubScene$SubSceneDirtyBits;
import javafx.scene.input.PickResult;
import javafx.scene.paint.Paint;

public class SubScene
extends Node {
    private static boolean is3DSupported;
    private final SceneAntialiasing antiAliasing;
    private final boolean depthBuffer;
    private ObjectProperty<Parent> root;
    private ObjectProperty<Camera> camera;
    private Camera defaultCamera;
    private DoubleProperty width;
    private DoubleProperty height;
    private ObjectProperty<Paint> fill;
    private ObjectProperty<String> userAgentStylesheet;
    boolean dirtyLayout;
    private boolean dirtyNodes;
    private TopMostTraversalEngine traversalEngine;
    private int dirtyBits;
    private List<LightBase> lights;

    public SubScene(@NamedArg(value="root") Parent parent, @NamedArg(value="width") double d2, @NamedArg(value="height") double d3) {
        this(parent, d2, d3, false, SceneAntialiasing.DISABLED);
    }

    public SubScene(@NamedArg(value="root") Parent object, @NamedArg(value="width") double d2, @NamedArg(value="height") double d3, @NamedArg(value="depthBuffer") boolean bl2, @NamedArg(value="antiAliasing") SceneAntialiasing sceneAntialiasing) {
        SubSceneHelper.initHelper(this);
        this.userAgentStylesheet = null;
        this.dirtyLayout = false;
        this.dirtyNodes = false;
        this.traversalEngine = new SubSceneTraversalEngine(this);
        this.dirtyBits = -1;
        this.lights = new ArrayList<LightBase>();
        this.depthBuffer = bl2;
        this.antiAliasing = sceneAntialiasing;
        boolean bl3 = sceneAntialiasing != null && sceneAntialiasing != SceneAntialiasing.DISABLED;
        this.setRoot((Parent)object);
        this.setWidth(d2);
        this.setHeight(d3);
        if ((bl2 || bl3) && !is3DSupported) {
            object = SubScene.class.getName();
            PlatformLogger.getLogger((String)object).warning("System can't support ConditionalFeature.SCENE3D");
        }
        if (bl3 && !Toolkit.getToolkit().isMSAASupported()) {
            object = SubScene.class.getName();
            PlatformLogger.getLogger((String)object).warning("System can't support antiAliasing");
        }
    }

    public final SceneAntialiasing getAntiAliasing() {
        return this.antiAliasing;
    }

    public final boolean isDepthBuffer() {
        return this.depthBuffer;
    }

    private boolean isDepthBufferInternal() {
        if (is3DSupported) {
            return this.depthBuffer;
        }
        return false;
    }

    public final void setRoot(Parent parent) {
        this.rootProperty().set(parent);
    }

    public final Parent getRoot() {
        if (this.root == null) {
            return null;
        }
        return (Parent)this.root.get();
    }

    public final ObjectProperty<Parent> rootProperty() {
        if (this.root == null) {
            this.root = new SubScene$2(this);
        }
        return this.root;
    }

    public final void setCamera(Camera camera) {
        this.cameraProperty().set(camera);
    }

    public final Camera getCamera() {
        if (this.camera == null) {
            return null;
        }
        return (Camera)this.camera.get();
    }

    public final ObjectProperty<Camera> cameraProperty() {
        if (this.camera == null) {
            this.camera = new SubScene$3(this);
        }
        return this.camera;
    }

    Camera getEffectiveCamera() {
        Camera camera = this.getCamera();
        if (camera == null || camera instanceof PerspectiveCamera && !is3DSupported) {
            if (this.defaultCamera == null) {
                this.defaultCamera = new ParallelCamera();
                this.defaultCamera.setOwnerSubScene(this);
                this.defaultCamera.setViewWidth(this.getWidth());
                this.defaultCamera.setViewHeight(this.getHeight());
            }
            return this.defaultCamera;
        }
        return camera;
    }

    final void markContentDirty() {
        this.markDirty(SubScene$SubSceneDirtyBits.CONTENT_DIRTY);
    }

    public final void setWidth(double d2) {
        this.widthProperty().set(d2);
    }

    public final double getWidth() {
        if (this.width == null) {
            return 0.0;
        }
        return this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new SubScene$4(this);
        }
        return this.width;
    }

    public final void setHeight(double d2) {
        this.heightProperty().set(d2);
    }

    public final double getHeight() {
        if (this.height == null) {
            return 0.0;
        }
        return this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new SubScene$5(this);
        }
        return this.height;
    }

    public final void setFill(Paint paint) {
        this.fillProperty().set(paint);
    }

    public final Paint getFill() {
        if (this.fill == null) {
            return null;
        }
        return (Paint)this.fill.get();
    }

    public final ObjectProperty<Paint> fillProperty() {
        if (this.fill == null) {
            this.fill = new SubScene$6(this, null);
        }
        return this.fill;
    }

    private void doUpdatePeer() {
        this.dirtyNodes = false;
        if (this.isDirty()) {
            NGSubScene nGSubScene = (NGSubScene)this.getPeer();
            Camera camera = this.getEffectiveCamera();
            boolean bl2 = false;
            if (camera.getSubScene() == null && this.isDirty(SubScene$SubSceneDirtyBits.CONTENT_DIRTY)) {
                camera.syncPeer();
            }
            if (this.isDirty(SubScene$SubSceneDirtyBits.FILL_DIRTY)) {
                Object object = this.getFill() == null ? null : Toolkit.getPaintAccessor().getPlatformPaint(this.getFill());
                nGSubScene.setFillPaint(object);
                bl2 = true;
            }
            if (this.isDirty(SubScene$SubSceneDirtyBits.SIZE_DIRTY)) {
                nGSubScene.setWidth((float)this.getWidth());
                nGSubScene.setHeight((float)this.getHeight());
            }
            if (this.isDirty(SubScene$SubSceneDirtyBits.CAMERA_DIRTY)) {
                nGSubScene.setCamera((NGCamera)camera.getPeer());
                bl2 = true;
            }
            if (this.isDirty(SubScene$SubSceneDirtyBits.ROOT_SG_DIRTY)) {
                nGSubScene.setRoot((NGNode)this.getRoot().getPeer());
                bl2 = true;
            }
            if ((bl2 |= this.syncLights()) || this.isDirty(SubScene$SubSceneDirtyBits.CONTENT_DIRTY)) {
                nGSubScene.markContentDirty();
            }
            this.clearDirtyBits();
        }
    }

    @Override
    void nodeResolvedOrientationChanged() {
        this.getRoot().parentResolvedOrientationInvalidated();
    }

    private void doProcessCSS() {
        if (this.cssFlag == CssFlags.CLEAN) {
            return;
        }
        if (this.getRoot().cssFlag == CssFlags.CLEAN) {
            this.getRoot().cssFlag = this.cssFlag;
        }
        SubSceneHelper.superProcessCSS(this);
        this.getRoot().processCSS();
    }

    @Override
    void processCSS() {
        Parent parent = this.getRoot();
        if (parent.isDirty(DirtyBits.NODE_CSS)) {
            parent.clearDirty(DirtyBits.NODE_CSS);
            if (this.cssFlag == CssFlags.CLEAN) {
                this.cssFlag = CssFlags.UPDATE;
            }
        }
        super.processCSS();
    }

    public final ObjectProperty<String> userAgentStylesheetProperty() {
        if (this.userAgentStylesheet == null) {
            SubScene subScene = this;
            this.userAgentStylesheet = new SubScene$7(subScene, subScene, "userAgentStylesheet", null);
        }
        return this.userAgentStylesheet;
    }

    public final String getUserAgentStylesheet() {
        if (this.userAgentStylesheet == null) {
            return null;
        }
        return (String)this.userAgentStylesheet.get();
    }

    public final void setUserAgentStylesheet(String string) {
        this.userAgentStylesheetProperty().set(string);
    }

    @Override
    void updateBounds() {
        super.updateBounds();
        this.getRoot().updateBounds();
    }

    private NGNode doCreatePeer() {
        if (!is3DSupported) {
            return new NGSubScene(false, false);
        }
        boolean bl2 = this.antiAliasing != null && this.antiAliasing != SceneAntialiasing.DISABLED;
        return new NGSubScene(this.depthBuffer, bl2 && Toolkit.getToolkit().isMSAASupported());
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        int n2 = (int)Math.ceil(this.width.get());
        int n3 = (int)Math.ceil(this.height.get());
        BaseBounds baseBounds2 = baseBounds = baseBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, n2, n3, 0.0f);
        baseBounds = baseTransform.transform(baseBounds2, baseBounds2);
        return baseBounds;
    }

    void setDirtyLayout(Parent parent) {
        if (!this.dirtyLayout && parent != null && parent.getSubScene() == this && this.getScene() != null) {
            this.dirtyLayout = true;
            this.markDirtyLayoutBranch();
            this.markDirty(SubScene$SubSceneDirtyBits.CONTENT_DIRTY);
        }
    }

    void setDirty(Node node) {
        if (!this.dirtyNodes && node != null && node.getSubScene() == this && this.getScene() != null) {
            this.dirtyNodes = true;
            this.markDirty(SubScene$SubSceneDirtyBits.CONTENT_DIRTY);
        }
    }

    void layoutPass() {
        if (this.dirtyLayout) {
            Parent parent = this.getRoot();
            if (parent != null) {
                parent.layout();
            }
            this.dirtyLayout = false;
        }
    }

    boolean traverse(Node node, Direction direction, TraversalMethod traversalMethod) {
        return this.traversalEngine.trav(node, direction, traversalMethod) != null;
    }

    private void clearDirtyBits() {
        this.dirtyBits = 0;
    }

    private boolean isDirty() {
        return this.dirtyBits != 0;
    }

    private void setDirty(SubScene$SubSceneDirtyBits subScene$SubSceneDirtyBits) {
        this.dirtyBits |= subScene$SubSceneDirtyBits.getMask();
    }

    private boolean isDirty(SubScene$SubSceneDirtyBits subScene$SubSceneDirtyBits) {
        return (this.dirtyBits & subScene$SubSceneDirtyBits.getMask()) != 0;
    }

    private void markDirty(SubScene$SubSceneDirtyBits subScene$SubSceneDirtyBits) {
        if (!this.isDirty()) {
            NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
        }
        this.setDirty(subScene$SubSceneDirtyBits);
    }

    private boolean doComputeContains(double d2, double d3) {
        if (this.subSceneComputeContains(d2, d3)) {
            return true;
        }
        return NodeHelper.computeContains(this.getRoot(), d2, d3);
    }

    private boolean subSceneComputeContains(double d2, double d3) {
        if (d2 < 0.0 || d3 < 0.0 || d2 > this.getWidth() || d3 > this.getHeight()) {
            return false;
        }
        return this.getFill() != null;
    }

    private PickResult pickRootSG(double d2, double d3) {
        double d4 = this.getWidth();
        double d5 = this.getHeight();
        if (d2 < 0.0 || d3 < 0.0 || d2 > d4 || d3 > d5) {
            return null;
        }
        PickResultChooser pickResultChooser = new PickResultChooser();
        PickRay pickRay = this.getEffectiveCamera().computePickRay(d2, d3, new PickRay());
        pickRay.getDirectionNoClone().normalize();
        this.getRoot().pickNode(pickRay, pickResultChooser);
        return pickResultChooser.toPickResult();
    }

    private void doPickNodeLocal(PickRay object, PickResultChooser pickResultChooser) {
        double d2 = this.intersectsBounds((PickRay)object);
        if (!Double.isNaN(d2) && pickResultChooser.isCloser(d2)) {
            PickResult pickResult = this.pickRootSG(((Point3D)(object = PickResultChooser.computePoint((PickRay)object, d2))).getX(), ((Point3D)object).getY());
            if (pickResult != null) {
                pickResultChooser.offerSubScenePickResult(this, pickResult, d2);
                return;
            }
            if (this.isPickOnBounds() || this.subSceneComputeContains(((Point3D)object).getX(), ((Point3D)object).getY())) {
                pickResultChooser.offer(this, d2, (Point3D)object);
            }
        }
    }

    final void addLight(LightBase lightBase) {
        if (!this.lights.contains(lightBase)) {
            this.markDirty(SubScene$SubSceneDirtyBits.LIGHTS_DIRTY);
            this.lights.add(lightBase);
        }
    }

    final void removeLight(LightBase lightBase) {
        if (this.lights.remove(lightBase)) {
            this.markDirty(SubScene$SubSceneDirtyBits.LIGHTS_DIRTY);
        }
    }

    private boolean syncLights() {
        int n2 = 0;
        if (!this.isDirty(SubScene$SubSceneDirtyBits.LIGHTS_DIRTY)) {
            return false;
        }
        NGSubScene nGSubScene = (NGSubScene)this.getPeer();
        NGLightBase[] nGLightBaseArray = nGSubScene.getLights();
        if (!this.lights.isEmpty() || nGLightBaseArray != null) {
            if (this.lights.isEmpty()) {
                nGSubScene.setLights(null);
            } else {
                if (nGLightBaseArray == null || nGLightBaseArray.length < this.lights.size()) {
                    nGLightBaseArray = new NGLightBase[this.lights.size()];
                }
                for (n2 = 0; n2 < this.lights.size(); ++n2) {
                    nGLightBaseArray[n2] = (NGLightBase)this.lights.get(n2).getPeer();
                }
                while (n2 < nGLightBaseArray.length && nGLightBaseArray[n2] != null) {
                    nGLightBaseArray[n2++] = null;
                }
                nGSubScene.setLights(nGLightBaseArray);
            }
            n2 = 1;
        }
        return n2 != 0;
    }

    static {
        SubSceneHelper.setSubSceneAccessor(new SubScene$1());
        is3DSupported = Platform.isSupported(ConditionalFeature.SCENE3D);
    }
}

