/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.canvas;

import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.PixelGetter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.ByteBgraPre;
import com.sun.javafx.sg.prism.GrowableDataBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.paint.Color;

class GraphicsContext$1
implements PixelWriter {
    final /* synthetic */ GraphicsContext this$0;

    GraphicsContext$1(GraphicsContext graphicsContext) {
        this.this$0 = graphicsContext;
    }

    @Override
    public PixelFormat<ByteBuffer> getPixelFormat() {
        return PixelFormat.getByteBgraPreInstance();
    }

    private BytePixelSetter getSetter() {
        return ByteBgraPre.setter;
    }

    @Override
    public void setArgb(int n2, int n3, int n4) {
        GrowableDataBuffer growableDataBuffer = this.this$0.getBuffer();
        growableDataBuffer.putByte((byte)52);
        growableDataBuffer.putInt(n2);
        growableDataBuffer.putInt(n3);
        growableDataBuffer.putInt(n4);
    }

    @Override
    public void setColor(int n2, int n3, Color color) {
        if (color == null) {
            throw new NullPointerException("Color cannot be null");
        }
        int n4 = (int)Math.round(color.getOpacity() * 255.0);
        int n5 = (int)Math.round(color.getRed() * 255.0);
        int n6 = (int)Math.round(color.getGreen() * 255.0);
        int n7 = (int)Math.round(color.getBlue() * 255.0);
        this.setArgb(n2, n3, n4 << 24 | n5 << 16 | n6 << 8 | n7);
    }

    private void writePixelBuffer(int n2, int n3, int n4, int n5, byte[] byArray) {
        GrowableDataBuffer growableDataBuffer = this.this$0.getBuffer();
        growableDataBuffer.putByte((byte)53);
        growableDataBuffer.putInt(n2);
        growableDataBuffer.putInt(n3);
        growableDataBuffer.putInt(n4);
        growableDataBuffer.putInt(n5);
        growableDataBuffer.putObject(byArray);
    }

    private int[] checkBounds(int n2, int n3, int n4, int n5, PixelFormat<? extends Buffer> pixelFormat, int n6) {
        int n7 = (int)Math.ceil(this.this$0.theCanvas.getWidth());
        int n8 = (int)Math.ceil(this.this$0.theCanvas.getHeight());
        if (n2 >= 0 && n3 >= 0 && n2 + n4 <= n7 && n3 + n5 <= n8) {
            return null;
        }
        int n9 = 0;
        if (n2 < 0) {
            if ((n4 += n2) < 0) {
                return null;
            }
            if (pixelFormat != null) {
                switch (pixelFormat.getType()) {
                    case BYTE_BGRA: 
                    case BYTE_BGRA_PRE: {
                        n9 = 0 - (n2 << 2);
                        break;
                    }
                    case BYTE_RGB: {
                        n9 = 0 - n2 * 3;
                        break;
                    }
                    case BYTE_INDEXED: 
                    case INT_ARGB: 
                    case INT_ARGB_PRE: {
                        n9 = 0 - n2;
                        break;
                    }
                    default: {
                        throw new InternalError("unknown Pixel Format");
                    }
                }
            }
            n2 = 0;
        }
        if (n3 < 0) {
            if ((n5 += n3) < 0) {
                return null;
            }
            n9 -= n3 * n6;
            n3 = 0;
        }
        if (n2 + n4 > n7 && (n4 = n7 - n2) < 0) {
            return null;
        }
        if (n3 + n5 > n8 && (n5 = n8 - n3) < 0) {
            return null;
        }
        return new int[]{n2, n3, n4, n5, n9};
    }

    @Override
    public <T extends Buffer> void setPixels(int n2, int n3, int n4, int n5, PixelFormat<T> pixelConverter, T t2, int n6) {
        if (pixelConverter == null) {
            throw new NullPointerException("PixelFormat cannot be null");
        }
        if (t2 == null) {
            throw new NullPointerException("Buffer cannot be null");
        }
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        int n7 = t2.position();
        Object[] objectArray = this.checkBounds(n2, n3, n4, n5, (PixelFormat<? extends Buffer>)((Object)pixelConverter), n6);
        if (objectArray != null) {
            n2 = objectArray[0];
            n3 = objectArray[1];
            n4 = objectArray[2];
            n5 = objectArray[3];
            n7 += objectArray[4];
        }
        byte[] byArray = new byte[n4 * n5 << 2];
        objectArray = byArray;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        pixelConverter = PixelUtils.getGetter(pixelConverter);
        pixelConverter = PixelUtils.getConverter(pixelConverter, this.getSetter());
        pixelConverter.convert(t2, n7, n6, byteBuffer, 0, n4 << 2, n4, n5);
        this.writePixelBuffer(n2, n3, n4, n5, (byte[])objectArray);
    }

    @Override
    public void setPixels(int n2, int n3, int n4, int n5, PixelFormat<ByteBuffer> object, byte[] byArray, int n6, int n7) {
        if (object == null) {
            throw new NullPointerException("PixelFormat cannot be null");
        }
        if (byArray == null) {
            throw new NullPointerException("Buffer cannot be null");
        }
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        Object[] objectArray = this.checkBounds(n2, n3, n4, n5, (PixelFormat<? extends Buffer>)object, n7);
        if (objectArray != null) {
            n2 = objectArray[0];
            n3 = objectArray[1];
            n4 = objectArray[2];
            n5 = objectArray[3];
            n6 += objectArray[4];
        }
        objectArray = new byte[n4 * n5 << 2];
        object = PixelUtils.getByteGetter(object);
        object = PixelUtils.getB2BConverter((PixelGetter<ByteBuffer>)object, this.getSetter());
        object.convert(byArray, n6, n7, (byte[])objectArray, 0, n4 << 2, n4, n5);
        this.writePixelBuffer(n2, n3, n4, n5, (byte[])objectArray);
    }

    @Override
    public void setPixels(int n2, int n3, int n4, int n5, PixelFormat<IntBuffer> object, int[] nArray, int n6, int n7) {
        if (object == null) {
            throw new NullPointerException("PixelFormat cannot be null");
        }
        if (nArray == null) {
            throw new NullPointerException("Buffer cannot be null");
        }
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        Object[] objectArray = this.checkBounds(n2, n3, n4, n5, (PixelFormat<? extends Buffer>)object, n7);
        if (objectArray != null) {
            n2 = objectArray[0];
            n3 = objectArray[1];
            n4 = objectArray[2];
            n5 = objectArray[3];
            n6 += objectArray[4];
        }
        objectArray = new byte[n4 * n5 << 2];
        object = PixelUtils.getIntGetter(object);
        object = PixelUtils.getI2BConverter((PixelGetter<IntBuffer>)object, this.getSetter());
        object.convert(nArray, n6, n7, (byte[])objectArray, 0, n4 << 2, n4, n5);
        this.writePixelBuffer(n2, n3, n4, n5, (byte[])objectArray);
    }

    @Override
    public void setPixels(int n2, int n3, int n4, int n5, PixelReader pixelReader, int n6, int n7) {
        if (pixelReader == null) {
            throw new NullPointerException("Reader cannot be null");
        }
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        int[] nArray = this.checkBounds(n2, n3, n4, n5, null, 0);
        if (nArray != null) {
            int n8 = nArray[0];
            n4 = nArray[1];
            n6 += n8 - n2;
            n7 += n4 - n3;
            n2 = n8;
            n3 = n4;
            n4 = nArray[2];
            n5 = nArray[3];
        }
        byte[] byArray = new byte[n4 * n5 << 2];
        pixelReader.getPixels(n6, n7, n4, n5, PixelFormat.getByteBgraPreInstance(), byArray, 0, n4 << 2);
        this.writePixelBuffer(n2, n3, n4, n5, byArray);
    }
}

