/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.scene.NodeHelper;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.Axis$1;
import javafx.scene.chart.Axis$10;
import javafx.scene.chart.Axis$2;
import javafx.scene.chart.Axis$3;
import javafx.scene.chart.Axis$4;
import javafx.scene.chart.Axis$5;
import javafx.scene.chart.Axis$6;
import javafx.scene.chart.Axis$7;
import javafx.scene.chart.Axis$8;
import javafx.scene.chart.Axis$9;
import javafx.scene.chart.Axis$StyleableProperties;
import javafx.scene.chart.Axis$TickMark;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;

public abstract class Axis<T>
extends Region {
    Text measure = new Text();
    private Orientation effectiveOrientation;
    private double effectiveTickLabelRotation = Double.NaN;
    private Label axisLabel = new Label();
    private final Path tickMarkPath = new Path();
    private double oldLength = 0.0;
    boolean rangeValid = false;
    boolean measureInvalid = false;
    boolean tickLabelsVisibleInvalid = false;
    private BitSet labelsToSkip = new BitSet();
    private final ObservableList<Axis$TickMark<T>> tickMarks = FXCollections.observableArrayList();
    private final ObservableList<Axis$TickMark<T>> unmodifiableTickMarks = FXCollections.unmodifiableObservableList(this.tickMarks);
    private ObjectProperty<Side> side = new Axis$1(this);
    private ObjectProperty<String> label = new Axis$2(this);
    private BooleanProperty tickMarkVisible = new Axis$3(this, true);
    private BooleanProperty tickLabelsVisible = new Axis$4(this, true);
    private DoubleProperty tickLength = new Axis$5(this, 8.0);
    private BooleanProperty autoRanging = new Axis$6(this, true);
    private ObjectProperty<Font> tickLabelFont = new Axis$7(this, Font.font("System", 8.0));
    private ObjectProperty<Paint> tickLabelFill = new Axis$8(this, Color.BLACK);
    private DoubleProperty tickLabelGap = new Axis$9(this, 3.0);
    private BooleanProperty animated = new SimpleBooleanProperty(this, "animated", true);
    private DoubleProperty tickLabelRotation = new Axis$10(this, 0.0);
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("right");

    public ObservableList<Axis$TickMark<T>> getTickMarks() {
        return this.unmodifiableTickMarks;
    }

    public final Side getSide() {
        return (Side)((Object)this.side.get());
    }

    public final void setSide(Side side) {
        this.side.set(side);
    }

    public final ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    final void setEffectiveOrientation(Orientation orientation) {
        this.effectiveOrientation = orientation;
    }

    final Side getEffectiveSide() {
        Side side = this.getSide();
        if (side == null || side.isVertical() && this.effectiveOrientation == Orientation.HORIZONTAL || side.isHorizontal() && this.effectiveOrientation == Orientation.VERTICAL) {
            if (this.effectiveOrientation == Orientation.VERTICAL) {
                return Side.LEFT;
            }
            return Side.BOTTOM;
        }
        return side;
    }

    public final String getLabel() {
        return (String)this.label.get();
    }

    public final void setLabel(String string) {
        this.label.set(string);
    }

    public final ObjectProperty<String> labelProperty() {
        return this.label;
    }

    public final boolean isTickMarkVisible() {
        return this.tickMarkVisible.get();
    }

    public final void setTickMarkVisible(boolean bl2) {
        this.tickMarkVisible.set(bl2);
    }

    public final BooleanProperty tickMarkVisibleProperty() {
        return this.tickMarkVisible;
    }

    public final boolean isTickLabelsVisible() {
        return this.tickLabelsVisible.get();
    }

    public final void setTickLabelsVisible(boolean bl2) {
        this.tickLabelsVisible.set(bl2);
    }

    public final BooleanProperty tickLabelsVisibleProperty() {
        return this.tickLabelsVisible;
    }

    public final double getTickLength() {
        return this.tickLength.get();
    }

    public final void setTickLength(double d2) {
        this.tickLength.set(d2);
    }

    public final DoubleProperty tickLengthProperty() {
        return this.tickLength;
    }

    public final boolean isAutoRanging() {
        return this.autoRanging.get();
    }

    public final void setAutoRanging(boolean bl2) {
        this.autoRanging.set(bl2);
    }

    public final BooleanProperty autoRangingProperty() {
        return this.autoRanging;
    }

    public final Font getTickLabelFont() {
        return (Font)this.tickLabelFont.get();
    }

    public final void setTickLabelFont(Font font) {
        this.tickLabelFont.set(font);
    }

    public final ObjectProperty<Font> tickLabelFontProperty() {
        return this.tickLabelFont;
    }

    public final Paint getTickLabelFill() {
        return (Paint)this.tickLabelFill.get();
    }

    public final void setTickLabelFill(Paint paint) {
        this.tickLabelFill.set(paint);
    }

    public final ObjectProperty<Paint> tickLabelFillProperty() {
        return this.tickLabelFill;
    }

    public final double getTickLabelGap() {
        return this.tickLabelGap.get();
    }

    public final void setTickLabelGap(double d2) {
        this.tickLabelGap.set(d2);
    }

    public final DoubleProperty tickLabelGapProperty() {
        return this.tickLabelGap;
    }

    public final boolean getAnimated() {
        return this.animated.get();
    }

    public final void setAnimated(boolean bl2) {
        this.animated.set(bl2);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final double getTickLabelRotation() {
        return this.tickLabelRotation.getValue();
    }

    public final void setTickLabelRotation(double d2) {
        this.tickLabelRotation.setValue(d2);
    }

    public final DoubleProperty tickLabelRotationProperty() {
        return this.tickLabelRotation;
    }

    public Axis() {
        this.getStyleClass().setAll((String[])new String[]{"axis"});
        this.axisLabel.getStyleClass().add("axis-label");
        this.axisLabel.setAlignment(Pos.CENTER);
        this.tickMarkPath.getStyleClass().add("axis-tick-mark");
        this.getChildren().addAll((Node[])new Node[]{this.axisLabel, this.tickMarkPath});
    }

    protected final boolean isRangeValid() {
        return this.rangeValid;
    }

    protected final void invalidateRange() {
        this.rangeValid = false;
    }

    protected final boolean shouldAnimate() {
        return this.getAnimated() && NodeHelper.isTreeShowing(this);
    }

    @Override
    public void requestLayout() {
    }

    public void requestAxisLayout() {
        super.requestLayout();
    }

    public void invalidateRange(List<T> list) {
        this.invalidateRange();
        this.requestAxisLayout();
    }

    protected abstract Object autoRange(double var1);

    protected abstract void setRange(Object var1, boolean var2);

    protected abstract Object getRange();

    public abstract double getZeroPosition();

    public abstract double getDisplayPosition(T var1);

    public abstract T getValueForDisplay(double var1);

    public abstract boolean isValueOnAxis(T var1);

    public abstract double toNumericValue(T var1);

    public abstract T toRealValue(double var1);

    protected abstract List<T> calculateTickValues(double var1, Object var3);

    @Override
    protected double computePrefHeight(double d2) {
        Object object = this.getEffectiveSide();
        if (object.isVertical()) {
            return 100.0;
        }
        object = this.autoRange(d2);
        double d3 = 0.0;
        if (this.isTickLabelsVisible()) {
            List<T> list = this.calculateTickValues(d2, object);
            for (T t2 : list) {
                d3 = Math.max(d3, this.measureTickMarkSize(t2, object).getHeight());
            }
        }
        double d4 = this.isTickMarkVisible() ? (this.getTickLength() > 0.0 ? this.getTickLength() : 0.0) : 0.0;
        double d5 = this.axisLabel.getText() == null || this.axisLabel.getText().length() == 0 ? 0.0 : ((Node)this.axisLabel).prefHeight(-1.0);
        return d3 + this.getTickLabelGap() + d4 + d5;
    }

    @Override
    protected double computePrefWidth(double d2) {
        Object object = this.getEffectiveSide();
        if (object.isVertical()) {
            object = this.autoRange(d2);
            double d3 = 0.0;
            if (this.isTickLabelsVisible()) {
                List<T> list = this.calculateTickValues(d2, object);
                for (T t2 : list) {
                    d3 = Math.max(d3, this.measureTickMarkSize(t2, object).getWidth());
                }
            }
            double d4 = this.isTickMarkVisible() ? (this.getTickLength() > 0.0 ? this.getTickLength() : 0.0) : 0.0;
            double d5 = this.axisLabel.getText() == null || this.axisLabel.getText().length() == 0 ? 0.0 : ((Node)this.axisLabel).prefHeight(-1.0);
            return d3 + this.getTickLabelGap() + d4 + d5;
        }
        return 100.0;
    }

    protected void tickMarksUpdated() {
    }

    @Override
    protected void layoutChildren() {
        boolean bl2 = this.oldLength == 0.0;
        Side side = this.getEffectiveSide();
        double d2 = side.isVertical() ? this.getHeight() : this.getWidth();
        boolean bl3 = !this.isRangeValid();
        boolean bl4 = this.oldLength != d2;
        if (bl4 || bl3) {
            Object object2;
            if (this.isAutoRanging()) {
                object2 = this.autoRange(d2);
                this.setRange(object2, this.getAnimated() && !bl2 && NodeHelper.isTreeShowing(this) && bl3);
            } else {
                object2 = this.getRange();
            }
            List<T> list = this.calculateTickValues(d2, object2);
            Iterator iterator = this.tickMarks.iterator();
            while (iterator.hasNext()) {
                Axis$TickMark axis$TickMark = (Axis$TickMark)iterator.next();
                Axis$TickMark<Object> axis$TickMark2 = axis$TickMark;
                if (this.shouldAnimate()) {
                    FadeTransition fadeTransition = new FadeTransition(Duration.millis(250.0), axis$TickMark.textNode);
                    fadeTransition.setToValue(0.0);
                    fadeTransition.setOnFinished(actionEvent -> this.getChildren().remove(axis$TickMark.textNode));
                    fadeTransition.play();
                } else {
                    this.getChildren().remove(axis$TickMark2.textNode);
                }
                iterator.remove();
            }
            for (Axis$TickMark<Object> axis$TickMark2 : list) {
                Axis$TickMark<Axis$TickMark> axis$TickMark = new Axis$TickMark<Axis$TickMark>();
                axis$TickMark.setValue(axis$TickMark2);
                axis$TickMark.textNode.setText(this.getTickMarkLabel(axis$TickMark2));
                axis$TickMark.textNode.setFont(this.getTickLabelFont());
                axis$TickMark.textNode.setFill(this.getTickLabelFill());
                axis$TickMark.setTextVisible(this.isTickLabelsVisible());
                if (this.shouldAnimate()) {
                    axis$TickMark.textNode.setOpacity(0.0);
                }
                this.getChildren().add(axis$TickMark.textNode);
                this.tickMarks.add(axis$TickMark);
                if (!this.shouldAnimate()) continue;
                FadeTransition object3 = new FadeTransition(Duration.millis(750.0), axis$TickMark.textNode);
                object3.setFromValue(0.0);
                object3.setToValue(1.0);
                object3.play();
            }
            this.tickMarksUpdated();
            this.oldLength = d2;
            this.rangeValid = true;
        }
        if (bl4 || bl3 || this.measureInvalid || this.tickLabelsVisibleInvalid) {
            this.measureInvalid = false;
            this.tickLabelsVisibleInvalid = false;
            this.labelsToSkip.clear();
            int n2 = 0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (Axis$TickMark axis$TickMark : this.tickMarks) {
                axis$TickMark.setPosition(this.getDisplayPosition(axis$TickMark.getValue()));
                if (!axis$TickMark.isTextVisible()) continue;
                double d5 = this.measureTickMarkSize(axis$TickMark.getValue(), side);
                d3 += d5;
                d4 = Math.round(Math.max(d4, d5));
            }
            if (d4 > 0.0 && d2 < d3) {
                n2 = (int)((double)this.tickMarks.size() * d4 / d2) + 1;
            }
            if (n2 > 0) {
                int n3 = 0;
                for (Axis$TickMark axis$TickMark : this.tickMarks) {
                    if (!axis$TickMark.isTextVisible()) continue;
                    axis$TickMark.setTextVisible(n3++ % n2 == 0);
                }
            }
            if (this.tickMarks.size() > 2) {
                Axis$TickMark axis$TickMark;
                Axis$TickMark axis$TickMark2;
                Axis$TickMark axis$TickMark3 = (Axis$TickMark)this.tickMarks.get(0);
                if (this.isTickLabelsOverlap(side, axis$TickMark3, axis$TickMark2 = (Axis$TickMark)this.tickMarks.get(1), this.getTickLabelGap())) {
                    axis$TickMark2.setTextVisible(false);
                }
                if (this.isTickLabelsOverlap(side, axis$TickMark3 = (Axis$TickMark)this.tickMarks.get(this.tickMarks.size() - 2), axis$TickMark = (Axis$TickMark)this.tickMarks.get(this.tickMarks.size() - 1), this.getTickLabelGap())) {
                    axis$TickMark3.setTextVisible(false);
                }
            }
            this.updateTickMarks(side, d2);
        }
    }

    private void updateTickMarks(Side side, double d2) {
        this.tickMarkPath.getElements().clear();
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        double d5 = this.isTickMarkVisible() && this.getTickLength() > 0.0 ? this.getTickLength() : 0.0;
        double d6 = this.getEffectiveTickLabelRotation();
        if (Side.LEFT.equals((Object)side)) {
            this.tickMarkPath.setLayoutX(-0.5);
            this.tickMarkPath.setLayoutY(0.5);
            if (this.getLabel() != null) {
                this.axisLabel.getTransforms().setAll((Transform[])new Transform[]{new Translate(0.0, d4), new Rotate(-90.0, 0.0, 0.0)});
                this.axisLabel.setLayoutX(0.0);
                this.axisLabel.setLayoutY(0.0);
                ((Node)this.axisLabel).resize(d4, Math.ceil(((Node)this.axisLabel).prefHeight(d3)));
            }
            for (Axis$TickMark axis$TickMark : this.tickMarks) {
                this.positionTextNode(axis$TickMark.textNode, d3 - this.getTickLabelGap() - d5, axis$TickMark.getPosition(), d6, side);
                this.updateTickMark(axis$TickMark, d2, d3 - d5, axis$TickMark.getPosition(), d3, axis$TickMark.getPosition());
            }
            return;
        }
        if (Side.RIGHT.equals((Object)side)) {
            this.tickMarkPath.setLayoutX(0.5);
            this.tickMarkPath.setLayoutY(0.5);
            if (this.getLabel() != null) {
                double d7 = Math.ceil(((Node)this.axisLabel).prefHeight(d3));
                this.axisLabel.getTransforms().setAll((Transform[])new Transform[]{new Translate(0.0, d4), new Rotate(-90.0, 0.0, 0.0)});
                this.axisLabel.setLayoutX(d3 - d7);
                this.axisLabel.setLayoutY(0.0);
                ((Node)this.axisLabel).resize(d4, d7);
            }
            for (Axis$TickMark axis$TickMark : this.tickMarks) {
                this.positionTextNode(axis$TickMark.textNode, this.getTickLabelGap() + d5, axis$TickMark.getPosition(), d6, side);
                this.updateTickMark(axis$TickMark, d2, 0.0, axis$TickMark.getPosition(), d5, axis$TickMark.getPosition());
            }
            return;
        }
        if (Side.TOP.equals((Object)side)) {
            this.tickMarkPath.setLayoutX(0.5);
            this.tickMarkPath.setLayoutY(-0.5);
            if (this.getLabel() != null) {
                this.axisLabel.getTransforms().clear();
                this.axisLabel.setLayoutX(0.0);
                this.axisLabel.setLayoutY(0.0);
                ((Node)this.axisLabel).resize(d3, Math.ceil(((Node)this.axisLabel).prefHeight(d3)));
            }
            for (Axis$TickMark axis$TickMark : this.tickMarks) {
                this.positionTextNode(axis$TickMark.textNode, axis$TickMark.getPosition(), d4 - d5 - this.getTickLabelGap(), d6, side);
                this.updateTickMark(axis$TickMark, d2, axis$TickMark.getPosition(), d4, axis$TickMark.getPosition(), d4 - d5);
            }
            return;
        }
        this.tickMarkPath.setLayoutX(0.5);
        this.tickMarkPath.setLayoutY(0.5);
        if (this.getLabel() != null) {
            this.axisLabel.getTransforms().clear();
            double d8 = Math.ceil(((Node)this.axisLabel).prefHeight(d3));
            this.axisLabel.setLayoutX(0.0);
            this.axisLabel.setLayoutY(d4 - d8);
            ((Node)this.axisLabel).resize(d3, d8);
        }
        for (Axis$TickMark axis$TickMark : this.tickMarks) {
            this.positionTextNode(axis$TickMark.textNode, axis$TickMark.getPosition(), d5 + this.getTickLabelGap(), d6, side);
            this.updateTickMark(axis$TickMark, d2, axis$TickMark.getPosition(), 0.0, axis$TickMark.getPosition(), d5);
        }
    }

    private boolean isTickLabelsOverlap(Side side, Axis$TickMark<T> axis$TickMark, Axis$TickMark<T> axis$TickMark2, double d2) {
        if (!axis$TickMark.isTextVisible() || !axis$TickMark2.isTextVisible()) {
            return false;
        }
        double d3 = this.measureTickMarkSize(axis$TickMark.getValue(), side);
        double d4 = this.measureTickMarkSize(axis$TickMark2.getValue(), side);
        double d5 = axis$TickMark.getPosition() - d3 / 2.0;
        double d6 = axis$TickMark.getPosition() + d3 / 2.0;
        double d7 = axis$TickMark2.getPosition() - d4 / 2.0;
        double d8 = axis$TickMark2.getPosition() + d4 / 2.0;
        if (side.isVertical()) {
            return d5 - d8 <= d2;
        }
        return d7 - d6 <= d2;
    }

    private void positionTextNode(Text text, double d2, double d3, double d4, Side side) {
        text.setLayoutX(0.0);
        text.setLayoutY(0.0);
        text.setRotate(d4);
        Bounds bounds = text.getBoundsInParent();
        if (Side.LEFT.equals((Object)side)) {
            text.setLayoutX(d2 - bounds.getWidth() - bounds.getMinX());
            text.setLayoutY(d3 - bounds.getHeight() / 2.0 - bounds.getMinY());
            return;
        }
        if (Side.RIGHT.equals((Object)side)) {
            text.setLayoutX(d2 - bounds.getMinX());
            text.setLayoutY(d3 - bounds.getHeight() / 2.0 - bounds.getMinY());
            return;
        }
        if (Side.TOP.equals((Object)side)) {
            text.setLayoutX(d2 - bounds.getWidth() / 2.0 - bounds.getMinX());
            text.setLayoutY(d3 - bounds.getHeight() - bounds.getMinY());
            return;
        }
        text.setLayoutX(d2 - bounds.getWidth() / 2.0 - bounds.getMinX());
        text.setLayoutY(d3 - bounds.getMinY());
    }

    private void updateTickMark(Axis$TickMark<T> axis$TickMark, double d2, double d3, double d4, double d5, double d6) {
        if (axis$TickMark.getPosition() >= 0.0 && axis$TickMark.getPosition() <= Math.ceil(d2)) {
            axis$TickMark.textNode.setVisible(axis$TickMark.isTextVisible());
            this.tickMarkPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d3, d4), new LineTo(d5, d6)});
            return;
        }
        axis$TickMark.textNode.setVisible(false);
    }

    protected abstract String getTickMarkLabel(T var1);

    protected final Dimension2D measureTickMarkLabelSize(String object, double d2) {
        this.measure.setRotate(d2);
        this.measure.setText((String)object);
        object = this.measure.getBoundsInParent();
        return new Dimension2D(((Bounds)object).getWidth(), ((Bounds)object).getHeight());
    }

    protected final Dimension2D measureTickMarkSize(T t2, double d2) {
        Axis axis = this;
        return axis.measureTickMarkLabelSize(axis.getTickMarkLabel(t2), d2);
    }

    protected Dimension2D measureTickMarkSize(T t2, Object object) {
        return this.measureTickMarkSize(t2, this.getEffectiveTickLabelRotation());
    }

    private double measureTickMarkSize(T object, Side side) {
        object = this.measureTickMarkSize(object, this.getEffectiveTickLabelRotation());
        if (side.isVertical()) {
            return ((Dimension2D)object).getHeight();
        }
        return ((Dimension2D)object).getWidth();
    }

    final double getEffectiveTickLabelRotation() {
        if (!this.isAutoRanging() || Double.isNaN(this.effectiveTickLabelRotation)) {
            return this.getTickLabelRotation();
        }
        return this.effectiveTickLabelRotation;
    }

    final void setEffectiveTickLabelRotation(double d2) {
        this.effectiveTickLabelRotation = d2;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Axis$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Axis.getClassCssMetaData();
    }
}

