/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend$LegendItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.DoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart$1;
import javafx.scene.chart.BarChart$2;
import javafx.scene.chart.BarChart$StyleableProperties;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.chart.XYChart$Data;
import javafx.scene.chart.XYChart$Series;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class BarChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart$Series<X, Y>, Map<String, XYChart$Data<X, Y>>> seriesCategoryMap = new HashMap<XYChart$Series<X, Y>, Map<String, XYChart$Data<X, Y>>>();
    private final Orientation orientation;
    private CategoryAxis categoryAxis;
    private ValueAxis valueAxis;
    private Timeline dataRemoveTimeline;
    private double bottomPos = 0.0;
    private static String NEGATIVE_STYLE = "negative";
    private ParallelTransition pt;
    private Map<XYChart$Data<X, Y>, Double> XYValueMap = new HashMap<XYChart$Data<X, Y>, Double>();
    private DoubleProperty barGap = new BarChart$1(this, 4.0);
    private DoubleProperty categoryGap = new BarChart$2(this, 10.0);
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("horizontal");

    public final double getBarGap() {
        return this.barGap.getValue();
    }

    public final void setBarGap(double d2) {
        this.barGap.setValue(d2);
    }

    public final DoubleProperty barGapProperty() {
        return this.barGap;
    }

    public final double getCategoryGap() {
        return this.categoryGap.getValue();
    }

    public final void setCategoryGap(double d2) {
        this.categoryGap.setValue(d2);
    }

    public final DoubleProperty categoryGapProperty() {
        return this.categoryGap;
    }

    public BarChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public BarChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart$Series<X, Y>> observableList) {
        super(axis, axis2);
        this.getStyleClass().add("bar-chart");
        if (!(axis instanceof ValueAxis && axis2 instanceof CategoryAxis || axis2 instanceof ValueAxis && axis instanceof CategoryAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, one of X,Y should be CategoryAxis and the other NumberAxis");
        }
        if (axis instanceof CategoryAxis) {
            this.categoryAxis = (CategoryAxis)axis;
            this.valueAxis = (ValueAxis)axis2;
            this.orientation = Orientation.VERTICAL;
        } else {
            this.categoryAxis = (CategoryAxis)axis2;
            this.valueAxis = (ValueAxis)axis;
            this.orientation = Orientation.HORIZONTAL;
        }
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, this.orientation == Orientation.HORIZONTAL);
        this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, this.orientation == Orientation.VERTICAL);
        this.setData(observableList);
    }

    public BarChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart$Series<X, Y>> observableList, @NamedArg(value="categoryGap") double d2) {
        this(axis, axis2);
        this.setData(observableList);
        this.setCategoryGap(d2);
    }

    @Override
    protected void dataItemAdded(XYChart$Series<X, Y> xYChart$Series, int n2, XYChart$Data<X, Y> xYChart$Data) {
        Object object;
        String string = this.orientation == Orientation.VERTICAL ? (String)xYChart$Data.getXValue() : (String)xYChart$Data.getYValue();
        Map<String, XYChart$Data<X, Y>> map = this.seriesCategoryMap.get(xYChart$Series);
        if (map == null) {
            map = new HashMap<String, XYChart$Data<X, Y>>();
            this.seriesCategoryMap.put(xYChart$Series, map);
        }
        if (!this.categoryAxis.getCategories().contains(string)) {
            this.categoryAxis.getCategories().add(n2, string);
        } else if (map.containsKey(string)) {
            object = map.get(string);
            this.getPlotChildren().remove(((XYChart$Data)object).getNode());
            this.removeDataItemFromDisplay(xYChart$Series, object);
            this.requestChartLayout();
            map.remove(string);
        }
        map.put(string, xYChart$Data);
        object = this.createBar(xYChart$Series, this.getData().indexOf(xYChart$Series), xYChart$Data, n2);
        if (this.shouldAnimate()) {
            this.animateDataAdd(xYChart$Data, (Node)object);
            return;
        }
        this.getPlotChildren().add((Node)object);
    }

    @Override
    protected void dataItemRemoved(XYChart$Data<X, Y> xYChart$Data, XYChart$Series<X, Y> xYChart$Series) {
        Node node = xYChart$Data.getNode();
        if (node != null) {
            node.focusTraversableProperty().unbind();
        }
        if (this.shouldAnimate()) {
            this.XYValueMap.clear();
            this.dataRemoveTimeline = this.createDataRemoveTimeline(xYChart$Data, node, xYChart$Series);
            this.dataRemoveTimeline.setOnFinished(actionEvent -> {
                xYChart$Data.setSeries(null);
                this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
            });
            this.dataRemoveTimeline.play();
            return;
        }
        this.processDataRemove(xYChart$Series, xYChart$Data);
        this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
    }

    @Override
    protected void dataItemChanged(XYChart$Data<X, Y> xYChart$Data) {
        double d2;
        double d3;
        if (this.orientation == Orientation.VERTICAL) {
            d3 = ((Number)xYChart$Data.getYValue()).doubleValue();
            d2 = ((Number)xYChart$Data.getCurrentY()).doubleValue();
        } else {
            d3 = ((Number)xYChart$Data.getXValue()).doubleValue();
            d2 = ((Number)xYChart$Data.getCurrentX()).doubleValue();
        }
        if (d2 > 0.0 && d3 < 0.0) {
            xYChart$Data.getNode().getStyleClass().add(NEGATIVE_STYLE);
            return;
        }
        if (d2 < 0.0 && d3 > 0.0) {
            xYChart$Data.getNode().getStyleClass().remove(NEGATIVE_STYLE);
        }
    }

    @Override
    protected void seriesChanged(ListChangeListener$Change<? extends XYChart$Series> listChangeListener$Change) {
        for (int i2 = 0; i2 < this.getDataSize(); ++i2) {
            XYChart$Series xYChart$Series = (XYChart$Series)this.getData().get(i2);
            for (int i3 = 0; i3 < xYChart$Series.getData().size(); ++i3) {
                Object object = (XYChart$Data)xYChart$Series.getData().get(i3);
                object = ((XYChart$Data)object).getNode();
                ((Node)object).getStyleClass().setAll((String[])new String[]{"chart-bar", "series" + i2, "data" + i3, xYChart$Series.defaultColorStyleClass});
            }
        }
    }

    @Override
    protected void seriesAdded(XYChart$Series<X, Y> xYChart$Series, int n2) {
        HashMap<String, XYChart$Data> hashMap = new HashMap<String, XYChart$Data>();
        for (int i2 = 0; i2 < xYChart$Series.getData().size(); ++i2) {
            double d2;
            XYChart$Data xYChart$Data = (XYChart$Data)xYChart$Series.getData().get(i2);
            Node node = this.createBar(xYChart$Series, n2, xYChart$Data, i2);
            String string = this.orientation == Orientation.VERTICAL ? (String)xYChart$Data.getXValue() : (String)xYChart$Data.getYValue();
            hashMap.put(string, xYChart$Data);
            if (this.shouldAnimate()) {
                this.animateDataAdd(xYChart$Data, node);
                continue;
            }
            double d3 = d2 = this.orientation == Orientation.VERTICAL ? ((Number)xYChart$Data.getYValue()).doubleValue() : ((Number)xYChart$Data.getXValue()).doubleValue();
            if (d3 < 0.0) {
                node.getStyleClass().add(NEGATIVE_STYLE);
            }
            this.getPlotChildren().add(node);
        }
        if (hashMap.size() > 0) {
            this.seriesCategoryMap.put(xYChart$Series, hashMap);
        }
    }

    @Override
    protected void seriesRemoved(XYChart$Series<X, Y> xYChart$Series) {
        if (this.shouldAnimate()) {
            this.pt = new ParallelTransition();
            this.pt.setOnFinished(actionEvent -> this.removeSeriesFromDisplay(xYChart$Series));
            this.XYValueMap.clear();
            for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                Animation animation;
                Node node = xYChart$Data.getNode();
                if (this.getSeriesSize() > 1) {
                    animation = this.createDataRemoveTimeline(xYChart$Data, node, xYChart$Series);
                    this.pt.getChildren().add(animation);
                    continue;
                }
                animation = new FadeTransition(Duration.millis(700.0), node);
                ((FadeTransition)animation).setFromValue(1.0);
                ((FadeTransition)animation).setToValue(0.0);
                animation.setOnFinished(actionEvent -> {
                    this.processDataRemove(xYChart$Series, xYChart$Data);
                    node.setOpacity(1.0);
                });
                this.pt.getChildren().add(animation);
            }
            this.pt.play();
            return;
        }
        for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
            this.processDataRemove(xYChart$Series, xYChart$Data);
        }
        this.removeSeriesFromDisplay(xYChart$Series);
    }

    @Override
    protected void layoutPlotChildren() {
        double d2;
        double d3 = this.categoryAxis.getCategorySpacing();
        double d4 = d3 - (this.getCategoryGap() + this.getBarGap());
        double d5 = d4 / (double)this.getSeriesSize() - this.getBarGap();
        double d6 = -((d3 - this.getCategoryGap()) / 2.0);
        double d7 = d2 = this.valueAxis.getLowerBound() > 0.0 ? this.valueAxis.getDisplayPosition(this.valueAxis.getLowerBound()) : ((Axis)this.valueAxis).getZeroPosition();
        if (d5 <= 0.0) {
            d5 = 1.0;
        }
        int n2 = 0;
        for (String string : this.categoryAxis.getCategories()) {
            int n3 = 0;
            Iterator iterator = this.getDisplayedSeriesIterator();
            while (iterator.hasNext()) {
                double d8;
                double d9;
                Object object = iterator.next();
                if ((object = this.getDataItem((XYChart$Series<X, Y>)object, n3, n2, string)) == null) continue;
                Node node = ((XYChart$Data)object).getNode();
                if (this.orientation == Orientation.VERTICAL) {
                    d9 = this.getXAxis().getDisplayPosition(((XYChart$Data)object).getCurrentX());
                    d8 = this.getYAxis().getDisplayPosition(((XYChart$Data)object).getCurrentY());
                } else {
                    d9 = this.getYAxis().getDisplayPosition(((XYChart$Data)object).getCurrentY());
                    d8 = this.getXAxis().getDisplayPosition(((XYChart$Data)object).getCurrentX());
                }
                if (Double.isNaN(d9) || Double.isNaN(d8)) continue;
                double d10 = Math.min(d8, d2);
                double d11 = Math.max(d8, d2);
                this.bottomPos = d10;
                if (this.orientation == Orientation.VERTICAL) {
                    node.resizeRelocate(d9 + d6 + (d5 + this.getBarGap()) * (double)n3, d10, d5, d11 - d10);
                } else {
                    node.resizeRelocate(d10, d9 + d6 + (d5 + this.getBarGap()) * (double)n3, d11 - d10, d5);
                }
                ++n3;
            }
            ++n2;
        }
    }

    @Override
    Legend$LegendItem createLegendItemForSeries(XYChart$Series<X, Y> xYChart$Series, int n2) {
        Legend$LegendItem legend$LegendItem = new Legend$LegendItem(xYChart$Series.getName());
        legend$LegendItem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-bar", "series" + n2, "bar-legend-symbol", xYChart$Series.defaultColorStyleClass});
        return legend$LegendItem;
    }

    private void updateMap(XYChart$Series<X, Y> xYChart$Series, XYChart$Data<X, Y> object) {
        object = this.orientation == Orientation.VERTICAL ? (String)((XYChart$Data)object).getXValue() : (String)((XYChart$Data)object).getYValue();
        Map<String, XYChart$Data<X, Y>> map = this.seriesCategoryMap.get(xYChart$Series);
        if (map != null) {
            map.remove(object);
            if (map.isEmpty()) {
                this.seriesCategoryMap.remove(xYChart$Series);
            }
        }
        if (this.seriesCategoryMap.isEmpty() && this.categoryAxis.isAutoRanging()) {
            this.categoryAxis.getCategories().clear();
        }
    }

    private void processDataRemove(XYChart$Series<X, Y> xYChart$Series, XYChart$Data<X, Y> xYChart$Data) {
        Node node = xYChart$Data.getNode();
        this.getPlotChildren().remove(node);
        this.updateMap(xYChart$Series, xYChart$Data);
    }

    private void animateDataAdd(XYChart$Data<X, Y> xYChart$Data, Node node) {
        double d2;
        if (this.orientation == Orientation.VERTICAL) {
            double d3;
            double d4 = ((Number)xYChart$Data.getYValue()).doubleValue();
            if (d3 < 0.0) {
                node.getStyleClass().add(NEGATIVE_STYLE);
            }
            xYChart$Data.setCurrentY(this.getYAxis().toRealValue(d4 < 0.0 ? -this.bottomPos : this.bottomPos));
            this.getPlotChildren().add(node);
            xYChart$Data.setYValue(this.getYAxis().toRealValue(d4));
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getCurrentY())), new KeyFrame(Duration.millis(700.0), new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getYValue(), Interpolator.EASE_BOTH)));
            return;
        }
        double d5 = ((Number)xYChart$Data.getXValue()).doubleValue();
        if (d2 < 0.0) {
            node.getStyleClass().add(NEGATIVE_STYLE);
        }
        xYChart$Data.setCurrentX(this.getXAxis().toRealValue(d5 < 0.0 ? -this.bottomPos : this.bottomPos));
        this.getPlotChildren().add(node);
        xYChart$Data.setXValue(this.getXAxis().toRealValue(d5));
        this.animate(new KeyFrame(Duration.ZERO, new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getCurrentX())), new KeyFrame(Duration.millis(700.0), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getXValue(), Interpolator.EASE_BOTH)));
    }

    private Timeline createDataRemoveTimeline(XYChart$Data<X, Y> xYChart$Data, Node object, XYChart$Series<X, Y> xYChart$Series) {
        object = new Timeline();
        if (this.orientation == Orientation.VERTICAL) {
            XYChart$Data xYChart$Data2 = xYChart$Data;
            this.XYValueMap.put(xYChart$Data2, ((Number)xYChart$Data2.getYValue()).doubleValue());
            xYChart$Data.setYValue(this.getYAxis().toRealValue(this.bottomPos));
            ((Timeline)object).getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getCurrentY())), new KeyFrame(Duration.millis(700.0), actionEvent -> {
                this.processDataRemove(xYChart$Series, xYChart$Data);
                this.XYValueMap.clear();
            }, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getYValue(), Interpolator.EASE_BOTH))});
        } else {
            XYChart$Data xYChart$Data3 = xYChart$Data;
            this.XYValueMap.put(xYChart$Data3, ((Number)xYChart$Data3.getXValue()).doubleValue());
            xYChart$Data.setXValue(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            ((Timeline)object).getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getCurrentX())), new KeyFrame(Duration.millis(700.0), actionEvent -> {
                this.processDataRemove(xYChart$Series, xYChart$Data);
                this.XYValueMap.clear();
            }, new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getXValue(), Interpolator.EASE_BOTH))});
        }
        return object;
    }

    @Override
    void dataBeingRemovedIsAdded(XYChart$Data<X, Y> xYChart$Data, XYChart$Series<X, Y> xYChart$Series) {
        if (this.dataRemoveTimeline != null) {
            this.dataRemoveTimeline.setOnFinished(null);
            ((Animation)this.dataRemoveTimeline).stop();
        }
        this.processDataRemove(xYChart$Series, xYChart$Data);
        xYChart$Data.setSeries(null);
        this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
        this.restoreDataValues(xYChart$Data);
        this.XYValueMap.clear();
    }

    private void restoreDataValues(XYChart$Data xYChart$Data) {
        Double d2 = this.XYValueMap.get(xYChart$Data);
        if (d2 != null) {
            if (this.orientation.equals((Object)Orientation.VERTICAL)) {
                xYChart$Data.setYValue(d2);
                xYChart$Data.setCurrentY(d2);
                return;
            }
            xYChart$Data.setXValue(d2);
            xYChart$Data.setCurrentX(d2);
        }
    }

    @Override
    void seriesBeingRemovedIsAdded(XYChart$Series<X, Y> xYChart$Series) {
        boolean bl2;
        boolean bl3 = bl2 = this.pt.getChildren().size() == 1;
        if (this.pt != null) {
            if (!this.pt.getChildren().isEmpty()) {
                for (Animation object : this.pt.getChildren()) {
                    object.setOnFinished(null);
                }
            }
            for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                this.processDataRemove(xYChart$Series, xYChart$Data);
                if (bl2) continue;
                this.restoreDataValues(xYChart$Data);
            }
            this.XYValueMap.clear();
            this.pt.setOnFinished(null);
            this.pt.getChildren().clear();
            this.pt.stop();
            this.removeSeriesFromDisplay(xYChart$Series);
        }
    }

    private Node createBar(XYChart$Series<X, Y> xYChart$Series, int n2, XYChart$Data<X, Y> xYChart$Data, int n3) {
        Node node = xYChart$Data.getNode();
        if (node == null) {
            node = new StackPane();
            node.setAccessibleRole(AccessibleRole.TEXT);
            node.setAccessibleRoleDescription("Bar");
            node.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            xYChart$Data.setNode(node);
        }
        node.getStyleClass().setAll((String[])new String[]{"chart-bar", "series" + n2, "data" + n3, xYChart$Series.defaultColorStyleClass});
        return node;
    }

    private XYChart$Data<X, Y> getDataItem(XYChart$Series<X, Y> object, int n2, int n3, String string) {
        if ((object = this.seriesCategoryMap.get(object)) != null) {
            return (XYChart$Data)object.get(string);
        }
        return null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return BarChart$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return BarChart.getClassCssMetaData();
    }
}

